/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oldcore.calc.transformations.TransformWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.KinshipChainsCriteria;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.ods.ODS1File;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.xls.XLS1File;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetReporter;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.BicomponentWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.HairCutWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.ToolBox;
import org.tip.puck.visualization.VisualizationController;
import org.tip.puck.visualization.style.implementations.OreGraph;
import org.tip.puck.visualization.style.implementations.PGraph;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.AboutPopup;
import org.tip.puckgui.views.AllianceNetworkInputWindow;
import org.tip.puckgui.views.CalculatorWindow;
import org.tip.puckgui.views.CensusInputWindow;
import org.tip.puckgui.views.ClusterSizeExtractionInputWindow;
import org.tip.puckgui.views.ClusterValueExtractionInputWindow;
import org.tip.puckgui.views.ControlInputWindow;
import org.tip.puckgui.views.CorpusPanel;
import org.tip.puckgui.views.DifferentialCensusInputWindow;
import org.tip.puckgui.views.FamiliesPanel;
import org.tip.puckgui.views.FieldworkInputWindow;
import org.tip.puckgui.views.FlowNetworkInputWindow;
import org.tip.puckgui.views.FooReporterInputWindow;
import org.tip.puckgui.views.FuseInputWindow;
import org.tip.puckgui.views.IndividualsPanel;
import org.tip.puckgui.views.KinshipChainsInputDialog;
import org.tip.puckgui.views.ListByClusterInputWindow;
import org.tip.puckgui.views.ListMissingRelativesByClusterInputWindow;
import org.tip.puckgui.views.ListRelativesByClusterInputWindow;
import org.tip.puckgui.views.OpenEncodingWindow;
import org.tip.puckgui.views.OpenRecentFolderMenuItem;
import org.tip.puckgui.views.OpenRecentMenuItem;
import org.tip.puckgui.views.PajekExportCriteria;
import org.tip.puckgui.views.PajekExportInputDialog;
import org.tip.puckgui.views.PartitionStatisticsInputWindow;
import org.tip.puckgui.views.PreferencesWindow;
import org.tip.puckgui.views.RandomCorpusInputWindow;
import org.tip.puckgui.views.RandomCorpusMASInputWindow;
import org.tip.puckgui.views.RelationModelInputWindow;
import org.tip.puckgui.views.RelationsPanel;
import org.tip.puckgui.views.RemoveAttributeCriteria;
import org.tip.puckgui.views.RemoveAttributeInputDialog;
import org.tip.puckgui.views.ReportPanel;
import org.tip.puckgui.views.ReportsPanel;
import org.tip.puckgui.views.ReshufflingNetworkInputWindow;
import org.tip.puckgui.views.SegmentationPanel;
import org.tip.puckgui.views.StatisticsInputWindow;
import org.tip.puckgui.views.ValuateExogenousAttributeCriteria;
import org.tip.puckgui.views.ValuateExogenousAttributeDialog;
import org.tip.puckgui.views.WindowMenuItem;
import org.tip.puckgui.views.visualization.Test;
import org.tip.puckgui.views.visualization.VisualizationPanel;

public class MainWindow {
    private static final Logger logger = LoggerFactory.getLogger(MainWindow.class);
    private int reportCounter = 0;
    private JFrame frmPuck;
    private NetGUI netGUI;
    private JMenuItem mntmSave;
    private JMenuItem mntmRevert;
    private JMenu mntmRecent;
    private JTabbedPane tabbedPaneCorpus;
    private CorpusPanel corpusTab;
    private FamiliesPanel familiesTab;
    private IndividualsPanel individualsTab;
    private SegmentationPanel segmentationPanel;

    public MainWindow(NetGUI guiManager) {
        this.netGUI = guiManager;
        this.initialize();
        this.frmPuck.setVisible(true);
        this.updateMenuItems();
        this.updateTitle();
        this.getCorpusTab().update();
        this.getIndividualsTab().update();
        this.getFamiliesTab().update();
        this.getIndividualsTab().select(null);
        this.getFamiliesTab().select(null);
        for (RelationModel relationModel : this.netGUI.getNet().relationModels()) {
            this.addTab(relationModel.getName(), new RelationsPanel(this.netGUI, relationModel));
        }
    }

    public void addRelationTab(RelationModel relationModel) {
        if (relationModel != null) {
            RelationsPanel relationPanel = new RelationsPanel(this.netGUI, relationModel);
            this.tabbedPaneCorpus.addTab(relationModel.getName(), null, relationPanel, null);
            this.tabbedPaneCorpus.setSelectedComponent(relationPanel);
        }
    }

    public void addReportTab(Report report) {
        ++this.reportCounter;
        JPanel reportPanel = report.containsSubReport() ? new ReportsPanel(this.netGUI, report) : new ReportPanel(this.netGUI, report);
        this.tabbedPaneCorpus.addTab(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.reportTab.title")) + "(" + this.reportCounter + ")", null, reportPanel, null);
        this.tabbedPaneCorpus.setSelectedComponent(reportPanel);
    }

    public void addTab(String title, JPanel panel) {
        this.tabbedPaneCorpus.addTab(title, null, panel, null);
        this.tabbedPaneCorpus.setSelectedComponent(panel);
    }

    public void closeCurrentTab() {
        this.tabbedPaneCorpus.remove(this.tabbedPaneCorpus.getSelectedIndex());
    }

    public void closeRelationTabs() {
        for (RelationsPanel tab : this.getRelationTabs()) {
            this.tabbedPaneCorpus.remove(tab);
        }
    }

    public void closeReportTabs() {
        int tabIndex = 3;
        while (tabIndex < this.tabbedPaneCorpus.getTabCount()) {
            this.tabbedPaneCorpus.remove(tabIndex);
            ++tabIndex;
        }
    }

    public void dispose() {
        this.frmPuck.dispose();
    }

    public CorpusPanel getCorpusTab() {
        return this.corpusTab;
    }

    public int getCurrentTabIndex() {
        int result = this.tabbedPaneCorpus.getSelectedIndex();
        return result;
    }

    public FamiliesPanel getFamiliesTab() {
        return this.familiesTab;
    }

    public IndividualsPanel getIndividualsTab() {
        return this.individualsTab;
    }

    public JFrame getJFrame() {
        JFrame result = this.frmPuck;
        return result;
    }

    public RelationsPanel getRelationTab(RelationModel relationModel) {
        int tabIndex = this.getRelationTabIndex(relationModel);
        RelationsPanel result = tabIndex == -1 ? null : (RelationsPanel)this.tabbedPaneCorpus.getComponent(tabIndex);
        return result;
    }

    public int getRelationTabIndex(RelationModel relationModel) {
        int result = -1;
        boolean ended = false;
        int tabIndex = 0;
        while (!ended) {
            if (tabIndex < this.tabbedPaneCorpus.getComponentCount()) {
                Component tab = this.tabbedPaneCorpus.getComponent(tabIndex);
                if (tab.getClass() == RelationsPanel.class && ((RelationsPanel)tab).getRelationModel() == relationModel) {
                    ended = true;
                    result = tabIndex;
                    continue;
                }
                ++tabIndex;
                continue;
            }
            ended = true;
            result = -1;
        }
        return result;
    }

    public List<RelationsPanel> getRelationTabs() {
        ArrayList<RelationsPanel> result = new ArrayList<RelationsPanel>();
        Component[] componentArray = this.tabbedPaneCorpus.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component tab = componentArray[n2];
            if (tab.getClass() == RelationsPanel.class) {
                result.add((RelationsPanel)tab);
            }
            ++n2;
        }
        return result;
    }

    public SegmentationPanel getSegmentationPanel() {
        return this.segmentationPanel;
    }

    private void initialize() {
        this.frmPuck = new JFrame();
        this.frmPuck.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("Closing event.");
                MainWindow.this.performCloseWindow();
            }
        });
        this.frmPuck.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.frmPuck.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.frmPuck.title"));
        this.frmPuck.setBounds(50, 0, 1020, MainWindow.getDesktopHeight());
        this.frmPuck.setDefaultCloseOperation(0);
        JMenuBar menuBar = new JMenuBar();
        this.frmPuck.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFile.text"));
        mnFile.setMnemonic('F');
        menuBar.add(mnFile);
        JMenu mnNew = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNew.text"));
        mnFile.add(mnNew);
        JMenuItem mntmBlankCorpus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBlankCorpus.text"));
        mntmBlankCorpus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PuckGUI.instance().createNetGUI();
            }
        });
        mnNew.add(mntmBlankCorpus);
        JMenu mnRandomnetwork = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRandomnetwork.text"));
        mnNew.add(mnRandomnetwork);
        JMenuItem mntmClassic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClassic.text"));
        mntmClassic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomCorpusInputWindow window = new RandomCorpusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRandomnetwork.add(mntmClassic);
        JMenuItem mntmTelmo = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTelmo.text"));
        mntmTelmo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomCorpusMASInputWindow window = new RandomCorpusMASInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnRandomnetwork.add(mntmTelmo);
        JMenuItem mntmEmptyAllianceNetwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEmptyAllianceNetwork.text"));
        mntmEmptyAllianceNetwork.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        mntmEmptyAllianceNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PuckGUI.instance().createGroupNetGUI(new Graph<Cluster<Individual>>(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName")));
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnNew.add(mntmEmptyAllianceNetwork);
        JMenuItem mntmOpen = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.text"));
        mntmOpen.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.toolTipText"));
        mntmOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mntmOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.openFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
            }
        });
        mnFile.add(mntmOpen);
        this.mntmRecent = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text"));
        this.mntmRecent.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu openRecentMenu = (JMenu)event.getSource();
                openRecentMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu openRecentMenu = (JMenu)event.getSource();
                for (File file : PuckGUI.instance().recentFiles()) {
                    openRecentMenu.add(new OpenRecentMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, file));
                }
            }
        });
        mnFile.add(this.mntmRecent);
        JMenu mnOpenRecentFolder = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnOpenFolder.text"));
        mnOpenRecentFolder.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu openRecentFolderMenu = (JMenu)event.getSource();
                openRecentFolderMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu openRecentFolderMenu = (JMenu)event.getSource();
                for (File file : PuckGUI.instance().recentFolders()) {
                    openRecentFolderMenu.add(new OpenRecentFolderMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, file));
                }
            }
        });
        mnFile.add(mnOpenRecentFolder);
        this.mntmRevert = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
        this.mntmRevert.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mntmRevert.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.toolTipText"));
        this.mntmRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int response = JOptionPane.showConfirmDialog(MainWindow.this.frmPuck, "All changes will be lost. Confirm revert of this corpus?", "Revert confirm", 0);
                    if (response == 0) {
                        MainWindow.this.netGUI.revert();
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmOpenEncoding = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenEncoding.text"));
        mntmOpenEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.openEncodingFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmOpenEncoding);
        mnFile.add(this.mntmRevert);
        JSeparator separator_4 = new JSeparator();
        mnFile.add(separator_4);
        this.mntmSave = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.text"));
        this.mntmSave.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.toolTipText"));
        this.mntmSave.setEnabled(false);
        this.mntmSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performSave(false, true);
            }
        });
        JMenuItem mntmFuse = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFuse.text"));
        mntmFuse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    FuseInputWindow window = new FuseInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmFuse);
        JMenuItem mntmUpdateOverwriting = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateOverwriting.text"));
        mntmUpdateOverwriting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    File file = MainWindow.selectFile(MainWindow.this.frmPuck, null);
                    if (file != null) {
                        Net updatedNet = PuckManager.updateNetOverwriting(MainWindow.this.netGUI.getNet(), file);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
                        newNetGui.setChanged(true, "-overwritten");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmUpdateOverwriting);
        JMenuItem mntmUpdateAppending = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateAppending.text"));
        mntmUpdateAppending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectFile(MainWindow.this.frmPuck, null);
                    if (file != null) {
                        Net updatedNet = PuckManager.updateNetAppending(MainWindow.this.netGUI.getNet(), file);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
                        newNetGui.setChanged(true, "-appended");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmUpdateAppending);
        JSeparator separator_5 = new JSeparator();
        mnFile.add(separator_5);
        mnFile.add(this.mntmSave);
        JMenuItem mntmSaveAs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.text"));
        mntmSaveAs.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.toolTipText"));
        mntmSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performSave(true, true);
            }
        });
        mnFile.add(mntmSaveAs);
        JMenuItem mntmSaveACopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.text"));
        mntmSaveACopy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.toolTipText"));
        mntmSaveACopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performSave(true, false);
            }
        });
        mnFile.add(mntmSaveACopy);
        JMenuItem mntmClose = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.text"));
        mntmClose.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.toolTipText"));
        mntmClose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        mntmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performCloseCorpus();
            }
        });
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmExportToPajek = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportToPajek.text"));
        mntmExportToPajek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PajekExportCriteria criteria = PajekExportInputDialog.showDialog(MainWindow.this.netGUI.getFile(), IndividualValuator.getAttributeLabels(MainWindow.this.netGUI.getNet().individuals()));
                    if (criteria != null) {
                        PAJFile.exportToPajek(MainWindow.this.netGUI.getNet(), criteria.getTargetFileName(), criteria.getGraphType(), criteria.getPartitionLabelsNotBlank());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmImportXls = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportXls.text"));
        mntmImportXls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectXLSFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (file != null) {
                        Net net = XLS1File.load(file);
                        if (MainWindow.this.netGUI.isBlank()) {
                            MainWindow.this.netGUI.setFile(file);
                            MainWindow.this.netGUI.setNet(net);
                        } else {
                            PuckGUI.instance().createNetGUI(file, net);
                        }
                    }
                }
                catch (PuckException exception) {
                    String message;
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmImportOds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportOds.text"));
        mntmImportOds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = MainWindow.selectODSFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());
                    if (file != null) {
                        Net net = ODS1File.load(file);
                        if (MainWindow.this.netGUI.isBlank()) {
                            MainWindow.this.netGUI.setFile(file);
                            MainWindow.this.netGUI.setNet(net);
                        } else {
                            PuckGUI.instance().createNetGUI(file, net);
                        }
                    }
                }
                catch (PuckException exception) {
                    String message;
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnFile.add(mntmImportOds);
        mnFile.add(mntmImportXls);
        JMenuItem mntmExportXls = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportXls.text"));
        mntmExportXls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performXLS1Save();
            }
        });
        JMenuItem mntmExportOds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportOds.text"));
        mntmExportOds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.performODS1Save();
            }
        });
        mnFile.add(mntmExportOds);
        mnFile.add(mntmExportXls);
        mnFile.add(mntmExportToPajek);
        JSeparator separator_1 = new JSeparator();
        mnFile.add(separator_1);
        mnFile.add(mntmClose);
        JMenuItem mntmQuit = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.text"));
        mntmQuit.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.toolTipText"));
        mntmQuit.setMnemonic('Q');
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quit action.");
                MainWindow.this.performQuit();
            }
        });
        JSeparator separator_7 = new JSeparator();
        mnFile.add(separator_7);
        mnFile.add(mntmQuit);
        JMenu mnEdit = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_1"));
        mnEdit.setMnemonic('E');
        menuBar.add(mnEdit);
        JMenuItem mntmCut = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCut.text"));
        mntmCut.setAccelerator(KeyStroke.getKeyStroke(65489, 0));
        mntmCut.setEnabled(false);
        mnEdit.add(mntmCut);
        JMenuItem mntmCopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopy.text"));
        mntmCopy.setAccelerator(KeyStroke.getKeyStroke(65485, 0));
        mntmCopy.setEnabled(false);
        mnEdit.add(mntmCopy);
        JMenuItem mntmPaste = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPaste.text"));
        mntmPaste.setAccelerator(KeyStroke.getKeyStroke(65487, 0));
        mntmPaste.setEnabled(false);
        mnEdit.add(mntmPaste);
        JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDelete.text"));
        mntmDelete.setEnabled(false);
        mnEdit.add(mntmDelete);
        JSeparator separator_2 = new JSeparator();
        mnEdit.add(separator_2);
        JMenuItem mntmPreferences = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPreferences.text"));
        mntmPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PreferencesWindow preferences = new PreferencesWindow();
                    preferences.setDefaultCloseOperation(2);
                    preferences.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JMenuItem mntmAddIndividual = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddIndividual.text"));
        mntmAddIndividual.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        mntmAddIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.individualsTab.addIndividual();
            }
        });
        mnEdit.add(mntmAddIndividual);
        JMenuItem mntmFind = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFind.text"));
        mntmFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.setFocusOnFind();
                        break;
                    }
                    case 2: {
                        MainWindow.this.familiesTab.setFocusOnFind();
                    }
                }
            }
        });
        JMenuItem mntmAddPartner = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddPartner.text"));
        mntmAddPartner.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        mntmAddPartner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addPartner();
                    }
                }
            }
        });
        JMenuItem mntmAddOriginFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddOriginFamily.text"));
        mntmAddOriginFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addOriginFamily();
                    }
                }
            }
        });
        mntmAddOriginFamily.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        mnEdit.add(mntmAddOriginFamily);
        mnEdit.add(mntmAddPartner);
        JMenuItem mntmAddChild = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddChild.text"));
        mntmAddChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
                    case 1: {
                        MainWindow.this.individualsTab.addChild();
                        break;
                    }
                    case 2: {
                        MainWindow.this.familiesTab.addChild();
                    }
                }
            }
        });
        mntmAddChild.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        mnEdit.add(mntmAddChild);
        JMenuItem mntmAddFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddFamily.text"));
        mntmAddFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.familiesTab.addFamily();
            }
        });
        mntmAddFamily.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        mnEdit.add(mntmAddFamily);
        JMenuItem mntmAddRelationModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNewMenuItem.text_1"));
        mntmAddRelationModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModelInputWindow window = new RelationModelInputWindow(MainWindow.this.netGUI, null);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnEdit.add(mntmAddRelationModel);
        mntmFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        mnEdit.add(mntmFind);
        JSeparator separator_9 = new JSeparator();
        mnEdit.add(separator_9);
        mnEdit.add(mntmPreferences);
        JMenu mnCorpus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCorpus.text"));
        menuBar.add(mnCorpus);
        JMenuItem mntmListById = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListById.text"));
        mntmListById.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), IndividualComparator.Sorting.ID);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListById);
        JMenuItem mntmListByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByFirst.text"));
        mntmListByFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), IndividualComparator.Sorting.FIRSTN);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByFirst);
        JMenuItem mntmListByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast.text"));
        mntmListByLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), IndividualComparator.Sorting.LASTN);
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByLast);
        JMenuItem mntmListByClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByClusters.text"));
        mntmListByClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ListByClusterInputWindow window = new ListByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListByClusters);
        JMenuItem mntmListRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListRelatives.text"));
        mntmListRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ListRelativesByClusterInputWindow window = new ListRelativesByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListRelatives);
        JMenuItem mntmExportFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportFamilyIds.text"));
        mntmExportFamilyIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = StatisticsReporter.reportFamiliesByHusband(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmListMissingRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListMissingRelatives.text"));
        mntmListMissingRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ListMissingRelativesByClusterInputWindow window = new ListMissingRelativesByClusterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListMissingRelatives);
        mnCorpus.add(mntmExportFamilyIds);
        JMenuItem mntmListFamiliesBy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListFamiliesBy.text"));
        mntmListFamiliesBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = StatisticsReporter.reportFamiliesByWife(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmListFamiliesBy);
        JMenuItem mntmHomonyms = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmHomonyms.text"));
        mntmHomonyms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = StatisticsReporter.reportHomonyms(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCorpus.add(mntmHomonyms);
        JMenu mnControls = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls.text"));
        mnCorpus.add(mnControls);
        JMenuItem mntmControl = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControl.text"));
        mnControls.add(mntmControl);
        JSeparator separator_8 = new JSeparator();
        mnControls.add(separator_8);
        JMenuItem mntmControlSameSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlSameSex.text"));
        mnControls.add(mntmControlSameSex);
        JMenuItem mntmControlFemaleFathers = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlFemaleFathers.text"));
        mnControls.add(mntmControlFemaleFathers);
        JMenuItem mntmMultipleFathersOr = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMultipleFathersOr.text"));
        mntmMultipleFathersOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportMultipleFathersOrMothers(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmMultipleFathersOr);
        JMenuItem mntmControlCyclicDescent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlCyclicDescent.text"));
        mnControls.add(mntmControlCyclicDescent);
        JMenuItem mntmControlUnknownSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlUnknownSex.text"));
        mnControls.add(mntmControlUnknownSex);
        JMenuItem mntmControlNamelessPersons = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlNamelessPersons.text"));
        mnControls.add(mntmControlNamelessPersons);
        JMenuItem mntmControlParentchildMarriages = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlParentchildMarriages.text"));
        mnControls.add(mntmControlParentchildMarriages);
        JMenuItem mntmAutomarriage = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAutomarriage.text"));
        mntmAutomarriage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = ControlReporter.reportAutoMarriages(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnControls.add(mntmAutomarriage);
        mntmControlParentchildMarriages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportParentChildMarriages(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlNamelessPersons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportNamelessPersons(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlUnknownSex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportUnknownSexPersons(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlCyclicDescent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportCyclicDescentCases(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlFemaleFathers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportFemaleFathersOrMaleMothers(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControlSameSex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ControlReporter.reportSameSexSpouses(MainWindow.this.netGUI.getNet(), ResourceBundle.getBundle("org.tip.puckgui.messages"));
                    if (report.status() == 0) {
                        String title = "Control special features report";
                        String message = "No special features found.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    } else {
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ControlInputWindow window = new ControlInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_6 = new JSeparator();
        mnCorpus.add(separator_6);
        JMenu mnTransform = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform.text"));
        menuBar.add(mnTransform);
        JMenuItem mntmAnonymizeByGender = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByGender.text"));
        mntmAnonymizeByGender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.anonymizeByGenderAndId(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAnonymizeByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByFirst.text_1"));
        mntmAnonymizeByFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net targetNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.anonymizeByFirstName(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmAnonymizeByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByLast.text_1"));
        mntmAnonymizeByLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.anonymizeByLastName(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-anonymized");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmDuplicate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDuplicate.text"));
        mnTransform.add(mntmDuplicate);
        mntmDuplicate.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        mntmDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), new Net(MainWindow.this.netGUI.getNet()));
                newNetGui.setChanged(MainWindow.this.netGUI.isChanged());
            }
        });
        mnTransform.add(mntmAnonymizeByFirst);
        mnTransform.add(mntmAnonymizeByLast);
        mnTransform.add(mntmAnonymizeByGender);
        JMenuItem mntmNumberNames_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNumberNames_1.text"));
        mntmNumberNames_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net targetNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    NetUtils.numberNames(currentIndividuals);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
                    newNetGui.setChanged(true, "-names_numbered");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmNumberNames_1);
        JMenuItem mntmCleanAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCleanAttribute.text"));
        mntmCleanAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String label = JOptionPane.showInputDialog("Clean attributes with blank or 0 as value.\nPlease, input attribute label:");
                    if (StringUtils.isNotBlank((CharSequence)label)) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                        int count = AttributeWorker.cleanAttribute(currentIndividuals, label);
                        String title = "Clean Attribute Result";
                        String message = "Number of attribute removed: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                        newNetGui.setChanged(true, "-cleaned");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_18 = new JSeparator();
        mnTransform.add(separator_18);
        JMenuItem mntmValuateExogeneousAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmValuateExogeneousAttribute.text"));
        mntmValuateExogeneousAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.showDialog();
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        int count = AttributeWorker.valuateExogenousAttribute(newNet.individuals(), criteria.getSourceLabel(), criteria.getTargetLabel(), criteria.getValuePrefix());
                        String title = "Valuate Exogenous Attribute Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0) {
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                            newNetGui.setChanged(true, "-attributeValuated");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmValuateExogeneousAttribute);
        mnTransform.add(mntmCleanAttribute);
        JMenuItem mntmCopyRedefiningRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyRedefiningRelations.text"));
        mntmCopyRedefiningRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = TransformWorker.redefineRelations(MainWindow.this.netGUI.getNet(), "FIXME", KinType.CHILD);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(MainWindow.this.netGUI.isChanged());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmRemoveAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRemoveAttribute.text"));
        mntmRemoveAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<String> relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
                    List<String> attributeNames = AttributeWorker.getExogenousAttributeLabels(MainWindow.this.netGUI.getNet(), null);
                    RemoveAttributeCriteria criteria = RemoveAttributeInputDialog.showDialog(relationModelNames, attributeNames);
                    if (criteria != null) {
                        Net newNet = new Net(MainWindow.this.netGUI.getNet());
                        int count = AttributeWorker.removeAttribute(newNet, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(), criteria.getType());
                        String title = "Remove Attribute Count";
                        String message = "Number of attribute touched: " + count;
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                        if (count > 0) {
                            NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                            newNetGui.setChanged(true, "-attributeRemoved");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRemoveAttribute);
        JSeparator separator_19 = new JSeparator();
        mnTransform.add(separator_19);
        mnTransform.add(mntmCopyRedefiningRelations);
        JMenuItem mntmMarryCoparents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMarryCoparents.text"));
        mntmMarryCoparents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    int count = NetUtils.marryCoparents(newNet);
                    String title = "Marry co-parents Result";
                    String message = "Number of unmarried co-parents married: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-married");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmMarryCoparents);
        JMenuItem mntmRenumber = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumber.text"));
        mnTransform.add(mntmRenumber);
        mntmRenumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetUtils.renumberate(MainWindow.this.netGUI.getNet());
                MainWindow.this.corpusTab.update();
                MainWindow.this.individualsTab.update();
                MainWindow.this.familiesTab.update();
                MainWindow.this.netGUI.setChanged(true, "re-numbered");
            }
        });
        mntmRenumber.setEnabled(false);
        JMenuItem mntmFamiliesAsRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddEditableFamilies.text"));
        mntmFamiliesAsRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RelationModel model = NetUtils.createRelationsFromFamilies(MainWindow.this.netGUI.getNet());
                    MainWindow.this.netGUI.setChanged(true);
                    MainWindow.this.netGUI.addRelationTab(model);
                    MainWindow.this.netGUI.updateAll();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmFamiliesAsRelations);
        JSeparator separator_10 = new JSeparator();
        mnTransform.add(separator_10);
        JSeparator separator_11 = new JSeparator();
        mnTransform.add(separator_11);
        JMenu mnReduce = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReduce.text"));
        mnTransform.add(mnReduce);
        JMenuItem mntmCuttingTails = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyCuttingTails.text_1"));
        mnReduce.add(mntmCuttingTails);
        JMenuItem mntmCopyWithoutMarked = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutMarked.text"));
        mnReduce.add(mntmCopyWithoutMarked);
        JMenuItem mntmCopyWithoutStruct = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutStruct.text"));
        mnReduce.add(mntmCopyWithoutStruct);
        JMenuItem mntmEliminateSingles = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEliminateSingles.text"));
        mnReduce.add(mntmEliminateSingles);
        JMenuItem mntmCopyWithoutVirtuals = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutVirtuals.text"));
        mnReduce.add(mntmCopyWithoutVirtuals);
        mntmCopyWithoutVirtuals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int count = NetUtils.eliminateVirtuals(newNet, currentIndividuals);
                    String title = "Eliminate Virtuals Individuals Result";
                    String message = "Number of individuals removed: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-wo_virtuals");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmEliminateSingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Chronometer chrono = new Chronometer();
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int previousIndividualCount = newNet.individuals().size();
                    int count = NetUtils.eliminateSingles(newNet, currentIndividuals);
                    String title = "Eliminate Unmarried Result";
                    String message = String.format("Eliminated singles: %d\nPrevious count: %d\nUpdated count: %d\nTime spent: %d ms", count, previousIndividualCount, MainWindow.this.netGUI.getNet().individuals().size(), chrono.stop().interval());
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-wo_unmarried");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCopyWithoutStruct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = MainWindow.this.netGUI.getNet();
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int count = NetUtils.eliminateStructuralChildren(newNet, currentIndividuals);
                    String title = "Eliminate Structural Children Result";
                    String message = "Number of individuals removed: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGUI = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGUI.setChanged(true, "-adults");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCopyWithoutMarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
                    int count = NetUtils.eliminateMarkedDoubles(newNet, currentIndividuals);
                    String title = "Eliminate Marked Double individuals Result";
                    String message = "Number of individuals removed: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-univocal");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmCuttingTails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = new Net(MainWindow.this.netGUI.getNet());
                    int count = HairCutWorker.shave(newNet);
                    String title = "Haircut Result";
                    String message = "Number of individuals eliminated: " + count;
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 1);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, "-shaved");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmExtractCurrentSegment = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCurrentSegment.text"));
        mntmExtractCurrentSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Net newNet = NetUtils.extract(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getCurrentIndividuals());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenu mnExtract = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnExtract.text"));
        mnTransform.add(mnExtract);
        JMenuItem mntmExtractCore = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCore.text"));
        mnExtract.add(mntmExtractCore);
        JMenuItem mntmKernel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKernel.text"));
        mnExtract.add(mntmKernel);
        JMenuItem mntmMaximalBicomponent = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMaximalBicomponent.text"));
        mnExtract.add(mntmMaximalBicomponent);
        mntmMaximalBicomponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getMaximalBicomponent(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-maxBicomponent");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmExtractLargeClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractLargeClusters.text"));
        mnExtract.add(mntmExtractLargeClusters);
        JMenuItem mntmExtractPositiveCluster = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractPositiveCluster.text"));
        mnExtract.add(mntmExtractPositiveCluster);
        mntmExtractPositiveCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClusterValueExtractionInputWindow window = new ClusterValueExtractionInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmExtractLargeClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClusterSizeExtractionInputWindow window = new ClusterSizeExtractionInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getKernel(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-kernel");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmExtractCore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net target = BicomponentWorker.getCore(MainWindow.this.netGUI.getNet());
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
                    newNetGui.setChanged(true, "-core");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_17 = new JSeparator();
        mnTransform.add(separator_17);
        mnTransform.add(mntmExtractCurrentSegment);
        JMenuItem mntmShufflePgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmShufflePgraph.text"));
        mntmShufflePgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ReshufflingNetworkInputWindow window = new ReshufflingNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenu mnNewMenu = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_2"));
        mnTransform.add(mnNewMenu);
        JMenuItem mntmUniversal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal.text"));
        mntmUniversal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment(), null);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_ALL");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmUniversal);
        JMenuItem mntmBottomup = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBottomup.text"));
        mntmBottomup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment(), KinType.PARENT);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_UP");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmBottomup);
        JMenuItem mntmTopdown = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTopdown.text"));
        mntmTopdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment(), KinType.CHILD);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_DOWN");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmTopdown);
        JMenuItem mntmConjugal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConjugal.text"));
        mntmConjugal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentSegment(), KinType.SPOUSE);
                    NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
                    newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out") + "_expanded_MARR");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnNewMenu.add(mntmConjugal);
        JSeparator separator_15 = new JSeparator();
        mnTransform.add(separator_15);
        JMenu mnShrink = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnShrink.text"));
        mnTransform.add(mnShrink);
        JMenuItem mntmInterMarriageReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIntermarriageReport.text"));
        mnShrink.add(mntmInterMarriageReport);
        JMenuItem mntmFlowReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlowReport_1.text"));
        mnShrink.add(mntmFlowReport);
        mntmFlowReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlowNetworkInputWindow window = new FlowNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmInterMarriageReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AllianceNetworkInputWindow window = new AllianceNetworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JSeparator separator_16 = new JSeparator();
        mnTransform.add(separator_16);
        mnTransform.add(mntmShufflePgraph);
        JMenuItem mntmVirtualFieldwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldwork.text"));
        mntmVirtualFieldwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FieldworkInputWindow window = new FieldworkInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmVirtualFieldwork);
        JMenuItem mntmVirtualFieldworkVariations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldworkVariations.text"));
        mntmVirtualFieldworkVariations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Report report = RandomNetReporter.reportVirtualFieldworkVariations(MainWindow.this.netGUI.getSegmentation());
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (PuckException e) {
                    e.printStackTrace();
                }
            }
        });
        mnTransform.add(mntmVirtualFieldworkVariations);
        JMenu mnCensus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCensus.text"));
        menuBar.add(mnCensus);
        JMenuItem mntmPedigree = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPedigree.text"));
        mntmPedigree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Pedigree Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        if (parameter != null) {
                            int maxDepth = Integer.parseInt(parameter);
                            Report report = CensusReporter.reportPedigree(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmPedigree);
        JMenuItem mntmRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelatives.text"));
        mntmRelatives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Enter kinship string (in positional notation): ", "Chains Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        Report report = CensusReporter.reportRelatives(MainWindow.this.netGUI.getNet().getLabel(), ego, parameter);
                        MainWindow.this.netGUI.addReportTab(report);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmProgeniture = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProgeniture.text"));
        mntmProgeniture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Progeniture Report", 3);
                        logger.debug("parameter=[" + parameter + "]");
                        if (parameter != null) {
                            int maxDepth = Integer.parseInt(parameter);
                            Report report = CensusReporter.reportProgeniture(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmProgeniture);
        mnCensus.add(mntmRelatives);
        JMenuItem mntmKinshipChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinshipChains.text"));
        mntmKinshipChains.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Individual ego = MainWindow.this.netGUI.selectedIndividual();
                    if (ego == null) {
                        String title = "Information";
                        String message = "Please, select an individual on the list.";
                        JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                    } else {
                        KinshipChainsCriteria criteria = KinshipChainsInputDialog.showDialog();
                        if (criteria != null) {
                            Individual alter = MainWindow.this.netGUI.getNet().get(criteria.getAlterId());
                            Report report = CensusReporter.reportKinshipChains(MainWindow.this.netGUI.getNet().getLabel(), ego, alter, criteria.getMaximalDepth(), criteria.getMaximalOrder(), criteria.getChainClassification());
                            MainWindow.this.netGUI.addReportTab(report);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmKinshipChains);
        JMenuItem mntmFindCircuit2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFindCircuit2.text"));
        mntmFindCircuit2.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        mntmFindCircuit2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CensusInputWindow window = new CensusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmDistances = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDistances.text"));
        mntmDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Individual ego = MainWindow.this.netGUI.selectedIndividual();
                StatisticsWorker.getDistances(ego, 100, FiliationType.COGNATIC);
            }
        });
        mnCensus.add(mntmDistances);
        JSeparator separator_13 = new JSeparator();
        mnCensus.add(separator_13);
        JMenuItem mntmBasicInformation = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicInformation.text"));
        mnCensus.add(mntmBasicInformation);
        mntmBasicInformation.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        mntmBasicInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Chronometer chrono = new Chronometer();
                    Report report = StatisticsReporter.reportBasicInformation(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation());
                    chrono.stop();
                    logger.info(String.format("Time spent: %d ms", chrono.interval()));
                    MainWindow.this.netGUI.addReportTab(report);
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        JMenuItem mntmBasicGraphs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicGraphs.text"));
        mnCensus.add(mntmBasicGraphs);
        mntmBasicGraphs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StatisticsInputWindow window = new StatisticsInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mntmBasicGraphs.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        JMenuItem mntmPartitionStatistics = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionStatistics.text"));
        mntmPartitionStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PartitionStatisticsInputWindow window = new PartitionStatisticsInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmPartitionStatistics);
        JSeparator separator_14 = new JSeparator();
        mnCensus.add(separator_14);
        mnCensus.add(mntmFindCircuit2);
        JMenuItem mntmDifferentialCensus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCensus.text"));
        mntmDifferentialCensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    DifferentialCensusInputWindow window = new DifferentialCensusInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmDifferentialCensus);
        JSeparator separator_12 = new JSeparator();
        mnCensus.add(separator_12);
        JMenuItem mntmSynopsis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSynopsis.text"));
        mntmSynopsis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File file = MainWindow.selectFolder(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());
                if (file != null) {
                    String directory = file.getAbsolutePath();
                    Report report = StatisticsReporter.reportSynopsis(directory);
                    MainWindow.this.netGUI.addReportTab(report);
                }
            }
        });
        mnCensus.add(mntmSynopsis);
        JMenu mnDraw = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnDraw.text"));
        menuBar.add(mnDraw);
        JMenuItem mntmOregraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOregraph.text"));
        mntmOregraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());
                    VisualizationController vizController = VisualizationController.getSharedInstance();
                    VisualizationPanel buildView = vizController.buildView(graph, OreGraph.class);
                    MainWindow.this.netGUI.addTab("Ore-Graph Draw", buildView);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnDraw.add(mntmOregraph);
        JMenuItem mntmPgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPgraph.text"));
        mntmPgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());
                    VisualizationController vizController = VisualizationController.getSharedInstance();
                    VisualizationPanel buildView = vizController.buildView(graph, PGraph.class);
                    MainWindow.this.netGUI.addTab("P-Graph Draw", buildView);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnDraw.add(mntmPgraph);
        JMenu mnTools = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTools.text"));
        menuBar.add(mnTools);
        JMenuItem mntmCalculator = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCalculator.text"));
        mntmCalculator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CalculatorWindow window = new CalculatorWindow(MainWindow.this.netGUI);
                    window.getJFrame().setDefaultCloseOperation(2);
                    window.getJFrame().setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, 0);
                }
            }
        });
        mnTools.add(mntmCalculator);
        JMenu mnWindows = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnWindows.text"));
        mnWindows.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                windowsMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                for (WindowGUI windowGUI : PuckGUI.instance().windowGUIs()) {
                    windowsMenu.add(new WindowMenuItem(windowGUI));
                }
            }
        });
        menuBar.add(mnWindows);
        JMenu mnHelp = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnHelp.text"));
        mnHelp.setMnemonic('H');
        menuBar.add(mnHelp);
        JMenuItem mntmOfficialWebSite = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOfficialWebSite.text"));
        mntmOfficialWebSite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.callPuckHelp((JMenuItem)event.getSource());
            }
        });
        mnHelp.add(mntmOfficialWebSite);
        JMenuItem mntmAboutPuck = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAboutPuck.text"));
        mntmAboutPuck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AboutPopup dialog = new AboutPopup();
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JSeparator separator_3 = new JSeparator();
        mnHelp.add(separator_3);
        mnHelp.add(mntmAboutPuck);
        JMenu mnFoo = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFoo.text"));
        mnFoo.setVisible(false);
        mnFoo.setEnabled(false);
        menuBar.add(mnFoo);
        JMenuItem mntmFooworker = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFooworker.text"));
        mnFoo.add(mntmFooworker);
        JMenuItem mntmTestDev = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTestDev.text"));
        mnFoo.add(mntmTestDev);
        mntmTestDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GraphReporter.test();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mntmTestDev.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        JMenuItem mntmVisualizationTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVisualizationTdev.text"));
        mntmVisualizationTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Test.test((NetGUI)MainWindow.this.netGUI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mntmVisualizationTest.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        mnFoo.add(mntmVisualizationTest);
        mntmFooworker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FooReporterInputWindow window = new FooReporterInputWindow(MainWindow.this.netGUI);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.frmPuck.getContentPane().setLayout(new BoxLayout(this.frmPuck.getContentPane(), 1));
        this.segmentationPanel = new SegmentationPanel(this.netGUI);
        this.frmPuck.getContentPane().add(this.segmentationPanel);
        this.tabbedPaneCorpus = new JTabbedPane(1);
        this.frmPuck.getContentPane().add(this.tabbedPaneCorpus);
        this.corpusTab = new CorpusPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.corpusTab.title"), null, this.corpusTab, null);
        this.individualsTab = new IndividualsPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individualsPanel.title"), null, this.individualsTab, null);
        this.familiesTab = new FamiliesPanel(this.netGUI);
        this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.familiesPanel.title"), null, this.familiesTab, null);
    }

    private void performCloseCorpus() {
        boolean doClose;
        if (this.netGUI.isChanged()) {
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");
            int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 0);
            doClose = response == 0;
        } else {
            doClose = true;
        }
        if (doClose) {
            if (PuckGUI.instance().windowGUIs().size() == 1) {
                if (!this.netGUI.isBlank()) {
                    this.netGUI.setBlank();
                }
            } else {
                PuckGUI.instance().close(this.netGUI);
                this.frmPuck.dispose();
            }
        }
    }

    private void performCloseWindow() {
        if (PuckGUI.instance().windowGUIs().size() == 1) {
            if (this.netGUI.isBlank()) {
                PuckGUI.instance().exit();
            } else {
                this.netGUI.setBlank();
            }
        } else {
            boolean doClose;
            if (this.netGUI.isChanged()) {
                String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
                String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");
                int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 0);
                doClose = response == 0;
            } else {
                doClose = true;
            }
            if (doClose) {
                PuckGUI.instance().close(this.netGUI);
                this.frmPuck.dispose();
            }
        }
    }

    protected void performODS1Save() {
        try {
            File targetFile = this.netGUI.getFile() != null && StringUtils.isNotBlank((CharSequence)this.netGUI.getFile().getAbsolutePath()) ? ToolBox.setExtension(this.netGUI.getFile(), ".ods") : null;
            boolean ended = false;
            while (!ended) {
                boolean doSave;
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(targetFile);
                chooser.setDialogTitle("Export to ODS version 1");
                chooser.setFileSelectionMode(0);
                chooser.setAcceptAllFileFilterUsed(false);
                GenericFileFilter defaultFileFilter = new GenericFileFilter("ODS version 1 (*.ods)", "ods");
                chooser.addChoosableFileFilter(defaultFileFilter);
                chooser.setFileFilter(defaultFileFilter);
                if (chooser.showSaveDialog(this.frmPuck) == 0) {
                    System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                    System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                    targetFile = chooser.getSelectedFile();
                    if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
                        targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".ods");
                    }
                } else {
                    System.out.println("No Selection ");
                    ended = true;
                }
                if (ended) continue;
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                ODS1File.save(targetFile, this.netGUI.getNet());
            }
        }
        catch (PuckException exception) {
            String message;
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                }
            }
            JOptionPane.showMessageDialog(this.frmPuck, message, title, 0);
        }
    }

    private void performQuit() {
        boolean doQuit;
        if (PuckGUI.instance().existsUnsavedChanges()) {
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.text");
            int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 0);
            doQuit = response == 0;
        } else {
            doQuit = true;
        }
        if (doQuit) {
            PuckGUI.instance().exit();
        }
    }

    protected void performSave(boolean displayFileChooser, boolean persistFileName) {
        try {
            File targetFile = this.netGUI.getFile();
            boolean displayChooser = ToolBox.getExtension(targetFile) == null ? true : displayFileChooser;
            boolean ended = false;
            while (!ended) {
                boolean doSave;
                if (displayChooser) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setSelectedFile(targetFile);
                    chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(false);
                    GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.ged, *.ods, *.pl, *.puc, *.tip, *.txt, *.txt3, *.xls, *.xml)", "ged", "ods", "pl", "puc", "tip", "txt", "txt3", "xls", "xml");
                    chooser.addChoosableFileFilter(defaultFileFilter);
                    chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("Text version 3 (*.txt3)", "txt3"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
                    chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
                    chooser.setFileFilter(defaultFileFilter);
                    if (chooser.showSaveDialog(this.frmPuck) == 0) {
                        System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                        System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                        targetFile = chooser.getSelectedFile();
                        if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
                            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt3");
                        }
                    } else {
                        System.out.println("No Selection ");
                        ended = true;
                    }
                }
                if (ended) continue;
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                        displayChooser = true;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                PuckManager.saveNet(targetFile, this.netGUI.getNet());
                if (persistFileName) {
                    this.netGUI.setFile(targetFile);
                }
                this.netGUI.setChanged(false);
            }
        }
        catch (PuckException exception) {
            String message;
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                }
            }
            JOptionPane.showMessageDialog(this.frmPuck, message, title, 0);
        }
    }

    protected void performXLS1Save() {
        try {
            File targetFile = this.netGUI.getFile() != null && StringUtils.isNotBlank((CharSequence)this.netGUI.getFile().getAbsolutePath()) ? ToolBox.setExtension(this.netGUI.getFile(), ".xls") : null;
            boolean ended = false;
            while (!ended) {
                boolean doSave;
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(targetFile);
                chooser.setDialogTitle("Export to XLS version 1");
                chooser.setFileSelectionMode(0);
                chooser.setAcceptAllFileFilterUsed(false);
                GenericFileFilter defaultFileFilter = new GenericFileFilter("XLS version 1 (*.xls)", "xls");
                chooser.addChoosableFileFilter(defaultFileFilter);
                chooser.setFileFilter(defaultFileFilter);
                if (chooser.showSaveDialog(this.frmPuck) == 0) {
                    System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                    System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                    targetFile = chooser.getSelectedFile();
                    if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
                        targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".xls");
                    }
                } else {
                    System.out.println("No Selection ");
                    ended = true;
                }
                if (ended) continue;
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this.frmPuck, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                XLS1File.save(targetFile, this.netGUI.getNet());
            }
        }
        catch (PuckException exception) {
            String message;
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                }
            }
            JOptionPane.showMessageDialog(this.frmPuck, message, title, 0);
        }
    }

    public void selectFamiliesTab(Family family) {
        this.tabbedPaneCorpus.setSelectedIndex(2);
        this.familiesTab.select(family);
    }

    public void selectIndividualsTab() {
        this.tabbedPaneCorpus.setSelectedIndex(1);
    }

    public void selectIndividualsTab(Individual individual) {
        this.tabbedPaneCorpus.setSelectedIndex(1);
        this.individualsTab.select(individual);
    }

    public void selectRelationTab(Relation relation) {
        int tabIndex = this.getRelationTabIndex(relation.getModel());
        if (tabIndex != -1) {
            this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
            RelationsPanel tab = (RelationsPanel)this.tabbedPaneCorpus.getComponent(tabIndex);
            tab.select(relation);
        }
    }

    public void selectTab(int tabIndex) {
        this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
    }

    public void setIndividualsTab(Individual individual) {
        this.individualsTab.select(individual);
    }

    public void toFront() {
        this.frmPuck.toFront();
    }

    public void updateLocale(Locale locale) {
        this.frmPuck.setLocale(locale);
    }

    public void updateMenuItems() {
        if (this.netGUI.isChanged()) {
            this.mntmSave.setEnabled(true);
            this.mntmRevert.setEnabled(true);
        } else {
            this.mntmSave.setEnabled(false);
            this.mntmRevert.setEnabled(false);
        }
    }

    public void updateTitle() {
        String changeToken;
        if (this.netGUI.isChanged()) {
            changeToken = "*";
            this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
        } else {
            changeToken = "";
            this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        this.frmPuck.setTitle(String.valueOf(changeToken) + this.netGUI.getFile().getName() + "-" + this.netGUI.getId() + " - Puck");
    }

    public static void callPuckHelp(JMenuItem source) {
        String HELP_URL = "http://www.kintip.net/puck-aide-mainmenu-24";
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = new URI(HELP_URL);
                    desktop.browse(uri);
                } else if (source != null) {
                    source.setEnabled(false);
                }
            } else if (source != null) {
                source.setEnabled(false);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("The system cannot find the URL specified: [" + HELP_URL + "]");
            JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            System.out.println("Illegal character in path [" + HELP_URL + "]");
            JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
        }
    }

    public static int getDesktopHeight() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Insets insets = toolkit.getScreenInsets(gconf);
        int result = (int)(dim.getHeight() - (double)insets.bottom - (double)insets.top);
        return result;
    }

    public static void openEncodingFile(NetGUI netGUI, JFrame parentPanel, File folder) {
        String charsetName = OpenEncodingWindow.showDialog();
        logger.debug("charset=[" + charsetName + "]");
        if (charsetName != null) {
            MainWindow.openFile(netGUI, parentPanel, folder, charsetName);
        }
    }

    public static void openFile(NetGUI netGUI, JFrame parentPanel, File folder) {
        MainWindow.openFile(netGUI, parentPanel, folder, PuckManager.DEFAULT_CHARSET_NAME);
    }

    public static void openFile(NetGUI netGUI, JFrame parentPanel, File folder, String charsetName) {
        try {
            File file = MainWindow.selectFile(parentPanel, folder);
            if (file != null) {
                if (netGUI.isBlank()) {
                    netGUI.updateFile(file, charsetName);
                } else {
                    PuckGUI.instance().createNetGUI(file, charsetName);
                }
            }
        }
        catch (PuckException exception) {
            String message;
            exception.printStackTrace();
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
            switch (PuckExceptions.valueOf(exception.getCode())) {
                case FILE_NOT_FOUND: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                    break;
                }
                case BAD_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                    break;
                }
                case UNSUPPORTED_FILE_FORMAT: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                    break;
                }
                case NOT_A_FILE: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                    break;
                }
                case UNSUPPORTED_ENCODING: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                    break;
                }
                default: {
                    message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                }
            }
            JOptionPane.showMessageDialog(parentPanel, message, title, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
            JOptionPane.showMessageDialog(parentPanel, message, title, 0);
        }
    }

    public static File selectFile(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(true);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.ged, *.ods, *.paj, *.pl, *.puc, *.tip, *.txt, *.txt3, *.xls, *.xml)", "ged", "ods", "paj", "pl", "puc", "tip", "txt", "txt3", "xls", "xml");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
        chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Pajek Network (*.paj)", "paj"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
        chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
        chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Text version 3 (*.txt3)", "txt3"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
        chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }

    public static File selectFolder(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(true);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }

    public static File selectODSFileToLoad(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".ods"));
        }
        chooser.setDialogTitle("Import ODS version 1 & 2");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("ODS version 1 (*.ods)", "ods");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }

    public static File selectXLSFileToLoad(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".xls"));
        }
        chooser.setDialogTitle("Import XLS version 1 & 2");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("XLS version 1 (*.xls)", "xls");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

