/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.EvoAllianceGenNoCLI;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.clusternetworks.ClusterNetworkUtils;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.EvoStrategy;
import org.tip.puck.report.Report;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.GenerateRulesCriteria;

public class GenerateRulesInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(GenerateRulesInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JSpinner spinnerGenerationCount;

    public GenerateRulesInputWindow(final GroupNetGUI groupNetGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GenerateRulesInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle("Generate Rules Input Window");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 147);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateRulesInputWindow.this.dispose();
            }
        });
        JButton btnRestoreDefaults = new JButton("Restore defaults");
        btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateRulesInputWindow.this.setCriteria(new GenerateRulesCriteria());
            }
        });
        buttonPanel.add(btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GenerateRulesCriteria criteria = GenerateRulesInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setGenerateRulesCriteria(criteria);
                    AllianceNet allianceNet = ClusterNetworkUtils.graphToAllianceNet(groupNetGUI.getGroupNet());
                    EvoAllianceGenNoCLI callbacks = new EvoAllianceGenNoCLI(allianceNet);
                    EvoStrategy popGen = new EvoStrategy(1, 1, 1);
                    EvoGen evo = new EvoGen(popGen, callbacks, criteria.getGenerationCount());
                    evo.run();
                    Report report = ClusterNetworkReporter.reportGenerateRules(groupNetGUI.getGroupNet(), criteria, evo);
                    groupNetGUI.addReportTab(report);
                    GenerateRulesInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GenerateRulesInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "North");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNrGenerationCount = new JLabel("Generation count:");
        lblNrGenerationCount.setHorizontalAlignment(0);
        panel.add((Component)lblNrGenerationCount, "2, 4, right, default");
        this.spinnerGenerationCount = new JSpinner();
        this.spinnerGenerationCount.setModel(new SpinnerNumberModel(new Integer(100), new Integer(0), null, new Integer(100)));
        panel.add((Component)this.spinnerGenerationCount, "4, 4");
        this.setCriteria(PuckGUI.instance().getPreferences().getGenerateRulesCriteria());
    }

    public GenerateRulesCriteria getCriteria() throws PuckException {
        GenerateRulesCriteria result = new GenerateRulesCriteria();
        result.setGenerationCount((Integer)this.spinnerGenerationCount.getValue());
        return result;
    }

    public void setCriteria(GenerateRulesCriteria source) {
        if (source != null) {
            this.spinnerGenerationCount.setValue(source.getGenerationCount());
        }
    }
}

