/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.FooReporterInputWindow;

public class FlowNetworkInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(FlowNetworkInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static String lastParameter1;
    private static String lastParameter2;
    private static int lastMinimalValue;
    private JComboBox comboBoxParameter1;
    private JComboBox comboBoxParameter2;
    private JSpinner spinnerMinimalNumberOfLinks;

    static {
        lastMinimalValue = 2;
    }

    public FlowNetworkInputWindow(final NetGUI netGUI) {
        List<String> availableParameters1 = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        ArrayList<String> availableParameters2 = new ArrayList<String>(availableParameters1);
        if (lastParameter1 == null) {
            availableParameters1.add(0, "");
        } else {
            availableParameters1.add(0, lastParameter1);
        }
        if (lastParameter2 == null) {
            availableParameters2.add(0, "");
        } else {
            availableParameters2.add(0, lastParameter2);
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Flow Network Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 317, 198);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSourceLabel = new JLabel("Source Label:");
        panel.add((Component)lblSourceLabel, "2, 4, right, default");
        this.comboBoxParameter1 = new JComboBox<Object>(availableParameters1.toArray());
        this.comboBoxParameter1.setSelectedIndex(0);
        this.comboBoxParameter1.setMaximumRowCount(12);
        this.comboBoxParameter1.setEditable(true);
        panel.add((Component)this.comboBoxParameter1, "4, 4, fill, default");
        JLabel lblTargetLabel = new JLabel("Target Label:");
        panel.add((Component)lblTargetLabel, "2, 6, right, default");
        this.comboBoxParameter2 = new JComboBox<Object>(availableParameters2.toArray());
        this.comboBoxParameter2.setSelectedIndex(0);
        this.comboBoxParameter2.setMaximumRowCount(12);
        this.comboBoxParameter2.setEditable(true);
        panel.add((Component)this.comboBoxParameter2, "4, 6, fill, default");
        JLabel label = new JLabel("<html><div style=\"text-align:right\">Minimal number:<br/>of links</div></html>");
        panel.add((Component)label, "2, 8");
        this.spinnerMinimalNumberOfLinks = new JSpinner();
        this.spinnerMinimalNumberOfLinks.setModel(new SpinnerNumberModel(new Integer(2), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNumberOfLinks, "4, 8");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowNetworkInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String parameter1 = (String)FlowNetworkInputWindow.this.comboBoxParameter1.getSelectedItem();
                    String parameter2 = (String)FlowNetworkInputWindow.this.comboBoxParameter2.getSelectedItem();
                    int minimalNumberOfLinks = (Integer)FlowNetworkInputWindow.this.spinnerMinimalNumberOfLinks.getValue();
                    lastParameter1 = parameter1;
                    lastParameter2 = parameter2;
                    lastMinimalValue = minimalNumberOfLinks;
                    if (parameter1 == null || parameter2 == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Report report = ClusterNetworkReporter.reportFlowNetwork(netGUI.getSegmentation(), netGUI.getFile(), parameter1, parameter2, minimalNumberOfLinks);
                        netGUI.addReportTab(report);
                        FlowNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        this.spinnerMinimalNumberOfLinks.setValue(lastMinimalValue);
    }
}

