/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.clusternetworks.ClusterNetworkUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.AllianceNetworkCriteria;

public class AllianceNetworkInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(AllianceNetworkInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static AllianceNetworkCriteria lastCriteria;
    private JComboBox cmbBxLabel;
    private JComboBox comboBoxType;
    private JSpinner spinnerMinimalDegree;
    private JCheckBox chckbxWeightedArcs;
    private JSpinner spinnerMinimalLinkWeight;
    private final ButtonGroup buttonGroupLinkType = new ButtonGroup();
    private JSpinner spinnerMinimalNodeStrength;

    public AllianceNetworkInputWindow(final NetGUI netGUI) {
        List<String> availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        if (lastCriteria == null) {
            lastCriteria = new AllianceNetworkCriteria();
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AllianceNetworkInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Alliance Network Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 410, 330);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblLabel = new JLabel("Label:");
        panel.add((Component)lblLabel, "2, 2, right, default");
        this.cmbBxLabel = new JComboBox<Object>(availableLabels.toArray());
        this.cmbBxLabel.setMaximumRowCount(12);
        this.cmbBxLabel.setEditable(true);
        panel.add((Component)this.cmbBxLabel, "4, 2, fill, default");
        JLabel lblMinimalNumberOf = new JLabel("<html><div style=\"text-align:right\">Minimal number of<br/>links (node degree):</div></html>");
        panel.add((Component)lblMinimalNumberOf, "2, 8, right, default");
        this.spinnerMinimalDegree = new JSpinner();
        this.spinnerMinimalDegree.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalDegree, "4, 8");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AllianceNetworkInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AllianceNetworkCriteria criteria = AllianceNetworkInputWindow.this.getCriteria();
                    lastCriteria = criteria;
                    if (StringUtils.isBlank((CharSequence)criteria.getLabel())) {
                        String title = "Bad input";
                        String message = "Please, enter none empty label.";
                        JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Graph<Cluster<Individual>> graph;
                        switch (criteria.getAllianceType()) {
                            case WIFE_HUSBAND: {
                                graph = ClusterNetworkUtils.createAllianceNetwork(netGUI.getSegmentation(), criteria.getLabel(), criteria.getLineType());
                                break;
                            }
                            case SISTER_BROTHER: {
                                graph = ClusterNetworkUtils.createSiblingNetwork(netGUI.getSegmentation(), criteria.getLabel(), criteria.getLineType());
                                break;
                            }
                            default: {
                                graph = null;
                            }
                        }
                        graph = GraphUtils.reduce(graph, criteria.getMinimalDegree(), criteria.getMinimalNodeStrength(), criteria.getMinimalLinkWeight());
                        graph.attributes().put("Label", criteria.getLabel());
                        graph.attributes().put("Alliance Type", criteria.getAllianceType().toString());
                        if (criteria.getLineType() == ClusterNetworkUtils.LineType.WEIGHTED_ARC) {
                            graph.attributes().put("Weighted Arcs", "true");
                        } else {
                            graph.attributes().put("Weighted Arcs", "false");
                        }
                        graph.attributes().put("Minimal number of links (node degree)", String.valueOf(criteria.getMinimalDegree()));
                        graph.attributes().put("Minimal number of alliances per node (node strength)", String.valueOf(criteria.getMinimalLinkWeight()));
                        graph.attributes().put("Minimal number of alliances per link (link weight)", String.valueOf(criteria.getMinimalLinkWeight()));
                        PuckGUI.instance().createGroupNetGUI(graph);
                        AllianceNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        JButton btnLaunchold = new JButton("Statistics");
        btnLaunchold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AllianceNetworkCriteria criteria = AllianceNetworkInputWindow.this.getCriteria();
                    lastCriteria = criteria;
                    if (StringUtils.isBlank((CharSequence)criteria.getLabel())) {
                        String title = "Bad input";
                        String message = "Please, enter none empty label.";
                        JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Report report = ClusterNetworkReporter.reportAllianceNetwork(netGUI.getSegmentation(), netGUI.getFile(), criteria.getLabel(), criteria.getAllianceType(), criteria.getLineType(), criteria.getMinimalDegree(), criteria.getMinimalNodeStrength(), criteria.getMinimalLinkWeight());
                        netGUI.addReportTab(report);
                        AllianceNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunchold);
        buttonPanel.add(btnLaunch);
        JLabel lblAllianceType = new JLabel("Alliance Type:");
        panel.add((Component)lblAllianceType, "2, 4, right, default");
        this.comboBoxType = new JComboBox<Object>(new Object[]{"Wife-Husband", "Sister-Brother"});
        this.comboBoxType.setSelectedIndex(0);
        this.comboBoxType.setMaximumRowCount(12);
        this.comboBoxType.setEditable(true);
        panel.add((Component)this.comboBoxType, "4, 4, fill, default");
        this.chckbxWeightedArcs = new JCheckBox("Weighted Arcs");
        this.chckbxWeightedArcs.setSelected(true);
        panel.add((Component)this.chckbxWeightedArcs, "4, 6");
        JLabel lblMinimalNodeStrength = new JLabel("<html><div style=\"text-align:right\">Minimal number of<br/>alliances per node:<br/>(node strength)</div></html>\n");
        panel.add((Component)lblMinimalNodeStrength, "2, 10, right, default");
        this.spinnerMinimalNodeStrength = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNodeStrength, "4, 10");
        JLabel lblMinimalArcWeight = new JLabel("<html><div style=\"text-align:right\">Minimal number of<br/>alliances per link:<br/>(link weight)</div></html>");
        panel.add((Component)lblMinimalArcWeight, "2, 12, right, default");
        this.spinnerMinimalLinkWeight = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalLinkWeight, "4, 12");
        this.setCriteria(lastCriteria);
    }

    public AllianceNetworkCriteria getCriteria() {
        ClusterNetworkUtils.AllianceType allianceType;
        AllianceNetworkCriteria result = new AllianceNetworkCriteria();
        result.setLabel((String)this.cmbBxLabel.getSelectedItem());
        switch (this.comboBoxType.getSelectedIndex()) {
            case 0: {
                allianceType = ClusterNetworkUtils.AllianceType.WIFE_HUSBAND;
                break;
            }
            case 1: {
                allianceType = ClusterNetworkUtils.AllianceType.SISTER_BROTHER;
                break;
            }
            default: {
                allianceType = ClusterNetworkUtils.AllianceType.WIFE_HUSBAND;
            }
        }
        result.setAllianceType(allianceType);
        ClusterNetworkUtils.LineType lineType = this.chckbxWeightedArcs.isSelected() ? ClusterNetworkUtils.LineType.WEIGHTED_ARC : ClusterNetworkUtils.LineType.SIMPLE_ARC;
        result.setLineType(lineType);
        result.setMinimalDegree((Integer)this.spinnerMinimalDegree.getValue());
        result.setMinimalNodeStrength((Integer)this.spinnerMinimalNodeStrength.getValue());
        result.setMinimalLinkWeight((Integer)this.spinnerMinimalLinkWeight.getValue());
        return result;
    }

    public void setCriteria(AllianceNetworkCriteria source) {
        if (source != null) {
            this.cmbBxLabel.setSelectedItem(source.getLabel());
            switch (source.getAllianceType()) {
                case WIFE_HUSBAND: {
                    this.comboBoxType.setSelectedIndex(0);
                    break;
                }
                case SISTER_BROTHER: {
                    this.comboBoxType.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.comboBoxType.setSelectedIndex(0);
                }
            }
            if (source.getLineType() == ClusterNetworkUtils.LineType.WEIGHTED_ARC) {
                this.chckbxWeightedArcs.setSelected(true);
            } else {
                this.chckbxWeightedArcs.setSelected(false);
            }
            this.spinnerMinimalDegree.setValue(source.getMinimalDegree());
            this.spinnerMinimalNodeStrength.setValue(source.getMinimalNodeStrength());
            this.spinnerMinimalLinkWeight.setValue(source.getMinimalLinkWeight());
        }
    }
}

