/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.util.ComboBoxIds;
import org.tip.puckgui.views.IndividualsPanel;

public class IndividualSpousesModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8018474967949155510L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualSpousesModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static ImageIcon smallFemaleIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
    private static ImageIcon smallMaleIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
    private static ImageIcon smallUnknowIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));
    private static ImageIcon smallUnmarriedIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/unmarried-x16.png"));
    private static ImageIcon smallMarriedIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/married-x16.png"));
    private static ImageIcon smallDivorcedIcon = new ImageIcon(IndividualSpousesModel.class.getResource("/org/tip/puckgui/images/divorced-x16.png"));
    private NetGUI netGUI;
    private Individual source;
    private List<Individual> spouses;
    private List<Family> families;

    public IndividualSpousesModel(NetGUI netGUI, Individual source) {
        this.netGUI = netGUI;
        this.spouses = new ArrayList<Individual>();
        this.families = new ArrayList<Family>();
        this.initialize(source);
    }

    public void escapeNewEdition() {
        if (this.isNewEditionOn()) {
            logger.debug("ESCAPE d");
            int index = this.spouses.size() - 1;
            this.spouses.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = ImageIcon.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = ImageIcon.class;
                break;
            }
            case 4: {
                result = Number.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 5;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.id");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.gender");
                break;
            }
            case 2: {
                result = BUNDLE.getString("MainWindow.individual.name");
                break;
            }
            case 3: {
                result = BUNDLE.getString("MainWindow.individual.married");
                break;
            }
            case 4: {
                result = BUNDLE.getString("MainWindow.individual.family");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public Family getFamily(int rowIndex) {
        Family result = this.families == null || rowIndex < 0 || rowIndex >= this.families.size() ? null : this.families.get(rowIndex);
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.source == null ? 0 : this.spouses.size();
        return result;
    }

    public Individual getSource() {
        Individual result = this.source;
        return result;
    }

    public Individual getSpouse(int rowIndex) {
        Individual result;
        if (this.families == null || rowIndex < 0 || rowIndex >= this.families.size()) {
            result = null;
        } else {
            Family family = this.families.get(rowIndex);
            result = family.getOtherParent(this.source);
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.source == null) {
            result = null;
        } else if (this.isNewEditionOn() && rowIndex == this.spouses.size() - 1) {
            result = "";
        } else {
            block0 : switch (columnIndex) {
                case 0: {
                    if (this.spouses.get(rowIndex) == null) {
                        result = "---";
                        break;
                    }
                    result = this.spouses.get(rowIndex).getId();
                    break;
                }
                case 1: {
                    if (this.spouses.get(rowIndex) == null) {
                        result = smallUnknowIcon;
                        break;
                    }
                    switch (this.spouses.get(rowIndex).getGender()) {
                        case FEMALE: {
                            result = smallFemaleIcon;
                            break block0;
                        }
                        case MALE: {
                            result = smallMaleIcon;
                            break block0;
                        }
                        case UNKNOWN: {
                            result = smallUnknowIcon;
                            break block0;
                        }
                    }
                    result = smallUnknowIcon;
                    break;
                }
                case 2: {
                    if (this.spouses.get(rowIndex) == null) {
                        result = "Unknown";
                        break;
                    }
                    result = this.spouses.get(rowIndex).getName();
                    break;
                }
                case 3: {
                    switch (this.families.get(rowIndex).getUnionStatus()) {
                        case UNMARRIED: {
                            result = smallUnmarriedIcon;
                            break block0;
                        }
                        case MARRIED: {
                            result = smallMarriedIcon;
                            break block0;
                        }
                        case DIVORCED: {
                            result = smallDivorcedIcon;
                            break block0;
                        }
                    }
                    result = smallUnknowIcon;
                    break;
                }
                case 4: {
                    result = this.families.get(rowIndex).getId();
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public void initialize(Individual source) {
        this.source = source;
        this.spouses.clear();
        this.families.clear();
        if (source != null) {
            this.spouses = this.source.getPartners().toSortedList();
            for (Individual spouse : this.spouses) {
                this.families.add(source.getPersonalFamilies().getBySpouses(source, spouse));
            }
            for (Family family : this.source.getPersonalFamilies().singleParentFamilies().toSortedList()) {
                this.spouses.add(null);
                this.families.add(family);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        switch (col) {
            case 0: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isNewEditionOn() {
        boolean result = this.source == null ? false : this.spouses.size() == this.families.size() + 1;
        return result;
    }

    public void setNewItem() {
        this.spouses.add(new Individual(0, "?", Gender.UNKNOWN));
        this.fireTableDataChanged();
    }

    public void setSource(Individual source) {
        this.initialize(source);
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt(" + rowIndex + ", " + columnIndex + ", " + value + ")");
        if (this.netGUI != null && columnIndex == 0) {
            Individual currentIndividual = this.netGUI.selectedIndividual();
            if (this.isNewEditionOn()) {
                Individual newSpouse = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                if (newSpouse == null) {
                    if (this.source.isMale()) {
                        this.netGUI.getNet().createFamily(this.source, null, new Individual[0]);
                    } else {
                        this.netGUI.getNet().createFamily(null, this.source, new Individual[0]);
                    }
                    this.netGUI.setChanged(true);
                    this.netGUI.updateAll();
                } else {
                    String errorMessage = IndividualsPanel.controlFixedPartners(InputSettings.CheckLevel.ERROR, this.source, newSpouse, this.source.getChildren().toArray());
                    if (errorMessage != null) {
                        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                    } else {
                        Family newFamily;
                        String warningMessage = IndividualsPanel.controlFixedPartners(InputSettings.CheckLevel.WARNING, this.source, newSpouse, this.source.getChildren().toArray());
                        if (warningMessage != null) {
                            JOptionPane.showMessageDialog(null, warningMessage, "Warning", 2);
                        }
                        if ((newFamily = this.netGUI.getNet().families().getBySpouses(this.source, newSpouse)) == null) {
                            newFamily = NetUtils.isRolesFixedByGender(this.source, newSpouse) ? this.netGUI.getNet().createFamily(this.source, newSpouse, new Individual[0]) : this.netGUI.getNet().createFamily(newSpouse, this.source, new Individual[0]);
                            newFamily.setUnionStatus(this.netGUI.getDefaultUnionStatus());
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                            this.netGUI.selectIndividualsTab(currentIndividual);
                        } else {
                            JOptionPane.showMessageDialog(null, "Partners already defined.", "Error", 0);
                            this.fireTableDataChanged();
                        }
                    }
                }
            } else {
                Individual oldSpouse = this.spouses.get(rowIndex);
                Family oldFamily = this.families.get(rowIndex);
                Individual newSpouse = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                if (newSpouse == null) {
                    NetUtils.removeSpouse(oldFamily, oldSpouse);
                    this.netGUI.setChanged(true);
                    this.netGUI.updateAll();
                } else {
                    String errorMessage = IndividualsPanel.controlFixedPartners(InputSettings.CheckLevel.ERROR, this.source, newSpouse, this.source.getChildren().toArray());
                    if (errorMessage != null) {
                        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                    } else {
                        String warningMessage = IndividualsPanel.controlFixedPartners(InputSettings.CheckLevel.WARNING, this.source, newSpouse, this.source.getChildren().toArray());
                        if (warningMessage != null) {
                            JOptionPane.showMessageDialog(null, warningMessage, "Warning", 2);
                        }
                        if (newSpouse != oldSpouse) {
                            Family newFamily = this.netGUI.getNet().families().getBySpouses(this.source, newSpouse);
                            if (newFamily == null) {
                                if (oldFamily.getFather() == this.source) {
                                    NetUtils.setKinMother(oldFamily, newSpouse);
                                } else {
                                    NetUtils.setKinFather(oldFamily, newSpouse);
                                }
                                this.netGUI.setChanged(true);
                                this.netGUI.updateAll();
                                this.netGUI.selectIndividualsTab(currentIndividual);
                            } else {
                                JOptionPane.showMessageDialog(null, "New partner already defined.", "Error", 0);
                            }
                        }
                    }
                }
            }
        }
    }

    public Individual source() {
        Individual result = this.source;
        return result;
    }

    public List<Individual> spouses() {
        List<Individual> result = this.spouses;
        return result;
    }
}

