/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;

public class FamiliesModel
extends AbstractListModel {
    private static final long serialVersionUID = -4415669569733860497L;
    protected Families source;
    protected List<Family> delegate;
    private int lastFamilySearchIndex;
    private String lastFamilySearchPattern;

    public FamiliesModel(Families source) {
        this.source = source;
        this.delegate = source == null ? new ArrayList<Family>(0) : this.source.toSortedList();
        this.lastFamilySearchIndex = -1;
        this.lastFamilySearchPattern = null;
    }

    @Override
    public Object getElementAt(int index) {
        Family result = this.delegate.get(index);
        return result;
    }

    @Override
    public int getSize() {
        int result = this.delegate.size();
        return result;
    }

    public Families getSource() {
        return this.source;
    }

    public int indexOf(Family family) {
        int result;
        if (this.source == null) {
            result = -1;
        } else {
            boolean ended = false;
            result = -1;
            int index = 0;
            while (!ended) {
                if (index < this.delegate.size()) {
                    if (this.delegate.get(index) == family) {
                        ended = true;
                        result = index;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = -1;
            }
        }
        return result;
    }

    public Family nextSearchedFamily(String pattern) {
        Family result;
        if (StringUtils.isBlank((CharSequence)pattern)) {
            result = null;
        } else if (NumberUtils.isDigits((String)pattern)) {
            int familyId = Integer.parseInt(pattern);
            result = (Family)this.source.getById(familyId);
            this.resetFamilySearch();
        } else {
            List<Family> foundFamilies = this.source.searchByName(pattern);
            if (foundFamilies.isEmpty()) {
                this.resetFamilySearch();
                result = null;
            } else if (this.lastFamilySearchPattern == null || !this.lastFamilySearchPattern.equals(pattern)) {
                this.lastFamilySearchIndex = 0;
                this.lastFamilySearchPattern = pattern;
                result = foundFamilies.get(0);
            } else {
                ++this.lastFamilySearchIndex;
                if (this.lastFamilySearchIndex >= foundFamilies.size()) {
                    this.lastFamilySearchIndex = 0;
                }
                result = foundFamilies.get(this.lastFamilySearchIndex);
            }
        }
        return result;
    }

    public int nextSearchedFamilyIndex(String pattern) {
        int result = this.indexOf(this.nextSearchedFamily(pattern));
        return result;
    }

    public void resetFamilySearch() {
        this.lastFamilySearchIndex = -1;
        this.lastFamilySearchPattern = null;
    }

    public void setSource(Families source) {
        this.resetFamilySearch();
        this.fireIntervalRemoved(this, 0, this.delegate.size());
        this.source = source;
        this.delegate = this.source.toSortedList();
        this.fireIntervalAdded(this, 0, this.delegate.size());
    }
}

