/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.views.MainWindow;
import org.tip.puckgui.views.RelationsPanel;

public class NetGUI
implements WindowGUI {
    private static final Logger logger = LoggerFactory.getLogger(NetGUI.class);
    private int id;
    private File file;
    private Net net;
    private MainWindow window;
    private boolean changed;
    private Segmentation segmentation;

    public NetGUI(int id) {
        this.id = id;
        this.file = new File(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName"));
        this.net = new Net();
        this.net.setLabel(this.file.getName());
        this.changed = false;
        this.segmentation = new Segmentation(this.net);
        this.window = new MainWindow(this);
    }

    public NetGUI(int id, File file, Net net) {
        this.id = id;
        this.file = file;
        this.net = net;
        this.changed = false;
        this.segmentation = new Segmentation(this.net);
        PuckGUI.instance().recentFiles().updateFile(file);
        PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());
        this.window = new MainWindow(this);
        this.window.selectIndividualsTab(null);
    }

    public void addRelationTab(RelationModel relationModel) {
        this.window.addRelationTab(relationModel);
    }

    @Override
    public void addReportTab(Report report) {
        this.window.addReportTab(report);
    }

    public void addTab(String tabTitle, JPanel panel) {
        this.window.addTab(tabTitle, panel);
    }

    public void changeSegmentationToClear() throws PuckException {
        if (!this.segmentation.isAtTheTop()) {
            Individual selectedIndividual = this.selectedIndividual();
            this.segmentation.clear();
            this.changeSegmentationToCluster(selectedIndividual);
        }
    }

    public void changeSegmentationToCluster(Individual individual) throws PuckException {
        if (individual != null) {
            this.segmentation.selectCluster(individual);
            this.window.getSegmentationPanel().update();
            this.window.getIndividualsTab().update(individual);
            this.window.selectIndividualsTab();
            this.window.getFamiliesTab().update();
            for (RelationsPanel tab : this.window.getRelationTabs()) {
                tab.update();
            }
        }
    }

    public void changeSegmentationToCluster(int clusterIndex) throws PuckException {
        this.segmentation.selectCluster(clusterIndex);
        this.window.getSegmentationPanel().update();
        this.window.getIndividualsTab().update();
        this.window.setIndividualsTab(null);
        this.window.getFamiliesTab().update();
        for (RelationsPanel tab : this.window.getRelationTabs()) {
            tab.update();
        }
    }

    public void changeSegmentationToDown() throws PuckException {
        if (!this.segmentation.isAtTheBottom()) {
            this.changeSegmentationToPartition(this.segmentation.getCurrentSegmentIndex() + 1);
        }
    }

    public void changeSegmentationToNew(PartitionCriteria criteria) throws PuckException {
        if (criteria != null) {
            Individual selectedIndividual = this.selectedIndividual();
            this.segmentation.addSegment(criteria);
            this.segmentation.selectCluster(selectedIndividual);
            this.window.getSegmentationPanel().update();
            this.window.getIndividualsTab().update();
            this.window.getIndividualsTab().select(selectedIndividual);
            this.window.getFamiliesTab().update();
            for (RelationsPanel tab : this.window.getRelationTabs()) {
                tab.update();
            }
        }
    }

    public void changeSegmentationToPartition(int partitionIndex) throws PuckException {
        if (partitionIndex >= 0 && partitionIndex < this.segmentation.size()) {
            Individual selectedIndividual = this.selectedIndividual();
            Family selectedFamily = this.selectedFamily();
            this.segmentation.selectPartition(partitionIndex);
            if (selectedIndividual != null) {
                this.segmentation.selectCluster(selectedIndividual);
            }
            this.window.getSegmentationPanel().update();
            this.window.getIndividualsTab().update();
            this.window.getIndividualsTab().select(selectedIndividual);
            this.window.getFamiliesTab().update();
            this.window.getFamiliesTab().select(selectedFamily);
            for (RelationsPanel tab : this.window.getRelationTabs()) {
                tab.update();
            }
        }
    }

    public void changeSegmentationToPop() throws PuckException {
        if (!this.segmentation.isAtTheTop()) {
            this.changeSegmentationToUp();
            this.segmentation.clearBelow();
            this.window.getSegmentationPanel().update();
        }
    }

    public void changeSegmentationToRoot() throws PuckException {
        if (!this.segmentation.isAtTheTop()) {
            this.changeSegmentationToPartition(0);
        }
    }

    public void changeSegmentationToUp() throws PuckException {
        if (!this.segmentation.isAtTheTop()) {
            this.changeSegmentationToPartition(this.segmentation.getCurrentSegmentIndex() - 1);
        }
    }

    @Override
    public void closeCurrentTab() {
        this.window.closeCurrentTab();
    }

    public void closeRelationTab(RelationModel relationModel) {
        this.window.closeCurrentTab();
        this.setChanged(true);
    }

    public Families getCurrentFamilies() {
        Families result = this.segmentation.getCurrentFamilies();
        return result;
    }

    public Individuals getCurrentIndividuals() {
        Individuals result = this.segmentation.getCurrentIndividuals();
        return result;
    }

    public Relations getCurrentRelations() {
        Relations result = this.segmentation.getCurrentRelations();
        return result;
    }

    public UnionStatus getDefaultUnionStatus() {
        UnionStatus result = this.window.getIndividualsTab().getDefaultUnionStatus();
        return result;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public NumberablesHashMap.IdStrategy getIndividualIdStrategy() {
        NumberablesHashMap.IdStrategy result = this.window.getIndividualsTab().getIndividualIdStrategy();
        return result;
    }

    @Override
    public JFrame getJFrame() {
        JFrame result = this.window.getJFrame();
        return result;
    }

    public Net getNet() {
        return this.net;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public Family getSelectedFamily() {
        Family result = this.window.getFamiliesTab().getSelectedFamily();
        return result;
    }

    @Override
    public String getTitle() {
        String result = String.valueOf(this.getFile().getName()) + "-" + this.getId() + " (Net)";
        return result;
    }

    public boolean isBlank() {
        boolean result = this.net.individuals().size() == 0 && !this.file.getName().contains(".");
        return result;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public void revert() throws PuckException {
        int currentTabIndex = this.window.getCurrentTabIndex();
        if (ToolBox.getExtension(this.getFile()) == null) {
            this.setNet(new Net());
            this.setChanged(false);
        } else {
            Net net = PuckManager.loadCorpus(this.getFile());
            this.setNet(net);
            this.setChanged(false);
        }
        this.window.selectTab(currentTabIndex);
    }

    public Family selectedFamily() {
        Family result = this.window.getFamiliesTab().getSelectedFamily();
        return result;
    }

    public Individual selectedIndividual() {
        Individual result = this.window.getIndividualsTab().getSelectedIndividual();
        return result;
    }

    public void selectFamiliesTab(Family family) {
        this.window.selectFamiliesTab(family);
    }

    public void selectIndividualsTab(Individual individual) {
        this.window.selectIndividualsTab(individual);
    }

    public void selectRelationTab(Relation relation) {
        this.window.selectRelationTab(relation);
    }

    public void setBlank() {
        this.window.closeRelationTabs();
        this.file = new File(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName"));
        this.net = new Net();
        this.net.setLabel(this.file.getName());
        this.changed = false;
        this.segmentation = new Segmentation(this.net);
        this.window.updateMenuItems();
        this.window.updateTitle();
        this.window.getSegmentationPanel().update();
        this.window.getCorpusTab().update();
        this.window.getIndividualsTab().update();
        this.window.getFamiliesTab().update();
        this.window.getIndividualsTab().select(null);
        this.window.getFamiliesTab().select(null);
        this.window.closeReportTabs();
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
        this.window.updateMenuItems();
        this.window.updateTitle();
    }

    public void setChanged(boolean changed, String additionalName) {
        this.changed = changed;
        if (ToolBox.getExtension(this.getFile()) != null) {
            this.file = ToolBox.addToName(this.getFile(), additionalName);
        }
        this.window.updateMenuItems();
        this.window.updateTitle();
    }

    public void setFile(File file) {
        this.file = file;
        this.net.setLabel(file.getName());
        this.window.updateMenuItems();
        this.window.updateTitle();
        PuckGUI.instance().recentFiles().updateFile(file);
        PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());
        this.window.getCorpusTab().update();
    }

    public void setNet(Net net) {
        this.net = net;
        this.segmentation = new Segmentation(net);
        this.window.getSegmentationPanel().update();
        this.window.getCorpusTab().update();
        this.window.getIndividualsTab().update();
        this.window.selectIndividualsTab(null);
        this.window.getFamiliesTab().update();
        this.window.closeRelationTabs();
        for (RelationModel relationModel : net.relationModels()) {
            this.window.addTab(relationModel.getName(), new RelationsPanel(this, relationModel));
        }
    }

    @Override
    public void toFront() {
        this.window.toFront();
    }

    public void updateAll() {
        this.window.getSegmentationPanel().update();
        this.window.getCorpusTab().update();
        this.window.getIndividualsTab().update();
        this.window.getFamiliesTab().update();
        if (this.net != null) {
            for (RelationModel relationModel : this.net.relationModels()) {
                this.window.getRelationTab(relationModel).update();
            }
        }
    }

    public void updateFile(File file) throws PuckException {
        this.updateFile(file, "UTF-8");
    }

    public void updateFile(File file, String charsetName) throws PuckException {
        Net net = PuckManager.loadCorpus(file, charsetName);
        this.setChanged(false);
        this.setFile(file);
        this.setNet(net);
        this.window.selectIndividualsTab(null);
    }

    public void updateIndividualIdentity() {
        this.window.getIndividualsTab().updateIndividualIdentity();
    }

    @Override
    public void updateLocale(Locale locale) {
        int tabIndex = this.window.getCurrentTabIndex();
        this.window.dispose();
        this.window = new MainWindow(this);
        if (tabIndex < 3) {
            this.window.selectTab(tabIndex);
        } else {
            this.window.selectIndividualsTab();
        }
    }

    public void updateRelationIdentity(RelationModel relationModel) {
        this.window.getRelationTab(relationModel).updateRelationIdentity();
    }
}

