/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import fr.devinsy.util.StringList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;
import org.tip.puck.workers.NodeReferentValuator;

public class PuckUtils {
    private static final Logger logger = LoggerFactory.getLogger(PuckUtils.class);

    public static <E> StringList writePajekNetwork(Graph<E> source) throws PuckException {
        StringList result = PuckUtils.writePajekNetwork(source, null);
        return result;
    }

    public static <E> StringList writePajekNetwork(Graph<E> source, List<String> partitionLabels) throws PuckException {
        StringList result = GraphUtils.writePajekNetwork(source, NodeValuator.getMatchingLabels(partitionLabels));
        for (String label : NodeValuator.getNotMatchingLabels(partitionLabels)) {
            result.appendln();
            Values values = new NodeReferentValuator<Node<E>>().get(source.getNodes().toListSortedById(), label);
            if (values.isNumeric()) {
                result.appendln("*Vector " + label);
                result.appendln("*vertices " + source.nodeCount());
                for (Value value : values) {
                    result.appendln(value.intValue());
                }
                continue;
            }
            Partition<Value> partition = PartitionMaker.create(label, values);
            partition = PartitionMaker.createNumerized(partition);
            result.appendln("*Partition " + partition.getLabel());
            result.appendln("*vertices " + source.nodeCount());
            int valueIndex = 1;
            while (valueIndex <= values.size()) {
                Value value = (Value)values.get(valueIndex - 1);
                result.appendln(partition.getValue(value).intValue());
                ++valueIndex;
            }
        }
        return result;
    }

    public static <E> StringList writePajekPartition(Partition<E> partition, Comparator<E> comparator) throws PuckException {
        StringList result = new StringList();
        String label = partition.getLabel();
        if (partition.isNumeric()) {
            result.appendln("*Vector " + label);
            result.appendln("*vertices " + partition.itemsCount());
            for (E item : partition.getItemsAsSortedList(comparator)) {
                result.appendln(partition.getValue(item).intValue());
            }
        } else {
            partition = PartitionMaker.createNumerized(partition);
            result.appendln("*Partition " + label);
            result.appendln("*vertices " + partition.itemsCount());
            for (E item : partition.getItemsAsSortedList(comparator)) {
                result.appendln(partition.getValue(item).intValue());
            }
        }
        return result;
    }
}

