/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberableComparator;
import org.tip.puck.util.Numberables;

public class NumberablesHashMap<NumberableType extends Numberable>
implements Numberables<NumberableType> {
    protected HashMap<Integer, NumberableType> data;

    public NumberablesHashMap() {
        this.data = new HashMap();
    }

    public NumberablesHashMap(int initialCapacity) {
        this.data = new HashMap(initialCapacity);
    }

    public void add(NumberableType numberableObject) {
        this.put(numberableObject);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public boolean contains(NumberableType numberableObject) {
        boolean result = this.data.containsValue(numberableObject);
        return result;
    }

    @Override
    public boolean containsId(int id) {
        boolean result = this.data.containsKey(id);
        return result;
    }

    @Override
    public NumberableType getById(int id) {
        Numberable result = (Numberable)this.data.get(id);
        return (NumberableType)result;
    }

    public int getFirstFreeId() {
        int result;
        Object[] ids = this.getIds();
        if (ids.length == 0) {
            result = 1;
        } else {
            Arrays.sort(ids);
            boolean ended = false;
            int index = 0;
            result = -1;
            while (!ended) {
                if (index < ids.length - 1) {
                    if ((Integer)ids[index] + 1 == (Integer)ids[index + 1]) {
                        ++index;
                        continue;
                    }
                    ended = true;
                    result = (Integer)ids[index] + 1;
                    continue;
                }
                ended = true;
                result = (Integer)ids[index] + 1;
            }
        }
        return result;
    }

    public int getFirstId() {
        int result = Integer.MAX_VALUE;
        for (Integer id : this.data.keySet()) {
            if (id >= result) continue;
            result = id;
        }
        if (result == Integer.MAX_VALUE) {
            result = 0;
        }
        return result;
    }

    @Override
    public Integer[] getIds() {
        Integer[] result = new Integer[this.data.keySet().size()];
        this.data.keySet().toArray(result);
        return result;
    }

    public int getLastId() {
        int result = 0;
        for (Integer id : this.data.keySet()) {
            if (id <= result) continue;
            result = id;
        }
        return result;
    }

    public List<Integer> getSparseIds() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object[] ids = this.getIds();
        Arrays.sort(ids);
        int index = 1;
        while (index < ids.length) {
            if ((Integer)ids[index] - 1 != (Integer)ids[index - 1]) {
                result.add(index);
            }
            ++index;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = this.data.isEmpty();
        return result;
    }

    @Override
    public Iterator<NumberableType> iterator() {
        Iterator<NumberableType> result = this.data.values().iterator();
        return result;
    }

    public int nextFreeId(IdStrategy strategy) {
        int result;
        if (strategy == null) {
            result = 0;
        } else {
            switch (strategy) {
                case FILL: {
                    result = this.getFirstFreeId();
                    break;
                }
                case APPEND: {
                    result = this.getLastId() + 1;
                    break;
                }
                case SIZE: {
                    result = this.size() + 1;
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    @Override
    public void put(NumberableType numberableObject) {
        if (numberableObject != null) {
            this.data.put(numberableObject.getId(), numberableObject);
        }
    }

    @Override
    public void removeById(int id) {
        this.data.remove(id);
    }

    @Override
    public int size() {
        int result = this.data.size();
        return result;
    }

    public List<NumberableType> toList() {
        ArrayList<NumberableType> result = new ArrayList<NumberableType>(this.data.values());
        return result;
    }

    public List<NumberableType> toSortedList() {
        List<NumberableType> result = this.toList();
        Collections.sort(result, new NumberableComparator());
        return result;
    }

    public static enum IdStrategy {
        FILL,
        APPEND,
        SIZE;

    }
}

