/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Family;
import org.tip.puck.net.FamilyComparator;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Clusters;
import org.tip.puck.partitions.MultiPartition;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.BIASCount;
import org.tip.puck.statistics.BIASCounts;
import org.tip.puck.statistics.FiliationCount;
import org.tip.puck.statistics.FiliationCounts;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class StatisticsReporter {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsReporter.class);

    public static <E> ReportChart createArrayChart(String title, double[][] array, String[] lineTitles) {
        ReportChart result = new ReportChart(title, ReportChart.GraphType.LINES);
        int j = 0;
        while (j < array[0].length) {
            result.setLineTitle(lineTitles[j], j);
            int i = 0;
            while (i < array.length) {
                result.setHeader(String.valueOf(i), i);
                result.setValue(array[i][j], j, i);
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static ReportChart createCompletenessChart(FiliationCounts counts) {
        ReportChart result = new ReportChart("Genealogical Completeness", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational depth");
        result.setLinesLegend("% ascendants");
        result.setLineTitle("Overall", 0);
        result.setLineTitle("Agnatic", 1);
        result.setLineTitle("Uterine", 2);
        int ascendingIndex = 1;
        while (ascendingIndex < counts.size()) {
            FiliationCount count = counts.get(ascendingIndex);
            if (count.isPositive()) {
                result.addValue(ascendingIndex, count.getCognatic(), 0);
                result.addValue(ascendingIndex, count.getAgnatic(), 1);
                result.addValue(ascendingIndex, count.getUterine(), 2);
            }
            ++ascendingIndex;
        }
        return result;
    }

    public static ReportChart createComponentsChart(Individuals individuals, int resolution) throws PuckException {
        FiliationCounts counts = StatisticsWorker.components(individuals, resolution);
        ReportChart result = new ReportChart("Components", ReportChart.GraphType.LINES);
        result.setLogarithmType(ReportChart.LogarithmType.HORIZONTAL);
        result.setHeadersLegend("% Individuals");
        result.setLinesLegend("% Components");
        result.setLineTitle("Agnatic", 0);
        result.setLineTitle("Uterine", 1);
        int ascendingIndex = 0;
        while (ascendingIndex < counts.size()) {
            result.addValue(MathUtils.percent(ascendingIndex, resolution), counts.get(ascendingIndex).getAgnatic(), 0);
            result.addValue(MathUtils.percent(ascendingIndex, resolution), counts.get(ascendingIndex).getUterine(), 1);
            ++ascendingIndex;
        }
        return result;
    }

    public static ReportChart createFratryDistributionChart(FiliationCounts counts) throws PuckException {
        ReportChart result = new ReportChart("Fratry Distribution", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Size");
        result.setLinesLegend("Number");
        result.setLineTitle("Uterine", 0);
        result.setLineTitle("Agnatic", 1);
        int countIndex = 2;
        while (countIndex < counts.size()) {
            result.setHeader(MathUtils.toString(countIndex), countIndex);
            result.addValue(countIndex, counts.get(countIndex).getUterine(), 0);
            result.addValue(countIndex, counts.get(countIndex).getAgnatic(), 1);
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createFratryDistributionTable(FiliationCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size() + 1, 5);
        result.setTitle("Fratry Distribution");
        result.set(0, 0, " ");
        result.set(0, 1, "Uterine");
        result.set(0, 2, "Agnatic");
        result.set(0, 3, "% Agnatic");
        result.set(0, 4, "% Uterine");
        int agnaticSum = counts.agnaticSum();
        int uterineSum = counts.uterineSum();
        int countIndex = 0;
        while (countIndex < counts.size()) {
            result.set(countIndex + 1, 0, countIndex);
            result.set(countIndex + 1, 1, MathUtils.toString(counts.get(countIndex).getUterine()));
            result.set(countIndex + 1, 2, MathUtils.toString(counts.get(countIndex).getAgnatic()));
            result.set(countIndex + 1, 3, MathUtils.percent(counts.get(countIndex).getUterine(), (double)uterineSum));
            result.set(countIndex + 1, 4, MathUtils.percent(counts.get(countIndex).getAgnatic(), (double)agnaticSum));
            ++countIndex;
        }
        return result;
    }

    public static ReportChart createGenderBIASNetWeightChart(BIASCounts counts) {
        ReportChart result = new ReportChart("Gender BIAS (net weight)", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational Distance");
        result.setLinesLegend("% Individuals");
        result.setLineTitle("Only Uterine Ancestor Known", 0);
        result.setLineTitle("Only Agnatic Ancestor Known", 1);
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            if (count.isPositive()) {
                result.setHeader(MathUtils.toString(countIndex), countIndex);
                result.addValue(countIndex, count.getUterine(), 0);
                result.addValue(countIndex, count.getAgnatic(), 1);
            }
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createGenderBIASNetWeightTable(BIASCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size(), 5);
        result.setTitle("Gender BIAS (net weight)");
        result.set(0, 0, " ");
        result.set(0, 1, "A or U");
        result.set(0, 2, "U not A");
        result.set(0, 3, "A not U");
        result.set(0, 4, "Diff");
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            result.set(countIndex, 0, countIndex);
            result.set(countIndex, 1, count.getCoo());
            result.set(countIndex, 2, count.getUterine());
            result.set(countIndex, 3, count.getAgnatic());
            result.set(countIndex, 4, MathUtils.roundHundredth(count.getUterine() - count.getAgnatic()));
            ++countIndex;
        }
        return result;
    }

    public static ReportChart createGenderBIASWeightChart(BIASCounts counts) {
        ReportChart result = new ReportChart("Gender BIAS (weight)", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Generational Distance");
        result.setLinesLegend("% Individuals");
        result.setLineTitle("Uterine Ancestor Known", 0);
        result.setLineTitle("Agnatic Ancestor Known", 1);
        result.setLineTitle("Agn. and Ut. Ancestor Known", 2);
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            if (count.isPositive()) {
                result.setHeader(MathUtils.toString(countIndex), countIndex);
                result.addValue(countIndex, count.getUterine(), 0);
                result.addValue(countIndex, count.getAgnatic(), 1);
                result.addValue(countIndex, count.getCognatic(), 2);
            }
            ++countIndex;
        }
        return result;
    }

    public static ReportTable createGenderBIASWeightTable(BIASCounts counts) throws PuckException {
        ReportTable result = new ReportTable(counts.size(), 6);
        result.setTitle("Gender BIAS (weight)");
        result.set(0, 0, " ");
        result.set(0, 1, "A or U");
        result.set(0, 2, "U");
        result.set(0, 3, "A");
        result.set(0, 4, "A and U");
        result.set(0, 5, "Diff");
        int countIndex = 1;
        while (countIndex < counts.size()) {
            BIASCount count = counts.get(countIndex);
            result.set(countIndex, 0, countIndex);
            result.set(countIndex, 1, count.getCoo());
            result.set(countIndex, 2, count.getUterine());
            result.set(countIndex, 3, count.getAgnatic());
            result.set(countIndex, 4, count.getCognatic());
            result.set(countIndex, 5, MathUtils.roundHundredth(count.getUterine() - count.getAgnatic()));
            ++countIndex;
        }
        return result;
    }

    public static <E> ReportChart createMapChart(Map<Value, Double[]> map, int idx, String label) throws PuckException {
        ReportChart result;
        if (map == null) {
            result = null;
        } else {
            result = new ReportChart(label, ReportChart.GraphType.STACKED_BARS);
            int index = 0;
            for (Value key : map.keySet()) {
                result.setHeader(key.toString(), index);
                result.addValue(map.get(key)[idx], 0);
                ++index;
            }
        }
        return result;
    }

    public static ReportChart createMeanClusterValuesChart(String criteriaString, Map<Cluster<Individual>, Double> source) throws PuckException {
        ReportChart result;
        if (criteriaString == null || source == null) {
            result = null;
        } else {
            result = new ReportChart("Mean Cluster Values (" + criteriaString + ")", ReportChart.GraphType.SCATTER);
            result.setHeadersLegend("Size");
            result.setLinesLegend("Mean Values");
            result.setLineTitle("Clusters", 0);
            int columnIndex = 0;
            for (Cluster<Individual> cluster : source.keySet()) {
                result.setHeader(cluster.getLabel(), columnIndex);
                result.addValue(cluster.size(), (double)source.get(cluster), 0);
                ++columnIndex;
            }
        }
        return result;
    }

    public static ReportTable createMeanClusterValuesTable(String criteriaString, Clusters<Individual> source, Map<Cluster<Individual>, Double> means) throws PuckException {
        ReportTable result;
        if (criteriaString == null || source == null || means == null) {
            result = null;
        } else {
            result = new ReportTable(source.size() + 1, 4);
            result.setTitle("Mean Cluster Values (" + criteriaString + ")");
            result.set(0, 0, "Cluster");
            result.set(0, 1, "Name");
            result.set(0, 2, "Mean Value");
            result.set(0, 3, "Size");
            int rowIndex = 1;
            for (Cluster<Individual> cluster : source.toListSortedByDescendingSize()) {
                result.set(rowIndex, 0, rowIndex);
                result.set(rowIndex, 1, cluster.getLabel());
                result.set(rowIndex, 2, MathUtils.toString(means.get(cluster)));
                result.set(rowIndex, 3, MathUtils.toString(cluster.size()));
                ++rowIndex;
            }
        }
        return result;
    }

    public static <E> ReportChart createMultiPartitionChart(MultiPartition<E> partitions) throws PuckException {
        ReportChart result = new ReportChart(partitions.getLabel(), ReportChart.GraphType.STACKED_BARS);
        int columnIndex = 0;
        for (Value columnValue : partitions.colValues()) {
            result.setLineTitle(columnValue.toString(), columnIndex);
            int rowIndex = 0;
            for (Value rowValue : partitions.rowValues()) {
                result.setHeader(rowValue.toString(), rowIndex);
                result.setValue(partitions.frequency(rowValue, columnValue), columnIndex, rowIndex);
                ++rowIndex;
            }
            ++columnIndex;
        }
        return result;
    }

    public static <E> ReportChart createPartitionChart(Partition<E> partition) throws PuckException {
        ReportChart result;
        if (partition == null) {
            result = null;
        } else {
            result = new ReportChart(partition.getLabel(), ReportChart.GraphType.STACKED_BARS);
            int clusterIndex = 0;
            for (Cluster<E> cluster : partition.getClusters().toListSortedByValue()) {
                result.setHeader(cluster.getLabel(), clusterIndex);
                result.addValue(cluster.size(), 0);
                ++clusterIndex;
            }
        }
        return result;
    }

    public static ReportChart createPartitionChart(Partition<Individual> source, PartitionCriteria partitionCriteria, PartitionCriteria splitCriteria) throws PuckException {
        ReportChart result;
        if (source == null || partitionCriteria == null || !partitionCriteria.isValid()) {
            result = null;
        } else {
            Partition<Individual> partition = source;
            if (partitionCriteria.getSizeFilter() != null && partitionCriteria.getSizeFilter() != PartitionCriteria.SizeFilter.NONE) {
                partition = PartitionMaker.createCleaned(partition, partitionCriteria.getSizeFilter());
            }
            if (partitionCriteria.getValueFilter() != null && partitionCriteria.getValueFilter() != PartitionCriteria.ValueFilter.NONE) {
                partition = PartitionMaker.createCleaned(partition, partitionCriteria.getValueFilter());
            }
            result = new ReportChart(String.valueOf(partition.getLabel()) + " " + partitionCriteria.toShortString(), ReportChart.GraphType.STACKED_BARS);
            if (partitionCriteria.getCumulationType() == PartitionCriteria.CumulationType.ASCENDANT) {
                int clusterIndex = 0;
                int cumulation = 0;
                for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.addValue(cumulation += cluster.size(), 0);
                    ++clusterIndex;
                }
            } else if (partitionCriteria.getCumulationType() == PartitionCriteria.CumulationType.DESCENDANT) {
                int clusterIndex = partition.size() - 1;
                int cumulation = 0;
                List<Cluster<Individual>> clusters = partition.getClusters().toListSortedByValue();
                Collections.reverse(clusters);
                for (Cluster<Individual> cluster : clusters) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.setValue(cumulation += cluster.size(), 0, clusterIndex);
                    --clusterIndex;
                }
            } else if (splitCriteria != null && splitCriteria.isValid()) {
                int clusterIndex = 0;
                HashMap<String, Integer> clusterValueToLineIndex = new HashMap<String, Integer>();
                for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
                    Partition<Individual> split = PartitionMaker.create("split", new Individuals(cluster.getItems()), splitCriteria);
                    logger.debug("split cluster size=" + split.size());
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    for (Cluster<Individual> splitCluster : split.getClusters().toListSortedByValue()) {
                        String splitClusterLabel = splitCluster.getLabel() == null ? "null" : splitCluster.getLabel();
                        Integer lineIndex = (Integer)clusterValueToLineIndex.get(splitClusterLabel);
                        if (lineIndex == null) {
                            lineIndex = clusterValueToLineIndex.size();
                            clusterValueToLineIndex.put(splitClusterLabel, lineIndex);
                            result.setLineTitle(splitClusterLabel, lineIndex);
                        }
                        result.setValue(splitCluster.size(), lineIndex, clusterIndex);
                    }
                    ++clusterIndex;
                }
            } else {
                int clusterIndex = 0;
                for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
                    result.setHeader(cluster.getLabel(), clusterIndex);
                    result.addValue(cluster.size(), 0);
                    ++clusterIndex;
                }
            }
        }
        return result;
    }

    public static Report reportBasicInformation(Net net, Segmentation segmentation) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Basic statistics about a corpus.");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        if (segmentation.isOn()) {
            result.setInputComment("Segmentation:\n" + segmentation.getSummary());
        }
        StatisticsWorker worker = new StatisticsWorker(net);
        ReportAttributes items = new ReportAttributes();
        StatisticsWorker.Indicator[] indicatorArray = StatisticsWorker.Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsWorker.Indicator indicator = indicatorArray[n2];
            if (!indicator.equals((Object)StatisticsWorker.Indicator.MEAN_DEPTH) && !indicator.equals((Object)StatisticsWorker.Indicator.MEAN_SPOUSE_DISTANCE_GEN)) {
                worker.addItem(items, indicator);
            }
            ++n2;
        }
        result.outputs().append(items);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCompleteness(Segmentation segmentation) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Completeness statistics about a corpus.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        if (segmentation.isOn()) {
            result.setInputComment(segmentation.getSummary());
        }
        FiliationCounts counts = StatisticsWorker.completeness(segmentation.getCurrentIndividuals(), 10);
        ReportChart reportChart = StatisticsReporter.createCompletenessChart(counts);
        result.outputs().append(reportChart);
        result.outputs().appendln();
        result.outputs().append(ReportTable.transpose(reportChart.createReportTableWithSum()));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFamiliesByHusband(Net net) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Family Spouse Ids (by Husband).");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        ArrayList<String> strings = new ArrayList<String>();
        for (Family family : net.families().toSortedList(FamilyComparator.Sorting.HUSBAND)) {
            String wifeName;
            int wifeId;
            String husbandName;
            int husbandId;
            if (family.getHusband() == null) {
                husbandId = 0;
                husbandName = "";
            } else {
                husbandId = family.getHusband().getId();
                husbandName = family.getHusband().getName();
            }
            if (family.getWife() == null) {
                wifeId = 0;
                wifeName = "";
            } else {
                wifeId = family.getWife().getId();
                wifeName = family.getWife().getName();
            }
            String string = String.valueOf(husbandId) + "\t" + husbandName + "\t" + wifeId + "\t" + wifeName + "\t" + family.getId();
            strings.add(string);
        }
        result.outputs().appendln("Husband\tWife\tFamily");
        for (String string : strings) {
            result.outputs().appendln(string);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFamiliesByWife(Net net) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Family Spouse Ids (by Wife).");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        ArrayList<String> strings = new ArrayList<String>();
        for (Family family : net.families().toSortedList(FamilyComparator.Sorting.WIFE)) {
            String wifeName;
            int wifeId;
            String husbandName;
            int husbandId;
            if (family.getHusband() == null) {
                husbandId = 0;
                husbandName = "";
            } else {
                husbandId = family.getHusband().getId();
                husbandName = family.getHusband().getName();
            }
            if (family.getWife() == null) {
                wifeId = 0;
                wifeName = "";
            } else {
                wifeId = family.getWife().getId();
                wifeName = family.getWife().getName();
            }
            String string = String.valueOf(wifeId) + "\t" + wifeName + "\t" + husbandId + "\t" + husbandName + "\t" + family.getId();
            strings.add(string);
        }
        result.outputs().appendln("Wife\tHusband\tFamily");
        for (String string : strings) {
            result.outputs().appendln(string);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGraphicsStatistics(Segmentation segmentation, StatisticsCriteria criteria, File sourceFile) throws PuckException {
        Report result;
        if (segmentation == null || criteria == null) {
            result = null;
        } else {
            double[][] consCount;
            Object partition;
            ReportChart chart;
            ArrayList counts;
            Chronometer chrono = new Chronometer();
            result = new Report();
            result.setTitle("Basic graphics statistics about a corpus.");
            result.setOrigin("Statistics reporter");
            result.setTarget(segmentation.getLabel());
            if (segmentation.isOn()) {
                result.setInputComment("Segmentation:\n" + segmentation.getSummary());
            }
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            if (criteria.isGenderBIASWeight()) {
                counts = StatisticsWorker.biasWeights(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createGenderBIASWeightChart(counts));
                tables.add(StatisticsReporter.createGenderBIASWeightTable(counts));
            }
            if (criteria.isGenderBIASNetWeight()) {
                counts = StatisticsWorker.biasNetWeights(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createGenderBIASNetWeightChart(counts));
                tables.add(StatisticsReporter.createGenderBIASNetWeightTable(counts));
            }
            if (criteria.isComponents()) {
                charts.add(StatisticsReporter.createComponentsChart(segmentation.getCurrentIndividuals(), 1000));
            }
            if (criteria.isGenealogicalCompleteness()) {
                counts = StatisticsWorker.completeness(segmentation.getCurrentIndividuals(), 10);
                chart = StatisticsReporter.createCompletenessChart((FiliationCounts)counts);
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTable()));
            }
            if (criteria.isFratryDistribution()) {
                counts = StatisticsWorker.fratryDistribution(segmentation.getCurrentIndividuals());
                charts.add(StatisticsReporter.createFratryDistributionChart((FiliationCounts)counts));
                tables.add(StatisticsReporter.createFratryDistributionTable((FiliationCounts)counts));
            }
            if (criteria.isFourCousinMarriages() && (chart = StatisticsReporter.createPartitionChart(partition = CircuitFinder.createFirstCousinMarriages(segmentation))) != null) {
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
            }
            if (criteria.isAncestorTypes() && (chart = StatisticsReporter.createMultiPartitionChart(partition = CircuitFinder.createAncestorChains(segmentation, criteria.getAncestorTypesDegree()))) != null) {
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
            }
            if (criteria.isConsanguineChains() && (chart = StatisticsReporter.createArrayChart("Consanguines per person", consCount = StatisticsWorker.countConsanguinePairs(segmentation, criteria.getConsanguineDegree()), new String[]{"HH", "FF", "HF", "FH"})) != null) {
                chart.setHeadersLegend("Generational distance");
                chart.setLinesLegend("Consanguines");
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTable()));
            }
            StringList pajekBuffer = new StringList();
            for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
                if (!partitionCriteria.isValid()) continue;
                Partition<Individual> partition2 = PartitionMaker.create(segmentation.getLabel(), segmentation.getCurrentIndividuals(), partitionCriteria);
                ReportChart chart2 = StatisticsReporter.createPartitionChart(partition2, partitionCriteria, criteria.getSplitCriteria());
                if (chart2 != null) {
                    charts.add(chart2);
                    tables.add(ReportTable.transpose(chart2.createReportTableWithSum()));
                    if (criteria.isMeanClusterValues() && criteria.getSplitCriteria() != null) {
                        try {
                            Map<Cluster<Individual>, Double> means = StatisticsWorker.meanClusterValues(partition2.getClusters(), criteria.getSplitCriteria());
                            String criteriaString = String.valueOf(partitionCriteria.toShortString()) + "/" + criteria.getSplitCriteria().getLabel();
                            ReportChart meanChart = StatisticsReporter.createMeanClusterValuesChart(criteriaString, means);
                            charts.add(meanChart);
                            tables.add(StatisticsReporter.createMeanClusterValuesTable(criteriaString, partition2.getClusters(), means));
                        }
                        catch (ClassCastException exception) {
                            logger.debug("ClassCastException => No mean cluster value.");
                        }
                    }
                }
                partition2.setLabel(String.valueOf(partition2.getLabel()) + "_" + partitionCriteria.getLabel());
                pajekBuffer.addAll((Collection)PuckUtils.writePajekPartition(partition2, new IndividualComparator(IndividualComparator.Sorting.ID)));
            }
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % 4 == 3) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table.getTitle());
                result.outputs().appendln(table);
            }
            if (pajekBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(sourceFile, "-Partitions"), ".paj");
                ReportRawData rawData = new ReportRawData("Export Partitions to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln("Partitions");
                result.outputs().append(rawData);
            }
            result.setTimeSpent(chrono.stop().interval());
        }
        return result;
    }

    public static Report reportHomonyms(Net net) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Homonyms.");
        result.setOrigin("Statistics reporter");
        result.setTarget(net.getLabel());
        TreeMap<String, String> ids = new TreeMap<String, String>();
        TreeMap<String, Integer> count = new TreeMap<String, Integer>();
        for (Individual individual : net.individuals()) {
            String name = individual.getName();
            String id = (String)ids.get(name);
            if (id == null) {
                ids.put(name, String.valueOf(individual.getId()));
                count.put(name, 1);
                continue;
            }
            ids.put(name, String.valueOf(id) + ";" + individual.getId());
            count.put(name, (Integer)count.get(name) + 1);
        }
        result.outputs().appendln("Name\tIds");
        for (String name : ids.keySet()) {
            if ((Integer)count.get(name) <= 1) continue;
            result.outputs().appendln(String.valueOf(name) + "\t" + (String)ids.get(name));
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividuals(Segmentation segmentation, IndividualComparator.Sorting sorting) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Individual List.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Sorting", sorting.toString());
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList(sorting)) {
            String lastname;
            String signature = null;
            String firstname = individual.getFirstName();
            if (firstname == null) {
                firstname = "-";
            }
            if ((lastname = individual.getLastName()) == null) {
                lastname = "-";
            }
            switch (sorting) {
                case ID: {
                    signature = String.valueOf(individual.getId()) + "\t" + firstname + "\t" + lastname;
                    break;
                }
                case FIRSTN: {
                    signature = String.valueOf(firstname) + "\t" + lastname + "\t" + individual.getId();
                    break;
                }
                case LASTN: {
                    signature = String.valueOf(lastname) + "\t" + firstname + "\t" + individual.getId();
                }
            }
            if (signature == null) continue;
            result.outputs().append(signature);
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividuals(Segmentation segmentation, String partitionLabel, IndividualComparator.Sorting sorting) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Individual List.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Partition", partitionLabel);
        result.inputs().add("Sorting", sorting.toString());
        Partition<Individual> partition = PartitionMaker.createRaw(partitionLabel, segmentation.getCurrentIndividuals());
        for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
            if (cluster == null || cluster.getValue() == null) continue;
            result.outputs().append(String.valueOf(cluster.getValue().toString()) + "\t(" + cluster.count() + ")");
            result.outputs().appendln();
            for (Individual individual : new Individuals(cluster.getItems()).toSortedList(sorting)) {
                String signature = null;
                switch (sorting) {
                    case ID: {
                        signature = String.valueOf(individual.getId()) + "\t" + individual.getFirstName() + "\t" + individual.getLastName();
                        break;
                    }
                    case FIRSTN: {
                        signature = String.valueOf(individual.getFirstName()) + "\t" + individual.getLastName() + "\t" + individual.getId();
                        break;
                    }
                    case LASTN: {
                        signature = String.valueOf(individual.getLastName()) + "\t" + individual.getFirstName() + "\t" + individual.getId();
                    }
                }
                if (signature == null) continue;
                result.outputs().append(signature);
                result.outputs().appendln();
            }
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSynopsis(String directory) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Basic statistics about a corpus.");
        result.setOrigin("Statistics reporter");
        StringList listStatistics = new StringList();
        String headline = "General statistics";
        StatisticsWorker.Indicator[] indicatorArray = StatisticsWorker.Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsWorker.Indicator indicator = indicatorArray[n2];
            headline = String.valueOf(headline) + "\t" + indicator.toString();
            ++n2;
        }
        result.outputs().appendln(headline);
        StringList listBias = new StringList();
        listBias.appendln("Gender bias\tA1\tA2\tA3\tA4\tA5\tU1\tU2\tU3\tU4\tU5");
        StringList listCensus = new StringList();
        listCensus.appendln("First cousin marriages\tParPat\tCross\tParMat");
        String pattern = "XX(X)XX";
        String classificationType = "LINE";
        File folder = new File(directory);
        File[] fileArray = folder.listFiles();
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray[n4];
            try {
                Net net = PuckManager.loadCorpus(file);
                listStatistics.appendln(StatisticsWorker.getValueString(net));
                listBias.appendln(StatisticsWorker.listBiasWeights(net));
                listCensus.appendln(StatisticsWorker.listCircuitFrequencies(new Segmentation(net), classificationType, pattern));
            }
            catch (PuckException e) {
                System.err.println("Not a corpus file: " + file.getName());
            }
            ++n4;
        }
        result.outputs().append(listStatistics);
        result.outputs().appendln();
        result.outputs().append(listBias);
        result.outputs().appendln();
        result.outputs().append(listCensus);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

