/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.permutation.PermutationTable;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.NetUtils;

public class UpdateWorker {
    private static final Logger logger = LoggerFactory.getLogger(UpdateWorker.class);

    public static Net fuse(Net target, Net source, PermutationTable permutations) throws PuckException {
        int lastId = target.individuals().getLastId();
        int newIdCount = 0;
        for (Individual sourceIndividual : source.individuals().toList()) {
            Integer newId = permutations.getTarget(sourceIndividual.getId());
            if (newId == null) {
                newId = lastId + newIdCount + 1;
                ++newIdCount;
            }
            sourceIndividual.setId(newId);
        }
        Net result = UpdateWorker.update(target, source, UpdateMode.APPEND);
        return result;
    }

    @Deprecated
    private static Family getOrCreateFamily(Net target, Individual sourceFather, Individual sourceMother) {
        Family result;
        Individual targetFather = sourceFather == null ? null : (Individual)target.individuals().getById(sourceFather.getId());
        Individual targetMother = sourceMother == null ? null : (Individual)target.individuals().getById(sourceMother.getId());
        if (targetMother == null && targetFather == null) {
            result = null;
        } else {
            if (targetMother == null || targetFather == null) {
                result = new Family(target.families().getLastId() + 1, targetFather, targetMother);
                target.families().add(result);
            } else {
                result = target.families().getBySpouses(targetFather, targetMother);
                if (result == null) {
                    result = new Family(target.families().getLastId() + 1, targetFather, targetMother);
                    target.families().add(result);
                }
            }
            if (targetFather != null) {
                targetFather.getPersonalFamilies().add(result);
            }
            if (targetMother != null) {
                targetMother.getPersonalFamilies().add(result);
            }
        }
        return result;
    }

    public static void update(Attributes target, Attributes source, UpdateMode mode) {
        for (Attribute sourceAttribute : source) {
            if (!StringUtils.isNotBlank((CharSequence)sourceAttribute.getLabel()) || !StringUtils.isNotBlank((CharSequence)sourceAttribute.getValue())) continue;
            Attribute targetAttribute = (Attribute)target.get(sourceAttribute.getLabel());
            if (targetAttribute == null) {
                target.put(sourceAttribute.getLabel(), sourceAttribute.getValue());
                continue;
            }
            if (mode != UpdateMode.OVERWRITE) continue;
            targetAttribute.setValue(sourceAttribute.getValue());
        }
    }

    public static Net update(Net original, Net source, UpdateMode mode) throws PuckException {
        Net target = new Net(original);
        if (mode == UpdateMode.OVERWRITE && StringUtils.isNotBlank((CharSequence)source.getLabel())) {
            target.setLabel(source.getLabel());
        }
        HashMap originalTargetIds = new HashMap(target.individuals().size());
        Integer[] integerArray = target.individuals().getIds();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            originalTargetIds.put(id, null);
            ++n2;
        }
        for (Individual sourceIndividual : source.individuals().toSortedList()) {
            Object partner3;
            Individual targetIndividual = (Individual)target.individuals().getById(sourceIndividual.getId());
            if (targetIndividual == null) {
                targetIndividual = new Individual(sourceIndividual.getId());
                target.individuals().add(targetIndividual);
            }
            if (!originalTargetIds.containsKey(targetIndividual.getId())) {
                targetIndividual.setName(sourceIndividual.getName());
                targetIndividual.setGender(sourceIndividual.getGender());
                targetIndividual.attributes().addAll(sourceIndividual.attributes());
                if (sourceIndividual.getFather() != null) {
                    NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
                }
                if (sourceIndividual.getMother() != null) {
                    NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
                }
                for (Individual partner2 : sourceIndividual.getPartners()) {
                    NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), partner2.getId());
                }
                continue;
            }
            if (mode == UpdateMode.OVERWRITE) {
                String sourceName = sourceIndividual.getName();
                if (StringUtils.isNotBlank((CharSequence)sourceName) && sourceName.charAt(0) != '#' && sourceName.indexOf("*") == -1) {
                    targetIndividual.setName(sourceName);
                }
                if (!sourceIndividual.getGender().isUnknown()) {
                    targetIndividual.setGender(sourceIndividual.getGender());
                }
                UpdateWorker.update(targetIndividual.attributes(), sourceIndividual.attributes(), mode);
                if (sourceIndividual.getFather() != null) {
                    if (targetIndividual.getFather() != null) {
                        targetIndividual.getOriginFamily().getChildren().removeById(targetIndividual.getId());
                        targetIndividual.setOriginFamily(null);
                    }
                    NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
                }
                if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                    if (targetIndividual.getMother() != null) {
                        targetIndividual.getOriginFamily().getChildren().removeById(targetIndividual.getId());
                        targetIndividual.setOriginFamily(null);
                    }
                    NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
                }
                for (Object partner3 : sourceIndividual.getPartners()) {
                    NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), ((Individual)partner3).getId());
                }
                continue;
            }
            UpdateWorker.update(targetIndividual.attributes(), sourceIndividual.attributes(), mode);
            if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
                NetUtils.setFatherRelation(target, sourceIndividual.getFather().getId(), targetIndividual.getId());
            }
            if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                NetUtils.setMotherRelation(target, sourceIndividual.getMother().getId(), targetIndividual.getId());
            }
            partner3 = sourceIndividual.getPartners().iterator();
            while (partner3.hasNext()) {
                Individual partner2;
                partner2 = (Individual)partner3.next();
                NetUtils.setSpouseRelationAndFixRoles(target, targetIndividual.getId(), partner2.getId());
            }
        }
        logger.debug("===> source " + source.relationModels().size());
        logger.debug("===> target " + target.relationModels().size());
        for (RelationModel sourceRelationModel : source.relationModels()) {
            RelationModel targetRelationModel = target.relationModels().getByName(sourceRelationModel.getName());
            if (targetRelationModel == null) {
                targetRelationModel = target.createRelationModel(sourceRelationModel);
            } else {
                for (Role sourceRole : sourceRelationModel.roles()) {
                    if (targetRelationModel.roles().getByName(sourceRole.getName()) != null) continue;
                    targetRelationModel.roles().add(new Role(sourceRole));
                }
            }
            Relations sourceRelations = source.relations().getByModel(sourceRelationModel);
            Relations targetRelations = target.relations().getByModel(targetRelationModel);
            for (Relation sourceRelation : sourceRelations) {
                Relation targetRelation = (Relation)targetRelations.getById(sourceRelation.getId());
                if (targetRelation == null) {
                    targetRelation = target.createRelation(sourceRelation.getTypedId(), sourceRelation.getName(), targetRelationModel);
                } else if (mode == UpdateMode.OVERWRITE) {
                    targetRelation.setName(sourceRelation.getName());
                }
                for (Actor sourceActor : sourceRelation.actors()) {
                    if (targetRelation.hasActor(sourceActor)) continue;
                    target.createRelationActor(targetRelation, sourceActor.getId(), sourceActor.getRole().getName());
                }
                UpdateWorker.update(targetRelation.attributes(), targetRelation.attributes(), mode);
            }
        }
        Net result = NetUtils.buildCleanedNet(target);
        return result;
    }

    public static enum UpdateMode {
        APPEND,
        OVERWRITE;

    }
}

