/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class RelationValuator {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

    public static String extractYear(String source) {
        Matcher matcher = YEAR_PATTERN.matcher(source);
        String result = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : null;
        return result;
    }

    public static Value get(Relation source, String label) {
        Value result = RelationValuator.get(source, label, null);
        return result;
    }

    public static Value get(Relation source, String label, Object parameter) {
        Object result;
        EndogenousLabel enogenousLabel;
        try {
            enogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            enogenousLabel = null;
        }
        if (enogenousLabel == null) {
            String year;
            String attributeValue = source.getAttributeValue(label);
            result = attributeValue == null ? null : (label.toUpperCase().contains("DATE") ? ((year = RelationValuator.extractYear(attributeValue)) == null ? null : new Value(Integer.parseInt(year))) : new Value(attributeValue));
        } else {
            switch (enogenousLabel) {
                case ID: {
                    result = new Value(source.getId());
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static NumberedValues get(Relations source, String label) {
        NumberedValues result = RelationValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Relations source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        for (Relation relation : source) {
            result.put(relation.getId(), RelationValuator.get(relation, label, parameter));
        }
        return result;
    }

    public static List<String> getAttributeLabels(Relations source) {
        List<String> result = RelationValuator.getAttributeLabels(source, null);
        return result;
    }

    public static List<String> getAttributeLabels(Relations source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        result.addAll(RelationValuator.getExogenousAttributeLabels(source, limit));
        Collections.sort(result);
        return result;
    }

    public static List<String> getAttributeLabelSample(Relations source) {
        List<String> result = RelationValuator.getAttributeLabels(source, 10000);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Relations source) {
        List<String> result = RelationValuator.getExogenousAttributeLabels(source, null);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Relations source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        HashSet<String> buffer = new HashSet<String>();
        if (source != null) {
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Relation relation = (Relation)iterator.next();
                for (Attribute attribute : relation.attributes()) {
                    buffer.add(attribute.getLabel());
                }
            }
        }
        for (String string : buffer) {
            result.add(string);
        }
        Collections.sort(result);
        return result;
    }

    public static enum EndogenousLabel {
        ID;

    }
}

