/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.random;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.MemoryCriteria;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.BIASCounts;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.RandomUtils;
import org.tip.puck.util.Value;

public class RandomNetExplorer {
    private BIASCounts biasCounts;
    private Map<Value, Double[]> closureRates;
    private Double explorationRateIndi;
    private Double meanInformation;
    private Double explorationRateMarr;
    private Double meanDegree;
    private Net virtualNet;
    private Segmentation source;
    private MemoryCriteria criteria;
    private Random randGen;
    private Report report;
    Map<Individual, Set<Individual>> neighborSets;

    public Report getReport() {
        return this.report;
    }

    public Net getVirtualNet() {
        return this.virtualNet;
    }

    public Double getMeanDegree() {
        return this.meanDegree;
    }

    public BIASCounts getBiasCounts() {
        return this.biasCounts;
    }

    public Map<Value, Double[]> getClosureRates() {
        return this.closureRates;
    }

    public RandomNetExplorer(Segmentation source, MemoryCriteria criteria, Report report, Map<Individual, Set<Individual>> neighborSets) {
        this.source = source;
        this.criteria = criteria;
        this.report = report;
        this.randGen = new Random();
        this.neighborSets = neighborSets;
    }

    public RandomNetExplorer(Segmentation source, MemoryCriteria criteria, Report report) {
        this.source = source;
        this.criteria = criteria;
        this.report = report;
        this.randGen = new Random();
    }

    private void incrementArray(Double[] total, Double[] inc) {
        int i = 0;
        while (i < total.length) {
            total[i] = total[i] + inc[i];
            ++i;
        }
    }

    private void divideArray(Double[] total, Double sum) {
        int i = 0;
        while (i < total.length) {
            total[i] = total[i] / sum;
            ++i;
        }
    }

    public void getStatistics(int runs, int genMax) throws PuckException {
        this.biasCounts = new BIASCounts(genMax, genMax);
        this.closureRates = new HashMap<Value, Double[]>();
        Value agn = new Value("AGNATIC");
        Value ute = new Value("UTERINE");
        this.meanInformation = 0.0;
        this.explorationRateIndi = 0.0;
        int totalIndi = this.source.getAllIndividuals().size();
        int totalMarr = StatisticsWorker.numberOfMarriages(this.source.getAllFamilies());
        this.explorationRateMarr = 0.0;
        this.meanDegree = 0.0;
        this.closureRates.put(agn, new Double[]{0.0, 0.0, 0.0});
        this.closureRates.put(ute, new Double[]{0.0, 0.0, 0.0});
        int run = 0;
        while (run < runs) {
            this.virtualNet = this.createRandomNetByObserverSimulation();
            this.explorationRateIndi = this.explorationRateIndi + MathUtils.percent(this.virtualNet.individuals().size(), totalIndi);
            int marr = StatisticsWorker.numberOfMarriages(this.virtualNet.families());
            this.explorationRateMarr = this.explorationRateMarr + MathUtils.percent(marr, totalMarr);
            this.meanDegree = this.meanDegree + MathUtils.percent(2 * marr, 100 * this.virtualNet.individuals().size());
            this.biasCounts.add(StatisticsWorker.biasWeights(this.virtualNet.individuals()));
            Double[] agnaticClosure = CircuitFinder.getClosureRates(new Segmentation(this.virtualNet), "LINE", FiliationType.AGNATIC, genMax).get(agn);
            Double[] uterineClosure = CircuitFinder.getClosureRates(new Segmentation(this.virtualNet), "LINE", FiliationType.UTERINE, genMax).get(ute);
            if (agnaticClosure != null) {
                this.incrementArray(this.closureRates.get(agn), agnaticClosure);
            }
            if (uterineClosure != null) {
                this.incrementArray(this.closureRates.get(ute), uterineClosure);
            }
            ++run;
        }
        this.biasCounts.divide(new Double(runs));
        this.explorationRateIndi = this.explorationRateIndi / new Double(runs);
        this.explorationRateMarr = this.explorationRateMarr / new Double(runs);
        this.meanDegree = this.meanDegree / new Double(runs);
        this.meanInformation = this.meanInformation / new Double(runs * this.criteria.getNrInformants());
        for (Value key : this.closureRates.keySet()) {
            this.divideArray(this.closureRates.get(key), new Double(runs));
        }
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Double getExplorationRateIndi() {
        return this.explorationRateIndi;
    }

    public Double getExplorationRateMarr() {
        return this.explorationRateMarr;
    }

    public Net createRandomNetByObserverSimulation() throws PuckException {
        Net preresult = new Net();
        int nrInterviews = this.criteria.getNrInformants();
        FiliationType distanceType = this.criteria.getDistanceType();
        int maxDistance = this.criteria.getMaxDistance();
        Individual informant = null;
        double inertia = this.criteria.getDistanceWeight();
        if (this.meanInformation == null) {
            this.meanInformation = 0.0;
        }
        HashSet<Individual> oldInformants = new HashSet<Individual>();
        int interviews = 0;
        ArrayList<Integer> groupProfile = new ArrayList<Integer>();
        int groupSize = 0;
        while (interviews < nrInterviews) {
            Set<Object> neighbors = new HashSet();
            if (distanceType == null || informant == null) {
                informant = (Individual)RandomUtils.draw(this.source.getCurrentIndividuals().toList());
            } else if (this.neighborSets != null) {
                neighbors = this.neighborSets.get(informant);
                informant = (Individual)RandomUtils.draw(this.source.getCurrentIndividuals().toList(), neighbors, this.randGen, inertia);
            } else {
                Map<Individual, Integer> distances = StatisticsWorker.distances(informant, maxDistance, distanceType);
                HashMap<Individual, Double> weights = new HashMap<Individual, Double>();
                for (Individual neighbor : this.source.getCurrentIndividuals().toList()) {
                    if (distances.get(neighbor) != null && distances.get(neighbor) > 0 && distanceType.hasLinkingGender(neighbor.getGender())) {
                        weights.put(neighbor, inertia);
                        continue;
                    }
                    weights.put(neighbor, 1.0);
                }
                informant = (Individual)RandomUtils.draw(weights, this.randGen);
            }
            if (oldInformants.contains(informant) || !RandomNetExplorer.accepts(informant, this.criteria)) continue;
            ++interviews;
            oldInformants.add(informant);
            String distance = "";
            if (neighbors.contains(informant)) {
                ++groupSize;
                distance = distanceType.toString();
            } else if (groupSize != 0) {
                groupProfile.add(groupSize);
                groupSize = 1;
                distance = "NOLINK";
            }
            distance = String.valueOf(distance) + " " + (groupProfile.size() + 1) + "-" + groupSize;
            if (this.report != null) {
                String line = "Informant Nr. " + interviews + " " + " " + informant.signature() + " " + (Object)((Object)informant.getGender()) + " " + distance + " ";
                this.report.outputs().appendln(line);
            }
            HashMap<Individual, Integer> reportedAlters = new HashMap<Individual, Integer>();
            reportedAlters.put(informant, 0);
            RandomNetExplorer.explore(preresult, informant, informant, this.criteria, 1, this.report, reportedAlters);
            this.meanInformation = this.meanInformation + (double)reportedAlters.size();
        }
        if (this.report != null && this.neighborSets != null) {
            groupProfile.add(groupSize);
            this.report.outputs().appendln();
            this.report.outputs().appendln(Arrays.toString(groupProfile.toArray()));
        }
        Net result = NetUtils.buildCleanedNet(preresult);
        result.adjustIndividuals(this.source.getAllIndividuals());
        result.setLabel(String.valueOf(this.source.getLabel()) + " explored " + this.criteria.getDistanceFactor() + " " + this.criteria.getDistanceWeight());
        return result;
    }

    public Double getMeanInformation() {
        return this.meanInformation;
    }

    private static boolean accepts(Individual informant, MemoryCriteria criteria) {
        boolean result = informant.isMale() && RandomUtils.event(criteria.getMaleAcceptance()) || informant.isFemale() && RandomUtils.event(criteria.getFemaleAcceptance());
        return result;
    }

    private static void explore(Net net, Individual informant, Individual ego, MemoryCriteria criteria, int distance, Report report, Map<Individual, Integer> reportedAlters) throws PuckException {
        double factor = Math.pow(criteria.getDistanceFactor(), distance);
        String inset = "\t";
        int i = 0;
        while (i < distance) {
            inset = String.valueOf(inset) + "\t";
            ++i;
        }
        for (KinType type : KinType.basicTypes()) {
            for (Individual alter : ego.getKin(type)) {
                if (alter.getGender() == Gender.UNKNOWN || reportedAlters.get(alter) != null && reportedAlters.get(alter) <= distance) continue;
                reportedAlters.put(alter, distance);
                NetUtils.setKinRelation(net, ego, alter, type);
                double memory = factor * criteria.getMemory(ego.getGender(), alter.getGender(), type, informant.getGender());
                if (report != null) {
                    report.outputs().appendln(String.valueOf(distance) + " " + inset + memory + " " + type.toString(alter.getGender()) + " " + alter.signature());
                }
                if (!RandomUtils.event(memory)) continue;
                RandomNetExplorer.explore(net, informant, alter, criteria, distance + 1, report, reportedAlters);
            }
        }
    }
}

