/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.Comparator;
import org.tip.puck.net.Family;

public class FamilyComparator
implements Comparator<Family> {
    Sorting sorting;

    public FamilyComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(Family alpha, Family bravo) {
        int result;
        if (alpha == null && bravo == null) {
            result = 0;
        } else if (alpha == null) {
            result = -1;
        } else if (bravo == null) {
            result = 1;
        } else {
            switch (this.sorting) {
                case ID: {
                    result = new Integer(alpha.getId()).compareTo(bravo.getId());
                    break;
                }
                case HUSBAND: {
                    if (alpha.getHusband() == null && bravo.getHusband() == null) {
                        result = 0;
                        break;
                    }
                    if (alpha.getHusband() == null) {
                        result = -1;
                        break;
                    }
                    if (bravo.getHusband() == null) {
                        result = 1;
                        break;
                    }
                    result = new Integer(alpha.getHusband().getId()).compareTo(bravo.getHusband().getId());
                    if (result != 0) break;
                    result = new FamilyComparator(Sorting.WIFE).compare(alpha, bravo);
                    break;
                }
                case WIFE: {
                    if (alpha.getWife() == null && bravo.getWife() == null) {
                        result = 0;
                        break;
                    }
                    if (alpha.getWife() == null) {
                        result = -1;
                        break;
                    }
                    if (bravo.getWife() == null) {
                        result = 1;
                        break;
                    }
                    result = new Integer(alpha.getWife().getId()).compareTo(bravo.getWife().getId());
                    if (result != 0) break;
                    result = new FamilyComparator(Sorting.HUSBAND).compare(alpha, bravo);
                    break;
                }
                default: {
                    result = new Integer(alpha.getId()).compareTo(bravo.getId());
                }
            }
        }
        return result;
    }

    public static enum Sorting {
        ID,
        HUSBAND,
        WIFE;

    }
}

