/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.util.Numberable;

public class Family
implements Numberable {
    private int id;
    private Individual husband;
    private Individual wife;
    private UnionStatus unionStatus;
    private Individuals children;
    private Attributes attributes;

    public Family(Individual husband, Individual wife) {
        this.unionStatus = UnionStatus.UNMARRIED;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id) {
        this.id = id;
        this.unionStatus = UnionStatus.UNMARRIED;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id, Individual husband, Individual wife) {
        this.id = id;
        this.unionStatus = UnionStatus.UNMARRIED;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id, Individual husband, Individual wife, UnionStatus status) {
        this.id = id;
        this.unionStatus = status == null ? UnionStatus.UNMARRIED : status;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Family clone() {
        Individual husbandClone = null;
        if (this.husband != null) {
            husbandClone = this.husband.clone();
        }
        Individual wifeClone = null;
        if (this.wife != null) {
            wifeClone = this.wife.clone();
        }
        Family result = new Family(this.id, husbandClone, wifeClone);
        return result;
    }

    public String getAttributeValue(String label) {
        Attribute attribute = (Attribute)this.attributes().get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    public Individuals getChildren() {
        Individuals result = this.children;
        return result;
    }

    public Individuals getChildren(Gender gender) {
        Individuals result = new Individuals();
        for (Individual child : this.children) {
            if (child.getGender() != gender) continue;
            result.add(child);
        }
        return result;
    }

    public Individual getFather() {
        Individual result = this.husband;
        return result;
    }

    public Individual getHusband() {
        Individual result = this.husband;
        return result;
    }

    public Family getHusbandsOriginFamily() {
        Family result = this.husband == null ? null : this.husband.getOriginFamily();
        return result;
    }

    @Override
    public int getId() {
        int result = this.id;
        return result;
    }

    public Individual getMother() {
        Individual result = this.wife;
        return result;
    }

    public Individual getOtherParent(Individual parent) {
        Individual result = parent == this.husband ? this.wife : (parent == this.wife ? this.husband : null);
        return result;
    }

    public Individual getParent(Gender gender) {
        Individual result;
        switch (gender) {
            case MALE: {
                result = this.husband;
                break;
            }
            case FEMALE: {
                result = this.wife;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Individuals getParents() {
        Individuals result = new Individuals();
        if (this.husband != null) {
            result.add(this.husband);
        }
        if (this.wife != null) {
            result.add(this.wife);
        }
        return result;
    }

    public UnionStatus getUnionStatus() {
        return this.unionStatus;
    }

    public Individual getWife() {
        Individual result = this.wife;
        return result;
    }

    public Family getWifesOriginFamily() {
        Family result = this.wife == null ? null : this.wife.getOriginFamily();
        return result;
    }

    @Override
    public String hashKey() {
        String wifeStr = "?";
        String husbandStr = "?";
        if (this.wife != null) {
            wifeStr = "" + this.wife.getId();
        }
        if (this.husband != null) {
            husbandStr = "" + this.husband.getId();
        }
        return String.valueOf(wifeStr) + " [+] " + husbandStr;
    }

    public boolean isDivorced() {
        boolean result = this.unionStatus.isDivorced();
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.isOrphan() && this.isSterile() && this.attributes.isEmpty();
        return result;
    }

    public boolean isEmptyAndSingleParent() {
        boolean result = this.isSingleParent() && this.isSterile() && this.attributes.isEmpty();
        return result;
    }

    public boolean isFertile() {
        boolean result = this.children.size() != 0;
        return result;
    }

    public boolean isMarried() {
        boolean result = this.unionStatus.isMarried();
        return result;
    }

    public boolean isNotSingleParent() {
        boolean result = !this.isSingleParent();
        return result;
    }

    public boolean isOrphan() {
        boolean result = this.husband == null && this.wife == null;
        return result;
    }

    public boolean isParent(Individual parent) {
        boolean result = this.husband == parent || this.wife == parent;
        return result;
    }

    public boolean isSingleParent() {
        boolean result = this.husband == null && this.wife != null || this.husband != null && this.wife == null;
        return result;
    }

    public boolean isSterile() {
        boolean result = this.children.size() == 0;
        return result;
    }

    public int numberOfParents() {
        int result = this.husband != null && this.wife != null ? 2 : (this.husband == null && this.wife == null ? 0 : 1);
        return result;
    }

    public void setAttribute(String label, String value) {
        this.attributes().put(label, value);
    }

    public void setDivorced() {
        this.unionStatus = UnionStatus.DIVORCED;
    }

    public void setFather(Individual father) {
        this.husband = father;
    }

    public void setHusband(Individual husband) {
        this.husband = husband;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setMarried() {
        this.unionStatus = UnionStatus.MARRIED;
    }

    public void setMarried(boolean married) {
        this.unionStatus = married ? UnionStatus.MARRIED : UnionStatus.UNMARRIED;
    }

    public void setMother(Individual mother) {
        this.wife = mother;
    }

    public void setSpouses(Individual husband, Individual wife) {
        this.husband = husband;
        this.wife = wife;
    }

    public void setUnionStatus(UnionStatus value) {
        this.unionStatus = value == null ? UnionStatus.UNMARRIED : value;
    }

    public void setUnmarried() {
        this.unionStatus = UnionStatus.UNMARRIED;
    }

    public void setWife(Individual wife) {
        this.wife = wife;
    }

    public String toString() {
        String husbandString = "";
        if (this.husband != null) {
            husbandString = this.husband.toString();
        }
        String wifeString = "";
        if (this.wife != null) {
            wifeString = this.wife.toString();
        }
        String sep = "";
        if (this.husband != null && this.wife != null) {
            sep = " & ";
        }
        return String.valueOf(this.id) + " " + husbandString + sep + wifeString;
    }
}

