/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Family;
import org.tip.puck.net.FamilyComparator;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.util.NumberablesHashMap;

public class Families
extends NumberablesHashMap<Family> {
    public Families() {
    }

    public Families(Families source) {
        this.add(source);
    }

    public Families(int capacity) {
        super(capacity);
    }

    public Families(List<Family> source) {
        this.add(source);
    }

    public Families add(Families source) {
        Families result = this.put(source);
        return result;
    }

    public Families add(List<Family> source) {
        Families result = this.put(source);
        return result;
    }

    public Individuals children() {
        Individuals result = new Individuals();
        for (Family family : this) {
            result.put(family.getChildren());
        }
        return result;
    }

    public boolean containsChild() {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Family family = (Family)iterator.next();
                if (!family.isFertile()) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public List<String> getAttributeLabels() {
        ArrayList<String> result = new ArrayList<String>();
        for (Family family : this) {
            for (String label : family.attributes().labels()) {
                if (result.contains(label)) continue;
                result.add(label);
            }
        }
        return result;
    }

    public Family getBySpouses(Individual parent1, Individual parent2) {
        Family result;
        if (parent1 == null && parent2 == null) {
            result = null;
        } else {
            boolean ended = false;
            result = null;
            Iterator iterator = this.iterator();
            while (!ended) {
                if (iterator.hasNext()) {
                    Family family = (Family)iterator.next();
                    if ((family.getHusband() != parent1 || family.getWife() != parent2) && (family.getHusband() != parent2 || family.getWife() != parent1)) continue;
                    ended = true;
                    result = family;
                    continue;
                }
                ended = true;
                result = null;
            }
        }
        return result;
    }

    public Family getBySpouses(int targetSpouse1, int targetSpouse2) {
        boolean ended = false;
        Family result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Family family = (Family)iterator.next();
                int parentId1 = family.getHusband() == null ? 0 : family.getHusband().getId();
                int parentId2 = family.getWife() == null ? 0 : family.getWife().getId();
                if ((targetSpouse1 != parentId1 || targetSpouse2 != parentId2) && (targetSpouse1 != parentId2 || targetSpouse2 != parentId1)) continue;
                ended = true;
                result = family;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public Families getMarried() {
        Families result = new Families();
        for (Family family : this) {
            if (!family.isMarried()) continue;
            result.put(family);
        }
        return result;
    }

    public Individuals getPartners(Individual alter) {
        Individuals result = new Individuals();
        if (alter != null) {
            for (Family family : this) {
                Individual ego = family.getOtherParent(alter);
                if (ego == null) continue;
                result.add(ego);
            }
        }
        return result;
    }

    public Individuals marriedSpouses(Individual alter) {
        Individuals result = new Individuals();
        if (alter != null) {
            for (Family family : this) {
                Individual ego = family.getOtherParent(alter);
                if (ego == null || !family.isMarried()) continue;
                result.add(ego);
            }
        }
        return result;
    }

    public Families put(Families source) {
        if (source != null) {
            for (Family family : source) {
                this.add(family);
            }
        }
        Families result = this;
        return result;
    }

    public Families put(List<Family> source) {
        if (source != null) {
            for (Family family : source) {
                this.add(family);
            }
        }
        Families result = this;
        return result;
    }

    public List<Family> searchByName(String pattern) {
        Families families = new Families();
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            for (Family family : this) {
                String targetPattern = pattern.toLowerCase();
                if ((family.getHusband() == null || family.getHusband().getName() == null || !family.getHusband().getName().toLowerCase().contains(targetPattern)) && (family.getWife() == null || family.getWife().getName() == null || !family.getWife().getName().toLowerCase().contains(targetPattern))) continue;
                families.add(family);
            }
        }
        List<Family> result = families.toSortedList();
        return result;
    }

    public Families singleParentFamilies() {
        Families result = new Families();
        for (Family family : this) {
            if (!family.isSingleParent()) continue;
            result.add(family);
        }
        return result;
    }

    public List<Family> toSortedList(FamilyComparator.Sorting sorting) {
        List<Family> result = this.toList();
        Collections.sort(result, new FamilyComparator(sorting));
        return result;
    }
}

