/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.AttributeComparator;

public class Attributes
extends HashMap<String, Attribute>
implements Iterable<Attribute> {
    private static final long serialVersionUID = 8456469741805779474L;

    public Attributes() {
    }

    public Attributes(Attributes source) {
        if (source != null) {
            for (Attribute attribute : source.values()) {
                this.put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
            }
        }
    }

    public Attributes(int capacity) {
        super(capacity);
    }

    public void add(Attribute attribute) {
        this.put(attribute);
    }

    public void addAll(Attributes source) {
        for (Attribute attribute : source) {
            this.put(attribute.getLabel(), attribute.getValue());
        }
    }

    @Override
    public Attributes clone() {
        Attributes result = new Attributes();
        for (Attribute attribute : this.values()) {
            this.put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
        }
        return result;
    }

    public String getValue(String label) {
        Attribute attribute = (Attribute)this.get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    @Override
    public Iterator<Attribute> iterator() {
        Iterator<Attribute> result = this.values().iterator();
        return result;
    }

    public Set<String> labels() {
        Set<String> result = this.keySet();
        return result;
    }

    public void put(Attribute attribute) {
        if (attribute != null && attribute.getLabel() != null) {
            this.put(attribute.getLabel(), attribute);
        }
    }

    @Override
    public Attribute put(String label, String value) {
        Attribute result = (Attribute)this.get(label);
        if (result == null) {
            result = new Attribute(label, value);
            this.put(label, result);
        } else {
            result.setValue(value);
        }
        return result;
    }

    public void rename(Attribute attribute, String newLabel) {
        if (attribute != null && this.containsValue(attribute) && StringUtils.isNotBlank((CharSequence)newLabel)) {
            this.remove(attribute.getLabel());
            attribute.setLabel(newLabel);
            this.add(attribute);
        }
    }

    public List<Attribute> toList() {
        ArrayList<Attribute> result = new ArrayList<Attribute>(this.values());
        return result;
    }

    public List<Attribute> toSortedList() {
        List<Attribute> result = this.toList();
        Collections.sort(result, new AttributeComparator());
        return result;
    }
}

