/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.mas;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.tip.puck.mas.Agent;
import org.tip.puck.mas.MASConfig;
import org.tip.puck.mas.WFAgnaticCousins;
import org.tip.puck.mas.WFDivorce2;
import org.tip.puck.mas.WeightFactor;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

public class MAS {
    private Vector<Agent> livingAgents = new Vector();
    private Vector<Agent> livingMen = new Vector();
    private Vector<Agent> livingWomen = new Vector();
    private Vector<Agent> maleVirgins = new Vector();
    private Vector<Agent> femaleVirgins = new Vector();
    private Vector<Agent> allAgents = new Vector();
    private Vector<Family> currentMarriages = new Vector();
    private Vector<Family> allMarriages = new Vector();
    private Map<Integer, Agent> agentMap = new HashMap<Integer, Agent>();
    private List<WeightFactor> weightFactors = new LinkedList<WeightFactor>();
    private Random randGen = new Random();
    private int curId = 1;
    private int curFamilyId = 0;
    private int curCycle = 0;
    private int years = 300;
    private int initialPopulation = 100;
    private int maxAge = 70;
    private double fertilityRate = 2.0;
    private double marriagesMixRatio = 0.5;
    private double divorceMixRatio = 0.1;
    private int cousin1Marriages = 0;
    private int agnaticCousin1Marriages = 0;
    private int uterineCousin1Marriages = 0;
    private int cousins1 = 0;
    private int agnaticCousins1 = 0;
    private int uterineCousins1 = 0;
    private int diffSexAgnaticCousins1 = 0;
    private int samples = -1;
    private Agent[] mothers;
    private Agent[] fathers;
    private double[] weights;

    public void addFactor(WeightFactor factor) {
        this.weightFactors.add(factor);
    }

    private boolean testProb(double p) {
        if (p <= 0.0) {
            return false;
        }
        if (p >= 1.0) {
            return true;
        }
        double r = this.randGen.nextDouble();
        return r <= p;
    }

    public void initializePopulation(int size) {
        int i = 0;
        while (i < size) {
            Agent a = this.birth(null, null);
            a.setBirth(-this.randGen.nextInt(this.maxAge));
            ++i;
        }
    }

    public void run() {
        this.curCycle = 0;
        this.initializePopulation(this.initialPopulation);
        int i = 0;
        while (i < this.years) {
            this.cycle();
            ++this.curCycle;
            ++i;
        }
    }

    private Agent birth(Agent mother, Agent father) {
        if (mother != null && father != null && !mother.isPartnerOf(father)) {
            if (mother.getCurrentMarriage() != null) {
                this.divorce(mother);
            }
            if (father.getCurrentMarriage() != null) {
                this.divorce((Agent)father.getCurrentMarriage().getWife());
            }
            this.marriage(father, mother);
        }
        Gender gender = Gender.MALE;
        if (this.randGen.nextBoolean()) {
            gender = Gender.FEMALE;
        }
        Family origFamily = null;
        if (mother != null) {
            origFamily = mother.getCurrentMarriage();
        }
        Agent child = new Agent(this, this.curId++, gender, this.curCycle, origFamily);
        this.agentMap.put(child.getId(), child);
        this.livingAgents.add(child);
        this.allAgents.add(child);
        if (gender.isMale()) {
            this.livingMen.add(child);
            this.maleVirgins.add(child);
        } else if (gender.isFemale()) {
            this.livingWomen.add(child);
            this.femaleVirgins.add(child);
        }
        if (mother != null) {
            mother.getCurrentMarriage().getChildren().add(child);
        }
        if (mother != null) {
            mother.setTimeOfLastChildBirth(this.curCycle);
        }
        if (father != null) {
            father.setTimeOfLastChildBirth(this.curCycle);
        }
        child.updateCousins();
        return child;
    }

    private void marriage(Agent husband, Agent wife) {
        Family marriage = new Family(this.curFamilyId++, husband, wife);
        marriage.setMarried(true);
        this.currentMarriages.add(marriage);
        this.allMarriages.add(marriage);
        husband.setCurrentMarriage(marriage);
        wife.setCurrentMarriage(marriage);
        husband.addPersonalFamily(marriage);
        wife.addPersonalFamily(marriage);
        husband.addPartner(wife);
        wife.addPartner(husband);
        this.maleVirgins.remove(husband);
        this.femaleVirgins.remove(wife);
        if (husband.hasCousin(wife, 1)) {
            ++this.cousin1Marriages;
            husband.setAttribute("COUSINMARRIAGE", String.valueOf(wife.getId()));
            wife.setAttribute("COUSINMARRIAGE", String.valueOf(husband.getId()));
            marriage.setAttribute("COUSINMARRIAGE", "true");
        }
        if (husband.hasAgnaticCousin(wife, 1)) {
            ++this.agnaticCousin1Marriages;
            husband.setAttribute("AGNATICCOUSINMARRIAGE", String.valueOf(wife.getId()));
            wife.setAttribute("AGNATICCOUSINMARRIAGE", String.valueOf(husband.getId()));
            marriage.setAttribute("AGNATICCOUSINMARRIAGE", "true");
        }
        if (husband.hasUterineCousin(wife, 1)) {
            ++this.uterineCousin1Marriages;
        }
    }

    private void divorce(Agent wife) {
        this.endMarriage((Agent)wife.getCurrentMarriage().getHusband());
        this.endMarriage(wife);
    }

    private void endMarriage(Agent agent) {
        if (agent.getCurrentMarriage() != null) {
            this.currentMarriages.remove(agent.getCurrentMarriage());
            if (agent.isMale()) {
                Agent wife = (Agent)agent.getCurrentMarriage().getWife();
                wife.setCurrentMarriage(null);
            } else if (agent.isFemale()) {
                Agent husband = (Agent)agent.getCurrentMarriage().getHusband();
                husband.setCurrentMarriage(null);
            }
            agent.setCurrentMarriage(null);
        }
    }

    private void death(Agent agent) {
        if (agent.isMarried()) {
            for (Integer cousinId : agent.getAgnaticCousins().get(0)) {
                Agent cousin = this.agentMap.get(cousinId);
                if (!cousin.isMarried() || cousin.getGender() == agent.getGender()) continue;
                ++this.diffSexAgnaticCousins1;
            }
        }
        this.endMarriage(agent);
        if (agent.isMale()) {
            this.livingMen.remove(agent);
            this.maleVirgins.remove(agent);
        } else if (agent.isFemale()) {
            this.livingWomen.remove(agent);
            this.femaleVirgins.remove(agent);
        }
        this.livingAgents.remove(agent);
        agent.die();
    }

    private double computeWeight(Agent mother, Agent father, boolean marriage, boolean divorce) {
        double weight = 1.0;
        for (WeightFactor factor : this.weightFactors) {
            if (marriage) {
                if (!factor.appliesToMarriage()) continue;
                weight *= factor.factor(mother, father);
                continue;
            }
            if (divorce) {
                if (!factor.appliesToDivorce()) continue;
                weight *= factor.factor(mother, father);
                continue;
            }
            weight *= factor.factor(mother, father);
        }
        return weight;
    }

    /*
     * Unable to fully structure code
     */
    private void generateBirth() {
        marriage = false;
        divorce = false;
        p = this.randGen.nextDouble();
        if (this.currentMarriages.size() > 0 && p < this.marriagesMixRatio) {
            marriage = true;
        }
        p -= this.marriagesMixRatio;
        if (!marriage && this.currentMarriages.size() > 0 && p < this.divorceMixRatio) {
            divorce = true;
        }
        if (!marriage && !divorce) {
            if (this.femaleVirgins.size() == 0) {
                marriage = true;
            }
            if (this.maleVirgins.size() == 0) {
                marriage = true;
            }
        }
        totalWeight = 0.0;
        i = 0;
        while (i < this.samples) {
            block11: {
                block10: {
                    mother = null;
                    father = null;
                    if (!marriage) break block10;
                    index = this.randGen.nextInt(this.currentMarriages.size());
                    m = this.currentMarriages.get(index);
                    mother = (Agent)m.getMother();
                    father = (Agent)m.getFather();
                    break block11;
                }
                if (!divorce) ** GOTO lbl38
                while (mother == null || this.isIncest(mother, father) || !mother.isOrWasMarried() && !father.isOrWasMarried()) {
                    indexMother = this.randGen.nextInt(this.livingWomen.size());
                    indexFather = this.randGen.nextInt(this.livingMen.size());
                    mother = this.livingWomen.get(indexMother);
                    father = this.livingMen.get(indexFather);
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    indexMother = this.randGen.nextInt(this.femaleVirgins.size());
                    indexFather = this.randGen.nextInt(this.maleVirgins.size());
                    mother = this.femaleVirgins.get(indexMother);
                    father = this.maleVirgins.get(indexFather);
lbl38:
                    // 2 sources

                    ** while (mother == null || this.isIncest(mother, father))
                }
            }
            weight = this.computeWeight(mother, father, marriage, divorce);
            totalWeight += weight;
            this.mothers[i] = mother;
            this.fathers[i] = father;
            this.weights[i] = weight;
            ++i;
        }
        pos = this.randGen.nextDouble() * totalWeight;
        totalWeight = 0.0;
        i = 0;
        while (i < this.samples) {
            mother = this.mothers[i];
            father = this.fathers[i];
            if ((totalWeight += this.weights[i]) > pos) {
                this.birth(mother, father);
                return;
            }
            ++i;
        }
    }

    private void cycle() {
        double pop = this.livingAgents.size();
        double birthsPerYear = pop / 2.0 * (1.0 / (double)this.maxAge) * this.fertilityRate;
        double bpyInteger = Math.floor(birthsPerYear);
        double bpyFrac = birthsPerYear - bpyInteger;
        int birthsThisYear = (int)bpyInteger;
        if (this.testProb(bpyFrac)) {
            ++birthsThisYear;
        }
        System.out.println("birthsPerYear: " + birthsPerYear);
        System.out.println("birthsThisYear: " + birthsThisYear);
        int i = 0;
        while (i < birthsThisYear) {
            this.generateBirth();
            ++i;
        }
        LinkedList<Agent> deathList = new LinkedList<Agent>();
        for (Agent a : this.livingAgents) {
            if (a.getAge() < this.maxAge) continue;
            deathList.add(a);
        }
        for (Agent a : deathList) {
            this.death(a);
        }
        System.out.println("\n>> Year: " + this.curCycle);
        System.out.println("population: " + this.livingAgents.size() + "; men: " + this.livingMen.size() + "; women: " + this.livingWomen.size() + "; families: " + this.currentMarriages.size());
    }

    private boolean isIncest(Agent mother, Agent father) {
        if (father.getMother() == mother) {
            return true;
        }
        if (mother.getFather() == father) {
            return true;
        }
        if (mother.getFather() == father.getFather() && mother.getFather() != null) {
            return true;
        }
        if (mother.getMother() == father.getMother() && mother.getMother() != null) {
            return true;
        }
        if (father.getFather() != null && father.getFather().getMother() == mother) {
            return true;
        }
        if (father.getMother() != null && father.getMother().getMother() == mother) {
            return true;
        }
        if (mother.getFather() != null && mother.getFather().getFather() == father) {
            return true;
        }
        return mother.getMother() != null && mother.getMother().getFather() == father;
    }

    public void writeDemographicData(String filePath) {
        try {
            FileWriter outFile = new FileWriter(filePath);
            PrintWriter out = new PrintWriter(outFile);
            out.println("id, mother_age, father_age");
            for (Agent agent : this.allAgents) {
                out.println(String.format("%d,%d,%d", agent.getId(), agent.getAgeOfMotherAtBirth(), agent.getAgeOfFatherAtBirth()));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCurCycle() {
        return this.curCycle;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public double getFertilityRate() {
        return this.fertilityRate;
    }

    public void setFertilityRate(double fertilityRate) {
        this.fertilityRate = fertilityRate;
    }

    public Net toNet() {
        Net net = new Net();
        for (Individual individual : this.allAgents) {
            ((Agent)individual).setAttributes();
            net.individuals().put(individual);
        }
        for (Family family : this.allMarriages) {
            Family family2 = net.families().getBySpouses(family.getHusband(), family.getWife());
            if (family2 != null) {
                family2.getChildren().add(family.getChildren());
                continue;
            }
            net.families().put(family);
        }
        return net;
    }

    public String toString() {
        String str = "years: " + this.years + "\n";
        str = String.valueOf(str) + "initial population: " + this.initialPopulation + "\n";
        str = String.valueOf(str) + "fertility rate: " + this.fertilityRate + "\n";
        str = String.valueOf(str) + "max age: " + this.maxAge + "\n";
        str = String.valueOf(str) + "samples: " + this.samples + "\n";
        str = String.valueOf(str) + "marriages mix ratio: " + this.marriagesMixRatio + "\n";
        str = String.valueOf(str) + "divorce mix ratio: " + this.divorceMixRatio + "\n";
        return str;
    }

    public Vector<Agent> getAllAgents() {
        return this.allAgents;
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getInitialPopulation() {
        return this.initialPopulation;
    }

    public void setInitialPopulation(int initalPopulation) {
        this.initialPopulation = initalPopulation;
    }

    public double calcMeanSiblings() {
        double sum = 0.0;
        double count = 0.0;
        for (Agent a : this.allAgents) {
            sum += (double)a.calcNumberOfSiblings();
            count += 1.0;
        }
        return sum / count;
    }

    public double calcMeanFullSiblings() {
        double sum = 0.0;
        double count = 0.0;
        for (Agent a : this.allAgents) {
            sum += (double)a.calcNumberOfFullSiblings();
            count += 1.0;
        }
        return sum / count;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
        if (samples > 0) {
            this.mothers = new Agent[samples];
            this.fathers = new Agent[samples];
            this.weights = new double[samples];
        }
    }

    public void incCousins1() {
        ++this.cousins1;
    }

    public void incAgnaticCousins1() {
        ++this.agnaticCousins1;
    }

    public void incUterineCousins1() {
        ++this.uterineCousins1;
    }

    public double calcChildrenPerMarriage() {
        double children = 0.0;
        double marriages = 0.0;
        for (Family f : this.allMarriages) {
            marriages += 1.0;
            children += (double)f.getChildren().size();
        }
        return children / marriages;
    }

    public double getMarriagesMixRatio() {
        return this.marriagesMixRatio;
    }

    public void setMarriagesMixRatio(double marriagesMixRatio) {
        this.marriagesMixRatio = marriagesMixRatio;
    }

    public double getDivorceMixRatio() {
        return this.divorceMixRatio;
    }

    public void setDivorceMixRatio(double divorceMixRatio) {
        this.divorceMixRatio = divorceMixRatio;
    }

    public static void range() {
        try {
            FileWriter fstream = new FileWriter("results.csv");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("wfAgnaticCousins,wfDivorce2,marriages,cousin_marriages,agnatic_cousin_marriages,uterine_cousin_marriages,cousins1,agnatic_cousins1,uterine_cousins1,ds_agnatic_cousins1,agnatic_closure\n");
            double[] xVals = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0};
            double[] yVals = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0};
            double[] dArray = xVals;
            int n = xVals.length;
            int n2 = 0;
            while (n2 < n) {
                double x = dArray[n2];
                double[] dArray2 = yVals;
                int n3 = yVals.length;
                int n4 = 0;
                while (n4 < n3) {
                    double y = dArray2[n4];
                    MASConfig config = new MASConfig();
                    config.fromFile("experiments/mas/example.txt");
                    MAS mas = config.getMas();
                    WFAgnaticCousins wfAgnaticCousins = new WFAgnaticCousins(x, 1.0);
                    mas.addFactor(wfAgnaticCousins);
                    WFDivorce2 wfDivorce2 = new WFDivorce2(0.1, y, 0.1);
                    mas.addFactor(wfDivorce2);
                    mas.run();
                    String line = x + "," + y;
                    line = String.valueOf(line) + ", " + mas.allMarriages.size();
                    line = String.valueOf(line) + ", " + mas.cousin1Marriages;
                    line = String.valueOf(line) + ", " + mas.agnaticCousin1Marriages;
                    line = String.valueOf(line) + ", " + mas.uterineCousin1Marriages;
                    line = String.valueOf(line) + ", " + mas.cousins1;
                    line = String.valueOf(line) + ", " + mas.agnaticCousins1;
                    line = String.valueOf(line) + ", " + mas.uterineCousins1;
                    line = String.valueOf(line) + ", " + mas.diffSexAgnaticCousins1;
                    line = String.valueOf(line) + ", " + mas.agnaticCousin1Marriages / mas.diffSexAgnaticCousins1;
                    out.write(String.valueOf(line) + "\n");
                    ++n4;
                }
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void one() {
        MASConfig config = new MASConfig();
        config.fromFile("experiments/mas/example.txt");
        MAS mas = config.getMas();
        System.out.println(mas);
        mas.run();
        System.out.println("\n\nall marriages: " + mas.allMarriages.size());
        System.out.println("children per marriage: " + mas.calcChildrenPerMarriage());
        System.out.println("cousin1Marriages: " + mas.cousin1Marriages);
        System.out.println("agnaticCousin1Marriages: " + mas.agnaticCousin1Marriages);
        System.out.println("uterineCousin1Marriages: " + mas.uterineCousin1Marriages);
        System.out.println("meanSiblings: " + mas.calcMeanSiblings());
        System.out.println("meanFullSiblings: " + mas.calcMeanFullSiblings());
        System.out.println("cousins1: " + mas.cousins1);
        System.out.println("agnaticCousins1: " + mas.agnaticCousins1);
        System.out.println("uterineCousins1: " + mas.uterineCousins1);
        System.out.println("cognaticCousins1: " + (mas.cousins1 - mas.uterineCousins1 - mas.agnaticCousins1));
    }

    public static void main(String[] args) {
        MAS.one();
    }
}

