/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.xls;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSBufferedReader
extends BufferedReader {
    private static final Logger logger = LoggerFactory.getLogger(XLSBufferedReader.class);
    protected Workbook workbook;
    protected int currentSheet;
    protected int currentRow;
    protected int savedSheet;
    protected int savedRow;

    public XLSBufferedReader(File file) throws IOException {
        super(new InputStreamReader(new FileInputStream(file)));
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setEncoding("CP1252");
            this.workbook = Workbook.getWorkbook((File)file, (WorkbookSettings)settings);
            this.currentSheet = 0;
            this.currentRow = 0;
        }
        catch (BiffException exception) {
            logger.error("JXL error: " + exception.getMessage());
            throw new IOException("JXL error.", exception);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.workbook.close();
    }

    @Override
    public void mark(int size) {
        this.savedSheet = this.currentSheet;
        this.savedRow = this.currentRow;
    }

    @Override
    public boolean markSupported() {
        boolean result = true;
        return result;
    }

    @Override
    public String readLine() throws IOException {
        boolean ended = false;
        String result = null;
        while (!ended) {
            if (this.currentSheet < this.workbook.getNumberOfSheets()) {
                Sheet sheet = this.workbook.getSheet(this.currentSheet);
                if (this.currentRow < sheet.getRows()) {
                    ended = true;
                    result = XLSBufferedReader.toTXTLine(sheet.getRow(this.currentRow));
                    ++this.currentRow;
                    continue;
                }
                ++this.currentSheet;
                this.currentRow = 0;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    @Override
    public void reset() {
        this.currentSheet = this.savedSheet;
        this.currentRow = this.savedRow;
    }

    public static String toTXTLine(Cell[] cells) {
        StringBuffer buffer = new StringBuffer(1024);
        Cell[] cellArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String cellContent;
            Cell cell = cellArray[n2];
            if (buffer.length() != 0) {
                buffer.append("\t");
            }
            if (StringUtils.isNotBlank((CharSequence)(cellContent = cell.getContents()))) {
                cellContent = cellContent.replaceAll("[\r\n\t]+", "");
            }
            buffer.append(cellContent);
            ++n2;
        }
        String result = buffer.toString();
        return result;
    }
}

