/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.txt;

import java.io.BufferedReader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.txt1.TXT1File;
import org.tip.puck.io.txt3.TXT3File;
import org.tip.puck.net.Net;

public class TXTFile {
    private static final Logger logger = LoggerFactory.getLogger(TXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Version detectVersion(BufferedReader in) {
        Version result = null;
        return result;
    }

    public static Version detectVersion(File source) {
        Version result = null;
        return result;
    }

    public static Net load(File file) throws PuckException {
        Net result = TXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        Version version = TXTFile.detectVersion(file);
        switch (version) {
            case V1: 
            case V2: {
                result = TXT1File.load(file, DEFAULT_CHARSET_NAME);
                break;
            }
            case V3: {
                result = TXT3File.load(file, DEFAULT_CHARSET_NAME);
                break;
            }
            default: {
                result = TXT3File.load(file, DEFAULT_CHARSET_NAME);
            }
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        TXT3File.save(file, source);
    }

    public static enum Version {
        V1,
        V2,
        V3;

    }
}

