/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.puc;

import fr.devinsy.util.StringList;
import fr.devinsy.util.xml.XMLBadFormatException;
import fr.devinsy.util.xml.XMLReader;
import fr.devinsy.util.xml.XMLTag;
import fr.devinsy.util.xml.XMLTools;
import fr.devinsy.util.xml.XMLWriter;
import fr.devinsy.util.xml.XMLZipReader;
import fr.devinsy.util.xml.XMLZipWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.xml.sax.SAXException;

public class PUCFile {
    private static final Logger logger = LoggerFactory.getLogger(PUCFile.class);
    public static final String XSD_FILE = "/org/tip/puck/io/puc/puck-1.0.xsd";

    public static Net load(File file) throws PuckException {
        Net result;
        XMLZipReader in = null;
        try {
            try {
                in = new XMLZipReader(file);
                result = PUCFile.read((XMLReader)in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                exception.printStackTrace();
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]:" + exception.getMessage(), exception);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]: " + exception.getMessage(), exception);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create("Error reading file [" + file + "]: " + exception.getMessage(), exception);
            }
            catch (XMLStreamException exception) {
                exception.printStackTrace();
                throw PuckExceptions.BAD_FILE_FORMAT.create("Unexpected process error on [" + file + "]:" + exception.getMessage(), exception);
            }
            catch (XMLBadFormatException exception) {
                exception.printStackTrace();
                throw PuckExceptions.BAD_FILE_FORMAT.create("Bad XML format in file [" + file + "]: " + exception.getMessage(), new Object[]{exception});
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    public static Net read(XMLReader in) throws PuckException, XMLStreamException, XMLBadFormatException {
        Net result = new Net();
        in.readXMLHeader();
        in.readStartTag("corpus");
        PUCFile.readAttributes(result.attributes(), in);
        PUCFile.readIndividuals(result, in);
        PUCFile.readFamilies(result, in);
        PUCFile.readRelationModels(result, in);
        PUCFile.readRelations(result, in);
        in.readEndTag("corpus");
        in.readXMLFooter();
        return result;
    }

    public static void readActors(Net net, Relation relation, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("actors");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("actor")) {
                in.readStartTag("actor");
                String roleName = in.readContentTag("role").getContent();
                if (relation.getModel().roles().getByName(roleName) == null) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Undefined role [" + roleName + "] in relation model [" + relation.getModel().getName() + "].", new Object[0]);
                }
                int individualId = Integer.parseInt(in.readContentTag("individualId").getContent());
                net.createRelationActor(relation, individualId, roleName);
                in.readEndTag("actor");
            }
            in.readEndTag("actors");
        }
    }

    public static void readAttributes(Attributes target, XMLReader in) throws XMLStreamException, XMLBadFormatException {
        XMLTag list = in.readListTag("attributes");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("attribute")) {
                in.readStartTag("attribute");
                String label = in.readContentTag("label").getContent();
                String value = in.readNullableContentTag("value").getContent();
                if (value == null) {
                    value = "";
                }
                target.put(label, value);
                in.readEndTag("attribute");
            }
            in.readEndTag("attributes");
        }
    }

    public static void readFamilies(Net target, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("families");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("family")) {
                Individual mother;
                Individual father;
                UnionStatus status;
                XMLTag tag = in.readStartTag("family");
                int id = Integer.parseInt(tag.attributes().getByLabel("id").getValue());
                String statusToken = in.readContentTag("unionStatus").getContent();
                if (StringUtils.equals((CharSequence)statusToken, (CharSequence)"UNMARRIED")) {
                    status = UnionStatus.UNMARRIED;
                } else if (StringUtils.equals((CharSequence)statusToken, (CharSequence)"MARRIED")) {
                    status = UnionStatus.MARRIED;
                } else if (StringUtils.equals((CharSequence)statusToken, (CharSequence)"DIVORCED")) {
                    status = UnionStatus.DIVORCED;
                } else {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown union status [" + statusToken + "]", new Object[0]);
                }
                XMLTag fatherTag = in.readNullableContentTag("father");
                if (fatherTag.getContent() == null) {
                    father = null;
                } else {
                    int fatherId = Integer.parseInt(fatherTag.getContent());
                    father = (Individual)target.individuals().getById(fatherId);
                    if (father == null) {
                        father = target.createIndividual(fatherId);
                    }
                }
                XMLTag motherTag = in.readNullableContentTag("mother");
                if (motherTag.getContent() == null) {
                    mother = null;
                } else {
                    int motherId = Integer.parseInt(motherTag.getContent());
                    mother = (Individual)target.individuals().getById(motherId);
                    if (mother == null) {
                        mother = target.createIndividual(motherId);
                    }
                }
                Family family = target.createFamily(id, father, mother, status);
                XMLTag childrenTag = in.readNullableContentTag("children");
                if (childrenTag.getContent() != null) {
                    String[] childIds;
                    String[] stringArray = childIds = childrenTag.getContent().split("[ ,;]");
                    int n = childIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String childId = stringArray[n2];
                        Individual child = (Individual)target.individuals().getById(Integer.parseInt(childId));
                        if (child == null) {
                            target.createIndividual(id);
                        }
                        if (child.getOriginFamily() != null) {
                            throw PuckExceptions.BAD_FILE_FORMAT.create("Child [" + child.getId() + "] defined in two different families [" + child.getOriginFamily().getId() + "][" + family.getId() + "]", new Object[0]);
                        }
                        child.setOriginFamily(family);
                        family.getChildren().add(child);
                        ++n2;
                    }
                }
                PUCFile.readAttributes(family.attributes(), in);
                in.readEndTag("family");
            }
            in.readEndTag("families");
        }
    }

    public static void readIndividuals(Net target, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("individuals");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("individual")) {
                Gender gender;
                XMLTag tag = in.readStartTag("individual");
                int id = Integer.parseInt(tag.attributes().getByLabel("id").getValue());
                Individual individual = target.createIndividual(id);
                String name = in.readNullableContentTag("name").getContent();
                if (name == null) {
                    name = "";
                }
                individual.setName(name);
                String genderToken = in.readContentTag("gender").getContent();
                if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"MALE")) {
                    gender = Gender.MALE;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"FEMALE")) {
                    gender = Gender.FEMALE;
                } else if (StringUtils.equals((CharSequence)genderToken, (CharSequence)"UNKNOWN")) {
                    gender = Gender.UNKNOWN;
                } else {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown gender [" + genderToken + "]", new Object[0]);
                }
                individual.setGender(gender);
                PUCFile.readAttributes(individual.attributes(), in);
                in.readEndTag("individual");
            }
            in.readEndTag("individuals");
        }
    }

    public static void readRelationModels(Net target, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("relationModels");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("relationModel")) {
                in.readStartTag("relationModel");
                String name = in.readContentTag("name").getContent();
                if (target.relationModels().getByName(name) != null) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Relation model [" + name + "] is defined more than once.", new Object[0]);
                }
                RelationModel relationModel = target.createRelationModel(name);
                PUCFile.readRoles(relationModel.roles(), in);
                in.readEndTag("relationModel");
            }
            in.readEndTag("relationModels");
        }
    }

    public static void readRelations(Net target, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("relations");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("relation")) {
                in.readStartTag("relation");
                int typedId = Integer.parseInt(in.readContentTag("id").getContent());
                String name = in.readContentTag("name").getContent();
                String relationModelName = in.readContentTag("model").getContent();
                RelationModel model = target.relationModels().getByName(relationModelName);
                if (model == null) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Undefined relation model [" + name + "].", new Object[0]);
                }
                Relation relation = target.createRelation(typedId, name, model);
                PUCFile.readActors(target, relation, in);
                PUCFile.readAttributes(relation.attributes(), in);
                in.readEndTag("relation");
            }
            in.readEndTag("relations");
        }
    }

    public static void readRoles(Roles target, XMLReader in) throws XMLStreamException, XMLBadFormatException, PuckException {
        XMLTag list = in.readListTag("roles");
        if (list.getType() != XMLTag.TagType.EMPTY) {
            while (in.hasNextStartTag("role")) {
                in.readStartTag("role");
                String name = in.readContentTag("name").getContent();
                if (target.getByName(name) != null) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Role [" + name + "] is defined more than once.", new Object[0]);
                }
                target.add(new Role(name));
                in.readEndTag("role");
            }
            in.readEndTag("roles");
        }
    }

    public static void save(File file, Net source, String generator) throws PuckException {
        if (file == null || source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null detected", new Object[0]);
        }
        XMLZipWriter out = null;
        try {
            try {
                out = new XMLZipWriter(file);
                PUCFile.write((XMLWriter)out, source, generator, file.getName());
            }
            catch (IOException exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create("Error saving file [" + file + "]", exception);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        try {
            System.out.println("=====> " + XMLTools.isValid((File)file, (InputStream)PUCFile.class.getResourceAsStream(XSD_FILE)));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void write(XMLWriter out, Net source, String generator, String sourceFileName) {
        out.writeXMLHeader(new String[0]);
        out.writeStartTag("corpus", new String[]{"xmlns", "urn:schema:PUCK/1.0", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "version", "PUCK-1.0", "generator", "PUCK", "date", DatatypeConverter.printDateTime((Calendar)new GregorianCalendar()), "filename", sourceFileName});
        PUCFile.writeAttributes(out, source.attributes());
        PUCFile.writeIndividuals(out, source.individuals());
        PUCFile.writeFamilies(out, source.families());
        PUCFile.writeRelationModels(out, source.relationModels());
        PUCFile.writeRelations(out, source.relations());
        out.writeEndTag("corpus");
    }

    public static void writeActors(XMLWriter out, Actors source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("actors", new String[0]);
        } else {
            out.writeStartTag("actors", new String[]{"size", String.valueOf(source.size())});
            for (Actor actor : source) {
                out.writeStartTag("actor", new String[0]);
                out.writeTag("role", actor.getRole().getName(), new String[0]);
                out.writeTag("individualId", String.valueOf(actor.getIndividual().getId()), new String[0]);
                out.writeEndTag("actor");
            }
            out.writeEndTag("actors");
        }
    }

    public static void writeAttributes(XMLWriter out, Attributes source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("attributes", new String[0]);
        } else {
            out.writeStartTag("attributes", new String[]{"size", String.valueOf(source.size())});
            for (Attribute attribute : source) {
                out.writeStartTag("attribute", new String[0]);
                out.writeTag("label", attribute.getLabel(), new String[0]);
                out.writeTag("value", attribute.getValue(), new String[0]);
                out.writeEndTag("attribute");
            }
            out.writeEndTag("attributes");
        }
    }

    public static void writeFamilies(XMLWriter out, Families source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("families", new String[0]);
        } else {
            out.writeStartTag("families", new String[]{"size", String.valueOf(source.size())});
            for (Family family : source) {
                String unionStatusString;
                out.writeStartTag("family", new String[]{"id", String.valueOf(family.getId())});
                switch (family.getUnionStatus()) {
                    case UNMARRIED: {
                        unionStatusString = "UNMARRIED";
                        break;
                    }
                    case MARRIED: {
                        unionStatusString = "MARRIED";
                        break;
                    }
                    case DIVORCED: {
                        unionStatusString = "DIVORCED";
                        break;
                    }
                    default: {
                        unionStatusString = family.getUnionStatus().name();
                    }
                }
                out.writeTag("unionStatus", unionStatusString, new String[0]);
                if (family.getFather() == null) {
                    out.writeTag("father", null, new String[]{"xsi:nil", "true"});
                } else {
                    out.writeTag("father", String.valueOf(family.getFather().getId()), new String[0]);
                }
                if (family.getMother() == null) {
                    out.writeTag("mother", null, new String[]{"xsi:nil", "true"});
                } else {
                    out.writeTag("mother", String.valueOf(family.getMother().getId()), new String[0]);
                }
                StringList ids = new StringList();
                for (Individual individual : family.getChildren()) {
                    ids.add((Object)String.valueOf(individual.getId()));
                    ids.add((Object)" ");
                }
                if (!ids.isEmpty()) {
                    ids.removeLast();
                }
                if (ids.isEmpty()) {
                    out.writeEmptyTag("children", new String[0]);
                } else {
                    out.writeTag("children", ids.toString(), new String[0]);
                }
                PUCFile.writeAttributes(out, family.attributes());
                out.writeEndTag("family");
            }
            out.writeEndTag("families");
        }
    }

    public static void writeIndividuals(XMLWriter out, Individuals source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("individuals", new String[0]);
        } else {
            out.writeStartTag("individuals", new String[]{"size", String.valueOf(source.size())});
            for (Individual individual : source) {
                String gender;
                out.writeStartTag("individual", new String[]{"id", String.valueOf(individual.getId())});
                out.writeTag("name", individual.getName(), new String[0]);
                switch (individual.getGender()) {
                    case FEMALE: {
                        gender = "FEMALE";
                        break;
                    }
                    case MALE: {
                        gender = "MALE";
                        break;
                    }
                    case UNKNOWN: {
                        gender = "UNKNOWN";
                        break;
                    }
                    default: {
                        gender = individual.getGender().name();
                    }
                }
                out.writeTag("gender", gender, new String[0]);
                PUCFile.writeAttributes(out, individual.attributes());
                out.writeEndTag("individual");
            }
            out.writeEndTag("individuals");
        }
    }

    public static void writeRelationModels(XMLWriter out, RelationModels source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("relationModels", new String[0]);
        } else {
            out.writeStartTag("relationModels", new String[]{"size", String.valueOf(source.size())});
            for (RelationModel relationModel : source) {
                out.writeStartTag("relationModel", new String[0]);
                out.writeTag("name", relationModel.getName(), new String[0]);
                PUCFile.writeRoles(out, relationModel.roles());
                out.writeEndTag("relationModel");
            }
            out.writeEndTag("relationModels");
        }
    }

    public static void writeRelations(XMLWriter out, Relations source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("relations", new String[0]);
        } else {
            out.writeStartTag("relations", new String[]{"size", String.valueOf(source.size())});
            for (Relation relation : source) {
                out.writeStartTag("relation", new String[0]);
                out.writeTag("id", String.valueOf(relation.getTypedId()), new String[0]);
                out.writeTag("name", relation.getName(), new String[0]);
                out.writeTag("model", relation.getModel().getName(), new String[0]);
                PUCFile.writeActors(out, relation.actors());
                PUCFile.writeAttributes(out, relation.attributes());
                out.writeEndTag("relation");
            }
            out.writeEndTag("relations");
        }
    }

    public static void writeRoles(XMLWriter out, Roles source) {
        if (source == null || source.isEmpty()) {
            out.writeEmptyTag("roles", new String[0]);
        } else {
            out.writeStartTag("roles", new String[]{"size", String.valueOf(source.size())});
            for (Role role : source) {
                out.writeStartTag("role", new String[0]);
                out.writeTag("name", role.getName(), new String[0]);
                out.writeEndTag("role");
            }
            out.writeEndTag("roles");
        }
    }
}

