/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.onemode.GraphModeTransformer;
import org.tip.puck.graphs.onemode.OMGraph;
import org.tip.puck.graphs.onemode.OMLink;
import org.tip.puck.graphs.onemode.OMNode;
import org.tip.puck.graphs.onemode.ShuffleCriteria;
import org.tip.puck.net.Net;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;

public class Shuffler {
    public static Net shuffle(Net net, ShuffleCriteria criteria, Report report) {
        OMGraph.GraphMode mode = criteria.getMode();
        OMGraph omgraph = GraphModeTransformer.netToOmGraph(net, mode);
        Shuffler.shuffle(omgraph, criteria, report);
        Net result = GraphModeTransformer.omGraphToNet(omgraph, mode);
        return result;
    }

    private static void removeLink(OMLink link) {
        if (link.isWifeLink()) {
            link.getTarget().setFemaleLink(null);
        } else {
            link.getTarget().setFemaleLink(null);
        }
    }

    public static CircuitFinder findCircuits(Net net, ShuffleCriteria shuffleCriteria, int runs, CensusCriteria censusCriteria) throws PuckException {
        CircuitFinder result = new CircuitFinder(new Segmentation(net), censusCriteria);
        result.initializeCounts();
        int run = 0;
        while (run < runs) {
            Net shuffledNet = Shuffler.shuffle(net, shuffleCriteria, null);
            CircuitFinder finder = new CircuitFinder(new Segmentation(shuffledNet), censusCriteria);
            finder.findCircuits();
            if (censusCriteria.isOpenChainFrequencies()) {
                finder.getOpenChains();
            }
            result.incrementCounts(finder);
            ++run;
        }
        result.normalizeCounts(runs);
        return result;
    }

    public static double distance(OMGraph graph1, OMGraph graph2) {
        double dist = 0.0;
        double count = 0.0;
        for (OMNode node1 : graph1.getNodes()) {
            OMNode node2 = graph2.getNode(node1.hashKey());
            dist += node1.distance(node2);
            count += 1.0;
        }
        return dist / count;
    }

    public static void shuffle(OMGraph pgraph, ShuffleCriteria criteria, Report report) {
        OMGraph origPGraph = pgraph.clone();
        pgraph.storeOriginalDescendants();
        int k = criteria.getSwitchesPerIteration();
        int maxGenDist = criteria.getMaxGenerationalDistance();
        double minShufflePer = criteria.getMinShufflePercentage();
        int minStableIter = criteria.getMinStableIterations();
        int iteration = 0;
        int switches = 0;
        double maxDist = 0.0;
        double shuffled = 0.0;
        int stableIterations = 0;
        boolean stop = false;
        while (!stop) {
            shuffled = pgraph.percentageShuffledLinks();
            double dist = Shuffler.distance(pgraph, origPGraph);
            System.out.println("#iter " + iteration + "\t\tswaps: " + switches + "\t\tstable iter: " + stableIterations);
            System.out.println("  shuffled: " + shuffled + "%; dist: " + dist + "; max dist: " + maxDist);
            if (dist > maxDist) {
                maxDist = dist;
                stableIterations = 0;
            } else {
                ++stableIterations;
            }
            if (Shuffler.switchLinks(pgraph, k, maxGenDist)) {
                ++switches;
            }
            ++iteration;
            if (!(shuffled >= minShufflePer) || stableIterations < minStableIter) continue;
            stop = true;
        }
        if (report != null) {
            report.outputs().appendln("Reshuffling percentage: " + shuffled + "%");
            report.outputs().appendln("Maximal difference from original network: " + 100.0 * maxDist + "%");
        }
    }

    private static boolean addLink(OMGraph graph, OMLink link, int maxGenDist) {
        OMNode targ;
        OMNode orig = link.getOrigin();
        if (orig == (targ = link.getTarget())) {
            return false;
        }
        if (targ.hasDescendant(orig)) {
            return false;
        }
        int dist = orig.originalGenerationalDistance(targ);
        if (dist < 0 || dist > maxGenDist) {
            return false;
        }
        if (targ.isVirtual()) {
            return false;
        }
        if (link.isWifeLink()) {
            link.getTarget().setFemaleLink(link.getOrigin());
        } else {
            link.getTarget().setMaleLink(link.getOrigin());
        }
        graph.clearAncestors();
        graph.computeAncestors();
        return true;
    }

    public static boolean switchLinks(OMGraph pgraph, int k, int maxGenDist) {
        HashSet<OMLink> linkSet = new HashSet<OMLink>();
        OMLink link = pgraph.getRandomLink();
        linkSet.add(link);
        boolean gender = link.isWifeLink();
        while (linkSet.size() < k) {
            link = pgraph.getRandomLink();
            if (link.isWifeLink() != gender) continue;
            linkSet.add(link);
        }
        ArrayList links = new ArrayList(linkSet);
        ArrayList links2 = new ArrayList(links);
        boolean perfectShuffle = false;
        while (!perfectShuffle) {
            perfectShuffle = true;
            int i = 0;
            while (i < k) {
                if (links.get(i) == links2.get(i)) {
                    perfectShuffle = false;
                }
                ++i;
            }
            Collections.shuffle(links2);
        }
        ArrayList<Object> newLinks = new ArrayList<Object>();
        int i = 0;
        while (i < k) {
            Object newLink = new OMLink(((OMLink)links.get(i)).getOrigin(), ((OMLink)links2.get(i)).getTarget(), ((OMLink)links.get(i)).isWifeLink());
            newLinks.add(newLink);
            ++i;
        }
        for (OMLink oldLink : links) {
            Shuffler.removeLink(oldLink);
        }
        pgraph.clearAncestors();
        pgraph.computeAncestors();
        boolean fail = false;
        for (Object newLink : newLinks) {
            if (Shuffler.addLink(pgraph, (OMLink)newLink, maxGenDist)) continue;
            fail = true;
            break;
        }
        if (fail) {
            for (Object newLink : newLinks) {
                Shuffler.removeLink((OMLink)newLink);
            }
            for (OMLink oldLink : links) {
                Shuffler.addLink(pgraph, oldLink, maxGenDist);
            }
        } else {
            int i2 = 0;
            while (i2 < k) {
                ((OMLink)links.get(i2)).setTarget(((OMLink)links2.get(i2)).getTarget());
                ((OMLink)links.get(i2)).setShuffled(true);
                ++i2;
            }
        }
        return !fail;
    }
}

