/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.tip.puck.graphs.onemode.OMLink;
import org.tip.puck.graphs.onemode.OMNode;
import org.tip.puck.graphs.onemode.SiblingMarriageDistribution;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.RandomGenerator;

public class OMGraph {
    Map<String, OMNode> nodes = new HashMap<String, OMNode>();
    private Vector<OMLink> linksVector = new Vector();
    private SiblingMarriageDistribution siblingMarriageDistribution;
    private GraphMode mode;

    public OMGraph(GraphMode mode) {
        this.mode = mode;
    }

    public OMGraph clone() {
        OMGraph result = new OMGraph(this.mode);
        result.siblingMarriageDistribution = this.siblingMarriageDistribution;
        for (OMNode node : this.getNodes()) {
            result.putNode(node.cloneWithLinks());
        }
        result.putLinks();
        result.computeOutDegrees();
        result.computeAncestors();
        return result;
    }

    public float averageNumberOfDescendants() {
        float avg = 0.0f;
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode marriage = entry.getValue();
            avg += (float)marriage.numberOfDescendants();
        }
        return avg /= (float)this.numberOfNodes();
    }

    void clearAncestors() {
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode node = entry.getValue();
            node.clearDescendants();
        }
    }

    void computeAncestors() {
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode node = entry.getValue();
            node.addDescendant(node, 0);
        }
    }

    void computeOutDegrees() {
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode marriage = entry.getValue();
            OMNode wifeLink = marriage.getFemaleLink();
            OMNode husbandLink = marriage.getMaleLink();
            if (wifeLink != null) {
                wifeLink.incOutDegree();
                wifeLink.incOutDegreeF();
            }
            if (husbandLink == null) continue;
            husbandLink.incOutDegree();
            husbandLink.incOutDegreeM();
        }
    }

    public Collection<OMNode> getNodes() {
        return this.nodes.values();
    }

    public OMNode getNode(String key) {
        return this.nodes.get(key);
    }

    public OMNode getNode(Numberable referent) {
        return this.nodes.get(referent.hashKey());
    }

    public int getProbableNumberOfSpouses(Gender gender, int k) {
        if (gender == Gender.UNKNOWN) {
            return 0;
        }
        return this.siblingMarriageDistribution.howManySpouses(gender, k);
    }

    public float maxNumberOfDescendants() {
        float max = 0.0f;
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode marriage = entry.getValue();
            float descs = marriage.numberOfDescendants();
            if (!(descs > max)) continue;
            max = descs;
        }
        return max;
    }

    public int numberOfNodes() {
        return this.nodes.size();
    }

    public void putNode(OMNode node) {
        this.nodes.put(node.hashKey(), node);
    }

    public void putNode(Numberable referent) {
        this.nodes.put(referent.hashKey(), new OMNode(referent));
    }

    public void putNode(Individual individual, GraphMode mode) {
        if (mode == GraphMode.OREGRAPH) {
            this.putNode(individual);
        } else if (mode == GraphMode.PGRAPH) {
            if (individual.isMale()) {
                this.putNode(new Family(individual, null));
            } else {
                this.putNode(new Family(null, individual));
            }
        }
    }

    public void putLink(OMLink link) {
        this.linksVector.add(link);
    }

    public void putLinks() {
        for (OMNode node : this.getNodes()) {
            OMNode wifeLink = node.getFemaleLink();
            OMNode husbandLink = node.getMaleLink();
            if (wifeLink != null) {
                this.putLink(new OMLink(wifeLink, node, true));
            }
            if (husbandLink == null) continue;
            this.putLink(new OMLink(husbandLink, node, false));
        }
    }

    public double percentageShuffledLinks() {
        double shuffled = 0.0;
        double total = 0.0;
        for (OMLink link : this.linksVector) {
            if (link.isShuffled()) {
                shuffled += 1.0;
            }
            total += 1.0;
        }
        return shuffled / total * 100.0;
    }

    public void setSiblingMarriageDistribution(Net net) {
        this.siblingMarriageDistribution = new SiblingMarriageDistribution(net);
    }

    public void storeOriginalDescendants() {
        for (Map.Entry<String, OMNode> entry : this.nodes.entrySet()) {
            OMNode marriage = entry.getValue();
            marriage.storeOriginalDescendants();
        }
    }

    public OMLink getRandomLink() {
        OMLink result = this.linksVector.get(RandomGenerator.instance().random.nextInt(this.linksVector.size()));
        return result;
    }

    public String toString() {
        String str = "Number of marriages: " + this.numberOfNodes() + "\n";
        str = String.valueOf(str) + "Average number of descendants: " + this.averageNumberOfDescendants() + "\n";
        str = String.valueOf(str) + "Max number of descendants: " + this.maxNumberOfDescendants() + "\n";
        return str;
    }

    public static enum GraphMode {
        OREGRAPH,
        PGRAPH;

    }
}

