/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.clusternetworks;

import java.util.Vector;
import org.tip.puck.PuckException;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.Group;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.ClusterPair;
import org.tip.puck.graphs.Graph;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segmentation;

public class ClusterNetworkUtils {
    public static Graph<Cluster<Individual>> createAllianceNetwork(Segmentation source, String partitionLabel, LineType lineType) throws PuckException {
        if (source == null || partitionLabel == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        Partition<Individual> partition = PartitionMaker.createRaw(source.getLabel(), source.getCurrentIndividuals(), partitionLabel);
        Graph<Cluster<Individual>> result = new Graph<Cluster<Individual>>("Alliance Network " + source.getLabel() + " " + partitionLabel);
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (Family family : source.getCurrentFamilies()) {
            if (!family.isMarried()) continue;
            Individual husband = family.getHusband();
            Individual wife = family.getWife();
            if (husband == null || wife == null) continue;
            Cluster<Individual> husbandsCluster = partition.getCluster(husband);
            Cluster<Individual> wifesCluster = partition.getCluster(wife);
            if (husbandsCluster == null || husbandsCluster.isNull() || wifesCluster == null || wifesCluster.isNull()) continue;
            if (lineType == LineType.WEIGHTED_ARC) {
                result.incArcWeight(wifesCluster, husbandsCluster);
                continue;
            }
            if (lineType != LineType.SIMPLE_ARC || result.getArc(wifesCluster, husbandsCluster) != null) continue;
            result.addArc(wifesCluster, husbandsCluster, 1.0);
        }
        return result;
    }

    public static Graph<Cluster<Chain>> createCircuitIntersectionNetwork(CircuitFinder source) throws PuckException {
        if (source == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Graph<Cluster<Chain>> result = new Graph<Cluster<Chain>>("Circuit Intersection Network: " + source.getLabel());
        for (Cluster<Cluster<Chain>> coupleCluster : source.clustersByCouples(Gender.MALE).getClusters().toListSortedByValue()) {
            int i = 0;
            while (i < coupleCluster.count()) {
                Cluster<Chain> typeCluster1 = coupleCluster.getItems().get(i);
                int j = 0;
                while (j <= i) {
                    Cluster<Chain> typeCluster2 = coupleCluster.getItems().get(j);
                    if (!typeCluster1.isNull() && !typeCluster2.isNull()) {
                        result.incEdgeWeight(typeCluster2, typeCluster1);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public static Graph<ClusterPair<Individual>> createFlowNetwork(Segmentation source, String sourceLabel, String targetLabel, LineType lineType) throws PuckException {
        if (source == null || sourceLabel == null || targetLabel == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Partition<Individual> sourcePartition = PartitionMaker.createRaw(source.getLabel(), source.getCurrentIndividuals(), sourceLabel);
        Partition<Individual> targetPartition = PartitionMaker.createRaw(source.getLabel(), source.getCurrentIndividuals(), targetLabel);
        Graph<ClusterPair<Individual>> result = new Graph<ClusterPair<Individual>>("Flow Network: " + source.getLabel() + " " + sourceLabel + " " + targetLabel);
        for (Individual individual : source.getCurrentIndividuals()) {
            Cluster<Individual> sourceCluster = sourcePartition.getCluster(individual);
            Cluster<Individual> targetCluster = targetPartition.getCluster(individual);
            ClusterPair<Individual> sourcePair = new ClusterPair<Individual>(sourceCluster, targetPartition.getCluster(sourceCluster.getValue()));
            ClusterPair<Individual> targetPair = new ClusterPair<Individual>(sourcePartition.getCluster(targetCluster.getValue()), targetCluster);
            if (sourcePair.getLeft().isNull() || targetPair.getRight().isNull()) continue;
            if (lineType == LineType.WEIGHTED_ARC) {
                result.incArcWeight(sourcePair, targetPair);
                continue;
            }
            if (lineType != LineType.SIMPLE_ARC || result.getArc(sourcePair, targetPair) != null) continue;
            result.addArc(sourcePair, targetPair, 1.0);
        }
        return result;
    }

    public static Graph<Cluster<Individual>> createSiblingNetwork(Segmentation source, String partitionLabel, LineType lineType) throws PuckException {
        if (source == null || partitionLabel == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Partition<Individual> partition = PartitionMaker.createRaw(source.getLabel(), source.getCurrentIndividuals(), partitionLabel);
        Graph<Cluster<Individual>> result = new Graph<Cluster<Individual>>("Sibling Network " + source.getLabel() + " " + partitionLabel);
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (Family family : source.getCurrentFamilies()) {
            for (Individual brother : family.getChildren()) {
                if (brother == null || !brother.isMale() || !brother.isNotSingle()) continue;
                for (Individual sister : family.getChildren()) {
                    if (sister == null || !sister.isFemale() || !sister.isNotSingle()) continue;
                    Cluster<Individual> brothersCluster = partition.getCluster(brother);
                    Cluster<Individual> sistersCluster = partition.getCluster(sister);
                    if (brothersCluster == null || brothersCluster.isNull() || sistersCluster == null || sistersCluster.isNull()) continue;
                    if (lineType == LineType.WEIGHTED_ARC) {
                        result.incArcWeight(sistersCluster, brothersCluster);
                        continue;
                    }
                    if (lineType != LineType.SIMPLE_ARC || result.getArc(sistersCluster, brothersCluster) != null) continue;
                    result.addArc(sistersCluster, brothersCluster, 1.0);
                }
            }
        }
        return result;
    }

    public static Graph<Cluster<Individual>> createUnmergedFlowNetwork(Net source, String sourceLabel, String targetLabel) throws PuckException {
        if (source == null || sourceLabel == null || targetLabel == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Partition<Individual> sourcePartition = PartitionMaker.createRaw(source, sourceLabel);
        Partition<Individual> targetPartition = PartitionMaker.createRaw(source, targetLabel);
        Graph<Cluster<Individual>> result = new Graph<Cluster<Individual>>("Unmerged Flow Network: " + source.getLabel() + " " + sourceLabel + " " + targetLabel);
        for (Individual individual : source.individuals()) {
            Cluster<Individual> sourceCluster = sourcePartition.getCluster(individual);
            Cluster<Individual> targetCluster = targetPartition.getCluster(individual);
            if (sourceCluster.getLabel() == null || targetCluster.getLabel() == null) continue;
            result.incArcWeight(sourceCluster, targetCluster);
        }
        return result;
    }

    public static <E> AllianceNet graphToAllianceNet(Graph<E> source) {
        Matrix matrix = source.getSquareMatrix().getMatrix();
        AllianceNet result = new AllianceNet(true);
        Vector<Group> groups = new Vector<Group>();
        int columnIndex = 0;
        while (columnIndex < matrix.getColDim()) {
            Group group = result.addNode();
            groups.add(group);
            ++columnIndex;
        }
        int rowIndex = 0;
        while (rowIndex < matrix.getRowDim()) {
            int columnIndex2 = 0;
            while (columnIndex2 < matrix.getColDim()) {
                result.addEdge((Group)groups.get(rowIndex), (Group)groups.get(columnIndex2), matrix.get(rowIndex, columnIndex2));
                ++columnIndex2;
            }
            ++rowIndex;
        }
        return result;
    }

    public static enum AllianceType {
        WIFE_HUSBAND,
        SISTER_BROTHER;

    }

    public static enum LineType {
        SIMPLE_ARC,
        WEIGHTED_ARC;

    }
}

