package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.clusternetworks.VirtualFieldworkVariationsCriteria;
import org.tip.puck.graphs.random.RandomGraphReporter;
import org.tip.puck.report.Report;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class VirtualFieldworkVariationsInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(VirtualFieldworkVariationsInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private JPanel contentPane;
	private JButton btnRestoreDefaults;
	private JCheckBox chckbxNumberOfLoops;
	private JCheckBox chckbxNumberOfCircuits;
	private JCheckBox chckbxNumberOfTriangles;
	private JCheckBox chckbxConcentration;
	private JCheckBox chckbxStrengthConcentration;
	private JCheckBox chckbxWeightDistribution;
	private JCheckBox chckbxStrengthDistribution;
	private JSpinner spnrFractionOfNodes;
	private JSpinner spnrFractionOfArcs;
	private JSpinner spnrNumberOfRuns;
	private final ButtonGroup buttonGroupVariable1 = new ButtonGroup();
	private final ButtonGroup buttonGroupVariable2 = new ButtonGroup();
	private JRadioButton rdbtnVariable1Index1;
	private JRadioButton rdbtnVariable1Index2;
	private JRadioButton rdbtnVariable2Index1;
	private JRadioButton rdbtnVariable2Index2;
	private JCheckBox chckbxExtractRepresentative;
	private JSpinner spnrVariable1IntervalFactor;
	private JSpinner spnrVariable2IntervalFactor;
	private JSpinner spnrOutPreference;
	private JSpinner spnrVariable1NumberOfIntervals;
	private JSpinner spnrVariable2NumberOfIntervals;
	private JCheckBox chckbxSymmetry;

	/**
	 * Create the frame.
	 */
	public VirtualFieldworkVariationsInputWindow(final GroupNetGUI groupNetGUI) {
		setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		setTitle("Virtual Fieldwork Variations");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 518, 500);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});

		btnRestoreDefaults = new JButton("Restore Defaults");
		btnRestoreDefaults.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Restore Defaults.
				setCriteria(new VirtualFieldworkVariationsCriteria());
			}
		});
		buttonPanel.add(btnRestoreDefaults);
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					VirtualFieldworkVariationsCriteria criteria = getCriteria();

					//
					PuckGUI.instance().getPreferences().setVirtualFieldworkVariationsCriteria(criteria);

					//
					Report report = RandomGraphReporter.reportVirtualFieldworkVariations(groupNetGUI.getGroupNet(), criteria);

					//
					groupNetGUI.addReportTab(report);

					//
					dispose();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		JPanel panel_targets = new JPanel();
		panel_targets.setBorder(new TitledBorder(null, "Targets", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		contentPane.add(panel_targets, BorderLayout.NORTH);
		panel_targets.setLayout(new BoxLayout(panel_targets, BoxLayout.X_AXIS));

		JPanel panel_1 = new JPanel();
		panel_targets.add(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));

		chckbxNumberOfLoops = new JCheckBox("Number of loops");
		panel_1.add(chckbxNumberOfLoops);

		chckbxNumberOfCircuits = new JCheckBox("Number of circuits");
		panel_1.add(chckbxNumberOfCircuits);

		chckbxNumberOfTriangles = new JCheckBox("Number of triangles");
		panel_1.add(chckbxNumberOfTriangles);

		Component horizontalStrut = Box.createHorizontalStrut(20);
		panel_targets.add(horizontalStrut);

		JPanel panel = new JPanel();
		panel_targets.add(panel);
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

		chckbxConcentration = new JCheckBox("Concentration");
		panel.add(chckbxConcentration);

		chckbxWeightDistribution = new JCheckBox("Weight distribution");
		panel.add(chckbxWeightDistribution);

		chckbxStrengthDistribution = new JCheckBox("Strength distribution");
		panel.add(chckbxStrengthDistribution);

		Component horizontalStrut_2 = Box.createHorizontalStrut(20);
		panel_targets.add(horizontalStrut_2);

		JPanel panel_7 = new JPanel();
		panel_targets.add(panel_7);
		panel_7.setLayout(new BoxLayout(panel_7, BoxLayout.Y_AXIS));

		chckbxSymmetry = new JCheckBox("Symmetry");
		panel_7.add(chckbxSymmetry);

		chckbxStrengthConcentration = new JCheckBox("Strength Concentration");
		panel_7.add(chckbxStrengthConcentration);

		Component verticalGlue = Box.createVerticalGlue();
		panel_7.add(verticalGlue);

		JPanel panel_parameters = new JPanel();
		panel_parameters.setBorder(new TitledBorder(null, "Parameters", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		contentPane.add(panel_parameters, BorderLayout.CENTER);
		panel_parameters.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("100dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), },
				new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblNumberOfNodes = new JLabel("Fraction of nodes:");
		panel_parameters.add(lblNumberOfNodes, "2, 2");

		spnrFractionOfNodes = new JSpinner();
		spnrFractionOfNodes.setModel(new SpinnerNumberModel(new Double(1), new Double(0.0), new Double(1.0), new Double(0.05)));
		((JSpinner.NumberEditor) spnrFractionOfNodes.getEditor()).getFormat().setMinimumFractionDigits(5);
		panel_parameters.add(spnrFractionOfNodes, "4, 2");

		JLabel lblNumberOfArcs = new JLabel("Fraction of arcs:");
		panel_parameters.add(lblNumberOfArcs, "2, 4");

		spnrFractionOfArcs = new JSpinner();
		spnrFractionOfArcs.setModel(new SpinnerNumberModel(new Double(0.1), new Double(0.0), new Double(1.0), new Double(0.05)));
		((JSpinner.NumberEditor) spnrFractionOfArcs.getEditor()).getFormat().setMinimumFractionDigits(5);
		panel_parameters.add(spnrFractionOfArcs, "4, 4");

		JLabel lblOutPreference = new JLabel("Out preference:");
		panel_parameters.add(lblOutPreference, "2, 6, right, default");

		spnrOutPreference = new JSpinner();
		spnrOutPreference.setModel(new SpinnerNumberModel(new Double(0.5), new Double(0.1), null, new Double(0.1)));
		((JSpinner.NumberEditor) spnrOutPreference.getEditor()).getFormat().setMinimumFractionDigits(1);
		panel_parameters.add(spnrOutPreference, "4, 6");

		JLabel lblNumberOfRuns = new JLabel("Number of runs:");
		panel_parameters.add(lblNumberOfRuns, "2, 8");

		spnrNumberOfRuns = new JSpinner();
		spnrNumberOfRuns.setModel(new SpinnerNumberModel(new Integer(100), new Integer(1), null, new Integer(1)));
		panel_parameters.add(spnrNumberOfRuns, "4, 8");

		JPanel panel_2 = new JPanel();
		panel_parameters.add(panel_2, "2, 10, 5, 1, fill, fill");
		panel_2.setLayout(new BoxLayout(panel_2, BoxLayout.X_AXIS));

		JPanel panel_firstVariable = new JPanel();
		panel_firstVariable.setBorder(new TitledBorder(null, "First variable", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panel_2.add(panel_firstVariable);
		panel_firstVariable.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblIndex = new JLabel("Index:");
		panel_firstVariable.add(lblIndex, "2, 2, right, default");

		JPanel panel_3 = new JPanel();
		panel_firstVariable.add(panel_3, "4, 2, fill, fill");
		panel_3.setLayout(new BoxLayout(panel_3, BoxLayout.Y_AXIS));

		rdbtnVariable1Index1 = new JRadioButton("variable 1");
		buttonGroupVariable1.add(rdbtnVariable1Index1);
		rdbtnVariable1Index1.setSelected(true);
		panel_3.add(rdbtnVariable1Index1);

		rdbtnVariable1Index2 = new JRadioButton("variable 2");
		buttonGroupVariable1.add(rdbtnVariable1Index2);
		panel_3.add(rdbtnVariable1Index2);

		JPanel panel_5 = new JPanel();
		panel_firstVariable.add(panel_5, "2, 4, right, fill");
		panel_5.setLayout(new BoxLayout(panel_5, BoxLayout.Y_AXIS));

		JLabel lblNumberOf = new JLabel("Number of");
		panel_5.add(lblNumberOf);

		JLabel lblIntervals = new JLabel("intervals:");
		panel_5.add(lblIntervals);

		spnrVariable1NumberOfIntervals = new JSpinner();
		spnrVariable1NumberOfIntervals.setModel(new SpinnerNumberModel(new Integer(5), new Integer(0), null, new Integer(1)));
		panel_firstVariable.add(spnrVariable1NumberOfIntervals, "4, 4");

		JLabel lblIntervalFactor = new JLabel("Interval factor:");
		panel_firstVariable.add(lblIntervalFactor, "2, 6, right, default");

		spnrVariable1IntervalFactor = new JSpinner();
		spnrVariable1IntervalFactor.setModel(new SpinnerNumberModel(new Integer(10), new Integer(1), null, new Integer(1)));
		panel_firstVariable.add(spnrVariable1IntervalFactor, "4, 6");

		Component horizontalStrut_1 = Box.createHorizontalStrut(20);
		panel_2.add(horizontalStrut_1);

		JPanel panel_secondVariable = new JPanel();
		panel_secondVariable.setBorder(new TitledBorder(null, "Second variable", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panel_2.add(panel_secondVariable);
		panel_secondVariable.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblIndex_1 = new JLabel("Index:");
		panel_secondVariable.add(lblIndex_1, "2, 2, right, default");

		JPanel panel_4 = new JPanel();
		panel_secondVariable.add(panel_4, "4, 2, fill, fill");
		panel_4.setLayout(new BoxLayout(panel_4, BoxLayout.Y_AXIS));

		rdbtnVariable2Index1 = new JRadioButton("variable 1");
		buttonGroupVariable2.add(rdbtnVariable2Index1);
		panel_4.add(rdbtnVariable2Index1);

		rdbtnVariable2Index2 = new JRadioButton("variable 2");
		buttonGroupVariable2.add(rdbtnVariable2Index2);
		rdbtnVariable2Index2.setSelected(true);
		panel_4.add(rdbtnVariable2Index2);

		JPanel panel_6 = new JPanel();
		panel_secondVariable.add(panel_6, "2, 4, right, fill");
		panel_6.setLayout(new BoxLayout(panel_6, BoxLayout.Y_AXIS));

		JLabel lblNumberOf_1 = new JLabel("Number of");
		panel_6.add(lblNumberOf_1);

		JLabel lblIntervals_1 = new JLabel("intervals:");
		panel_6.add(lblIntervals_1);

		spnrVariable2NumberOfIntervals = new JSpinner();
		spnrVariable2NumberOfIntervals.setModel(new SpinnerNumberModel(new Integer(5), new Integer(0), null, new Integer(1)));
		panel_secondVariable.add(spnrVariable2NumberOfIntervals, "4, 4");

		JLabel lblIntervalFactor_1 = new JLabel("Interval factor:");
		panel_secondVariable.add(lblIntervalFactor_1, "2, 6, right, default");

		spnrVariable2IntervalFactor = new JSpinner();
		spnrVariable2IntervalFactor.setModel(new SpinnerNumberModel(new Integer(10), new Integer(1), null, new Integer(1)));
		panel_secondVariable.add(spnrVariable2IntervalFactor, "4, 6");

		chckbxExtractRepresentative = new JCheckBox("Extract a representative network");
		panel_parameters.add(chckbxExtractRepresentative, "2, 10, 5, 1");

		// //////////////////
		setCriteria(PuckGUI.instance().getPreferences().getVirtualFieldworkVariationsCriteria());
	}

	/**
	 * 
	 * @return
	 * @throws PuckException
	 */
	public VirtualFieldworkVariationsCriteria getCriteria() throws PuckException {
		VirtualFieldworkVariationsCriteria result;

		//
		result = new VirtualFieldworkVariationsCriteria();

		//
		result.setNumberOfLoopsChecked(chckbxNumberOfLoops.isSelected());
		result.setNumberOfCircuitsChecked(chckbxNumberOfCircuits.isSelected());
		result.setNumberOfTrianglesChecked(chckbxNumberOfTriangles.isSelected());
		result.setConcentrationChecked(chckbxConcentration.isSelected());
		result.setStrengthConcentrationChecked(chckbxStrengthConcentration.isSelected());
		result.setWeightDistributionChecked(chckbxWeightDistribution.isSelected());
		result.setStrengthDistributionChecked(chckbxStrengthDistribution.isSelected());
		result.setSymmetryChecked(chckbxSymmetry.isSelected());

		//
		result.setFractionOfNodes((Double) spnrFractionOfNodes.getValue());
		result.setFractionOfArcs((Double) spnrFractionOfArcs.getValue());
		result.setOutPreference((Double) spnrOutPreference.getValue());
		result.setNumberOfRuns((Integer) spnrNumberOfRuns.getValue());

		//
		int index1;
		if (rdbtnVariable1Index1.isSelected()) {
			index1 = 0;
		} else if (rdbtnVariable1Index2.isSelected()) {
			index1 = 1;
		} else {
			throw PuckExceptions.INVALID_PARAMETER.create("Bad value");
		}
		result.setFirstVariableIndex(index1);

		result.setFirstVariableIntervalFactor((Integer) spnrVariable1IntervalFactor.getValue());

		//
		int index2;
		if (rdbtnVariable2Index1.isSelected()) {
			index2 = 0;
		} else if (rdbtnVariable2Index2.isSelected()) {
			index2 = 1;
		} else {
			throw PuckExceptions.INVALID_PARAMETER.create("Bad value");
		}
		result.setSecondVariableIndex(index2);

		result.setSecondVariableIntervalFactor((Integer) spnrVariable2IntervalFactor.getValue());

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final VirtualFieldworkVariationsCriteria source) {
		//
		if (source != null) {
			//
			chckbxNumberOfLoops.setSelected(source.isNumberOfLoopsChecked());
			chckbxNumberOfCircuits.setSelected(source.isNumberOfCircuitsChecked());
			chckbxNumberOfTriangles.setSelected(source.isNumberOfTrianglesChecked());
			chckbxConcentration.setSelected(source.isConcentrationChecked());
			chckbxWeightDistribution.setSelected(source.isWeightDistributionChecked());
			chckbxStrengthDistribution.setSelected(source.isStrengthDistributionChecked());
			chckbxSymmetry.setSelected(source.isSymmetryChecked());

			//
			spnrFractionOfNodes.setValue(source.getFractionOfNodes());
			spnrFractionOfArcs.setValue(source.getArcWeightFraction());
			spnrOutPreference.setValue(source.getOutPreference());
			spnrNumberOfRuns.setValue(source.getNumberOfRuns());

			//
			rdbtnVariable1Index1.setSelected(false);
			rdbtnVariable1Index2.setSelected(false);
			switch (source.getFirstVariableIndex()) {
				case 0:
					rdbtnVariable1Index1.setSelected(true);
				break;
				case 1:
					rdbtnVariable1Index2.setSelected(true);
				break;
			}

			//
			spnrVariable1NumberOfIntervals.setValue(source.getFirstVariableNumberOfIntervals());
			spnrVariable1IntervalFactor.setValue(source.getFirstVariableIntervalFactor());

			//
			rdbtnVariable2Index1.setSelected(false);
			rdbtnVariable2Index2.setSelected(false);
			switch (source.getSecondVariableIndex()) {
				case 0:
					rdbtnVariable2Index1.setSelected(true);
				break;
				case 1:
					rdbtnVariable2Index2.setSelected(true);
				break;
			}

			//
			spnrVariable2NumberOfIntervals.setValue(source.getSecondVariableNumberOfIntervals());
			spnrVariable2IntervalFactor.setValue(source.getSecondVariableIntervalFactor());
		}
	}
}
