package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.models.ActorsModel;
import org.tip.puckgui.models.RelationsCellRenderer;
import org.tip.puckgui.models.RelationsModel;
import org.tip.puckgui.util.AutoComboBox;
import org.tip.puckgui.util.ComboBoxIds;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class RelationsPanel extends JPanel {

	private static final long serialVersionUID = 651718283569255829L;

	static private final Logger logger = LoggerFactory.getLogger(RelationsPanel.class);

	int reportCounter = 0;
	private JPanel thisJPanel;
	private RelationModel relationModel;
	private JTextField txtfldSearchRelation;
	private NetGUI netGUI;
	private JTable tableRelationActors;
	private JLabel lblRelationId;
	private JLabel lblRelationName;
	JLabel lblRelationModel;
	JList relationList;
	JScrollPane relationsScrollPane;
	private JLabel lblRelationActors;
	private JLabel lblPosition;
	private JTextField txtfldRelationName;
	private AttributesPanel attributesPanel;
	private AutoComboBox cmbbxActorIds;
	private AutoComboBox cmbbxActorRoles;

	/**
	 * Initialize the contents of the frame.
	 */
	public RelationsPanel(final NetGUI guiManager, final RelationModel relationModel) {

		//
		this.thisJPanel = this;
		this.netGUI = guiManager;
		this.relationModel = relationModel;

		//
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		JSplitPane relationsSplit = new JSplitPane();
		add(relationsSplit);
		relationsSplit.setAlignmentX(Component.CENTER_ALIGNMENT);

		JPanel relationsPanel = new JPanel();
		relationsPanel.setMinimumSize(new Dimension(200, 10));
		relationsSplit.setLeftComponent(relationsPanel);
		relationsPanel.setLayout(new BoxLayout(relationsPanel, BoxLayout.Y_AXIS));

		relationsScrollPane = new JScrollPane();
		relationsScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		relationsPanel.add(relationsScrollPane);

		relationList = new JList();
		relationList.setDoubleBuffered(true);
		relationList.addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(final ListSelectionEvent event) {
				// Selected.
				if (relationList.getSelectedIndex() != -1) {
					Relation relation = (Relation) ((JList) event.getSource()).getModel().getElementAt(relationList.getSelectedIndex());
					updateRelationIdentity(relation);
				}
			}
		});
		relationList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		relationList.setCellRenderer(new RelationsCellRenderer());
		relationList.setModel(new RelationsModel(netGUI.getSegmentation().getCurrentRelations().getByModel(relationModel)));
		relationsScrollPane.setViewportView(relationList);

		JPanel relationPanel = new JPanel();
		relationsSplit.setRightComponent(relationPanel);
		relationPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		relationPanel.setAlignmentY(Component.TOP_ALIGNMENT);
		relationPanel.setLayout(new BoxLayout(relationPanel, BoxLayout.Y_AXIS));

		JPanel panel_4 = new JPanel();
		panel_4.setAlignmentX(Component.LEFT_ALIGNMENT);
		relationPanel.add(panel_4);
		panel_4.setLayout(new BoxLayout(panel_4, BoxLayout.X_AXIS));

		lblRelationModel = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("RelationsPanel.lblRelationModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblRelationModel.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Relation Model double clicked.
				if (event.getClickCount() == 2) {
					int selectedIndex = relationList.getSelectedIndex();
					if (selectedIndex != -1) {
					}
				}
			}
		});

		JLabel lblModel = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("RelationsPanel.lblModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		panel_4.add(lblModel);

		Component horizontalStrut_2 = Box.createHorizontalStrut(10);
		panel_4.add(horizontalStrut_2);
		panel_4.add(lblRelationModel);

		Component horizontalStrut_4 = Box.createHorizontalStrut(10);
		panel_4.add(horizontalStrut_4);

		JButton btnEditModel = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("RelationsPanel.btnEditModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		btnEditModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Edit Relation Model.
				try {
					RelationModelInputWindow window = new RelationModelInputWindow(netGUI, relationModel);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		panel_4.add(btnEditModel);

		Component horizontalGlue = Box.createHorizontalGlue();
		panel_4.add(horizontalGlue);

		JButton btnDeleteModel = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("RelationsPanel.btnDeleteModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		btnDeleteModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Remove Model.
				if (netGUI.getNet().relations().getByModel(relationModel).size() == 0) {
					//
					int response = JOptionPane.showConfirmDialog(null, "Confirm relation model delete?", "Confirm", JOptionPane.YES_NO_OPTION);

					//
					if (response == JOptionPane.YES_OPTION) {
						netGUI.getNet().relationModels().remove(relationModel);
						netGUI.closeRelationTab(relationModel);
					}
				} else {
					JOptionPane.showMessageDialog(null, "Relation list of this model is not empty.", "Delete Model", JOptionPane.WARNING_MESSAGE);
				}
			}
		});
		panel_4.add(btnDeleteModel);

		JPanel panelRelationIdentity = new JPanel();
		panelRelationIdentity.setAlignmentX(Component.LEFT_ALIGNMENT);
		relationPanel.add(panelRelationIdentity);
		panelRelationIdentity.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
				FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));

		JPanel panelId = new JPanel();
		panelRelationIdentity.add(panelId, "4, 2");
		panelId.setLayout(new BoxLayout(panelId, BoxLayout.Y_AXIS));

		Component verticalStrut_9 = Box.createVerticalStrut(10);
		verticalStrut_9.setMaximumSize(new Dimension(20, 20));
		panelId.add(verticalStrut_9);

		lblRelationId = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.label.text_2"));

		lblRelationId.setAlignmentX(Component.RIGHT_ALIGNMENT);
		panelId.add(lblRelationId);

		Component verticalStrut_8 = Box.createVerticalStrut(10);
		verticalStrut_8.setMaximumSize(new Dimension(20, 10));
		panelId.add(verticalStrut_8);

		lblPosition = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.lblNewLabel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblPosition.setAlignmentX(Component.RIGHT_ALIGNMENT);
		panelId.add(lblPosition);

		lblRelationName = new JLabel("----");
		panelRelationIdentity.add(lblRelationName, "6, 2");
		lblRelationName.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent e) {
				// Relation name clicked.
				setRelationNameEditorOn();
			}
		});
		lblRelationName.setFont(new Font("Dialog", Font.PLAIN, 24));

		txtfldRelationName = new JTextField();
		txtfldRelationName.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(final KeyEvent event) {
				if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
					logger.debug("escape pressed");
					txtfldRelationName.setText(lblRelationName.getText());
					txtfldRelationName.transferFocus();
				}
			}
		});
		txtfldRelationName.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(final FocusEvent event) {
				// Relation name changed.
				logger.debug("name focus lost");
				if (StringUtils.isBlank(txtfldRelationName.getText())) {
					if (StringUtils.isBlank(lblRelationName.getText())) {
						Relation currentRelation = getSelectedRelation();
						currentRelation.setName("?");
						update();
					}
				} else if (!StringUtils.equals(txtfldRelationName.getText(), lblRelationName.getText())) {
					Relation currentRelation = getSelectedRelation();
					currentRelation.setName(txtfldRelationName.getText());
					update();
				}

				txtfldRelationName.setVisible(false);
				lblRelationName.setVisible(true);
			}
		});
		txtfldRelationName.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Relation name changed on Enter pressed.
				logger.debug("perform");
				txtfldRelationName.transferFocus();
			}
		});
		panelRelationIdentity.add(txtfldRelationName, "8, 2");
		txtfldRelationName.setText("");
		txtfldRelationName.setColumns(10);

		JPanel panel_6 = new JPanel();
		panel_6.setAlignmentX(Component.LEFT_ALIGNMENT);
		relationPanel.add(panel_6);
		panel_6.setLayout(new BorderLayout(0, 0));

		JSplitPane splitPane_1 = new JSplitPane();
		panel_6.add(splitPane_1, BorderLayout.CENTER);
		splitPane_1.setOrientation(JSplitPane.VERTICAL_SPLIT);

		JPanel panelIndividualSpouses = new JPanel();
		panelIndividualSpouses.setMinimumSize(new Dimension(10, 200));
		panelIndividualSpouses.setBorder(new EmptyBorder(0, 0, 0, 10));
		panelIndividualSpouses.setAlignmentY(Component.TOP_ALIGNMENT);
		panelIndividualSpouses.setAlignmentX(Component.LEFT_ALIGNMENT);
		splitPane_1.setLeftComponent(panelIndividualSpouses);
		panelIndividualSpouses.setLayout(new BoxLayout(panelIndividualSpouses, BoxLayout.Y_AXIS));

		Component verticalStrut_6 = Box.createVerticalStrut(5);
		panelIndividualSpouses.add(verticalStrut_6);

		JPanel panel = new JPanel();
		panel.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelIndividualSpouses.add(panel);
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

		lblRelationActors = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblActors.text"));
		panel.add(lblRelationActors);

		Component horizontalStrut = Box.createHorizontalStrut(20);
		panel.add(horizontalStrut);

		JButton btnAddActor = new JButton(" + ");
		btnAddActor.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					// Add an actor in relation.
					if ((relationModel.roles().size() > 0) && (netGUI.getCurrentIndividuals().size() > 0)) {
						if (((ActorsModel) tableRelationActors.getModel()).getSource() != null) {
							// Add attribute.
							if (tableRelationActors.getModel().getRowCount() == ((ActorsModel) tableRelationActors.getModel()).getSource().size()) {
								((ActorsModel) tableRelationActors.getModel()).setNewItem();
							}
							tableRelationActors.setRowSelectionInterval(tableRelationActors.getModel().getRowCount() - 1, tableRelationActors.getModel()
									.getRowCount() - 1);
							tableRelationActors.setRowSelectionInterval(tableRelationActors.getModel().getRowCount() - 1, tableRelationActors.getModel()
									.getRowCount() - 1);
							tableRelationActors.setColumnSelectionInterval(0, 0);
							tableRelationActors.editCellAt(tableRelationActors.getModel().getRowCount() - 1, 0);
							tableRelationActors.getEditorComponent().requestFocus();
						}
					}
				} catch (final Exception exception) {
					exception.printStackTrace();
				}
			}
		});
		btnAddActor.setBorder(new EmptyBorder(0, 0, 0, 0));
		panel.add(btnAddActor);

		JScrollPane scrollPane_1 = new JScrollPane();
		scrollPane_1.setBackground(new Color(255, 255, 255));
		scrollPane_1.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelIndividualSpouses.add(scrollPane_1);

		tableRelationActors = new JTable();
		tableRelationActors.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(final MouseEvent event) {
				// Relation actor clicked.
				try {
					if (event.getClickCount() == 2) {
						int selectedIndex = tableRelationActors.getSelectedRow();
						int selectedColumn = tableRelationActors.getSelectedColumn();
						if ((selectedIndex != -1) && (selectedColumn != -1)) {
							// Redirect to an individual.
							Individual selected = ((ActorsModel) tableRelationActors.getModel()).getSource().get(selectedIndex).getIndividual();
							if (selected != null) {
								netGUI.changeSegmentationToCluster(selected);
							}
						}
					}
				} catch (final Exception exception) {
					exception.printStackTrace();
				}
			}
		});

		JPopupMenu popupMenu = new JPopupMenu();
		addPopup(tableRelationActors, popupMenu);

		JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("RelationsPanel.mntmDelete.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Delete family children.
				logger.debug("Delete " + ArrayUtils.toString(tableRelationActors.getSelectedRows()));

				int[] selectedRowIds = tableRelationActors.getSelectedRows();
				if (selectedRowIds.length != 0) {
					Relation currentRelation = getIdentityRelation();
					ArrayUtils.reverse(selectedRowIds);
					for (int rowIndex : selectedRowIds) {
						netGUI.getNet().removeRelationActor(currentRelation, ((ActorsModel) tableRelationActors.getModel()).getTarget().get(rowIndex));
					}

					//
					netGUI.setChanged(true);
					netGUI.updateAll();
				}
			}
		});
		popupMenu.add(mntmDelete);

		//
		scrollPane_1.setViewportView(tableRelationActors);
		tableRelationActors.setBorder(new LineBorder(new Color(169, 169, 169)));
		tableRelationActors.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		tableRelationActors.setModel(new ActorsModel(null, netGUI, null));
		tableRelationActors.getTableHeader().setReorderingAllowed(false);

		//
		cmbbxActorRoles = new AutoComboBox(null);
		cmbbxActorRoles.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST RELATION TABLE MODEL" + tableRelationActors.isEditing());
				if (tableRelationActors.isEditing()) {
					tableRelationActors.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
				}
			}
		});
		cmbbxActorRoles.setEditable(true);
		cmbbxActorRoles.setStrict(true);
		cmbbxActorRoles.setMaximumRowCount(10);
		TableCellEditor editor = new DefaultCellEditor(cmbbxActorRoles);
		tableRelationActors.getColumnModel().getColumn(0).setCellEditor(editor);
		tableRelationActors.getColumnModel().getColumn(0).setMinWidth(10);
		tableRelationActors.getColumnModel().getColumn(0).setPreferredWidth(90);
		tableRelationActors.getColumnModel().getColumn(0).setMaxWidth(150);

		//
		cmbbxActorIds = new AutoComboBox(null);
		cmbbxActorIds.getEditor().getEditorComponent().addFocusListener(new FocusListener() {
			@Override
			public void focusGained(final FocusEvent arg0) {
			}

			@Override
			public void focusLost(final FocusEvent arg0) {
				logger.debug("FOCUS LOST RELATION TABLE INDIVIDUAL" + tableRelationActors.isEditing());
				if (tableRelationActors.isEditing()) {
					tableRelationActors.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
				}
			}
		});
		cmbbxActorIds.setEditable(true);
		cmbbxActorIds.setStrict(false);
		cmbbxActorIds.setMaximumRowCount(10);
		TableCellEditor editor2 = new DefaultCellEditor(cmbbxActorIds);
		tableRelationActors.getColumnModel().getColumn(1).setCellEditor(editor2);
		tableRelationActors.getColumnModel().getColumn(1).setMinWidth(10);
		tableRelationActors.getColumnModel().getColumn(1).setPreferredWidth(90);
		tableRelationActors.getColumnModel().getColumn(1).setMaxWidth(110);
		tableRelationActors.getColumnModel().getColumn(1).setResizable(false);

		Component verticalStrut_2 = Box.createVerticalStrut(10);
		panelIndividualSpouses.add(verticalStrut_2);

		attributesPanel = new AttributesPanel(this.netGUI, null);
		splitPane_1.setRightComponent(attributesPanel);

		JPanel buttonsPanel = new JPanel();
		add(buttonsPanel);
		buttonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		buttonsPanel.setLayout(new BoxLayout(buttonsPanel, BoxLayout.X_AXIS));

		JButton btnAddRelation = new JButton("");
		btnAddRelation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Add a relation.
				addRelation();
			}
		});
		btnAddRelation.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton_1.toolTipText"));
		btnAddRelation.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/add.png")));
		buttonsPanel.add(btnAddRelation);

		JButton btnRemoveRelation = new JButton("");
		btnRemoveRelation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Remove relation.
				Relation target = getSelectedRelation();
				if (target != null) {
					//
					int selectedIndex = relationList.getSelectedIndex();

					// Remove.
					netGUI.getNet().remove(target);

					// Refresh.
					Relations tabRelations = netGUI.getNet().relations().getByModel(relationModel);
					((RelationsModel) relationList.getModel()).setSource(tabRelations);
					if (tabRelations.size() != 0) {
						if (selectedIndex == tabRelations.size()) {
							selectedIndex -= 1;
						}
						relationList.setSelectedIndex(selectedIndex);
					}

					// Refresh.
					netGUI.updateAll();

					//
					netGUI.setChanged(true);
				}
			}
		});
		btnRemoveRelation.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNewButton.toolTipText"));
		btnRemoveRelation.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/remove.png")));
		buttonsPanel.add(btnRemoveRelation);

		Component horizontalGlue_3 = Box.createHorizontalGlue();
		buttonsPanel.add(horizontalGlue_3);

		JButton btnPreviousRelation = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
		btnPreviousRelation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Previous individual.
				int selectedIndex = relationList.getSelectedIndex();
				if (selectedIndex == -1) {
					int size = relationList.getModel().getSize();
					if (size != 0) {
						selectedIndex = size - 1;
						relationList.setSelectedIndex(selectedIndex);
						relationList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex > 0) {
					selectedIndex -= 1;
					relationList.setSelectedIndex(selectedIndex);
					relationList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		buttonsPanel.add(btnPreviousRelation);

		JButton btnNextRelation = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
		btnNextRelation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Next individual.
				int selectedIndex = relationList.getSelectedIndex();
				int size = relationList.getModel().getSize();
				if (selectedIndex == -1) {
					if (size != 0) {
						selectedIndex = 0;
						relationList.setSelectedIndex(selectedIndex);
						relationList.ensureIndexIsVisible(selectedIndex);
					}
				} else if (selectedIndex < size - 1) {
					selectedIndex += 1;
					relationList.setSelectedIndex(selectedIndex);
					relationList.ensureIndexIsVisible(selectedIndex);
				}
			}
		});
		buttonsPanel.add(btnNextRelation);

		Component horizontalGlue_1 = Box.createHorizontalGlue();
		buttonsPanel.add(horizontalGlue_1);

		JLabel lblRelationsSearch = new JLabel(" ");
		lblRelationsSearch.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSearch.text")); //$NON-NLS-1$ //$NON-NLS-2$
		lblRelationsSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
		buttonsPanel.add(lblRelationsSearch);
		lblRelationsSearch.setMinimumSize(new Dimension(300, 15));

		txtfldSearchRelation = new JTextField();
		txtfldSearchRelation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Search relation.
				String pattern = txtfldSearchRelation.getText();
				logger.debug("Search relation=[" + pattern + "]");
				if (StringUtils.isNotBlank(pattern)) {
					int index = ((RelationsModel) relationList.getModel()).nextSearchedIndex(pattern);
					if (index != -1) {
						relationList.setSelectedIndex(index);
						relationList.ensureIndexIsVisible(index);
					}
				}
			}
		});
		buttonsPanel.add(txtfldSearchRelation);
		txtfldSearchRelation.setMaximumSize(new Dimension(500, 50));
		txtfldSearchRelation.setText("");
		txtfldSearchRelation.setColumns(15);

		//
		if (relationList.getModel().getSize() != 0) {
			relationList.setSelectedIndex(0);
		}
	}

	public void addRelation() {
		try {
			//
			Relation relation = netGUI.getNet().createRelation("", relationModel);
			((RelationsModel) relationList.getModel()).setSource(netGUI.getCurrentRelations().getByModel(relationModel));

			select(relation);
			// netGUI.updateAll();
			// netGUI.selectRelationsTab(individual);

			//
			setRelationNameEditorOn();
		} catch (final Exception exception) {
			// Show trace.
			exception.printStackTrace();

			//
			String title = "Error computerum est";
			String message = "Error occured during working: " + exception.getMessage();

			//
			JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 * @return
	 */
	public Relation getIdentityRelation() {
		Relation result;

		if (NumberUtils.isDigits(lblRelationId.getText())) {
			result = netGUI.getNet().relations().getById(Integer.parseInt(lblRelationId.getText()));
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public RelationModel getRelationModel() {
		RelationModel result;

		result = this.relationModel;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Relation getSelectedRelation() {
		Relation result;

		if (relationList.getSelectedIndex() == -1) {
			result = null;
		} else {
			result = (Relation) ((RelationsModel) relationList.getModel()).getElementAt(relationList.getSelectedIndex());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param target
	 */
	public void select(final Relation relation) {
		int relationIndex = ((RelationsModel) relationList.getModel()).indexOf(relation);

		if ((relationIndex >= 0) && (relationIndex < ((RelationsModel) this.relationList.getModel()).getSize())) {
			this.relationList.setSelectedIndex(relationIndex);
			this.relationList.ensureIndexIsVisible(relationIndex);
		} else if (((RelationsModel) this.relationList.getModel()).getSize() != 0) {
			this.relationList.setSelectedIndex(0);
			this.relationList.ensureIndexIsVisible(0);
		} else {
			updateRelationIdentity(null);
		}
	}

	private void setRelationNameEditorOn() {
		lblRelationName.setVisible(false);
		txtfldRelationName.setVisible(true);
		txtfldRelationName.setText(lblRelationName.getText());
		txtfldRelationName.requestFocus();
	}

	/**
	 * 
	 */
	public void update() {
		int currentIndex = relationList.getSelectedIndex();
		((RelationsModel) relationList.getModel()).setSource(this.netGUI.getCurrentRelations().getByModel(relationModel));
		if (currentIndex < relationList.getModel().getSize()) {
			relationList.setSelectedIndex(currentIndex);
			updateRelationIdentity();
		} else {
			relationList.setSelectedIndex(0);
			updateRelationIdentity();
		}
	}

	/**
	 * 
	 */
	public void updateRelationIdentity() {
		updateRelationIdentity(getSelectedRelation());
	}

	/**
	 * 
	 */
	public void updateRelationIdentity(final Relation source) {

		if (source == null) {
			//
			this.lblRelationModel.setText("----");

			//
			this.lblRelationId.setText("---");
			this.lblRelationName.setVisible(true);
			this.lblRelationName.setText("----");
			this.txtfldRelationName.setVisible(false);
			this.lblPosition.setText("(--/--)");

			//
			((ActorsModel) tableRelationActors.getModel()).setSource(null, null, null);
			lblRelationActors.setText("Actors");

			//
			cmbbxActorIds.setDataList(new ArrayList<String>(0));

			//
			cmbbxActorRoles.setDataList(new ArrayList<String>(0));

			//
			attributesPanel.setSource(null);
		} else {
			//
			this.lblRelationModel.setText(source.getModel().getName());

			//
			this.lblRelationId.setText(String.valueOf(source.getId()));
			this.lblRelationName.setVisible(true);
			this.lblRelationName.setText(source.getName());
			this.txtfldRelationName.setVisible(false);
			this.lblPosition.setText("(" + (this.relationList.getSelectedIndex() + 1) + "/" + this.relationList.getModel().getSize() + ")");

			//
			((ActorsModel) tableRelationActors.getModel()).setSource(source.actors(), netGUI, source);
			lblRelationActors.setText("Actors (" + source.actors().size() + ")");

			//
			cmbbxActorIds.setDataList(ComboBoxIds.instance().items());

			//
			attributesPanel.setSource(source.attributes());

			//
			cmbbxActorRoles.setDataList(relationModel.roles().sortedNameList());
		}
	}

	private static void addPopup(final Component component, final JPopupMenu popup) {
		component.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			@Override
			public void mouseReleased(final MouseEvent e) {
				if (e.isPopupTrigger()) {
					showMenu(e);
				}
			}

			private void showMenu(final MouseEvent e) {
				popup.show(e.getComponent(), e.getX(), e.getY());
			}
		});
	}
}
