package org.tip.puckgui.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.InputSettings.CheckLevel;
import org.tip.puckgui.Language;
import org.tip.puckgui.Preferences;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class PreferencesWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(PreferencesWindow.class);

	private static final long serialVersionUID = -4427644262064342086L;
	private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages"); //$NON-NLS-1$

	private JPanel contentPane;
	private JComboBox languagesComboBox;
	private JCheckBox chkbxAutoLoadLastFile;
	private final ButtonGroup bttnGrpSameSexSpouse = new ButtonGroup();
	private final ButtonGroup bttnGrpFemaleFathersOrMaleMothers = new ButtonGroup();
	private final ButtonGroup bttnGrpParentChildMarriages = new ButtonGroup();
	private JRadioButton rdBttnSameSexSpouseNone;
	private JRadioButton rdBttnSameSexSpouseWarning;
	private JRadioButton rdBttnSameSexSpouseError;
	private JRadioButton rdBttnFemaleFathersOrMaleMothersNone;
	private JRadioButton rdBttnFemaleFathersOrMaleMothersWarning;
	private JRadioButton rdBttnFemaleFathersOrMaleMothersError;
	private JRadioButton rdBttnParentChildMarriagesNone;
	private JRadioButton rdBttnParentChildMarriagesWarning;
	private JRadioButton rdBttnParentChildMarriagesError;

	/**
	 * Create the frame.
	 */
	public PreferencesWindow() {
		setTitle(BUNDLE.getString("PreferencesWindow.this.title")); //$NON-NLS-1$
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		setBounds(100, 100, 400, 365);
		setLocationRelativeTo(null);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

		JPanel panel = new JPanel();
		contentPane.add(panel);
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.GLUE_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblLanguages = new JLabel(BUNDLE.getString("PreferencesWindow.language.text")); //$NON-NLS-1$
		panel.add(lblLanguages, "2, 2");

		languagesComboBox = new JComboBox();
		panel.add(languagesComboBox, "4, 2");
		List<String> languageLabels = new ArrayList<String>();
		for (Language language : Language.values()) {
			languageLabels.add(BUNDLE.getString("PreferencesWindow.language." + language.toString().toLowerCase()));
		}

		languagesComboBox.setModel(new DefaultComboBoxModel(languageLabels.toArray()));
		languagesComboBox.setSelectedIndex(ArrayUtils.indexOf(Language.values(), PuckGUI.instance().getPreferences().getLanguage()));

		JLabel lblAutoLoadLast = new JLabel(BUNDLE.getString("PreferencesWindow.lblAutoLoadLast.text")); //$NON-NLS-1$
		panel.add(lblAutoLoadLast, "2, 4");

		chkbxAutoLoadLastFile = new JCheckBox();
		panel.add(chkbxAutoLoadLastFile, "4, 4");

		JPanel panel_2 = new JPanel();
		panel_2.setBorder(new TitledBorder(null, "Input settings", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		contentPane.add(panel_2);
		panel_2.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblNone = new JLabel(BUNDLE.getString("PreferencesWindow.lblNone.text")); //$NON-NLS-1$
		panel_2.add(lblNone, "4, 2, center, default");

		JLabel lblWarning = new JLabel(BUNDLE.getString("PreferencesWindow.lblWarning.text")); //$NON-NLS-1$
		panel_2.add(lblWarning, "6, 2, center, default");

		JLabel lblError = new JLabel(BUNDLE.getString("PreferencesWindow.lblError.text")); //$NON-NLS-1$
		panel_2.add(lblError, "8, 2, center, default");

		JLabel lblSamesexSpouses = new JLabel(BUNDLE.getString("PreferencesWindow.lblSamesexSpouses.text")); //$NON-NLS-1$
		panel_2.add(lblSamesexSpouses, "2, 4");

		rdBttnSameSexSpouseNone = new JRadioButton();
		rdBttnSameSexSpouseNone.setSelected(true);
		bttnGrpSameSexSpouse.add(rdBttnSameSexSpouseNone);
		panel_2.add(rdBttnSameSexSpouseNone, "4, 4, center, default");

		rdBttnSameSexSpouseWarning = new JRadioButton();
		bttnGrpSameSexSpouse.add(rdBttnSameSexSpouseWarning);
		panel_2.add(rdBttnSameSexSpouseWarning, "6, 4, center, default");

		rdBttnSameSexSpouseError = new JRadioButton();
		bttnGrpSameSexSpouse.add(rdBttnSameSexSpouseError);
		panel_2.add(rdBttnSameSexSpouseError, "8, 4, center, default");

		JLabel lblFemalFathersOr = new JLabel(BUNDLE.getString("PreferencesWindow.lblFemalFathersOr.text")); //$NON-NLS-1$
		panel_2.add(lblFemalFathersOr, "2, 6");

		rdBttnFemaleFathersOrMaleMothersNone = new JRadioButton();
		rdBttnFemaleFathersOrMaleMothersNone.setSelected(true);
		bttnGrpFemaleFathersOrMaleMothers.add(rdBttnFemaleFathersOrMaleMothersNone);
		panel_2.add(rdBttnFemaleFathersOrMaleMothersNone, "4, 6, center, default");

		rdBttnFemaleFathersOrMaleMothersWarning = new JRadioButton();
		bttnGrpFemaleFathersOrMaleMothers.add(rdBttnFemaleFathersOrMaleMothersWarning);
		panel_2.add(rdBttnFemaleFathersOrMaleMothersWarning, "6, 6, center, default");

		rdBttnFemaleFathersOrMaleMothersError = new JRadioButton();
		bttnGrpFemaleFathersOrMaleMothers.add(rdBttnFemaleFathersOrMaleMothersError);
		panel_2.add(rdBttnFemaleFathersOrMaleMothersError, "8, 6, center, default");

		JLabel lblParentChildMarriages = new JLabel(BUNDLE.getString("PreferencesWindow.lblParentChildMarriages.text")); //$NON-NLS-1$
		panel_2.add(lblParentChildMarriages, "2, 8");

		rdBttnParentChildMarriagesNone = new JRadioButton();
		rdBttnParentChildMarriagesNone.setSelected(true);
		bttnGrpParentChildMarriages.add(rdBttnParentChildMarriagesNone);
		panel_2.add(rdBttnParentChildMarriagesNone, "4, 8, center, default");

		rdBttnParentChildMarriagesWarning = new JRadioButton();
		bttnGrpParentChildMarriages.add(rdBttnParentChildMarriagesWarning);
		panel_2.add(rdBttnParentChildMarriagesWarning, "6, 8, center, default");

		rdBttnParentChildMarriagesError = new JRadioButton();
		bttnGrpParentChildMarriages.add(rdBttnParentChildMarriagesError);
		panel_2.add(rdBttnParentChildMarriagesError, "8, 8, center, default");

		JLabel lblMarriageWithOneself = new JLabel(BUNDLE.getString("PreferencesWindow.lblMarriageWithOneself.text")); //$NON-NLS-1$
		panel_2.add(lblMarriageWithOneself, "2, 10");

		JRadioButton radioButton = new JRadioButton();
		radioButton.setEnabled(false);
		panel_2.add(radioButton, "4, 10, center, default");

		JRadioButton radioButton_1 = new JRadioButton();
		radioButton_1.setEnabled(false);
		panel_2.add(radioButton_1, "6, 10, center, default");

		JRadioButton radioButton_2 = new JRadioButton();
		radioButton_2.setSelected(true);
		panel_2.add(radioButton_2, "8, 10, center, default");

		JLabel lblChildKinWith = new JLabel(BUNDLE.getString("PreferencesWindow.lblChildKinWith.text")); //$NON-NLS-1$
		panel_2.add(lblChildKinWith, "2, 12");

		JRadioButton radioButton_3 = new JRadioButton();
		radioButton_3.setHorizontalAlignment(SwingConstants.CENTER);
		radioButton_3.setEnabled(false);
		panel_2.add(radioButton_3, "4, 12");

		JRadioButton radioButton_4 = new JRadioButton();
		radioButton_4.setEnabled(false);
		panel_2.add(radioButton_4, "6, 12, center, default");

		JRadioButton radioButton_5 = new JRadioButton();
		radioButton_5.setSelected(true);
		radioButton_5.setHorizontalAlignment(SwingConstants.CENTER);
		panel_2.add(radioButton_5, "8, 12");

		JPanel panel_1 = new JPanel();
		contentPane.add(panel_1);

		JButton btnSave = new JButton(BUNDLE.getString("PreferencesWindow.btnSave.text")); //$NON-NLS-1$
		btnSave.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Save preferences.
				try {
					//
					Language selectedLanguage = Language.values()[languagesComboBox.getSelectedIndex()];
					boolean updateLanguage;
					if (selectedLanguage != PuckGUI.instance().getPreferences().getLanguage()) {
						updateLanguage = true;
					} else {
						updateLanguage = false;
					}
					PuckGUI.instance().getPreferences().setLanguage(selectedLanguage);

					//
					PuckGUI.instance().getPreferences().setAutoLoadLastFile(chkbxAutoLoadLastFile.isSelected());

					//
					PuckGUI.instance().getPreferences().setInputSettings(getInputSettings());

					//
					try {
						PuckGUI.instance().savePreferences();
					} catch (final Exception exception) {
						exception.printStackTrace();
						logger.error("Error saving preferences file: " + exception.getMessage());
						logger.warn("Ignoring preferences file save.");
					}

					//
					if (updateLanguage) {
						PuckGUI.instance().updateLanguage();
					}

					//
					dispose();
				} catch (final Exception exception) {
					logger.error("Unavailable to save.");
				}
			}
		});

		JButton btnClose = new JButton(BUNDLE.getString("PreferencesWindow.btnCancel.text")); //$NON-NLS-1$
		btnClose.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});
		panel_1.add(btnClose);
		panel_1.add(btnSave);

		// ////
		setCriteria(PuckGUI.instance().getPreferences());
	}

	/**
	 * 
	 * @return
	 */
	public InputSettings getInputSettings() {
		InputSettings result;

		result = new InputSettings();

		//
		if (rdBttnSameSexSpouseNone.isSelected()) {
			result.setSameSexSpouses(CheckLevel.NONE);
		} else if (rdBttnSameSexSpouseWarning.isSelected()) {
			result.setSameSexSpouses(CheckLevel.WARNING);
		} else if (rdBttnSameSexSpouseError.isSelected()) {
			result.setSameSexSpouses(CheckLevel.ERROR);
		}

		//
		if (rdBttnFemaleFathersOrMaleMothersNone.isSelected()) {
			result.setFemaleFathersOrMaleMothers(CheckLevel.NONE);
		} else if (rdBttnFemaleFathersOrMaleMothersWarning.isSelected()) {
			result.setFemaleFathersOrMaleMothers(CheckLevel.WARNING);
		} else if (rdBttnFemaleFathersOrMaleMothersError.isSelected()) {
			result.setFemaleFathersOrMaleMothers(CheckLevel.ERROR);
		}

		//
		if (rdBttnParentChildMarriagesNone.isSelected()) {
			result.setParentChildMarriages(CheckLevel.NONE);
		} else if (rdBttnParentChildMarriagesWarning.isSelected()) {
			result.setParentChildMarriages(CheckLevel.WARNING);
		} else if (rdBttnParentChildMarriagesError.isSelected()) {
			result.setParentChildMarriages(CheckLevel.ERROR);
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final Preferences source) {
		//
		if (source != null) {
			//
			languagesComboBox.setSelectedIndex(ArrayUtils.indexOf(Language.values(), PuckGUI.instance().getPreferences().getLanguage()));

			//
			chkbxAutoLoadLastFile.setSelected(source.isAutoLoadLastFile());

			//
			setInputSettings(source.getInputSettings());
		}
	}

	/**
	 * 
	 * @return
	 */
	public void setInputSettings(final InputSettings source) {

		if (source != null) {
			//
			switch (source.getSameSexSpouses()) {
				case NONE:
					rdBttnSameSexSpouseNone.setSelected(true);
					rdBttnSameSexSpouseWarning.setSelected(false);
					rdBttnSameSexSpouseError.setSelected(false);
				break;

				case WARNING:
					rdBttnSameSexSpouseNone.setSelected(false);
					rdBttnSameSexSpouseWarning.setSelected(true);
					rdBttnSameSexSpouseError.setSelected(false);
				break;

				case ERROR:
					rdBttnSameSexSpouseNone.setSelected(false);
					rdBttnSameSexSpouseWarning.setSelected(false);
					rdBttnSameSexSpouseError.setSelected(true);
				break;
			}

			//
			switch (source.getFemaleFathersOrMaleMothers()) {
				case NONE:
					rdBttnFemaleFathersOrMaleMothersNone.setSelected(true);
					rdBttnFemaleFathersOrMaleMothersWarning.setSelected(false);
					rdBttnFemaleFathersOrMaleMothersError.setSelected(false);
				break;

				case WARNING:
					rdBttnFemaleFathersOrMaleMothersNone.setSelected(false);
					rdBttnFemaleFathersOrMaleMothersWarning.setSelected(true);
					rdBttnFemaleFathersOrMaleMothersError.setSelected(false);
				break;

				case ERROR:
					rdBttnFemaleFathersOrMaleMothersNone.setSelected(false);
					rdBttnFemaleFathersOrMaleMothersWarning.setSelected(false);
					rdBttnFemaleFathersOrMaleMothersError.setSelected(true);
				break;
			}

			//
			switch (source.getParentChildMarriages()) {
				case NONE:
					rdBttnParentChildMarriagesNone.setSelected(true);
					rdBttnParentChildMarriagesWarning.setSelected(false);
					rdBttnParentChildMarriagesError.setSelected(false);
				break;

				case WARNING:
					rdBttnParentChildMarriagesNone.setSelected(false);
					rdBttnParentChildMarriagesWarning.setSelected(true);
					rdBttnParentChildMarriagesError.setSelected(false);
				break;

				case ERROR:
					rdBttnParentChildMarriagesNone.setSelected(false);
					rdBttnParentChildMarriagesWarning.setSelected(false);
					rdBttnParentChildMarriagesError.setSelected(true);
				break;
			}
		}
	}
}
