package org.tip.puckgui.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

/**
 * 
 * @author TIP
 */
public class OpenRecentMenuItem extends JMenuItem {
	private static final long serialVersionUID = -6988304006803940278L;
	private NetGUI netGUI;
	private File file;

	/**
	 * 
	 * @param window
	 * @param netGUI
	 * @param file
	 */
	public OpenRecentMenuItem(final JFrame window, final NetGUI netGUI, final File file) {
		super();
		this.netGUI = netGUI;
		this.file = file;
		setText(file.getName());
		if (!file.exists()) {
			setEnabled(false);
		}

		this.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				//
				try {
					//
					if (netGUI.isBlank()) {
						netGUI.updateFile(file);
					} else {
						PuckGUI.instance().createNetGUI(file);
					}
				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(window, message, title, JOptionPane.ERROR_MESSAGE);
				} catch (final Exception exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message = "Error";

					//
					JOptionPane.showMessageDialog(window, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
	}
}
