package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.ChainValuator.ChainProperty;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class DifferentialCensusInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(DifferentialCensusInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private final ButtonGroup buttonGroupSymmetry = new ButtonGroup();
	private final ButtonGroup buttonGroupFiliation = new ButtonGroup();
	private final ButtonGroup buttonGroupSib = new ButtonGroup();
	private final ButtonGroup buttonGroupCircuit = new ButtonGroup();
	private JTextField txtfldPattern;
	private JTextField txtfldFilter;
	private JCheckBox chckbxCrossSex;
	private JCheckBox chckbxMarriedOnly;
	private final ButtonGroup buttonGroupRestriction = new ButtonGroup();
	private JRadioButton rdbtnCircuitTypeCircuit;
	private JRadioButton rdbtnCircuitTypeRing;
	private JRadioButton rdbtnCircuitTypeMinor;
	private JRadioButton rdbtnCircuitTypeMinimal;
	private JRadioButton rdbtnFiliationAgnatic;
	private JRadioButton rdbtnFiliationUterine;
	private JRadioButton rdbtnFiliationCognatic;
	private JRadioButton rdbtnFiliationBilateral;
	private JRadioButton rdbtnFiliationIdentity;
	private JRadioButton rdbtnSibNone;
	private JRadioButton rdbtnSibFull;
	private JRadioButton rdbtnSibAll;
	private JLabel lblRelationType;
	private JButton btnRestoreDefaults;
	private JComboBox cmbbxIndividualPartition;
	private JLabel lblChainClassification;
	private JComboBox cmbbxClassification;
	private JComboBox cmbbxClassificatoryLinking;

	/**
	 * Create the frame.
	 */
	public DifferentialCensusInputWindow(final NetGUI netGUI) {
		setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle("Differential Census Reporter Inputs");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 518, 512);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel panelInputs = new JPanel();
		contentPane.add(panelInputs, BorderLayout.CENTER);
		panelInputs.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC,
				FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel lblPattern = new JLabel("Pattern:");
		panelInputs.add(lblPattern, "4, 4, right, default");

		txtfldPattern = new JTextField();
		txtfldPattern.setColumns(10);
		panelInputs.add(txtfldPattern, "6, 4, fill, default");

		JLabel lblex = new JLabel("(ex. \"3 2 4\" ou \"HF(F)F\")");
		panelInputs.add(lblex, "6, 6");

		JLabel lblFilter = new JLabel("Filter:");
		panelInputs.add(lblFilter, "4, 8, right, default");

		txtfldFilter = new JTextField();
		txtfldFilter.setColumns(10);
		panelInputs.add(txtfldFilter, "6, 8, fill, default");

		JLabel lblClassificatoryLinking = new JLabel("Classificatory linking:");
		panelInputs.add(lblClassificatoryLinking, "4, 10, right, default");

		cmbbxClassificatoryLinking = new JComboBox();
		cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel(new String[] { "" }));
		panelInputs.add(cmbbxClassificatoryLinking, "6, 10, fill, default");

		lblRelationType = new JLabel("Individual partition:");
		panelInputs.add(lblRelationType, "4, 12, right, default");

		cmbbxIndividualPartition = new JComboBox();
		cmbbxIndividualPartition.setModel(new DefaultComboBoxModel(new String[] { "" }));
		panelInputs.add(cmbbxIndividualPartition, "6, 12, fill, default");

		lblChainClassification = new JLabel("Chain classification:");
		panelInputs.add(lblChainClassification, "4, 14, right, default");

		cmbbxClassification = new JComboBox();
		cmbbxClassification.setModel(new DefaultComboBoxModel(ChainProperty.values()));
		panelInputs.add(cmbbxClassification, "6, 14, fill, default");

		chckbxCrossSex = new JCheckBox("Cross-sex chains only");
		chckbxCrossSex.setSelected(true);
		panelInputs.add(chckbxCrossSex, "6, 16");

		chckbxMarriedOnly = new JCheckBox("Married only");
		chckbxMarriedOnly.setSelected(true);
		panelInputs.add(chckbxMarriedOnly, "6, 18");

		JPanel panel_1 = new JPanel();
		panelInputs.add(panel_1, "4, 20, 3, 1, fill, fill");
		panel_1.setLayout(new GridLayout(0, 3, 0, 0));

		JPanel panelCircuitType = new JPanel();
		panel_1.add(panelCircuitType);
		panelCircuitType.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Circuit Type", TitledBorder.LEADING, TitledBorder.TOP, null,
				new Color(51, 51, 51)));
		panelCircuitType.setLayout(new BoxLayout(panelCircuitType, BoxLayout.Y_AXIS));

		rdbtnCircuitTypeCircuit = new JRadioButton("Circuit");
		panelCircuitType.add(rdbtnCircuitTypeCircuit);
		rdbtnCircuitTypeCircuit.setSelected(true);
		buttonGroupCircuit.add(rdbtnCircuitTypeCircuit);

		rdbtnCircuitTypeRing = new JRadioButton("Ring");
		panelCircuitType.add(rdbtnCircuitTypeRing);
		buttonGroupCircuit.add(rdbtnCircuitTypeRing);

		rdbtnCircuitTypeMinor = new JRadioButton("Minor");
		panelCircuitType.add(rdbtnCircuitTypeMinor);
		buttonGroupCircuit.add(rdbtnCircuitTypeMinor);

		rdbtnCircuitTypeMinimal = new JRadioButton("Minimal");
		panelCircuitType.add(rdbtnCircuitTypeMinimal);
		buttonGroupCircuit.add(rdbtnCircuitTypeMinimal);

		JPanel panelFiliationType = new JPanel();
		panel_1.add(panelFiliationType);
		panelFiliationType.setBorder(new TitledBorder(null, "Filiation Type", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelFiliationType.setLayout(new BoxLayout(panelFiliationType, BoxLayout.Y_AXIS));

		rdbtnFiliationAgnatic = new JRadioButton("Agnatic");
		buttonGroupFiliation.add(rdbtnFiliationAgnatic);
		panelFiliationType.add(rdbtnFiliationAgnatic);

		rdbtnFiliationUterine = new JRadioButton("Uterine");
		buttonGroupFiliation.add(rdbtnFiliationUterine);
		panelFiliationType.add(rdbtnFiliationUterine);

		rdbtnFiliationCognatic = new JRadioButton("Cognatic");
		buttonGroupFiliation.add(rdbtnFiliationCognatic);
		rdbtnFiliationCognatic.setSelected(true);
		panelFiliationType.add(rdbtnFiliationCognatic);

		rdbtnFiliationBilateral = new JRadioButton("Bilateral");
		buttonGroupFiliation.add(rdbtnFiliationBilateral);
		panelFiliationType.add(rdbtnFiliationBilateral);

		rdbtnFiliationIdentity = new JRadioButton("Identity");
		buttonGroupFiliation.add(rdbtnFiliationIdentity);
		panelFiliationType.add(rdbtnFiliationIdentity);

		JPanel panelSiblingMode = new JPanel();
		panel_1.add(panelSiblingMode);
		panelSiblingMode.setBorder(new TitledBorder(null, "Sibling Mode", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelSiblingMode.setLayout(new BoxLayout(panelSiblingMode, BoxLayout.Y_AXIS));

		rdbtnSibNone = new JRadioButton("None");
		rdbtnSibNone.setToolTipText("No siblings assimilated.");
		panelSiblingMode.add(rdbtnSibNone);
		buttonGroupSib.add(rdbtnSibNone);

		rdbtnSibFull = new JRadioButton("Full");
		rdbtnSibFull.setToolTipText("Full siblings assimilated.");
		panelSiblingMode.add(rdbtnSibFull);
		rdbtnSibFull.setSelected(true);
		buttonGroupSib.add(rdbtnSibFull);

		rdbtnSibAll = new JRadioButton("All");
		rdbtnSibAll.setToolTipText("All siblings assimilated.");
		panelSiblingMode.add(rdbtnSibAll);
		buttonGroupSib.add(rdbtnSibAll);

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});

		btnRestoreDefaults = new JButton("Restore Defaults");
		btnRestoreDefaults.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Restore Defaults.
				setCriteria(new CensusCriteria());
			}
		});
		buttonPanel.add(btnRestoreDefaults);
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					CensusCriteria criteria = getCriteria();

					//
					PuckGUI.instance().getPreferences().setDifferentialCensusCriteria(criteria);

					//
					Report report = CensusReporter.reportDifferentialCensus(netGUI.getSegmentation(), criteria);
					// Report report =
					// CensusReporter.reportFindCircuit(netGUI.getNet(),
					// criteria);

					netGUI.addReportTab(report);

					dispose();

				} catch (final PuckException exception) {
					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		// /////////////////
		setCriteria(PuckGUI.instance().getPreferences().getDifferentialCensusCriteria());
	}

	/**
	 * 
	 * @return
	 */
	public CensusCriteria getCriteria() {
		CensusCriteria result;

		//
		result = new CensusCriteria();

		//
		result.setClosingRelation("TOTAL");

		//
		result.setPattern(txtfldPattern.getText());
		result.setFilter(txtfldFilter.getText());
		result.setClassificatoryLinking((String) cmbbxClassificatoryLinking.getSelectedItem());
		result.setIndividualPartitionLabel((String) cmbbxIndividualPartition.getSelectedItem());
		result.setChainClassification((String) cmbbxClassification.getSelectedItem());
		result.setCrossSexChainsOnly(chckbxCrossSex.isSelected());
		result.setMarriedOnly(chckbxMarriedOnly.isSelected());

		//
		CircuitType circuitType;
		if (rdbtnCircuitTypeCircuit.isSelected()) {
			circuitType = CircuitType.CIRCUIT;
		} else if (rdbtnCircuitTypeMinimal.isSelected()) {
			circuitType = CircuitType.MINIMAL;
		} else if (rdbtnCircuitTypeMinor.isSelected()) {
			circuitType = CircuitType.MINOR;
		} else if (rdbtnCircuitTypeRing.isSelected()) {
			circuitType = CircuitType.RING;
		} else {
			circuitType = null;
		}
		result.setCircuitType(circuitType);

		//
		FiliationType filiationType;
		if (rdbtnFiliationAgnatic.isSelected()) {
			filiationType = FiliationType.AGNATIC;
		} else if (rdbtnFiliationBilateral.isSelected()) {
			filiationType = FiliationType.BILINEAR;
		} else if (rdbtnFiliationCognatic.isSelected()) {
			filiationType = FiliationType.COGNATIC;
		} else if (rdbtnFiliationIdentity.isSelected()) {
			filiationType = FiliationType.IDENTITY;
		} else if (rdbtnFiliationUterine.isSelected()) {
			filiationType = FiliationType.UTERINE;
		} else {
			filiationType = null;
		}
		result.setFiliationType(filiationType);

		//
		result.setRestrictionType(RestrictionType.ALL);

		//
		SiblingMode siblingMode;
		if (rdbtnSibAll.isSelected()) {
			siblingMode = SiblingMode.ALL;
		} else if (rdbtnSibFull.isSelected()) {
			siblingMode = SiblingMode.FULL;
		} else if (rdbtnSibNone.isSelected()) {
			siblingMode = SiblingMode.NONE;
		} else {
			siblingMode = null;
		}
		result.setSiblingMode(siblingMode);

		//
		result.setSymmetryType(SymmetryType.INVERTIBLE);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public void setCriteria(final CensusCriteria source) {
		//
		if (source != null) {
			//
			txtfldPattern.setText(source.getPattern());
			txtfldFilter.setText(source.getFilter());

			//
			List<String> exogenousLabels = new ArrayList<String>(20);
			exogenousLabels.add("");
			exogenousLabels.addAll(IndividualValuator.getExogenousAttributeLabels(netGUI.getCurrentIndividuals()));

			cmbbxClassificatoryLinking.setModel(new DefaultComboBoxModel(exogenousLabels.toArray()));

			if (StringUtils.isBlank(source.getClassificatoryLinking())) {
				cmbbxClassificatoryLinking.setSelectedIndex(0);
			} else {
				int classificatoryLinkingLabelIndex = exogenousLabels.indexOf(source.getClassificatoryLinking());
				if (classificatoryLinkingLabelIndex == -1) {
					cmbbxClassificatoryLinking.setSelectedIndex(0);
				} else {
					cmbbxClassificatoryLinking.setSelectedIndex(classificatoryLinkingLabelIndex);
				}
			}

			//
			cmbbxIndividualPartition.setModel(new DefaultComboBoxModel(exogenousLabels.toArray()));
			if (StringUtils.isBlank(source.getIndividualPartitionLabel())) {
				cmbbxIndividualPartition.setSelectedIndex(0);
			} else if (exogenousLabels.contains(source.getIndividualPartitionLabel())) {
				cmbbxIndividualPartition.setSelectedIndex(exogenousLabels.indexOf(source.getIndividualPartitionLabel()));
			} else {
				exogenousLabels.add(0, source.getIndividualPartitionLabel());
				cmbbxIndividualPartition.setSelectedIndex(0);
			}

			//
			List<String> chainClassificationLabels = new ArrayList<String>();
			for (ChainProperty label : ChainProperty.values()) {
				chainClassificationLabels.add(label.toString());
			}
			Collections.sort(chainClassificationLabels);
			cmbbxClassification.setModel(new DefaultComboBoxModel(chainClassificationLabels.toArray()));

			int chainClassificationLabelIndex;
			if (StringUtils.isBlank(source.getChainClassification())) {
				chainClassificationLabelIndex = chainClassificationLabels.indexOf("SIMPLE");
			} else {
				chainClassificationLabelIndex = chainClassificationLabels.indexOf(source.getChainClassification());
				if (chainClassificationLabelIndex == -1) {
					chainClassificationLabelIndex = chainClassificationLabels.indexOf("SIMPLE");
				}
			}
			cmbbxClassification.setSelectedIndex(chainClassificationLabelIndex);

			//
			chckbxCrossSex.setSelected(source.isCrossSexChainsOnly());
			chckbxMarriedOnly.setSelected(source.isCouplesOnly());

			//
			rdbtnCircuitTypeCircuit.setSelected(false);
			rdbtnCircuitTypeMinimal.setSelected(false);
			rdbtnCircuitTypeMinor.setSelected(false);
			rdbtnCircuitTypeRing.setSelected(false);
			switch (source.getCircuitType()) {
				case CIRCUIT:
					rdbtnCircuitTypeCircuit.setSelected(true);
				break;
				case MINIMAL:
					rdbtnCircuitTypeMinimal.setSelected(true);
				break;
				case MINOR:
					rdbtnCircuitTypeMinor.setSelected(true);
				break;
				case RING:
					rdbtnCircuitTypeRing.setSelected(true);
				break;
			}

			//
			rdbtnFiliationAgnatic.setSelected(false);
			rdbtnFiliationBilateral.setSelected(false);
			rdbtnFiliationCognatic.setSelected(false);
			rdbtnFiliationIdentity.setSelected(false);
			rdbtnFiliationUterine.setSelected(false);
			switch (source.getFiliationType()) {
				case AGNATIC:
					rdbtnFiliationAgnatic.setSelected(true);
				break;
				case BILINEAR:
					rdbtnFiliationBilateral.setSelected(true);
				break;
				case COGNATIC:
					rdbtnFiliationCognatic.setSelected(true);
				break;
				case IDENTITY:
					rdbtnFiliationIdentity.setSelected(true);
				break;
				case UTERINE:
					rdbtnFiliationUterine.setSelected(true);
				break;
			}

			//
			rdbtnSibAll.setSelected(false);
			rdbtnSibFull.setSelected(false);
			rdbtnSibNone.setSelected(false);
			switch (source.getSiblingMode()) {
				case ALL:
					rdbtnSibAll.setSelected(true);
				break;
				case FULL:
					rdbtnSibFull.setSelected(true);
				break;
				case NONE:
					rdbtnSibNone.setSelected(true);
				break;
			}
		}
	}
}
