package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.clusternetworks.ClusterNetworkUtils;
import org.tip.puck.clusternetworks.ClusterNetworkUtils.LineType;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class AllianceNetworkInputWindow extends JFrame {

	static private final Logger logger = LoggerFactory.getLogger(AllianceNetworkInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private static String lastLabel;
	private static int lastMinimalValue = 0;
	private static boolean lastWeightedArcs = true;
	private static int lastMinimalArcWeight = 0;
	private JComboBox cmbBxLabel;
	private JComboBox comboBoxType;
	private JSpinner spinnerMinimalNumberOfLinks;
	private JCheckBox chckbxWeightedArcs;
	private JSpinner spinnerMinimalArcWeight;

	/**
	 * Create the frame.
	 */
	public AllianceNetworkInputWindow(final NetGUI netGUI) {
		//
		List<String> availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());

		//
		if (lastLabel == null) {
			availableLabels.add(0, "");
		} else {
			availableLabels.add(0, lastLabel);
		}

		// /////////////////////////////////
		setIconImage(Toolkit.getDefaultToolkit().getImage(AllianceNetworkInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle("Alliance Network Inputs");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 365, 290);
		setLocationRelativeTo(null);

		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new BorderLayout(0, 0));

		JPanel panel = new JPanel();
		contentPane.add(panel, BorderLayout.CENTER);
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));

		JLabel label = new JLabel("Label:");
		panel.add(label, "2, 4, right, default");

		cmbBxLabel = new JComboBox(availableLabels.toArray());
		cmbBxLabel.setSelectedIndex(0);
		cmbBxLabel.setMaximumRowCount(12);
		cmbBxLabel.setEditable(true);
		panel.add(cmbBxLabel, "4, 4, fill, default");

		JLabel lblMinimalNumberOf = new JLabel("<html><div style=\"text-align:right\">Minimal number:<br/>of links</div></html>");
		panel.add(lblMinimalNumberOf, "2, 6, center, default");

		spinnerMinimalNumberOfLinks = new JSpinner();
		spinnerMinimalNumberOfLinks.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
		panel.add(spinnerMinimalNumberOfLinks, "4, 6");

		JPanel buttonPanel = new JPanel();
		contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					String label = (String) cmbBxLabel.getSelectedItem();
					String type = (String) comboBoxType.getSelectedItem();
					int minimalNumberOfLinks = (Integer) spinnerMinimalNumberOfLinks.getValue();
					LineType lineType;
					if (chckbxWeightedArcs.isSelected()) {
						lineType = LineType.WEIGHTED_ARC;
					} else {
						lineType = LineType.SIMPLE_ARC;
					}
					int minimalArcWeight = (Integer) spinnerMinimalArcWeight.getValue();

					//
					lastLabel = label;
					lastMinimalValue = minimalNumberOfLinks;
					lastWeightedArcs = chckbxWeightedArcs.isSelected();
					lastMinimalArcWeight = minimalArcWeight;

					//
					if (label == null) {
						//
						String title = "Bad input";
						String message = "Please, enter none empty input.";

						//
						JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						//
						Graph<Cluster<Individual>> graph = null;
						if (type.equals("Wife-Husband")) {
							graph = ClusterNetworkUtils.createAllianceNetwork(netGUI.getSegmentation(), label, lineType);
						} else if (type.equals("Sister-Brother")) {
							graph = ClusterNetworkUtils.createSiblingNetwork(netGUI.getSegmentation(), label, lineType);
						}
						graph = GraphUtils.reduce(graph, minimalNumberOfLinks, minimalArcWeight);

						//
						graph.attributes().put("Label", label);
						graph.attributes().put("Minimal number of links", String.valueOf(minimalNumberOfLinks));
						graph.attributes().put("Arc Type", type);
						graph.attributes().put("Weighted Arcs", String.valueOf(chckbxWeightedArcs.isSelected()));
						graph.attributes().put("Minimal Arc Weight (marriages)", String.valueOf(minimalArcWeight));

						//
						PuckGUI.instance().createGroupNetGUI(graph);

						//
						dispose();
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JButton btnLaunchold = new JButton("Statistics");
		btnLaunchold.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Old Launch.
				try {
					//
					String parameter = (String) cmbBxLabel.getSelectedItem();
					String type = (String) comboBoxType.getSelectedItem();
					int minimalNumberOfLinks = (Integer) spinnerMinimalNumberOfLinks.getValue();
					LineType lineType;
					if (chckbxWeightedArcs.isSelected()) {
						lineType = LineType.WEIGHTED_ARC;
					} else {
						lineType = LineType.SIMPLE_ARC;
					}
					int minimalArcWeight = (Integer) spinnerMinimalArcWeight.getValue();

					//
					lastLabel = parameter;
					lastMinimalValue = minimalNumberOfLinks;
					lastWeightedArcs = chckbxWeightedArcs.isSelected();
					lastMinimalArcWeight = minimalArcWeight;

					//
					if (parameter == null) {
						//
						String title = "Bad input";
						String message = "Please, enter none empty input.";

						//
						JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						Report report = ClusterNetworkReporter.reportAllianceNetwork(netGUI.getSegmentation(), netGUI.getFile(), parameter, lineType,
								minimalNumberOfLinks, type, minimalArcWeight);
						netGUI.addReportTab(report);
						dispose();
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunchold);
		buttonPanel.add(btnLaunch);

		// ///////////////////
		//
		spinnerMinimalNumberOfLinks.setValue(lastMinimalValue);

		JLabel lblLink = new JLabel("Arc Type:");
		panel.add(lblLink, "2, 8, right, default");

		comboBoxType = new JComboBox(new Object[] { "Wife-Husband", "Sister-Brother" });
		comboBoxType.setSelectedIndex(0);
		comboBoxType.setMaximumRowCount(12);
		comboBoxType.setEditable(true);
		panel.add(comboBoxType, "4, 8, fill, default");

		chckbxWeightedArcs = new JCheckBox("Weighted Arcs");
		chckbxWeightedArcs.setSelected(true);
		panel.add(chckbxWeightedArcs, "4, 10");

		//
		chckbxWeightedArcs.setSelected(lastWeightedArcs);

		JLabel lblMinimalArcWeight = new JLabel("<html><div style=\"text-align:right\">Minimal arc:<br/>weight (marr.)</div></html>");
		panel.add(lblMinimalArcWeight, "2, 12, right, default");

		spinnerMinimalArcWeight = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
		panel.add(spinnerMinimalArcWeight, "4, 12");
		spinnerMinimalArcWeight.setValue(lastMinimalArcWeight);
	}
}
