package org.tip.puck.net.relations;

/**
 * 
 * @author TIP
 */
public class Role {

	private String name;
	private int defaultCardinality;

	/**
	 * 
	 * @param role
	 */
	public Role(final Role role) {
		if (role == null) {
			this.name = "";
			this.defaultCardinality = 0;
		} else {
			this.name = role.getName();
			this.defaultCardinality = role.getDefaultCardinality();
		}
	}

	/**
	 * 
	 * @param name
	 * @param defaultCardinality
	 */
	public Role(final String name) {
		this.name = name;
		this.defaultCardinality = 0;
	}

	/**
	 * 
	 * @param name
	 * @param defaultCardinality
	 */
	public Role(final String name, final int defaultCardinality) {
		this.name = name;
		this.defaultCardinality = defaultCardinality;
	}

	public int getDefaultCardinality() {
		return defaultCardinality;
	}

	public String getName() {
		return name;
	}

	public void setDefaultCardinality(final int defaultCardinality) {
		this.defaultCardinality = defaultCardinality;
	}

	public void setName(final String name) {
		this.name = name;
	}
}
