package org.tip.puck.net;

import java.util.HashMap;
import java.util.Map;

import oldcore.calc.partitions.Clusterable;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedIntegers;

/**
 * 
 * 
 * @author TIP
 */
public class Individual implements Comparable<Individual>, Numberable, Clusterable {

	private int id;
	private Gender gender;
	private String name;
	private Family originFamily;
	private final Families personalFamilies;
	private final Attributes attributes;
	private final Relations relations2;
	private Map<String, Individuals> relations;

	/**
	 * 
	 */
	public Individual(final int id) {
		this.id = id;
		this.gender = Gender.UNKNOWN;
		this.personalFamilies = new Families();
		this.relations2 = new Relations();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 */
	public Individual(final int id, final String name, final Gender gender) {
		this.id = id;
		this.setName(name);
		if (gender == null) {
			this.gender = Gender.UNKNOWN;
		} else {
			this.gender = gender;
		}
		this.personalFamilies = new Families();
		this.relations2 = new Relations();
		this.attributes = new Attributes();
	}

	/**
	 * 
	 * @param family
	 */
	public void addPersonalFamily(final Family family) {
		personalFamilies.add(family);
	}

	/**
	 * 
	 * @param label
	 * @param alter
	 */
	public void addRelation(final String label, final Individual alter) {
		if (relations == null) {
			relations = new HashMap<String, Individuals>();
		}
		if (relations.get(label) == null) {
			relations.put(label, new Individuals());
		}
		relations.get(label).add(alter);
	}

	/**
	 * 
	 * @param other
	 */
	public void adjust(final Individual other) {

		this.name = other.getName();
		this.gender = other.getGender();
		for (Attribute attribute : other.attributes().values()) {
			this.attributes.put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
		}

	}

	public Attributes attributes() {
		return attributes;
	}

	/**
	 * 
	 */
	@Override
	public Individual clone() {
		Individual result;

		result = new Individual(id, name, gender);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual cloneWithAttributes() {
		Individual result;

		result = new Individual(id, name, gender);

		for (Attribute attribute : this.attributes().values()) {
			result.attributes().put(attribute.getLabel(), new Attribute(attribute.getLabel(), attribute.getValue()));
		}

		//
		return result;
	}

	@Override
	public int compareTo(final Individual other) {
		int result;

		if (other == null) {
			result = 1;
		} else {
			result = new Integer(getId()).compareTo(other.getId());
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int depth() {
		int result;

		result = StatisticsWorker.depth(this, new NumberedIntegers(1000), FiliationType.COGNATIC);

		//
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		boolean result;

		result = obj != null && getId() == ((Individual) obj).getId();

		//
		return result;
	}
	
	public Individuals firstCousins (Gender parentGender, FiliationType filiation, boolean cross){
		Individuals result;
		
		result = new Individuals();
		
		Individual parent = getParent(parentGender);
		if (parent!=null) {
			for (Individual auntOrUncle : parent.siblings(filiation)){
				if ((auntOrUncle.getGender() != parentGender == cross) || !auntOrUncle.isSterile()) {
					for (Individual cousin : auntOrUncle.getChildren()){
						result.add(cousin);
					}
				}
			}
		}
		//
		return result;
	}	

	public Individuals firstCousins() {
		Individuals result;

		result = new Individuals();
		for (Individual parent : getParents()) {
			for (Individual auntOrUncle : parent.siblings()) {
				for (Individual cousin : auntOrUncle.getChildren()) {
					result.add(cousin);
				}
			}
		}

		//
		return result;
	}
	
	public Individuals  bilateralCousins (FiliationType filiation, boolean cross){
		Individuals result; 
		
		result = new Individuals();
		for (Individual paternal : firstCousins(Gender.MALE,filiation,cross)){
			for (Individual maternal: firstCousins(Gender.FEMALE,filiation,cross)){
				if (paternal.equals(maternal)) {
					result.add(paternal);
				}
			}
		}
		//
		return result;
	}
	
	public Individuals doubleCrossCousins (Gender gender, FiliationType filiation){
		Individuals result; 
		
		result = new Individuals();
		for (Individual cousin : firstCousins(gender.invert(),FiliationType.COGNATIC,true)){
				Individual otherGrandParent = getParent(gender.invert()).getParent(filiation);
				Individual cousinsOtherGrandParent = cousin.getParent(gender).getParent(filiation);
				for (Individual grandOblique : otherGrandParent.siblings(FiliationType.COGNATIC)){
					if (grandOblique.equals(cousinsOtherGrandParent)) {
						result.add(cousin);
					}
				}
		}
		//
		return result;
	}
	
	public Individuals obliqueCousins (Gender gender){
		Individuals result; 
		
		result = new Individuals();
		for (Individual crossCousin : firstCousins(gender.invert(),FiliationType.COGNATIC,true)){
			for (Individual oblique: obliques(gender,gender.invert(),FiliationType.COGNATIC)){
				if (crossCousin.equals(oblique) && !result.contains(crossCousin)) {
					result.add(crossCousin);
				}
			}
			if (crossCousin.equals(getParent(gender)) && !result.contains(crossCousin)) {
				result.add(crossCousin);
			}
		}
		//
		return result;
	}	
	
	
	/**
	 * gets the nephews and nieces
	 */
	public Individuals obliques (FiliationType filiation){
		Individuals result; 
		
		result = new Individuals();
		for (Individual sibling : siblings(filiation)){
			if (sibling.hasLinkingGender(filiation)) {
				for (Individual auntOrUncle : sibling.getChildren()){
					result.add(auntOrUncle);
				}
			}
		}
		//
		return result;
	}

	/**
	 * gets the uncles and aunts (parents' siblings) of a vertex
	 * @param parentGender the gender of the linking parent (0 = F, 1 = M)
	 * @param alterGender the gender of alter
	 * @param filiation the character of the sibling relation (0=agnatic, 1=uterine, 2=indifferent)
	 * @return the list of uncles and aunts
	 */
	public Individuals obliques (Gender parentGender, Gender alterGender, FiliationType filiation){
		Individuals result; 
		
		result = new Individuals();
		Individual parent = getParent(parentGender);
		if (parent!=null) {
			for (Individual auntOrUncle : parent.siblings(filiation)){
				if (auntOrUncle.getGender()!=alterGender) {
					result.add(auntOrUncle);
				}
			}
		}
		//
		return result;
	}	


	public Individuals fullSameSexSiblings() {
		Individuals result;

		result = this.originFamily.getChildren(getGender());
		result.removeById(getId());

		//
		return result;
	}

	/**
	 * FIXME TO BE COMMENTED
	 * 
	 * @return
	 */
	public Individuals fullSiblings() {
		Individuals result;

		result = this.originFamily.getChildren();
		result.removeById(getId());

		//
		return result;
	}
	
	/**
	 * gets the siblings that are at the same time cousins
	 */
	public Individuals siblingCousins (FiliationType filiation){
		Individuals result; 
		
		result = new Individuals();

		FiliationType otherFiliation = filiation.invert();
		
		Individual otherParent = getParent(otherFiliation);
		if (otherParent!=null){
			for (Individual sibling : siblings(filiation)){
				Individual stepParent = sibling.getParent(otherFiliation);
				if (otherParent.siblings(filiation).contains(stepParent)) {
					result.add(sibling);
				}
			}
		}
		//
		return result;
   }
	
	public Individuals getInlaws (FiliationType filiation){
		Individuals result; 
		
		result = new Individuals();
		for (Individual sibling : siblings(filiation)){
			if (!sibling.hasLinkingGender(filiation)) {
				for (Individual inLaw : sibling.getSpouses()){
					result.add(inLaw);
				}
			}
		}
		for (Individual spouse : getSpouses()){
			for (Individual inLaw : spouse.siblings(filiation)){
				result.add(inLaw);
			}
		}
		return result;
	}	



	/**
	 * 
	 */
	@Override
	public String getAttributeValue(final String label) {
		String result;

		result = this.attributes.getValue(label);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individuals getChildren() {
		Individuals result;

		result = personalFamilies.children();

		//
		return result;
	}

	public Individuals coSpouses() {
		Individuals result;

		//
		result = new Individuals();

		for (Individual spouse : getSpouses()) {
			for (Individual coSpouse : spouse.getSpouses()) {
				if (coSpouse != this) {
					result.add(coSpouse);
				}
			}
		}
		//
		return result;

	}
	
	public Individuals crossSexCousins(final FiliationType type) {
		Individuals result;

		result = new Individuals();

		for (Individual parent : getParents()) {
			if (parent.hasLinkingGender(type)) {
				for (Individual grandparent : parent.getParents()) {
					if (grandparent.hasLinkingGender(type) && !grandparent.isSterile()) {
						for (Individual oblique : grandparent.getChildren()) {
							if (oblique.hasLinkingGender(type) && oblique != parent && !oblique.isSterile()) {
								for (Individual cousin : oblique.getChildren()) {
									if (cousin.getGender() != getGender()) {
										result.put(cousin);
									}
								}
							}
						}
					}
				}
			}
		}
		//
		return result;

	}

	/**
	 * 
	 * @return
	 */
	public Individual getFather() {
		Individual result;

		if (this.originFamily == null) {
			result = null;
		} else {
			result = this.originFamily.getFather();
		}

		//
		return result;
	}

	/**
	 * 
	 * @param name
	 */
	public String getFirstName() {
		String result;

		if (this.name == null) {
			result = null;
		} else {
			int slashIndex = this.name.indexOf('/');
			if (slashIndex == -1) {
				result = this.name.trim();
			} else {
				result = this.name.substring(0, slashIndex).trim();
			}
		}

		//
		return result;
	}

	/**
	 * 
	 */
	public Gender getGender() {
		Gender result;

		result = this.gender;

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getId() {
		int result;

		result = this.id;

		//
		return result;
	}

	/**
	 * FIXME TO BE REWROTE
	 * 
	 * @deprecated
	 * @param key
	 * @return
	 */
	@Deprecated
	public Individuals getKin(final int key) {
		Individuals result;

		switch (key) {
			case -1:
				result = getChildren();
			break;
			case 0:
				result = getSpouses();
			break;
			case 1:
				result = getParents();
			break;
			default:
				result = null;
		}

		//
		return result;
	}
	
	public Individuals getKin(){
		Individuals result;
		
		result = new Individuals();
		
		for (KinType type : KinType.basicTypes()){
			result.add(getKin(type));
		}
		
		//
		return result;
	}
	
	public Individual getKin(final KinType type, Sorting sorting, final int order){
		Individual result;
		
		result = null;
		Individuals kin = getKin(type);
		if (order<=kin.size()){
			result = kin.toSortedList(sorting).get(order-1);
		}
		
		//
		return result;
	}

	/**
	 * 
	 * @param type
	 * @return
	 */
	public Individuals getKin(final KinType type) {
		Individuals result;

		switch (type) {
			case CHILD:
				result = getChildren();
			break;
			case SPOUSE:
				result = getSpouses();
			break;
			case PARENT:
				result = getParents();
			break;
			default:
				result = new Individuals();
		}

		//
		return result;
	}

	/**
	 * 
	 * @param name
	 */
	public String getLastName() {
		String result;

		if (this.name == null) {
			result = null;
		} else {
			int slashIndex = this.name.indexOf('/');
			if (slashIndex == -1) {
				result = null;
			} else {
				result = this.name.substring(slashIndex + 1).replaceAll("/", " ").trim();
				if (result.length() == 0) {
					result = null;
				}
			}
		}

		//
		return result;
	}

	public Individuals getMarriedSpouses() {
		Individuals result;

		result = this.personalFamilies.marriedSpouses(this);

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individual getMother() {
		Individual result;

		if (this.originFamily == null) {
			result = null;
		} else {
			result = this.originFamily.getMother();
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */

	public String getName() {
		String result;

		result = this.name;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */

	public Family getOriginFamily() {
		return originFamily;
	}

	/**
	 * 
	 * @param parent
	 * @return
	 */
	public Individual getOtherParent(final Individual parent) {
		Individual result;

		if (this.originFamily == null) {
			result = null;
		} else {
			result = this.originFamily.getOtherParent(parent);
		}

		//
		return result;
	}
	
	public Individual getParent (final Gender gender){
		Individual result = null;

		switch (gender) {
			case MALE:
				result = getFather();
				break;
			case FEMALE:
				result = getMother();
				break;
		}
		//
		return result;
	}
	
	public Individual getParent (final FiliationType filiation){
		Individual result = null;

		switch (filiation) {
			case AGNATIC:
				result = getFather();
				break;
			case UTERINE:
				result = getMother();
				break;
		}
		//
		return result;
	}


	@Deprecated
	public Individual getParent(final int key) {
		Individual result = null;

		switch (key) {
			case 0:
				result = getFather();
			case 1:
				result = getMother();
		}
		//
		return result;

	}

	/**
	 * 
	 * @return
	 */
	public Individuals getParents() {
		Individuals result;

		result = new Individuals();
		if (this.originFamily != null) {
			if (this.originFamily.getHusband() != null) {
				result.add(this.originFamily.getHusband());
			}
			if (this.originFamily.getWife() != null) {
				result.add(this.originFamily.getWife());
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Individuals getParents(final FiliationType line) {
		Individuals result;

		result = new Individuals();
		if (this.originFamily != null) {
			if (line.hasLinkingGender(Gender.MALE) && this.originFamily.getHusband() != null) {
				result.add(this.originFamily.getHusband());
			}
			if (line.hasLinkingGender(Gender.FEMALE) && this.originFamily.getWife() != null) {
				result.add(this.originFamily.getWife());
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param spouse
	 * @return
	 */
	public Individuals getPartners() {
		Individuals result;

		result = this.personalFamilies.getPartners(this);

		//
		return result;
	}
	
	public Families getPersonalFamilies() {
		return personalFamilies;
	}
	
	/**
	 * 
	 * @return
	 */
	public Individuals getSpouses() {
		Individuals result;

		result = getUnions(true).getPartners(this);

		//
		return result;
	}

	public String getTrimmedName() {
		String result;

		if (this.name == null) {
			result = null;
		} else {
			result = this.name.trim();
		}
		//
		return result;
	}

	public Families getUnions(final boolean married) {
		Families result;

		result = new Families();
		for (Family family : this.personalFamilies) {
			if (family.isMarried() || !married) {
				result.add(family);
			}
		}
		return result;
	}
	
	@Override
	public String hashKey() {
		return id + "";
	}

	public boolean hasLinkingGender(final FiliationType type) {
		boolean result;

		switch (type) {
			case COGNATIC:
				result = true;
			break;
			case AGNATIC:
				result = isMale();
			break;
			case UTERINE:
				result = isFemale();
			break;
			default:
				result = false;
		}
		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int height() {
		int result;

		result = height(new NumberedIntegers(1000));
		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int height(final NumberedIntegers depthData) {
		int result;

		Individuals children = this.getChildren();
		if (children.size() == 0) {
			result = 0;
		} else {
			// Calculate the max of children depth.
			result = 0;
			for (Individual child : children) {
				Integer childDepth = depthData.get(child.getId());
				if (childDepth == null) {
					childDepth = child.height(depthData);
					depthData.put(child.getId(), childDepth);
				}

				result = Math.max(result, childDepth);
			}

			//
			result += 1;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isFemale() {
		boolean result;

		result = this.gender.isFemale();

		//
		return result;
	}

	/**
	 * Checks whether the individual is with children
	 * 
	 * @return true if the individual has no children, false otherwise.
	 */
	public boolean isFertile() {
		boolean result;

		result = this.personalFamilies.containsChild();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isHalfOrphan() {
		boolean result;

		if ((this.originFamily == null) || ((this.originFamily.getHusband() != null) && (this.originFamily.getWife() != null))) {
			result = false;
		} else {
			result = true;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isMale() {
		boolean result;

		result = this.gender.isMale();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isNotOrphan() {
		boolean result;

		result = !isOrphan();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isNotOrphanOfFather() {
		boolean result;

		result = !isOrphanOfFather();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isNotOrphanOfMother() {
		boolean result;

		result = !isOrphanOfMother();

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public boolean isNotPartnerWith(final Individual source) {
		boolean result;

		result = !isPartnerWith(source);

		//
		return result;
	}

	/**
	 * Checks whether the individual is single.
	 * 
	 * @return true if the individual has no spouses, false otherwise.
	 */
	public boolean isNotSingle() {
		boolean result;

		result = !isSingle();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isOrphan() {
		boolean result;

		if ((this.originFamily == null) || this.originFamily.isOrphan()) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isOrphanOfFather() {
		boolean result;

		if ((this.originFamily == null) || ((this.originFamily.getFather() == null) && (this.originFamily.getMother() != null))) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isOrphanOfMother() {
		boolean result;

		if ((this.originFamily == null) || ((this.originFamily.getFather() != null) && (this.originFamily.getMother() == null))) {
			result = true;
		} else {
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isParent(final Individual parent) {
		boolean result;

		if ((this.originFamily == null)) {
			result = false;
		} else {
			result = this.originFamily.isParent(parent);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public boolean isPartnerWith(final Individual source) {
		boolean result;

		//
		Family target = this.personalFamilies.getBySpouses(this, source);

		//
		if (target == null) {
			result = false;
		} else {
			result = true;
		}

		//
		return result;
	}

	/**
	 * Checks whether the individual is single.
	 * 
	 * @return true if the individual has no spouses, false otherwise.
	 */
	public boolean isSingle() {
		boolean result;

		result = this.getUnions(true).size() == 0;

		//
		return result;
	}

	/**
	 * Checks whether the individual is single.
	 * 
	 * @return true if the individual has no spouses, false otherwise.
	 */
	public boolean isSingle(final String relationType) {
		boolean result;

		if (relationType.equals("SPOUSE")) {
			result = this.getUnions(true).size() == 0;
		} else {
			result = this.getUnions(false).size() == 0;
		}

		//
		return result;
	}

	/**
	 * Checks whether the individual is without children
	 * 
	 * @return true if the individual has no children, false otherwise.
	 */
	public boolean isSterile() {
		boolean result;

		result = !this.personalFamilies.containsChild();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isUnknown() {
		boolean result;

		result = this.gender.isUnknown();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Relations relations() {
		Relations result;

		result = this.relations2;

		//
		return result;
	}

	@Override
	public void setAttribute(final Attribute attribute) {
		// TODO Auto-generated method stub

	}

	public void setAttribute(final String label, final String value) {
		attributes.put(label, value);
	}

	/**
	 * By default, name is first name.
	 * 
	 * @param value
	 */
	public void setFirstName(final String value) {

		setName(value, this.getLastName());
	}

	/**
	 * 
	 * @param value
	 */
	public void setGender(final Gender value) {
		if (value == null) {
			this.gender = Gender.UNKNOWN;
		} else {
			this.gender = value;
		}
	}

	/**
	 * 
	 */
	@Override
	public void setId(final int id) {
		this.id = id;
	}

	/**
	 * By default, name is first name.
	 * 
	 * @param value
	 */
	public void setLastName(final String value) {

		setName(this.getFirstName(), value);
	}

	/**
	 * 
	 * @param name
	 */
	public void setName(final String name) {
		if (name == null) {
			this.name = null;
		} else {
			this.name = name.trim();
		}
	}

	/**
	 * By default, name is first name.
	 * 
	 * @param value
	 */
	public void setName(final String firstName, final String lastName) {

		//
		String newName;
		if (firstName == null) {
			if (StringUtils.isBlank(lastName)) {
				newName = "";
			} else {
				newName = "/" + lastName.trim();
			}
		} else {
			if (StringUtils.isBlank(lastName)) {
				newName = firstName.trim();
			} else {
				newName = firstName.trim() + "/" + lastName.trim();
			}
		}

		//
		this.name = newName;
	}

	/**
	 * 
	 * @param sourceFamily
	 */
	public void setOriginFamily(final Family family) {
		this.originFamily = family;
	}

	public Individuals siblings() {
		Individuals result;

		result = new Individuals();
		for (Individual parent : getParents()) {
			for (Individual sibling : parent.getChildren()) {
				result.add(sibling);
			}
		}
		//
		return result;
	}
	
	public Individuals siblings (FiliationType filiation){
		Individuals result;
		
		result = new Individuals();
		for (Individual parent : getParents()) {
			if (parent.hasLinkingGender(filiation)){
				for (Individual sibling : parent.getChildren()) {
					if (sibling!=this){
						result.add(sibling);
					}
				}
			}
		}
		//
		return result;
	}


	public String signature() {
		String result;

		result = id + " " + name;

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public String toString() {
		String result;

		result = this.name + " (" + this.id + ")";

		// result = String.format("[id=%d,name=%s]", this.id, this.name);

		//
		return result;
	}

}
