package org.tip.puck.io.txt;

import java.io.BufferedReader;
import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.txt1.TXT1File;
import org.tip.puck.io.txt3.TXT3File;
import org.tip.puck.net.Net;

/**
 * This class represents a TXT File reader and writer.
 * 
 * @author Klaus Hamberger
 * @author TIP
 */
public class TXTFile {

	public enum Version {
		V1,
		V2,
		V3
	}

	static private final Logger logger = LoggerFactory.getLogger(TXTFile.class);

	public static final String DEFAULT_CHARSET_NAME = "UTF-8";

	public static final int MAX_LINE_SIZE = 2048;

	/**
	 * 
	 * @param source
	 * @return
	 */
	static public Version detectVersion(final BufferedReader in) {
		Version result;

		result = null;

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	static public Version detectVersion(final File source) {
		Version result;

		result = null;

		//
		return result;
	}

	/**
	 * Loads a TXT file into a Net.
	 * 
	 * @param file
	 *            file from where load a net.
	 * 
	 * @return the loaded net.
	 * 
	 * @throws PuckException
	 */
	static public Net load(final File file) throws PuckException {
		Net result;

		result = load(file, DEFAULT_CHARSET_NAME);

		//
		return result;
	}

	/**
	 * Loads a TXT file into a Net.
	 * 
	 * @param file
	 *            file from where load a net.
	 * 
	 * @return the loaded net.
	 * 
	 * @throws PuckException
	 */
	static public Net load(final File file, final String charsetName) throws PuckException {
		Net result;

		Version version = detectVersion(file);

		switch (version) {
			case V1:
			case V2:
				result = TXT1File.load(file, DEFAULT_CHARSET_NAME);
			break;

			case V3:
				result = TXT3File.load(file, DEFAULT_CHARSET_NAME);
			break;

			default:
				result = TXT3File.load(file, DEFAULT_CHARSET_NAME);
		}

		//
		return result;
	}

	/**
	 * Saves a net in a file.
	 * 
	 * @param file
	 *            Target.
	 * @param source
	 *            Source.
	 * 
	 * @throws PuckException
	 */
	public static void save(final File file, final Net source) throws PuckException {

		TXT3File.save(file, source);
	}

}
