/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.report.Report;
import org.tip.puck.util.Chronometer;

public class ControlReporter {
    private static final Logger logger = LoggerFactory.getLogger(ControlReporter.class);

    public static void checkCycles(StringList control, Individual ego, Individual firstEgo, int k, String str) {
        if (k == 0 || ego.getId() < firstEgo.getId()) {
            return;
        }
        String[] parentType = new String[]{"F", "M", "X"};
        str = String.valueOf(str) + " " + ego.getName() + " (" + ego.getId() + ")";
        if (ego.equals(firstEgo)) {
            control.appendln(str);
        }
        for (Individual alter : ego.getParents()) {
            ControlReporter.checkCycles(control, alter, firstEgo, k - 1, String.valueOf(str) + " - " + parentType[alter.getGender().toInt()]);
        }
    }

    public static void checkCycles(StringList control, Individual ego, int k) {
        String[] parentType = new String[]{"F", "M", "X"};
        for (Individual alter : ego.getParents()) {
            ControlReporter.checkCycles(control, alter, ego, k, String.valueOf(ego.getName()) + " (" + ego.getId() + ") - " + parentType[alter.getGender().toInt()]);
        }
    }

    public static Report reportAutoMarriages(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            if (!individual.getSpouses().contains(individual)) continue;
            errors.appendln(String.valueOf(individual.getTrimmedName()) + " (" + individual.getId() + ")");
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Auto-Marriages.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Auto-Marriages") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportControl(Net net, ResourceBundle bundle, ControlType controlType) {
        Report result;
        switch (controlType) {
            case CYCLIC_DESCENT_CASES: {
                result = ControlReporter.reportCyclicDescentCases(net, bundle);
                break;
            }
            case FEMALE_FATHERS_OR_MALE_MOTHERS: {
                result = ControlReporter.reportFemaleFathersOrMaleMothers(net, bundle);
                break;
            }
            case MULTIPLE_FATHERS_OR_MOTHERS: {
                result = ControlReporter.reportMultipleFathersOrMothers(net, bundle);
                break;
            }
            case NAMELESS_PERSONS: {
                result = ControlReporter.reportNamelessPersons(net, bundle);
                break;
            }
            case AUTO_MARRIAGE: {
                result = ControlReporter.reportAutoMarriages(net, bundle);
                break;
            }
            case PARENT_CHILD_MARRIAGES: {
                result = ControlReporter.reportParentChildMarriages(net, bundle);
                break;
            }
            case SAME_SEX_SPOUSES: {
                result = ControlReporter.reportSameSexSpouses(net, bundle);
                break;
            }
            case UNKNOWN_SEX_PERSONS: {
                result = ControlReporter.reportUnknownSexPersons(net, bundle);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static Report reportControls(Net net, ResourceBundle bundle) {
        Report result = ControlReporter.reportControls(net, bundle, ControlType.values());
        return result;
    }

    public static Report reportControls(Net net, ResourceBundle bundle, ControlType ... controlTypes) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Checks for possible errors (special features).");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        ControlType[] controlTypeArray = controlTypes;
        int n = controlTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ControlType type = controlTypeArray[n2];
            result.inputs().add(type.toString(), "true");
            ++n2;
        }
        int errorCount = 0;
        ControlType[] controlTypeArray2 = controlTypes;
        int n3 = controlTypes.length;
        n = 0;
        while (n < n3) {
            ControlType controlType = controlTypeArray2[n];
            Report report = ControlReporter.reportControl(net, bundle, controlType);
            if (report != null && report.status() != 0) {
                errorCount += report.status();
                result.outputs().append(report.outputs());
                result.outputs().appendln();
            }
            ++n;
        }
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCyclicDescentCases(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            ControlReporter.checkCycles(errors, individual, 5);
        }
        int errorCount = errors.size() / 2;
        Report result = new Report();
        result.setTitle("Checks for Cases of Cyclic Descent.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Cases of Cyclic Descent") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFemaleFathersOrMaleMothers(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            Individual mother;
            Individual father = individual.getFather();
            if (father != null && father.getGender().isFemale()) {
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(father.getGender().toChar()), father.getTrimmedName(), father.getId(), Report.translate(bundle, "for"), individual.getName().trim(), individual.getId()));
                ++errorCount;
            }
            if ((mother = individual.getMother()) == null || !mother.getGender().isMale()) continue;
            errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(mother.getGender().toChar()), mother.getName().trim(), mother.getId(), Report.translate(bundle, "for"), individual.getName().trim(), individual.getId()));
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Female Fathers or Male Mothers.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Female Fathers or Male Mothers") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMultipleFathersOrMothers(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            for (Family family : individual.getPersonalFamilies()) {
                Individual parent = family.getParent(individual.getGender());
                if (parent == null || parent == individual) continue;
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(individual.getGender().toChar()), individual.getTrimmedName(), individual.getId(), Report.translate(bundle, "and"), parent.getName().trim(), parent.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Multiple Fathers or Mothers.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Multiple Fathers/Mothers") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportNamelessPersons(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            if (!StringUtils.isBlank((CharSequence)individual.getName())) continue;
            errors.appendln(String.valueOf(individual.getGender().toChar()) + " " + individual.getId());
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Nameless Persons.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Nameless Persons") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportParentChildMarriages(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            for (Individual parent : individual.getParents()) {
                if (!individual.getSpouses().contains(parent)) continue;
                errors.appendln(String.format("%s (%d) %s %s (%d)", individual.getTrimmedName(), individual.getId(), Report.translate(bundle, "and"), parent.getName().trim(), parent.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Parent-Child Marriages.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Parent-Child Marriages") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSameSexSpouses(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            for (Individual spouse : individual.getSpouses()) {
                if (individual.getId() > spouse.getId() || individual.getGender() != spouse.getGender()) continue;
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(spouse.getGender().toChar()), spouse.getTrimmedName(), spouse.getId(), Report.translate(bundle, "for"), individual.getName().trim(), individual.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Same-Sex Couples.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Same-Sex Couples") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownSexPersons(Net net, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : net.individuals()) {
            if (!individual.getGender().isUnknown()) continue;
            errors.appendln(String.valueOf(individual.getTrimmedName()) + " (" + individual.getId() + ")");
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Persons of unknown Sex.");
        result.setOrigin("Control reporter");
        result.setTarget(net.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Persons of unknown Sex") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static enum ControlType {
        UNKNOWN_RELATIVES,
        SAME_SEX_SPOUSES,
        FEMALE_FATHERS_OR_MALE_MOTHERS,
        MULTIPLE_FATHERS_OR_MOTHERS,
        CYCLIC_DESCENT_CASES,
        UNKNOWN_SEX_PERSONS,
        NAMELESS_PERSONS,
        PARENT_CHILD_MARRIAGES,
        AUTO_MARRIAGE;

    }
}

