/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class AttributeWorker {
    private static final Logger logger = LoggerFactory.getLogger(AttributeWorker.class);

    public static int cleanAttribute(Individuals source, String attributeLabel) {
        int result = 0;
        for (Individual individual : source) {
            Attribute attribute = (Attribute)individual.attributes().get(attributeLabel);
            if (attribute == null || !StringUtils.isBlank((CharSequence)attribute.getValue()) && !attribute.getValue().trim().equals("0")) continue;
            individual.attributes().remove(attributeLabel);
            logger.debug("remove ===>" + individual.getId() + " " + individual.attributes().get(attributeLabel));
            ++result;
        }
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Net source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        if (source != null) {
            HashSet<String> buffer = new HashSet<String>();
            for (Attribute attribute : source.attributes()) {
                buffer.add(attribute.getLabel());
            }
            int index = 0;
            Iterator iterator = source.individuals().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Individual individual = (Individual)iterator.next();
                for (Attribute attribute : individual.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            index = 0;
            iterator = source.families().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Family family = (Family)iterator.next();
                for (Attribute attribute : family.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            index = 0;
            iterator = source.relations().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Relation relation = (Relation)iterator.next();
                for (Attribute attribute : relation.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            for (String string : buffer) {
                result.add(string);
            }
            Collections.sort(result);
        }
        return result;
    }

    public static int removeAllAttribute(Net net, Scope scope, String optionalRelationModelName, EmptyType type) {
        if (net == null) {
            throw new IllegalArgumentException("net parameter is null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("target parameter is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type parameter is null");
        }
        int result = 0;
        if (scope == Scope.ALL || scope == Scope.CORPUS) {
            result += net.attributes().size();
            net.attributes().clear();
        }
        if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
            for (Individual individual : net.individuals()) {
                result += individual.attributes().size();
                individual.attributes().clear();
            }
        }
        if (scope == Scope.ALL || scope == Scope.FAMILIES) {
            for (Family family : net.families()) {
                result += family.attributes().size();
                family.attributes().clear();
            }
        }
        if (scope == Scope.ALL || scope == Scope.RELATIONS) {
            for (Relation relation : net.relations()) {
                result += relation.attributes().size();
                relation.attributes().clear();
            }
        }
        if (scope == Scope.RELATION) {
            Relations relations = net.relations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += relation.attributes().size();
                relation.attributes().clear();
            }
        }
        return result;
    }

    public static int removeAttribute(Attributes source, String label, EmptyType type) {
        int result;
        if (label == null) {
            throw new IllegalArgumentException("label parameter is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type parameter is null");
        }
        if (source == null) {
            result = 0;
        } else {
            Attribute target = (Attribute)source.get(label);
            switch (type) {
                case VOID: {
                    if (target == null) {
                        result = 0;
                        break;
                    }
                    source.remove(label);
                    result = 1;
                    break;
                }
                case BLANK: {
                    if (target == null) {
                        result = 0;
                        break;
                    }
                    target.setValue("");
                    result = 1;
                    break;
                }
                case FORCED_BLANK: {
                    source.put(label, "");
                    result = 1;
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int removeAttribute(Net net, Scope scope, String optionalRelationModelName, String label, EmptyType type) {
        logger.debug("removeAttribute [net={}][scope={}][optionalName={}][label={}][type={}]", new Object[]{net, scope, optionalRelationModelName, label, type});
        if (net == null) {
            throw new IllegalArgumentException("net parameter is null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("target parameter is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label parameter is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type parameter is null");
        }
        int result = 0;
        if (scope == Scope.ALL || scope == Scope.CORPUS) {
            result += AttributeWorker.removeAttribute(net.attributes(), label, type);
        }
        if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
            for (Individual individual : net.individuals()) {
                result += AttributeWorker.removeAttribute(individual.attributes(), label, type);
            }
        }
        if (scope == Scope.ALL || scope == Scope.FAMILIES) {
            for (Family family : net.families()) {
                result += AttributeWorker.removeAttribute(family.attributes(), label, type);
            }
        }
        if (scope == Scope.ALL || scope == Scope.RELATIONS) {
            for (Relation relation : net.relations()) {
                result += AttributeWorker.removeAttribute(relation.attributes(), label, type);
            }
        }
        if (scope == Scope.RELATION) {
            Relations relations = net.relations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.removeAttribute(relation.attributes(), label, type);
            }
        }
        return result;
    }

    public static int valuateExogenousAttribute(Individuals source, String sourceLabel, String targetLabel, String valuePrefix) {
        logger.debug("valuateExogenousAttribute [source={}][sourceLabel={}][targetLabel={}][valuePrefix={}]", new Object[]{source, sourceLabel, targetLabel, valuePrefix});
        if (source == null) {
            throw new IllegalArgumentException("source parameter is null");
        }
        if (sourceLabel == null) {
            throw new IllegalArgumentException("source label parameter is null");
        }
        if (StringUtils.isBlank((CharSequence)targetLabel)) {
            throw new IllegalArgumentException("target label parameter is null");
        }
        int result = 0;
        NumberedValues values = IndividualValuator.get(source, sourceLabel);
        for (Individual individual : source) {
            Value value = (Value)values.get(individual.getId());
            String attributeValue = value == null ? "" : value.toString();
            String prefix = valuePrefix == null ? "" : valuePrefix;
            individual.attributes().put(targetLabel, String.valueOf(prefix) + attributeValue);
            ++result;
        }
        return result;
    }

    public static enum EmptyType {
        VOID,
        BLANK,
        FORCED_BLANK;

    }

    public static enum Scope {
        ALL,
        CORPUS,
        INDIVIDUALS,
        FAMILIES,
        RELATION,
        RELATIONS;

    }
}

