/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.random;

import java.util.Map;
import java.util.Set;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.matrix.Mat;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetExplorer;
import org.tip.puck.net.random.RandomNetMaker;
import org.tip.puck.net.workers.MemoryCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.BIASCount;
import org.tip.puck.statistics.BIASCounts;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;
import org.tip.puckgui.views.RandomCorpusCriteria;

public class RandomNetReporter {
    public static void ReportMASVariation() {
        RandomCorpusCriteria criteria = new RandomCorpusCriteria();
        int runs = 10;
        RandomNetMaker randomNetMaker = new RandomNetMaker(criteria);
        int run = 0;
        while (run < runs) {
            Net net = randomNetMaker.createRandomNet();
            ++run;
        }
    }

    public static ReportChart buildChartFromTable(String chartTitle, ReportChart.GraphType chartType, double[][] source, double initialValue, double intervalFactor, MatrixStatistics.Indicator indicator) {
        ReportChart result = new ReportChart(chartTitle, chartType);
        int iMax = source.length;
        int jMax = source.length == 0 ? 0 : source[0].length;
        double v1 = initialValue;
        int i = 0;
        while (i < iMax) {
            result.setLineTitle(String.valueOf(Mat.round(v1, 8)), i);
            result.setHeader(String.valueOf(v1), i);
            int j = 0;
            while (j < jMax) {
                result.setValue(Mat.round(source[i][j], 4), i, j);
                ++j;
            }
            v1 *= intervalFactor;
            ++i;
        }
        return result;
    }

    public static <E> Report reportVirtualFieldworkVariations(Segmentation source) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Random Net Variation by observer");
        result.setOrigin("RandomNetReporter");
        result.setTarget(source.getLabel());
        int n1 = 8;
        int n2 = 6;
        double[][] biasCounts = new double[n1][n2];
        Double[][][] agnaticClosureRates = new Double[n1][n2][3];
        Double[][][] uterineClosureRates = new Double[n1][n2][3];
        double[][][] differenceClosureRates = new double[n1][n2][3];
        double[][] meanInformation = new double[n1][n2];
        double[][] explorationRateIndi = new double[n1][n2];
        double[][] explorationRateMarr = new double[n1][n2];
        double[][] meanDegree = new double[n1][n2];
        MemoryCriteria criteria = new MemoryCriteria();
        double lossFactorInitialValue = 0.1;
        double distanceWeightInitialValue = 1.0;
        double lossFactorIntervalFactor = 0.1;
        double distanceWeightIntervalFactor = 10.0;
        int runs = 100;
        int gen = 3;
        criteria.setMaxDistance(6);
        criteria.setDistanceType(FiliationType.VIRI);
        criteria.setDistanceFactor(lossFactorInitialValue);
        criteria.setDistanceWeight(distanceWeightInitialValue);
        Map<Individual, Set<Individual>> neighborSets = StatisticsWorker.neighborSets(source.getCurrentIndividuals(), criteria.getMaxDistance(), criteria.getDistanceType());
        int trueSize = source.getAllIndividuals().size();
        int trueMarriages = StatisticsWorker.numberOfMarriages(source.getAllFamilies());
        BIASCount trueBias = StatisticsWorker.biasWeights(source.getAllIndividuals()).get(3);
        Double[] trueAgnaticClosureRates = CircuitFinder.getClosureRates(source, "LINE", FiliationType.AGNATIC, 0).get(new Value("AGNATIC"));
        Double[] trueUterineClosureRates = CircuitFinder.getClosureRates(source, "LINE", FiliationType.UTERINE, 0).get(new Value("UTERINE"));
        result.inputs().add("Number of runs by combination", runs);
        result.inputs().add("Kin type", criteria.getDistanceType().toString());
        result.inputs().add("Maximal distance", criteria.getMaxDistance());
        int i = 0;
        while (i < n1) {
            int j = 0;
            while (j < n2) {
                System.out.println("loss Factor " + criteria.getDistanceFactor() + "\tdistance weight " + criteria.getDistanceWeight());
                RandomNetExplorer randomNetExplorer = new RandomNetExplorer(source, criteria, null, neighborSets);
                randomNetExplorer.getStatistics(runs, gen);
                BIASCounts theseBiasCounts = randomNetExplorer.getBiasCounts();
                biasCounts[i][j] = theseBiasCounts.get(gen).getAgnatic() - theseBiasCounts.get(gen).getUterine();
                explorationRateIndi[i][j] = randomNetExplorer.getExplorationRateIndi();
                meanInformation[i][j] = randomNetExplorer.getMeanInformation();
                explorationRateMarr[i][j] = randomNetExplorer.getExplorationRateMarr();
                meanDegree[i][j] = randomNetExplorer.getMeanDegree();
                Map<Value, Double[]> theseClosureRates = randomNetExplorer.getClosureRates();
                Double[] closureRateAgnatic = new Double[]{0.0, 0.0, 0.0};
                Double[] closureRateUterine = new Double[]{0.0, 0.0, 0.0};
                if (theseClosureRates.get(new Value("AGNATIC")) != null) {
                    closureRateAgnatic = theseClosureRates.get(new Value("AGNATIC"));
                }
                if (theseClosureRates.get(new Value("UTERINE")) != null) {
                    closureRateUterine = theseClosureRates.get(new Value("UTERINE"));
                }
                agnaticClosureRates[i][j] = closureRateAgnatic;
                uterineClosureRates[i][j] = closureRateUterine;
                int k = 0;
                while (k < 3) {
                    differenceClosureRates[i][j][k] = closureRateAgnatic[k] - closureRateUterine[k];
                    ++k;
                }
                criteria.setDistanceWeight(criteria.getDistanceWeight() * distanceWeightIntervalFactor);
                ++j;
            }
            criteria.setDistanceFactor(criteria.getDistanceFactor() + lossFactorIntervalFactor);
            criteria.setDistanceWeight(distanceWeightInitialValue);
            ++i;
        }
        result.outputs().appendln("Mean information");
        ReportChart chart00 = new ReportChart("Mean information", ReportChart.GraphType.SURFACE);
        double v1 = lossFactorInitialValue;
        double v2 = distanceWeightInitialValue;
        int j = 0;
        while (j < n2) {
            chart00.setHeader(String.valueOf(v2), j);
            v2 *= distanceWeightIntervalFactor;
            ++j;
        }
        int i2 = 0;
        while (i2 < n1) {
            chart00.setLineTitle(String.valueOf(v1), i2);
            int j2 = 0;
            while (j2 < n2) {
                chart00.setValue(Mat.round(meanInformation[i2][j2], 4), i2, j2);
                ++j2;
            }
            v1 += lossFactorIntervalFactor;
            ++i2;
        }
        result.outputs().append(chart00);
        ReportTable table00 = chart00.createReportTable();
        table00.set(0, 0, "loss/inertia");
        result.outputs().appendln(table00);
        result.outputs().appendln();
        result.outputs().appendln("Network exploration (individuals)");
        ReportChart chart01 = new ReportChart("Network exploration (individuals)", ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j3 = 0;
        while (j3 < n2) {
            chart01.setHeader(String.valueOf(v2), j3);
            v2 *= distanceWeightIntervalFactor;
            ++j3;
        }
        int i3 = 0;
        while (i3 < n1) {
            chart01.setLineTitle(String.valueOf(v1), i3);
            int j4 = 0;
            while (j4 < n2) {
                chart01.setValue(Mat.round(explorationRateIndi[i3][j4], 4), i3, j4);
                ++j4;
            }
            v1 += lossFactorIntervalFactor;
            ++i3;
        }
        result.outputs().append(chart01);
        ReportTable table01 = chart01.createReportTable();
        table01.set(0, 0, "loss/inertia");
        result.outputs().appendln(table01);
        result.outputs().appendln();
        result.outputs().appendln("Network exploration (marriages)");
        ReportChart chart03 = new ReportChart("Network exploration (marriages)", ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j5 = 0;
        while (j5 < n2) {
            chart03.setHeader(String.valueOf(v2), j5);
            v2 *= distanceWeightIntervalFactor;
            ++j5;
        }
        int i4 = 0;
        while (i4 < n1) {
            chart03.setLineTitle(String.valueOf(v1), i4);
            int j6 = 0;
            while (j6 < n2) {
                chart03.setValue(Mat.round(explorationRateMarr[i4][j6], 4), i4, j6);
                ++j6;
            }
            v1 += lossFactorIntervalFactor;
            ++i4;
        }
        result.outputs().append(chart03);
        ReportTable table03 = chart03.createReportTable();
        table03.set(0, 0, "loss/inertia");
        result.outputs().appendln(table03);
        result.outputs().appendln();
        result.outputs().appendln("Mean NrMarriages (true = " + MathUtils.percent(2 * trueMarriages, 100 * trueSize) + ")");
        ReportChart chart02 = new ReportChart("Mean NrMarriages", ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j7 = 0;
        while (j7 < n2) {
            chart02.setHeader(String.valueOf(v2), j7);
            v2 *= distanceWeightIntervalFactor;
            ++j7;
        }
        int i5 = 0;
        while (i5 < n1) {
            chart02.setLineTitle(String.valueOf(v1), i5);
            int j8 = 0;
            while (j8 < n2) {
                chart02.setValue(Mat.round(meanDegree[i5][j8], 4), i5, j8);
                ++j8;
            }
            v1 += lossFactorIntervalFactor;
            ++i5;
        }
        result.outputs().append(chart02);
        ReportTable table02 = chart02.createReportTable();
        table02.set(0, 0, "loss/inertia");
        result.outputs().appendln(table02);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic bias variation (" + gen + " generations)" + "( true = " + MathUtils.percent(trueBias.getAgnatic() - trueBias.getUterine(), 100.0) + ")");
        ReportChart chart = new ReportChart("Agnatic Bias Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j9 = 0;
        while (j9 < n2) {
            chart.setHeader(String.valueOf(v2), j9);
            v2 *= distanceWeightIntervalFactor;
            ++j9;
        }
        int i6 = 0;
        while (i6 < n1) {
            chart.setLineTitle(String.valueOf(v1), i6);
            int j10 = 0;
            while (j10 < n2) {
                chart.setValue(Mat.round(biasCounts[i6][j10], 4), i6, j10);
                ++j10;
            }
            v1 += lossFactorIntervalFactor;
            ++i6;
        }
        result.outputs().append(chart);
        ReportTable table = chart.createReportTable();
        table.set(0, 0, "loss/inertia");
        result.outputs().appendln(table);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic Cousin Marriage (" + gen + " generations) (true =" + trueAgnaticClosureRates[0] + ")");
        ReportChart chart2a = new ReportChart("Agnatic Cousin Marriage Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j11 = 0;
        while (j11 < n2) {
            chart2a.setHeader(String.valueOf(v2), j11);
            v2 *= distanceWeightIntervalFactor;
            ++j11;
        }
        int i7 = 0;
        while (i7 < n1) {
            chart2a.setLineTitle(String.valueOf(v1), i7);
            int j12 = 0;
            while (j12 < n2) {
                chart2a.setValue(Mat.round(agnaticClosureRates[i7][j12][0], 4), i7, j12);
                ++j12;
            }
            v1 += lossFactorIntervalFactor;
            ++i7;
        }
        result.outputs().append(chart2a);
        ReportTable table2a = chart2a.createReportTable();
        table2a.set(0, 0, "loss/inertia");
        result.outputs().appendln(table2a);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic Cousin Frequency (" + gen + " generations) (true =" + trueAgnaticClosureRates[1] + ")");
        ReportChart chart2b = new ReportChart("Agnatic Cousin Frequency Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j13 = 0;
        while (j13 < n2) {
            chart2b.setHeader(String.valueOf(v2), j13);
            v2 *= distanceWeightIntervalFactor;
            ++j13;
        }
        int i8 = 0;
        while (i8 < n1) {
            chart2b.setLineTitle(String.valueOf(v1), i8);
            int j14 = 0;
            while (j14 < n2) {
                chart2b.setValue(Mat.round(agnaticClosureRates[i8][j14][1], 4), i8, j14);
                ++j14;
            }
            v1 += lossFactorIntervalFactor;
            ++i8;
        }
        result.outputs().append(chart2b);
        ReportTable table2b = chart2b.createReportTable();
        table2b.set(0, 0, "loss/inertia");
        result.outputs().appendln(table2b);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic Closure (" + gen + " generations) (true =" + trueAgnaticClosureRates[2] + ")");
        ReportChart chart2c = new ReportChart("Agnatic Closure Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j15 = 0;
        while (j15 < n2) {
            chart2c.setHeader(String.valueOf(v2), j15);
            v2 *= distanceWeightIntervalFactor;
            ++j15;
        }
        int i9 = 0;
        while (i9 < n1) {
            chart2c.setLineTitle(String.valueOf(v1), i9);
            int j16 = 0;
            while (j16 < n2) {
                chart2c.setValue(Mat.round(agnaticClosureRates[i9][j16][2], 4), i9, j16);
                ++j16;
            }
            v1 += lossFactorIntervalFactor;
            ++i9;
        }
        result.outputs().append(chart2c);
        ReportTable table2c = chart2c.createReportTable();
        table2c.set(0, 0, "loss/inertia");
        result.outputs().appendln(table2c);
        result.outputs().appendln();
        result.outputs().appendln("Uterine Cousin Marriage (" + gen + " generations) (true =" + trueUterineClosureRates[0] + ")");
        ReportChart chart4a = new ReportChart("Uterine Cousin Marriage Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j17 = 0;
        while (j17 < n2) {
            chart4a.setHeader(String.valueOf(v2), j17);
            v2 *= distanceWeightIntervalFactor;
            ++j17;
        }
        int i10 = 0;
        while (i10 < n1) {
            chart4a.setLineTitle(String.valueOf(v1), i10);
            int j18 = 0;
            while (j18 < n2) {
                chart4a.setValue(Mat.round(uterineClosureRates[i10][j18][0], 4), i10, j18);
                ++j18;
            }
            v1 += lossFactorIntervalFactor;
            ++i10;
        }
        result.outputs().append(chart4a);
        ReportTable table4a = chart4a.createReportTable();
        table4a.set(0, 0, "loss/inertia");
        result.outputs().appendln(table4a);
        result.outputs().appendln();
        result.outputs().appendln("Uterine Cousin Frequency (" + gen + " generations) (true =" + trueUterineClosureRates[1] + ")");
        ReportChart chart4b = new ReportChart("Uterine Cousin Frequency Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j19 = 0;
        while (j19 < n2) {
            chart4b.setHeader(String.valueOf(v2), j19);
            v2 *= distanceWeightIntervalFactor;
            ++j19;
        }
        int i11 = 0;
        while (i11 < n1) {
            chart4b.setLineTitle(String.valueOf(v1), i11);
            int j20 = 0;
            while (j20 < n2) {
                chart4b.setValue(Mat.round(uterineClosureRates[i11][j20][1], 4), i11, j20);
                ++j20;
            }
            v1 += lossFactorIntervalFactor;
            ++i11;
        }
        result.outputs().append(chart4b);
        ReportTable table4b = chart4b.createReportTable();
        table4b.set(0, 0, "loss/inertia");
        result.outputs().appendln(table4b);
        result.outputs().appendln();
        result.outputs().appendln("Uterine Closure (" + gen + " generations) (true =" + trueUterineClosureRates[2] + ")");
        ReportChart chart4c = new ReportChart("Uterine Closure Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j21 = 0;
        while (j21 < n2) {
            chart4c.setHeader(String.valueOf(v2), j21);
            v2 *= distanceWeightIntervalFactor;
            ++j21;
        }
        int i12 = 0;
        while (i12 < n1) {
            chart4c.setLineTitle(String.valueOf(v1), i12);
            int j22 = 0;
            while (j22 < n2) {
                chart4c.setValue(Mat.round(uterineClosureRates[i12][j22][2], 4), i12, j22);
                ++j22;
            }
            v1 += lossFactorIntervalFactor;
            ++i12;
        }
        result.outputs().append(chart4c);
        ReportTable table4c = chart4c.createReportTable();
        table4c.set(0, 0, "loss/inertia");
        result.outputs().appendln(table4c);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic-Uterine cousin marriage divergence (" + gen + " generations) (true =" + (trueAgnaticClosureRates[0] - trueUterineClosureRates[0]) + ")");
        ReportChart chart3a = new ReportChart("Agnatic-Uterine cousin marriage divergence " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j23 = 0;
        while (j23 < n2) {
            chart3a.setHeader(String.valueOf(v2), j23);
            v2 *= distanceWeightIntervalFactor;
            ++j23;
        }
        int i13 = 0;
        while (i13 < n1) {
            chart3a.setLineTitle(String.valueOf(v1), i13);
            int j24 = 0;
            while (j24 < n2) {
                chart3a.setValue(Mat.round(differenceClosureRates[i13][j24][0], 4), i13, j24);
                ++j24;
            }
            v1 += lossFactorIntervalFactor;
            ++i13;
        }
        result.outputs().append(chart3a);
        ReportTable table3a = chart3a.createReportTable();
        table3a.set(0, 0, "loss/inertia");
        result.outputs().appendln(table3a);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic-Uterine cousin frequency divergence (" + gen + " generations) (true =" + (trueAgnaticClosureRates[1] - trueUterineClosureRates[1]) + ")");
        ReportChart chart3b = new ReportChart("Agnatic-Uterine cousin frequency divergence " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j25 = 0;
        while (j25 < n2) {
            chart3b.setHeader(String.valueOf(v2), j25);
            v2 *= distanceWeightIntervalFactor;
            ++j25;
        }
        int i14 = 0;
        while (i14 < n1) {
            chart3b.setLineTitle(String.valueOf(v1), i14);
            int j26 = 0;
            while (j26 < n2) {
                chart3b.setValue(Mat.round(differenceClosureRates[i14][j26][1], 4), i14, j26);
                ++j26;
            }
            v1 += lossFactorIntervalFactor;
            ++i14;
        }
        result.outputs().append(chart3b);
        ReportTable table3b = chart3b.createReportTable();
        table3b.set(0, 0, "loss/inertia");
        result.outputs().appendln(table3b);
        result.outputs().appendln();
        result.outputs().appendln("Agnatic-Uterine closure divergence (" + gen + " generations) (true =" + (trueAgnaticClosureRates[2] - trueUterineClosureRates[2]) + ")");
        ReportChart chart3c = new ReportChart("Agnatic-Uterine closure divergence Variation " + gen, ReportChart.GraphType.SURFACE);
        v1 = lossFactorInitialValue;
        v2 = distanceWeightInitialValue;
        int j27 = 0;
        while (j27 < n2) {
            chart3c.setHeader(String.valueOf(v2), j27);
            v2 *= distanceWeightIntervalFactor;
            ++j27;
        }
        int i15 = 0;
        while (i15 < n1) {
            chart3c.setLineTitle(String.valueOf(v1), i15);
            int j28 = 0;
            while (j28 < n2) {
                chart3c.setValue(Mat.round(differenceClosureRates[i15][j28][2], 4), i15, j28);
                ++j28;
            }
            v1 += lossFactorIntervalFactor;
            ++i15;
        }
        result.outputs().append(chart3c);
        ReportTable table3c = chart3c.createReportTable();
        table3c.set(0, 0, "loss/inertia");
        result.outputs().appendln(table3c);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportVirtualFieldwork(RandomNetExplorer randomNetExplorer, int runs, int genMax) throws PuckException {
        Report result;
        if (randomNetExplorer == null) {
            result = null;
        } else {
            Chronometer chrono = new Chronometer();
            result = new Report();
            result.setTitle("Virtual fieldwork statistics.");
            result.setOrigin("Fieldworker");
            randomNetExplorer.getStatistics(runs, genMax);
            BIASCounts counts = randomNetExplorer.getBiasCounts();
            Map<Value, Double[]> closureRates = randomNetExplorer.getClosureRates();
            ReportChart chart = StatisticsReporter.createGenderBIASWeightChart(counts);
            ReportTable table = StatisticsReporter.createGenderBIASWeightTable(counts);
            result.outputs().append(chart);
            result.outputs().appendln(table.getTitle());
            result.outputs().appendln(table);
            ReportChart chart2 = StatisticsReporter.createMapChart(closureRates, 0, "First cousin relations " + genMax);
            ReportTable table2 = chart2.createReportTable();
            result.outputs().append(chart2);
            result.outputs().appendln(table2.getTitle());
            result.outputs().appendln(table2);
            ReportChart chart3 = StatisticsReporter.createMapChart(closureRates, 1, "First cousin marriages " + genMax);
            ReportTable table3 = chart3.createReportTable();
            result.outputs().append(chart3);
            result.outputs().appendln(table3.getTitle());
            result.outputs().appendln(table3);
            ReportChart chart4 = StatisticsReporter.createMapChart(closureRates, 2, "First cousin closure Rates " + genMax);
            ReportTable table4 = chart4.createReportTable();
            result.outputs().append(chart4);
            result.outputs().appendln(table4.getTitle());
            result.outputs().appendln(table4);
            result.setTimeSpent(chrono.stop().interval());
        }
        return result;
    }
}

