/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

public enum UnionStatus {
    UNMARRIED(0),
    MARRIED(1),
    DIVORCED(2);

    public static final char UNMARRIED_CHAR = '\u26af';
    public static final char MARRIAGE_CHAR = '\u26ad';
    public static final char DIVORCE_CHAR = '\u26ae';
    private int code;

    private UnionStatus(int code) {
        this.code = code;
    }

    public boolean canMarry() {
        boolean result = this != MARRIED;
        return result;
    }

    public boolean isDivorced() {
        boolean result = this == DIVORCED;
        return result;
    }

    public boolean isMarried() {
        boolean result = this == MARRIED;
        return result;
    }

    public boolean isUnmarried() {
        boolean result = this == UNMARRIED;
        return result;
    }

    public int toInt() {
        int result = this.code;
        return result;
    }

    public char toSymbol() {
        char result;
        switch (this) {
            case MARRIED: {
                result = '\u26ad';
                break;
            }
            case DIVORCED: {
                result = '\u26ae';
                break;
            }
            default: {
                result = '\u26af';
            }
        }
        return result;
    }

    public static UnionStatus valueOf(String string) {
        return Enum.valueOf(UnionStatus.class, string);
    }
}

