/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.mas;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.tip.puck.mas.MAS;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;

public class Agent
extends Individual {
    public static int MAX_COUSIN_DEGREE = 2;
    private int birth;
    private Family currentMarriage;
    private Set<Integer> partners;
    private MAS mas;
    private int ageOfMotherAtBirth;
    private int ageOfFatherAtBirth;
    public Vector<Set<Integer>> cousins;
    public Vector<Set<Integer>> agnaticCousins;
    public Vector<Set<Integer>> uterineCousins;
    private int timeOfLastChildBirth;
    private boolean alive;

    public Agent(MAS mas, int id, Gender gender, int curCycle, Family origFamily) {
        super(id, "" + id, gender);
        HashSet cousinSet;
        this.mas = mas;
        this.setOriginFamily(origFamily);
        this.birth = curCycle;
        this.ageOfMotherAtBirth = 0;
        this.ageOfFatherAtBirth = 0;
        if (this.getMother() != null) {
            this.ageOfMotherAtBirth = ((Agent)this.getMother()).getAge();
        }
        if (this.getFather() != null) {
            this.ageOfFatherAtBirth = ((Agent)this.getFather()).getAge();
        }
        this.currentMarriage = null;
        this.partners = new HashSet<Integer>();
        this.cousins = new Vector();
        int i = 0;
        while (i < MAX_COUSIN_DEGREE) {
            cousinSet = new HashSet();
            this.cousins.add(cousinSet);
            ++i;
        }
        this.agnaticCousins = new Vector();
        i = 0;
        while (i < MAX_COUSIN_DEGREE) {
            cousinSet = new HashSet();
            this.agnaticCousins.add(cousinSet);
            ++i;
        }
        this.uterineCousins = new Vector();
        i = 0;
        while (i < MAX_COUSIN_DEGREE) {
            cousinSet = new HashSet();
            this.uterineCousins.add(cousinSet);
            ++i;
        }
        this.timeOfLastChildBirth = -1;
        this.alive = true;
    }

    public void die() {
        this.alive = false;
        this.cousins = null;
        this.agnaticCousins = null;
        this.uterineCousins = null;
    }

    public boolean isPartnerOf(Agent agent) {
        if (this.currentMarriage == null) {
            return false;
        }
        if (this.currentMarriage.getHusband().getId() == this.getId()) {
            return this.currentMarriage.getWife().getId() == agent.getId();
        }
        if (this.currentMarriage.getWife().getId() == this.getId()) {
            return this.currentMarriage.getHusband().getId() == agent.getId();
        }
        return false;
    }

    public boolean wasPartnerOf(Agent agent) {
        return this.partners.contains(agent.getId());
    }

    public boolean isOrWasMarried() {
        if (this.currentMarriage != null) {
            return true;
        }
        return this.partners.size() > 0;
    }

    public void setCousins(Agent cousin, int degree, FiliationType fil) {
        if (cousin.isAlive()) {
            this.cousins.get(degree - 1).add(cousin.getId());
            cousin.cousins.get(degree - 1).add(this.getId());
        }
        if (degree == 1) {
            this.mas.incCousins1();
        }
        if (fil == FiliationType.AGNATIC) {
            if (cousin.isAlive()) {
                this.agnaticCousins.get(degree - 1).add(cousin.getId());
                cousin.agnaticCousins.get(degree - 1).add(this.getId());
            }
            if (degree == 1) {
                this.mas.incAgnaticCousins1();
            }
        } else if (fil == FiliationType.UTERINE) {
            if (cousin.isAlive()) {
                this.uterineCousins.get(degree - 1).add(cousin.getId());
                cousin.uterineCousins.get(degree - 1).add(this.getId());
            }
            if (degree == 1) {
                this.mas.incUterineCousins1();
            }
        }
    }

    private void exploreDown(Individual alter, int distance, int depth, FiliationType fil) {
        if (distance == depth) {
            this.setCousins((Agent)alter, distance - 1, fil);
        } else {
            for (Individual c : alter.getChildren()) {
                FiliationType newFil;
                if (c == this.getMother() || c == this.getFather()) {
                    return;
                }
                if (c.getGender() == Gender.FEMALE) {
                    switch (fil) {
                        case IDENTITY: {
                            newFil = FiliationType.UTERINE;
                            break;
                        }
                        case AGNATIC: {
                            newFil = FiliationType.COGNATIC;
                            break;
                        }
                        case UTERINE: {
                            newFil = FiliationType.UTERINE;
                            break;
                        }
                        default: {
                            newFil = FiliationType.COGNATIC;
                            break;
                        }
                    }
                } else {
                    switch (fil) {
                        case IDENTITY: {
                            newFil = FiliationType.AGNATIC;
                            break;
                        }
                        case AGNATIC: {
                            newFil = FiliationType.AGNATIC;
                            break;
                        }
                        case UTERINE: {
                            newFil = FiliationType.COGNATIC;
                            break;
                        }
                        default: {
                            newFil = FiliationType.COGNATIC;
                        }
                    }
                }
                this.exploreDown((Agent)c, distance, depth + 1, newFil);
            }
        }
    }

    private void exploreUp(Individual alter, int distance, FiliationType fil) {
        if (distance < MAX_COUSIN_DEGREE + 2) {
            Individual father;
            Individual mother = alter.getMother();
            if (mother != null) {
                FiliationType newFil;
                switch (fil) {
                    case IDENTITY: {
                        newFil = FiliationType.UTERINE;
                        break;
                    }
                    case AGNATIC: {
                        newFil = FiliationType.COGNATIC;
                        break;
                    }
                    case UTERINE: {
                        newFil = FiliationType.UTERINE;
                        break;
                    }
                    default: {
                        newFil = FiliationType.COGNATIC;
                    }
                }
                this.exploreUp(mother, distance + 1, newFil);
            }
            if ((father = alter.getFather()) != null) {
                FiliationType newFil;
                switch (fil) {
                    case IDENTITY: {
                        newFil = FiliationType.AGNATIC;
                        break;
                    }
                    case AGNATIC: {
                        newFil = FiliationType.AGNATIC;
                        break;
                    }
                    case UTERINE: {
                        newFil = FiliationType.COGNATIC;
                        break;
                    }
                    default: {
                        newFil = FiliationType.COGNATIC;
                    }
                }
                this.exploreUp(father, distance + 1, newFil);
            }
            if (distance > 1) {
                this.exploreDown(alter, distance, 0, fil);
            }
        }
    }

    public void updateCousins() {
        this.exploreUp(this, 0, FiliationType.IDENTITY);
    }

    public boolean hasCousin(Agent alter, int degree) {
        return this.cousins.get(degree - 1).contains(alter.getId());
    }

    public boolean hasAgnaticCousin(Agent alter, int degree) {
        return this.agnaticCousins.get(degree - 1).contains(alter.getId());
    }

    public boolean hasUterineCousin(Agent alter, int degree) {
        return this.uterineCousins.get(degree - 1).contains(alter.getId());
    }

    public int getBirth() {
        return this.birth;
    }

    public int getAge() {
        return this.mas.getCurCycle() - this.birth;
    }

    public Family getCurrentMarriage() {
        return this.currentMarriage;
    }

    public void setCurrentMarriage(Family currentMarriage) {
        this.currentMarriage = currentMarriage;
    }

    public void addPartner(Agent agent) {
        this.partners.add(agent.getId());
    }

    public boolean isMarried() {
        return this.currentMarriage != null;
    }

    public int calcNumberOfSiblings() {
        HashSet<Integer> siblings = new HashSet<Integer>();
        if (this.getMother() != null) {
            Individuals motherSide = this.getMother().getChildren();
            for (Individual s : motherSide) {
                siblings.add(s.getId());
            }
        }
        if (this.getFather() != null) {
            Individuals fatherSide = this.getFather().getChildren();
            for (Individual s : fatherSide) {
                siblings.add(s.getId());
            }
        }
        siblings.remove(this.getId());
        return siblings.size();
    }

    public int calcNumberOfFullSiblings() {
        HashSet<Integer> siblings = new HashSet<Integer>();
        if (this.getMother() != null) {
            Individuals motherSide = this.getMother().getChildren();
            for (Individual s : motherSide) {
                if (s.getFather() != this.getFather()) continue;
                siblings.add(s.getId());
            }
        }
        if (this.getFather() != null) {
            Individuals fatherSide = this.getFather().getChildren();
            for (Individual s : fatherSide) {
                if (s.getMother() != this.getMother()) continue;
                siblings.add(s.getId());
            }
        }
        siblings.remove(this.getId());
        return siblings.size();
    }

    public int getAgeOfMotherAtBirth() {
        return this.ageOfMotherAtBirth;
    }

    public int getAgeOfFatherAtBirth() {
        return this.ageOfFatherAtBirth;
    }

    public void setAttributes() {
        this.setAttribute("BIRT_DATE", String.valueOf(this.birth));
        this.setAttribute("AGE", String.valueOf(this.getAge()));
    }

    public void setBirth(int birth) {
        this.birth = birth;
    }

    public int getTimeOfLastChildBirth() {
        return this.timeOfLastChildBirth;
    }

    public void setTimeOfLastChildBirth(int timeOfLastChildBirth) {
        this.timeOfLastChildBirth = timeOfLastChildBirth;
    }

    public MAS getMas() {
        return this.mas;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public Vector<Set<Integer>> getAgnaticCousins() {
        return this.agnaticCousins;
    }
}

