/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.pl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.pl.PLLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.LogHelper;

public class PLFile {
    private static final Logger logger = LoggerFactory.getLogger(PLFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Pattern PLLINE_PATTERN = Pattern.compile("^(\\D+\\d*)\\(p(\\d+),\\s*((p(\\d+))|('(.*)'))\\)\\.$");

    public static Net load(File file) throws PuckException {
        Net result = PLFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetname) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetname));
                result = PLFile.read(in);
                logger.debug("Net=" + LogHelper.toString(result));
                result = NetUtils.buildCleanedNet(result);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        boolean ended = false;
        while (!ended) {
            Individual individual;
            PLLine source = PLFile.readPLLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.label().equals("daughter") || source.label().equals("son") || source.label().equals("daughter") || source.label().equals("son") || source.label().equals("father") || source.label().equals("mother")) continue;
            if (source.label().equals("husband") || source.label().equals("wife")) {
                NetUtils.setSpouseRelationAndFixRoles(result, source.value1(), source.value2());
                continue;
            }
            if (source.label().equals("gname")) {
                individual = (Individual)result.individuals().getById(source.value1());
                if (individual == null) {
                    individual = new Individual(source.value1());
                    result.individuals().add(individual);
                }
                individual.setName(source.value2ToString());
                continue;
            }
            if (source.label().equals("sex")) {
                individual = (Individual)result.individuals().getById(source.value1());
                if (individual == null) {
                    individual = new Individual(source.value1());
                    result.individuals().add(individual);
                }
                individual.setGender(Gender.valueOf(source.value2ToChar()));
                continue;
            }
            if (source.label().startsWith("info")) {
                if (source.label().equals("info1")) {
                    NetUtils.setAttribute(result, source.value1(), "OCCU", source.value2ToString());
                    continue;
                }
                if (source.label().equals("info2")) {
                    NetUtils.setAttribute(result, source.value1(), "BIRT", source.value2ToString());
                    continue;
                }
                if (source.label().equals("info3")) {
                    NetUtils.setAttribute(result, source.value1(), "DEAT", source.value2ToString());
                    continue;
                }
                NetUtils.setAttribute(result, source.value1(), source.label(), source.value2ToString());
                continue;
            }
            throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown label.", new Object[0]);
        }
        logger.debug("Done.");
        return result;
    }

    public static PLLine readPLLine(BufferedReader in) throws PuckException {
        PLLine result;
        block4: {
            try {
                String line = in.readLine();
                if (line == null) {
                    result = null;
                    break block4;
                }
                Matcher matcher = PLLINE_PATTERN.matcher(line);
                if (matcher.find() && matcher.groupCount() == 7) {
                    String label = matcher.group(1);
                    int value1 = Integer.parseInt(matcher.group(2).trim());
                    String value2 = matcher.group(5) == null ? matcher.group(7).trim() : matcher.group(5);
                    result = new PLLine(label, value1, value2);
                    break block4;
                }
                throw PuckExceptions.BAD_FILE_FORMAT.create("Bad attributes line format: [" + line + "].", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception);
            }
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                PLFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void write(PrintWriter out, Net source) {
        Object wife;
        Individual husband;
        Individual parent;
        for (Individual individual : source.individuals()) {
            for (Individual child : individual.getChildren()) {
                if (!child.isFemale()) continue;
                PLFile.write(out, new PLLine("daughter", child.getId(), individual.getId()));
            }
        }
        for (Individual individual : source.individuals()) {
            parent = individual.getFather();
            if (parent == null || parent.isFemale()) continue;
            PLFile.write(out, new PLLine("father", parent.getId(), individual.getId()));
        }
        for (Individual individual : source.individuals()) {
            PLFile.write(out, new PLLine("gname", individual.getId(), individual.getName()));
        }
        for (Family family : source.families()) {
            husband = family.getHusband();
            wife = family.getWife();
            if (husband == null || wife == null) continue;
            PLFile.write(out, new PLLine("husband", husband.getId(), ((Individual)wife).getId()));
        }
        for (Individual individual : source.individuals()) {
            Attribute attribute = (Attribute)individual.attributes().get("OCCU");
            if (attribute != null) {
                PLFile.write(out, new PLLine("info1", individual.getId(), attribute.getValue()));
            }
            if ((attribute = (Attribute)individual.attributes().get("BIRT")) != null) {
                PLFile.write(out, new PLLine("info2", individual.getId(), attribute.getValue()));
            }
            if ((attribute = (Attribute)individual.attributes().get("DEAT")) == null) continue;
            PLFile.write(out, new PLLine("info3", individual.getId(), attribute.getValue()));
        }
        for (Individual individual : source.individuals()) {
            parent = individual.getMother();
            if (parent == null) continue;
            PLFile.write(out, new PLLine("mother", parent.getId(), individual.getId()));
        }
        for (Individual individual : source.individuals()) {
            PLFile.write(out, new PLLine("sex", individual.getId(), individual.getGender().toChar()));
        }
        for (Individual individual : source.individuals()) {
            for (Individual child : individual.getChildren()) {
                if (child.getGender() == Gender.FEMALE) continue;
                PLFile.write(out, new PLLine("son", child.getId(), individual.getId()));
            }
        }
        for (Family family : source.families()) {
            husband = family.getHusband();
            wife = family.getWife();
            if (husband == null || wife == null) continue;
            PLFile.write(out, new PLLine("wife", ((Individual)wife).getId(), husband.getId()));
        }
    }

    public static void write(PrintWriter out, PLLine source) {
        String line = source.isValue2Number() ? String.format("%s(p%d, p%d).", source.label(), source.value1(), source.value2()) : String.format("%s(p%d, '%s').", source.label(), source.value1(), source.value2ToString());
        out.println(line);
    }
}

