/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.workers;

import fr.devinsy.util.StringList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class GraphUtils {
    private static final Logger logger = LoggerFactory.getLogger(GraphUtils.class);

    public static <E> Graph<E> createGraphFromMatrix(Nodes<E> nodes, Matrix matrix) {
        Graph<E> result = new Graph<E>(0, nodes.size());
        result.addNodes(nodes);
        result.addArcs(matrix);
        return result;
    }

    private static <E> Node<E> maxStrengthNode(List<Node<E>> source, Cluster<Node<E>> cluster1, Cluster<Node<E>> cluster2) {
        Node<E> result = null;
        double maxStrength = 1.0;
        for (Node<E> node : source) {
            double strength = GraphUtils.strengthRate(node, cluster1, cluster2);
            if (!(strength >= maxStrength)) continue;
            maxStrength = strength;
            result = node;
        }
        return result;
    }

    public static <E> Graph<E> reduce(Graph<E> source, int minimalNumberOfLinks, double minimalLinkWeight) {
        Graph<E> result;
        logger.debug("reduce starting... [minimalNumberOfLinks={}][minimalLinkWeight={}]", (Object)minimalNumberOfLinks, (Object)minimalLinkWeight);
        if (minimalNumberOfLinks == 0 && minimalLinkWeight == 0.0) {
            result = source;
        } else {
            result = new Graph(source.getLabel());
            for (Node<E> node : source.getNodes()) {
                if (minimalNumberOfLinks != 0 && node.getOutArcs().size() + node.getInArcs().size() < minimalNumberOfLinks || minimalLinkWeight != 0.0 && !(MathUtils.compare(node.getMaxLinkWeight(), minimalLinkWeight) >= 0.0)) continue;
                result.addNode(node.getReferent());
            }
            for (Node<E> newSourceNode : result.getNodes()) {
                Node<E> oldSourceNode = source.getNode(newSourceNode.getReferent());
                for (Link<E> oldLink : oldSourceNode.getOutArcs()) {
                    Node<E> oldTargetNode = oldLink.getTargetNode();
                    Node<E> newTargetNode = result.getNode(oldTargetNode.getReferent());
                    if (newTargetNode == null || !(oldLink.getWeight() >= minimalLinkWeight)) continue;
                    result.addArc(newSourceNode, newTargetNode, oldLink.getWeight());
                }
            }
        }
        logger.debug("reduce done.");
        return result;
    }

    public static <E> double sidedness(Graph<E> source, Partition<Node<E>> sides) {
        double exoWeight = 0.0;
        double totalWeight = 0.0;
        for (Link link : source.getLinks()) {
            if (sides.getCluster(link.getSourceNode()) != sides.getCluster(link.getTargetNode())) {
                exoWeight += link.getWeight();
            }
            totalWeight += link.getWeight();
        }
        double result = exoWeight / totalWeight;
        return result;
    }

    public static <E> Partition<Node<E>> sides(Graph<E> source) {
        Partition<Node<Node<E>>> result = new Partition<Node<Node<E>>>();
        Cluster<Node<E>> side1 = new Cluster<Node<E>>(new Value(1));
        Cluster<Node<E>> side2 = new Cluster<Node<E>>(new Value(2));
        Cluster<Node<Node<E>>> side3 = new Cluster<Node<Node<E>>>(new Value(3));
        result.getClusters().put(side1);
        result.getClusters().put(side2);
        double maxStrength = 0.0;
        Node<E> maxStrengthNode = null;
        for (Node<E> node : source.getNodes()) {
            double strength = node.getForce();
            if (!(strength > 0.0)) continue;
            side3.put(node);
            if (!(strength > maxStrength)) continue;
            maxStrength = strength;
            maxStrengthNode = node;
        }
        result.swap(maxStrengthNode, side3, side1);
        result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side1, side3), side3, side2);
        int count = side3.count() + 1;
        while (side3.count() < count) {
            count = side3.count();
            result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side1, side2), side3, side2);
            result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side2, side1), side3, side1);
        }
        double sidedness = GraphUtils.sidedness(source, result) - 1.0;
        while (sidedness < GraphUtils.sidedness(source, result)) {
            sidedness = GraphUtils.sidedness(source, result);
            result.swap(GraphUtils.maxStrengthNode(side1.getItems(), side1, side2), side1, side2);
            result.swap(GraphUtils.maxStrengthNode(side2.getItems(), side2, side1), side2, side1);
        }
        return result;
    }

    private static <E> double strengthRate(Node<E> node, Cluster<Node<E>> cluster1, Cluster<Node<E>> cluster2) {
        double strength1 = 0.0;
        double strength2 = 0.0;
        for (Link link : node.getLinks()) {
            Node<E> other = link.getOtherNode(node);
            if (cluster1.getItems().contains(other)) {
                strength1 = link.getWeight();
                continue;
            }
            if (!cluster2.getItems().contains(other)) continue;
            strength2 = link.getWeight();
        }
        double result = strength1 / strength2;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <E> StringList writePajekNetwork(Graph<E> source, List<String> partitionLabels) throws PuckException {
        Links<E> edges;
        StringList result = new StringList(100);
        result.appendln("*Network " + source.getLabel());
        result.appendln();
        result.appendln("*vertices " + source.nodeCount());
        int nodeIndex = 1;
        while (nodeIndex <= source.nodeCount()) {
            Node<E> node = source.getNodes().get(nodeIndex);
            if (StringUtils.isBlank((CharSequence)node.getTag())) {
                result.appendln(String.valueOf(nodeIndex) + " '" + node.getLabel() + "'");
            } else {
                result.appendln(String.valueOf(nodeIndex) + " '" + node.getLabel() + "' " + node.getTag());
            }
            ++nodeIndex;
        }
        Links<E> arcs = source.getArcs();
        if (arcs.isNotEmpty()) {
            List<String> tags = arcs.getTags();
            if (tags.isEmpty()) {
                result.appendln("*arcs");
                for (Link link : arcs) {
                    result.appendln(String.valueOf(link.getSourceNode().getId()) + " " + link.getTargetNode().getId() + " " + link.getWeightAsInt());
                }
            } else {
                Collections.sort(tags);
                for (String string : tags) {
                    result.appendln("*arcs " + string);
                    for (Link link : arcs.getByTag(string)) {
                        result.appendln(String.valueOf(link.getSourceNode().getId()) + " " + link.getTargetNode().getId() + " " + link.getWeightAsInt());
                    }
                }
            }
        }
        if (!(edges = source.getEdges()).isEmpty()) {
            result.appendln("*edges");
            for (Link link : edges) {
                result.appendln(String.valueOf(link.getSourceNode().getId()) + " " + link.getTargetNode().getId() + " " + link.getWeightAsInt());
            }
        }
        for (String string : partitionLabels) {
            void var7_18;
            String type;
            result.appendln();
            logger.debug("label=[" + string + "]");
            Partition<Node<E>> partition = PartitionMaker.create(string, source.getNodes().toList(), PartitionCriteria.createRaw(string));
            if (partition.isNumeric()) {
                type = "Vector";
            } else {
                type = "Partition";
                Partition<Node<E>> partition2 = PartitionMaker.createNumerized(partition);
            }
            result.appendln("*" + type + " " + var7_18.getLabel());
            result.appendln("*vertices " + source.nodeCount());
            int nodeIndex2 = 1;
            while (nodeIndex2 <= source.nodeCount()) {
                Node<E> node = source.getNodes().get(nodeIndex2);
                result.appendln(var7_18.getValue(node).intValue());
                ++nodeIndex2;
            }
        }
        return result;
    }
}

