/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import org.tip.puck.evo.Evo;
import org.tip.puck.evo.EvoGenCallbacks;
import org.tip.puck.evo.Generator;
import org.tip.puck.evo.PopGenerator;

public class EvoGen
extends Evo {
    private PopGenerator popgen;
    private EvoGenCallbacks callbacks;
    private int generations;
    private Generator bestGenerator;
    protected int curgen;
    protected double bestGenFitness;
    protected double meanGenoSize;
    protected double genTime;
    protected double simTime;
    protected double fitTime;

    public EvoGen(PopGenerator popgen, EvoGenCallbacks callbacks, int generations) {
        this.popgen = popgen;
        this.callbacks = callbacks;
        int i = 0;
        while (i < popgen.popSize()) {
            Generator gen = callbacks.baseGenerator().clone();
            gen.initProgsRandom();
            this.population.add(gen);
            ++i;
        }
        this.generations = generations;
        this.bestGenerator = null;
        this.curgen = 0;
        this.bestFitness = Double.MAX_VALUE;
        this.bestGenFitness = Double.MAX_VALUE;
        this.meanGenoSize = 0.0;
        this.genTime = 0.0;
        this.simTime = 0.0;
        this.fitTime = 0.0;
    }

    @Override
    public int getPopulationSize() {
        return this.popgen.popSize();
    }

    @Override
    public void run() {
        this.curgen = 0;
        while (this.curgen < this.generations) {
            long startTime = System.currentTimeMillis();
            this.meanGenoSize = 0.0;
            this.simTime = 0.0;
            this.fitTime = 0.0;
            this.bestGenFitness = Double.MAX_VALUE;
            boolean first = false;
            int j = 0;
            while (j < this.popgen.popSize()) {
                Generator generator = (Generator)this.population.get(j);
                this.meanGenoSize += (double)generator.genotypeSize();
                if (!generator.simulated) {
                    long time0 = System.currentTimeMillis();
                    generator.run();
                    this.simTime += (double)(System.currentTimeMillis() - time0);
                    time0 = System.currentTimeMillis();
                    generator.fitness = this.callbacks.computeFitness(generator);
                    this.fitTime += (double)(System.currentTimeMillis() - time0);
                    generator.postFitness = generator.fitness;
                    if (first || generator.fitness < this.bestGenFitness) {
                        first = false;
                        this.bestGenFitness = generator.fitness;
                    }
                    generator.simulated = true;
                }
                if (this.curgen == 0 && j == 0 || generator.fitness < this.bestFitness) {
                    this.bestFitness = generator.fitness;
                    this.bestGenerator = generator;
                    this.callbacks.onNewBest(this);
                }
                ++j;
            }
            if (this.postFitness != null) {
                this.postFitness.postProcessFitness(this);
            }
            this.meanGenoSize /= (double)this.popgen.popSize();
            this.population = this.popgen.newGeneration(this);
            this.genTime = System.currentTimeMillis() - startTime;
            this.genTime /= 1000.0;
            this.simTime /= 1000.0;
            this.fitTime /= 1000.0;
            this.callbacks.onGeneration(this);
            ++this.curgen;
        }
    }

    @Override
    public String infoString() {
        String str = "population size: " + this.popgen.popSize() + "\n";
        str = String.valueOf(str) + "generations: " + this.generations + "\n";
        str = String.valueOf(str) + this.callbacks.infoString();
        str = String.valueOf(str) + this.popgen.infoString();
        return str;
    }

    public String genInfoString() {
        String tmpstr = "gen #" + this.curgen + "; best fitness: " + this.bestFitness + "; best gen fitness: " + this.bestGenFitness + "; best genotype size: " + this.bestGenerator.genotypeSize() + "; mean genotype size: " + this.meanGenoSize + "; gen comp time: " + this.genTime + "s." + "; sim comp time: " + this.simTime + "s." + "; fit comp time: " + this.fitTime + "s.";
        return tmpstr;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public void setCallbacks(EvoGenCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public int getCurgen() {
        return this.curgen;
    }

    public double getBestGenFitness() {
        return this.bestGenFitness;
    }

    public double getMeanGenoSize() {
        return this.meanGenoSize;
    }

    public double getGenTime() {
        return this.genTime;
    }

    public double getSimTime() {
        return this.simTime;
    }

    public double getFitTime() {
        return this.fitTime;
    }

    public Generator getBestGenerator() {
        return this.bestGenerator;
    }
}

