/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puckgui.views.ValuateExogenousAttributeCriteria;

public class ValuateExogenousAttributeDialog
extends JDialog {
    private static final long serialVersionUID = 159505630124471904L;
    private static final Logger logger = LoggerFactory.getLogger(ValuateExogenousAttributeDialog.class);
    private final JPanel contentPanel = new JPanel();
    private ValuateExogenousAttributeCriteria dialogCriteria;
    private static ValuateExogenousAttributeCriteria lastCriteria = new ValuateExogenousAttributeCriteria();
    private JComboBox cmbbxTarget;
    private JComboBox cmbbxSourceLabel;
    private JTextField txtfldTargetLabel;
    private JTextField txtfldValuePrefix;

    public ValuateExogenousAttributeDialog() {
        ArrayList<String> targetLabels = new ArrayList<String>();
        targetLabels.add("INDIVIDUALS");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Remove Attribute Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ValuateExogenousAttributeDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ValuateExogenousAttributeDialog.this.dialogCriteria = null;
                ValuateExogenousAttributeDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 366, 235);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblScope = new JLabel("Scope:");
        this.contentPanel.add((Component)lblScope, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JLabel lblSourceLabel = new JLabel("Source Label:");
        this.contentPanel.add((Component)lblSourceLabel, "2, 4, right, default");
        this.cmbbxSourceLabel = new JComboBox<IndividualValuator.EndogenousLabel>(IndividualValuator.EndogenousLabel.values());
        this.contentPanel.add((Component)this.cmbbxSourceLabel, "4, 4, fill, default");
        JLabel lblTargetLabel = new JLabel("Target Label:");
        this.contentPanel.add((Component)lblTargetLabel, "2, 6, right, default");
        this.txtfldTargetLabel = new JTextField();
        this.contentPanel.add((Component)this.txtfldTargetLabel, "4, 6, fill, default");
        this.txtfldTargetLabel.setColumns(10);
        JLabel lblPrefixValue = new JLabel("Prefix value:");
        this.contentPanel.add((Component)lblPrefixValue, "2, 8, right, default");
        this.txtfldValuePrefix = new JTextField();
        this.contentPanel.add((Component)this.txtfldValuePrefix, "4, 8, fill, default");
        this.txtfldValuePrefix.setColumns(10);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuateExogenousAttributeDialog.this.dialogCriteria = null;
                ValuateExogenousAttributeDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getTargetLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter a target label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    ValuateExogenousAttributeDialog.this.dialogCriteria = criteria;
                    ValuateExogenousAttributeDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public ValuateExogenousAttributeCriteria getCriteria() {
        ValuateExogenousAttributeCriteria result = new ValuateExogenousAttributeCriteria();
        result.setScope(AttributeWorker.Scope.INDIVIDUALS);
        logger.debug("===> " + this.cmbbxSourceLabel.getSelectedItem());
        result.setSourceLabel(this.cmbbxSourceLabel.getSelectedItem().toString());
        result.setTargetLabel(this.txtfldTargetLabel.getText());
        result.setValuePrefix(this.txtfldValuePrefix.getText());
        return result;
    }

    public ValuateExogenousAttributeCriteria getDialogCriteria() {
        ValuateExogenousAttributeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(ValuateExogenousAttributeCriteria source) {
        if (source != null) {
            this.cmbbxSourceLabel.setSelectedItem(source.getSourceLabel());
            if (this.cmbbxSourceLabel.getSelectedIndex() == -1) {
                this.cmbbxSourceLabel.setSelectedIndex(0);
            }
            if (source.getTargetLabel() != null) {
                this.txtfldTargetLabel.setText(source.getTargetLabel());
            }
            if (source.getValuePrefix() != null) {
                this.txtfldTargetLabel.setText(source.getValuePrefix());
            }
        }
    }

    public static void main(String[] args) {
        ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.showDialog();
    }

    public static ValuateExogenousAttributeCriteria showDialog() {
        ValuateExogenousAttributeDialog dialog = new ValuateExogenousAttributeDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        ValuateExogenousAttributeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

