/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.workers.PartitionReporter;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Labels;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.FooReporterInputWindow;
import org.tip.puckgui.views.PartitionCriteriaPanel;

public class PartitionInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(PartitionInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private PartitionCriteriaPanel partitionCriteriaPanel;

    public PartitionInputWindow(final NetGUI netGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Partition Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 454, 317);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PartitionCriteria criteria = PartitionInputWindow.this.partitionCriteriaPanel.getCriteria();
                    Report report = PartitionReporter.reportBasicInformation(netGUI.getNet(), criteria);
                    netGUI.addReportTab(report);
                    PartitionInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(PartitionInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        List<Labels> modelsLabels = Segmentation.buildModelLabels(netGUI.getCurrentIndividuals(), netGUI.getCurrentFamilies(), netGUI.getNet().relationModels(), netGUI.getNet().relations());
        this.partitionCriteriaPanel = new PartitionCriteriaPanel(modelsLabels);
        this.contentPane.add((Component)this.partitionCriteriaPanel, "Center");
    }
}

