/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.util.Labels;
import org.tip.puck.util.MathUtils;

public class PartitionCriteriaPanel
extends JPanel {
    private static final long serialVersionUID = 8629535949909082139L;
    private static PartitionCriteria defaultCriteria = null;
    private List<String> modelLabels;
    private JTextField txtfldParameter;
    private JTextField txtfldPattern;
    private JTextField txtfldCountedStart;
    private JTextField txtfldCountedCount;
    private JTextField txtfldCountedEnd;
    private JTextField txtfldSteps;
    private JTextField txtfldSizedStart;
    private JTextField txtfldSizedSize;
    private JTextField txtfldSizedEnd;
    private JPanel panelRaw;
    private JPanel panelBinarization;
    private JPanel panelFreeGrouping;
    private JPanel panelCountedGrouping;
    private JPanel panelSizedGrouping;
    private final ButtonGroup buttonGroupType = new ButtonGroup();
    private JComboBox cmbbxLabel;
    private final ButtonGroup buttonGroupScope = new ButtonGroup();
    private JRadioButton rdbtnSome;
    private JRadioButton rdbtnAll;
    private JComboBox cmbbxModel;

    public PartitionCriteriaPanel(final List<Labels> modelsLabels) {
        ArrayList<String> modelLabels = new ArrayList<String>();
        for (Labels labels : modelsLabels) {
            modelLabels.add(labels.getName());
            labels.sort();
        }
        this.setBorder(new TitledBorder(null, "Partition Criteria", 4, 2, null, null));
        this.setLayout(new BoxLayout(this, 1));
        JPanel panelGenericData2 = new JPanel();
        panelGenericData2.setAlignmentX(0.0f);
        this.add(panelGenericData2);
        panelGenericData2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblModel = new JLabel("Model:");
        panelGenericData2.add((Component)lblModel, "2, 2, right, default");
        this.cmbbxModel = new JComboBox<Object>(modelLabels.toArray());
        this.cmbbxModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedModel = PartitionCriteriaPanel.this.cmbbxModel.getSelectedIndex();
                if (PartitionCriteriaPanel.this.cmbbxLabel != null) {
                    PartitionCriteriaPanel.this.cmbbxLabel.setModel(new DefaultComboBoxModel<Object>(((Labels)modelsLabels.get(selectedModel)).toArray()));
                }
            }
        });
        this.cmbbxModel.setSelectedIndex(0);
        this.cmbbxModel.setMaximumRowCount(12);
        panelGenericData2.add((Component)this.cmbbxModel, "4, 2, 3, 1, fill, default");
        JLabel lblLabel = new JLabel("Label:");
        panelGenericData2.add((Component)lblLabel, "2, 4");
        this.cmbbxLabel = new JComboBox<Object>(new DefaultComboBoxModel<Object>(modelsLabels.get(0).toArray()));
        panelGenericData2.add((Component)this.cmbbxLabel, "4, 4");
        this.cmbbxLabel.setSelectedIndex(0);
        this.cmbbxLabel.setMaximumRowCount(12);
        this.cmbbxLabel.setEditable(true);
        JLabel lblParameter = new JLabel("Parameter:");
        panelGenericData2.add((Component)lblParameter, "6, 4");
        this.txtfldParameter = new JTextField();
        panelGenericData2.add((Component)this.txtfldParameter, "8, 4");
        this.txtfldParameter.setColumns(10);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.add(verticalStrut);
        JPanel panel_2 = new JPanel();
        panel_2.setAlignmentX(0.0f);
        this.add(panel_2);
        panel_2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblType = new JLabel("Type:");
        panel_2.add((Component)lblType, "2, 2, left, top");
        JPanel panelPartitionType = new JPanel();
        panelPartitionType.setAlignmentX(0.0f);
        this.add(panelPartitionType);
        panelPartitionType.setLayout(new BoxLayout(panelPartitionType, 0));
        JPanel panelPartitionTypes = new JPanel();
        panelPartitionTypes.setAlignmentY(0.0f);
        panelPartitionType.add(panelPartitionTypes);
        panelPartitionTypes.setLayout(new BoxLayout(panelPartitionTypes, 1));
        JRadioButton rdbtnRaw = new JRadioButton("Raw");
        this.buttonGroupType.add(rdbtnRaw);
        rdbtnRaw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaPanel.this.display(PartitionCriteria.PartitionType.RAW);
            }
        });
        rdbtnRaw.setSelected(true);
        panelPartitionTypes.add(rdbtnRaw);
        JRadioButton rdbtnBinarization = new JRadioButton("Binarization");
        this.buttonGroupType.add(rdbtnBinarization);
        rdbtnBinarization.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaPanel.this.display(PartitionCriteria.PartitionType.BINARIZATION);
            }
        });
        panelPartitionTypes.add(rdbtnBinarization);
        JRadioButton rdbtnFreeGrouping = new JRadioButton("Free Grouping");
        this.buttonGroupType.add(rdbtnFreeGrouping);
        rdbtnFreeGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaPanel.this.display(PartitionCriteria.PartitionType.FREE_GROUPING);
            }
        });
        panelPartitionTypes.add(rdbtnFreeGrouping);
        JRadioButton rdbtnCountedGrouping = new JRadioButton("Counted Grouping");
        this.buttonGroupType.add(rdbtnCountedGrouping);
        rdbtnCountedGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaPanel.this.display(PartitionCriteria.PartitionType.COUNTED_GROUPING);
            }
        });
        panelPartitionTypes.add(rdbtnCountedGrouping);
        JRadioButton rdbtnSizedGrouping = new JRadioButton("Sized Grouping");
        this.buttonGroupType.add(rdbtnSizedGrouping);
        rdbtnSizedGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaPanel.this.display(PartitionCriteria.PartitionType.SIZED_GROUPING);
            }
        });
        panelPartitionTypes.add(rdbtnSizedGrouping);
        JPanel panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panelPartitionType.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        this.panelRaw = new JPanel();
        panel.add(this.panelRaw);
        this.panelBinarization = new JPanel();
        panel.add(this.panelBinarization);
        this.panelBinarization.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_1 = new JLabel(" ");
        this.panelBinarization.add((Component)label_1, "2, 2");
        JLabel lblPattern = new JLabel("Pattern:");
        this.panelBinarization.add((Component)lblPattern, "2, 4, right, default");
        this.txtfldPattern = new JTextField();
        this.panelBinarization.add((Component)this.txtfldPattern, "4, 4, fill, default");
        this.txtfldPattern.setColumns(10);
        this.panelFreeGrouping = new JPanel();
        panel.add(this.panelFreeGrouping);
        this.panelFreeGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNewLabel = new JLabel(" ");
        this.panelFreeGrouping.add((Component)lblNewLabel, "2, 2");
        JLabel label = new JLabel(" ");
        this.panelFreeGrouping.add((Component)label, "2, 4");
        JLabel lblSteps = new JLabel("Steps:");
        this.panelFreeGrouping.add((Component)lblSteps, "2, 6, right, default");
        this.txtfldSteps = new JTextField();
        this.panelFreeGrouping.add((Component)this.txtfldSteps, "4, 6, fill, default");
        this.txtfldSteps.setColumns(10);
        JLabel lblExample = new JLabel("e.g. 1990 1993 2000");
        this.panelFreeGrouping.add((Component)lblExample, "4, 8");
        this.panelCountedGrouping = new JPanel();
        panel.add(this.panelCountedGrouping);
        this.panelCountedGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_4 = new JLabel("    ");
        this.panelCountedGrouping.add((Component)label_4, "2, 2");
        JLabel lblStart = new JLabel("Start:");
        this.panelCountedGrouping.add((Component)lblStart, "2, 4, right, default");
        this.txtfldCountedStart = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedStart, "4, 4, fill, default");
        this.txtfldCountedStart.setColumns(10);
        JLabel lblCount = new JLabel("Count:");
        this.panelCountedGrouping.add((Component)lblCount, "2, 6, right, default");
        this.txtfldCountedCount = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedCount, "4, 6, fill, default");
        this.txtfldCountedCount.setColumns(10);
        JLabel lblEnd = new JLabel("End:");
        this.panelCountedGrouping.add((Component)lblEnd, "2, 8, right, default");
        this.txtfldCountedEnd = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedEnd, "4, 8, fill, default");
        this.txtfldCountedEnd.setColumns(10);
        this.panelSizedGrouping = new JPanel();
        panel.add(this.panelSizedGrouping);
        this.panelSizedGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_2 = new JLabel("    ");
        this.panelSizedGrouping.add((Component)label_2, "2, 2");
        JLabel lblStart_1 = new JLabel("Start:");
        this.panelSizedGrouping.add((Component)lblStart_1, "2, 4, right, default");
        this.txtfldSizedStart = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedStart, "4, 4, fill, default");
        this.txtfldSizedStart.setColumns(10);
        JLabel lblSize = new JLabel("Size:");
        this.panelSizedGrouping.add((Component)lblSize, "2, 6, right, default");
        this.txtfldSizedSize = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedSize, "4, 6, fill, default");
        this.txtfldSizedSize.setColumns(10);
        JLabel lblEnd_1 = new JLabel("End:");
        this.panelSizedGrouping.add((Component)lblEnd_1, "2, 8, right, default");
        this.txtfldSizedEnd = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedEnd, "4, 8, fill, default");
        this.txtfldSizedEnd.setColumns(10);
        JPanel panelFamilyScope = new JPanel();
        panelFamilyScope.setAlignmentX(0.0f);
        this.add(panelFamilyScope);
        panelFamilyScope.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblFamilyScope = new JLabel("Family Scope:");
        panelFamilyScope.add((Component)lblFamilyScope, "2, 2");
        this.rdbtnSome = new JRadioButton("Some");
        this.buttonGroupScope.add(this.rdbtnSome);
        panelFamilyScope.add((Component)this.rdbtnSome, "4, 2");
        this.rdbtnSome.setSelected(true);
        this.rdbtnAll = new JRadioButton("All");
        this.buttonGroupScope.add(this.rdbtnAll);
        panelFamilyScope.add((Component)this.rdbtnAll, "6, 2");
        JPanel panel_1 = new JPanel();
        panel_1.setAlignmentX(0.0f);
        this.add(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        this.display(PartitionCriteria.PartitionType.RAW);
        if (defaultCriteria != null) {
            if (defaultCriteria.getLabelParameter() != null) {
                this.txtfldParameter.setText(defaultCriteria.getLabelParameter());
            }
            if (defaultCriteria.getType() != null) {
                this.display(defaultCriteria.getType());
                switch (defaultCriteria.getType()) {
                    case RAW: {
                        rdbtnRaw.setSelected(true);
                        break;
                    }
                    case BINARIZATION: {
                        rdbtnBinarization.setSelected(true);
                        if (defaultCriteria.getPattern() == null) break;
                        this.txtfldPattern.setText(defaultCriteria.getPattern());
                        break;
                    }
                    case FREE_GROUPING: {
                        rdbtnFreeGrouping.setSelected(true);
                        if (defaultCriteria.getIntervals() == null) break;
                        this.txtfldSteps.setText(defaultCriteria.getIntervals().toBasicStepString());
                        break;
                    }
                    case COUNTED_GROUPING: {
                        rdbtnCountedGrouping.setSelected(true);
                        if (defaultCriteria.getStart() != null) {
                            this.txtfldCountedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
                        }
                        if (defaultCriteria.getCount() != null) {
                            this.txtfldCountedCount.setText(MathUtils.toString(defaultCriteria.getCount()));
                        }
                        if (defaultCriteria.getEnd() == null) break;
                        this.txtfldCountedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
                        break;
                    }
                    case SIZED_GROUPING: {
                        rdbtnSizedGrouping.setSelected(true);
                        if (defaultCriteria.getStart() != null) {
                            this.txtfldSizedStart.setText(MathUtils.toString(defaultCriteria.getStart()));
                        }
                        if (defaultCriteria.getSize() != null) {
                            this.txtfldSizedSize.setText(MathUtils.toString(defaultCriteria.getSize()));
                        }
                        if (defaultCriteria.getEnd() == null) break;
                        this.txtfldSizedEnd.setText(MathUtils.toString(defaultCriteria.getEnd()));
                    }
                }
            }
            if (defaultCriteria.getFamilyScope() == PartitionCriteria.FamilyScope.SOME) {
                this.rdbtnSome.setSelected(true);
                this.rdbtnAll.setSelected(false);
            } else {
                this.rdbtnAll.setSelected(true);
                this.rdbtnSome.setSelected(false);
            }
        }
    }

    public void display(PartitionCriteria.PartitionType type) {
        this.panelRaw.setVisible(false);
        this.panelBinarization.setVisible(false);
        this.panelFreeGrouping.setVisible(false);
        this.panelCountedGrouping.setVisible(false);
        this.panelSizedGrouping.setVisible(false);
        switch (type) {
            case RAW: {
                this.panelRaw.setVisible(true);
                break;
            }
            case BINARIZATION: {
                this.panelBinarization.setVisible(true);
                break;
            }
            case FREE_GROUPING: {
                this.panelFreeGrouping.setVisible(true);
                break;
            }
            case COUNTED_GROUPING: {
                this.panelCountedGrouping.setVisible(true);
                break;
            }
            case SIZED_GROUPING: {
                this.panelSizedGrouping.setVisible(true);
            }
        }
    }

    public PartitionCriteria getCriteria() {
        PartitionCriteria result;
        String relationModelName = (String)this.cmbbxModel.getSelectedItem();
        String label = (String)this.cmbbxLabel.getSelectedItem();
        String parameter = this.txtfldParameter.getText();
        if (this.panelRaw.isVisible()) {
            result = PartitionCriteria.createRaw(label, parameter);
            result.setRelationModelName(relationModelName);
        } else if (this.panelBinarization.isVisible()) {
            result = PartitionCriteria.createBinarization(label, this.txtfldParameter.getText(), this.txtfldPattern.getText());
            result.setRelationModelName(relationModelName);
        } else if (this.panelFreeGrouping.isVisible()) {
            result = PartitionCriteria.createGrouping(label, this.txtfldParameter.getText(), this.txtfldSteps.getText());
            result.setRelationModelName(relationModelName);
        } else if (this.panelCountedGrouping.isVisible()) {
            Double start = NumberUtils.isNumber((String)this.txtfldCountedStart.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedStart.getText())) : null;
            Double count = NumberUtils.isNumber((String)this.txtfldCountedCount.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedCount.getText())) : null;
            Double end = NumberUtils.isNumber((String)this.txtfldCountedEnd.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedEnd.getText())) : null;
            result = PartitionCriteria.createCountedGrouping(label, parameter, start, count, end);
            result.setRelationModelName(relationModelName);
        } else if (this.panelSizedGrouping.isVisible()) {
            Double start = NumberUtils.isNumber((String)this.txtfldSizedStart.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedStart.getText())) : null;
            Double size = NumberUtils.isNumber((String)this.txtfldSizedSize.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedSize.getText())) : null;
            Double end = NumberUtils.isNumber((String)this.txtfldSizedEnd.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedEnd.getText())) : null;
            result = PartitionCriteria.createSizedGrouping(label, parameter, start, size, end);
            result.setRelationModelName(relationModelName);
        } else {
            result = null;
        }
        if (this.rdbtnSome.isSelected()) {
            result.setFamilyScope(PartitionCriteria.FamilyScope.SOME);
        } else {
            result.setFamilyScope(PartitionCriteria.FamilyScope.ALL);
        }
        defaultCriteria = result;
        return result;
    }
}

