/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.dat.DATFile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puck.visualization.VisualizationController;
import org.tip.puck.visualization.style.implementations.AllianceNetwork;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.AboutPopup;
import org.tip.puckgui.views.GenerateRulesInputWindow;
import org.tip.puckgui.views.GroupNetInfosPanel;
import org.tip.puckgui.views.MainWindow;
import org.tip.puckgui.views.RandomAllianceNetworkByAgentSimulationInputWindow;
import org.tip.puckgui.views.RandomAllianceNetworkByAgentSimulationVariationsInputWindow;
import org.tip.puckgui.views.RandomAllianceNetworkByRandomDistributionInputWindow;
import org.tip.puckgui.views.RandomPermutationInputWindow;
import org.tip.puckgui.views.ReportPanel;
import org.tip.puckgui.views.ReportsPanel;
import org.tip.puckgui.views.ReshufflingAllianceNetworkInputWindow;
import org.tip.puckgui.views.VirtualFieldworkInputWindow;
import org.tip.puckgui.views.VirtualFieldworkVariationsInputWindow;
import org.tip.puckgui.views.WindowMenuItem;
import org.tip.puckgui.views.visualization.VisualizationPanel;

public class GroupNetWindow
extends JFrame {
    private static final long serialVersionUID = 1973988817198888692L;
    private static final Logger logger = LoggerFactory.getLogger(GroupNetWindow.class);
    private static final ResourceBundle messsges = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private GroupNetGUI gui;
    private JFrame thisFrame = this;
    private JPanel contentPane;
    private int reportCounter = 0;
    private JTabbedPane tabbedPane;

    public GroupNetWindow(final GroupNetGUI gui) {
        this.gui = gui;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("Closing event.");
                GroupNetWindow.this.performCloseWindow();
            }
        });
        this.setTitle("Group Network");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GroupNetWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 0, 1020, MainWindow.getDesktopHeight());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        mnFile.setMnemonic('F');
        menuBar.add(mnFile);
        JMenu mnNew = new JMenu(messsges.getString("MainWindow.mnNew.text"));
        mnFile.add(mnNew);
        JMenuItem mntmBlankCorpus = new JMenuItem(messsges.getString("MainWindow.mntmBlankCorpus.text"));
        mntmBlankCorpus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PuckGUI.instance().createNetGUI();
            }
        });
        mnNew.add(mntmBlankCorpus);
        JMenuItem mntmRandomNetworkby = new JMenuItem(messsges.getString("GroupNetWindow.mntmRandomNetworkby.text"));
        mntmRandomNetworkby.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomAllianceNetworkByRandomDistributionInputWindow window = new RandomAllianceNetworkByRandomDistributionInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnNew.add(mntmRandomNetworkby);
        JMenuItem mntmRandomNetworkby_1 = new JMenuItem(messsges.getString("GroupNetWindow.mntmRandomNetworkby_1.text"));
        mntmRandomNetworkby_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RandomAllianceNetworkByAgentSimulationInputWindow window = new RandomAllianceNetworkByAgentSimulationInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnNew.add(mntmRandomNetworkby_1);
        JMenuItem mntmRandomNetworkVariation = new JMenuItem(messsges.getString("GroupNetWindow.mntmRandomNetworkVariation.text"));
        mntmRandomNetworkVariation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RandomAllianceNetworkByAgentSimulationVariationsInputWindow window = new RandomAllianceNetworkByAgentSimulationVariationsInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnNew.add(mntmRandomNetworkVariation);
        JSeparator separator_1 = new JSeparator();
        mnFile.add(separator_1);
        JMenuItem mntmExportToPajek = new JMenuItem(messsges.getString("GroupNetWindow.mntmExportToPajek.text"));
        mntmExportToPajek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = new File("groupNetExport.paj");
                    boolean ended = false;
                    while (!ended) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setSelectedFile(targetFile);
                        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                        chooser.setFileSelectionMode(0);
                        chooser.setAcceptAllFileFilterUsed(false);
                        GenericFileFilter defaultFileFilter = new GenericFileFilter("Pajek files (*.paj)", "paj");
                        chooser.addChoosableFileFilter(defaultFileFilter);
                        chooser.setFileFilter(defaultFileFilter);
                        if (chooser.showSaveDialog(GroupNetWindow.this.thisFrame) == 0) {
                            boolean doSave;
                            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                            targetFile = chooser.getSelectedFile();
                            if (targetFile.exists()) {
                                String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                                String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                                int response = JOptionPane.showConfirmDialog(GroupNetWindow.this.thisFrame, message, title, 1);
                                if (response == 0) {
                                    doSave = true;
                                    ended = true;
                                } else if (response == 1) {
                                    doSave = false;
                                    ended = false;
                                } else {
                                    doSave = false;
                                    ended = true;
                                }
                            } else {
                                doSave = true;
                                ended = true;
                            }
                            if (!doSave) continue;
                            PAJFile.exportToPajek(gui.getGroupNet(), targetFile.getAbsolutePath(), (List<String>)ClusterNetworkReporter.ALLIANCE_NETWORK_PARTITION_LABELS);
                            continue;
                        }
                        System.out.println("No Selection ");
                        ended = true;
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        JMenuItem mntmImportFromDat = new JMenuItem(messsges.getString("GroupNetWindow.mntmImportFromDat.text"));
        mntmImportFromDat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = GroupNetWindow.selectDatFile(GroupNetWindow.this.thisFrame, null);
                    if (file != null) {
                        Graph<Cluster<Individual>> graph = DATFile.load(file);
                        PuckGUI.instance().createGroupNetGUI(graph);
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnFile.add(mntmImportFromDat);
        mnFile.add(mntmExportToPajek);
        JMenuItem mntmExportToMatrixDatFile = new JMenuItem(messsges.getString("GroupNetWindow.mntmMatrixToDat.text"));
        mntmExportToMatrixDatFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = new File("groupNetExport.dat");
                    boolean ended = false;
                    while (!ended) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setSelectedFile(targetFile);
                        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                        chooser.setFileSelectionMode(0);
                        chooser.setAcceptAllFileFilterUsed(false);
                        GenericFileFilter defaultFileFilter = new GenericFileFilter("Dat files (*.dat)", "dat");
                        chooser.addChoosableFileFilter(defaultFileFilter);
                        chooser.setFileFilter(defaultFileFilter);
                        if (chooser.showSaveDialog(GroupNetWindow.this.thisFrame) == 0) {
                            boolean doSave;
                            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                            targetFile = chooser.getSelectedFile();
                            if (targetFile.exists()) {
                                String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                                String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                                int response = JOptionPane.showConfirmDialog(GroupNetWindow.this.thisFrame, message, title, 1);
                                if (response == 0) {
                                    doSave = true;
                                    ended = true;
                                } else if (response == 1) {
                                    doSave = false;
                                    ended = false;
                                } else {
                                    doSave = false;
                                    ended = true;
                                }
                            } else {
                                doSave = true;
                                ended = true;
                            }
                            if (!doSave) continue;
                            DATFile.exportToDAT(gui.getGroupNet(), targetFile.getAbsolutePath());
                            continue;
                        }
                        System.out.println("No Selection ");
                        ended = true;
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnFile.add(mntmExportToMatrixDatFile);
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmClose = new JMenuItem(messsges.getString("MainWindow.mntmClose.text"));
        mntmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupNetWindow.this.performCloseGroupNet();
            }
        });
        mntmClose.setToolTipText(messsges.getString("MainWindow.mntmClose.toolTipText"));
        mntmClose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        mnFile.add(mntmClose);
        JMenuItem mntmQuit = new JMenuItem(messsges.getString("MainWindow.mntmQuit.text"));
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupNetWindow.this.performQuit();
            }
        });
        JSeparator separator_2 = new JSeparator();
        mnFile.add(separator_2);
        mntmQuit.setMnemonic('Q');
        mntmQuit.setToolTipText(messsges.getString("MainWindow.mntmQuit.toolTipText"));
        mnFile.add(mntmQuit);
        JMenu mnGroupNetwork = new JMenu(messsges.getString("GroupNetWindow.mnGroupNetwork.text"));
        menuBar.add(mnGroupNetwork);
        JMenuItem mntmMatrix = new JMenuItem("Matrix");
        mntmMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportMatrix(gui.getGroupNet());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnGroupNetwork.add(mntmMatrix);
        JMenuItem mntmCouples = new JMenuItem("Couples");
        mntmCouples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportCouples(gui.getGroupNet(), ((Attribute)gui.getGroupNet().attributes().get("Arc Type")).getValue());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnGroupNetwork.add(mntmCouples);
        JMenuItem mntmSortableList = new JMenuItem("Sortable List");
        mntmSortableList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportSortableList(gui.getGroupNet());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnGroupNetwork.add(mntmSortableList);
        JMenuItem mntmSides = new JMenuItem("Sides");
        mntmSides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportSides(gui.getGroupNet());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnGroupNetwork.add(mntmSides);
        JMenu mnTransform = new JMenu("Transform");
        menuBar.add(mnTransform);
        JMenuItem mntmRandomPermutation = new JMenuItem(messsges.getString("GroupNetWindow.mntmRandomPermutation.text"));
        mntmRandomPermutation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomPermutationInputWindow window = new RandomPermutationInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmRandomPermutation);
        JMenuItem mntmReshuffling = new JMenuItem(messsges.getString("GroupNetWindow.mntmReshuffling.text"));
        mntmReshuffling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReshufflingAllianceNetworkInputWindow window = new ReshufflingAllianceNetworkInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmReshuffling);
        JMenuItem mntmVirtualFieldwork = new JMenuItem(messsges.getString("GroupNetWindow.mntmVirtualFieldwork.text"));
        mntmVirtualFieldwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VirtualFieldworkInputWindow window = new VirtualFieldworkInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmVirtualFieldwork);
        JMenuItem mntmVirtualFieldworkVariations = new JMenuItem(messsges.getString("GroupNetWindow.mntmVirtualFiledworkVariations.text"));
        mntmVirtualFieldworkVariations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VirtualFieldworkVariationsInputWindow window = new VirtualFieldworkVariationsInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnTransform.add(mntmVirtualFieldworkVariations);
        JMenu mnCensus = new JMenu(messsges.getString("GroupNetWindow.mnCensus.text"));
        menuBar.add(mnCensus);
        JMenuItem mntmAnalysis = new JMenuItem(messsges.getString("GroupNetWindow.mntmAnalysis.text"));
        mntmAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportAnalysis(gui.getGroupNet());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmAnalysis);
        JMenuItem mntmDistributions = new JMenuItem(messsges.getString("GroupNetWindow.mntmDistributions.text"));
        mntmDistributions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = ClusterNetworkReporter.reportDistributions(gui.getGroupNet());
                    gui.addReportTab(report);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmDistributions);
        JMenuItem mntmGenerateRules = new JMenuItem(messsges.getString("GroupNetWindow.mntmGenerateRules.text"));
        mntmGenerateRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GenerateRulesInputWindow window = new GenerateRulesInputWindow(gui);
                    window.setDefaultCloseOperation(2);
                    window.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GroupNetWindow.this.thisFrame, message, title, 0);
                }
            }
        });
        mnCensus.add(mntmGenerateRules);
        JSeparator separator_3 = new JSeparator();
        mnCensus.add(separator_3);
        JMenuItem mntmSynopsis = new JMenuItem(messsges.getString("GroupNetWindow.mntmSynopsis.text"));
        mntmSynopsis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File file = GroupNetWindow.selectFolder(GroupNetWindow.this.thisFrame, null);
                if (file != null) {
                    String directory = file.getAbsolutePath();
                    Report report = GraphReporter.reportSynopsis(directory);
                    gui.addReportTab(report);
                }
            }
        });
        mnCensus.add(mntmSynopsis);
        JMenu mnDraw = new JMenu("Draw");
        menuBar.add(mnDraw);
        JMenuItem mntmAllianceNetworkGraph = new JMenuItem(messsges.getString("GroupNetWindow.mntmAllianceNetworkGraph.text"));
        mntmAllianceNetworkGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VisualizationController vizController = VisualizationController.getSharedInstance();
                    VisualizationPanel buildView = vizController.buildView(gui.getGroupNet(), AllianceNetwork.class);
                    gui.addTab("Alliance Network Draw", buildView);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnDraw.add(mntmAllianceNetworkGraph);
        JMenu mnWindows = new JMenu("Windows");
        mnWindows.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                windowsMenu.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent event) {
                JMenu windowsMenu = (JMenu)event.getSource();
                for (WindowGUI windowGUI : PuckGUI.instance().windowGUIs()) {
                    windowsMenu.add(new WindowMenuItem(windowGUI));
                }
            }
        });
        menuBar.add(mnWindows);
        JMenu mnHelp = new JMenu(messsges.getString("MainWindow.mnHelp.text"));
        mnHelp.setMnemonic('H');
        menuBar.add(mnHelp);
        JMenuItem mntmPuckHelp = new JMenuItem(messsges.getString("MainWindow.mntmOfficialWebSite.text"));
        mntmPuckHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.callPuckHelp((JMenuItem)event.getSource());
            }
        });
        mnHelp.add(mntmPuckHelp);
        JMenuItem mntmAboutPuck = new JMenuItem(messsges.getString("AboutPopup.this.title"));
        mntmAboutPuck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AboutPopup dialog = new AboutPopup();
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        mnHelp.add(mntmAboutPuck);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.tabbedPane = new JTabbedPane(1);
        this.contentPane.add(this.tabbedPane);
        GroupNetInfosPanel groupNetInfosPanel = new GroupNetInfosPanel(gui);
        this.tabbedPane.addTab(messsges.getString("GroupNetWindow.groupNetworkInfosPanel.title"), null, groupNetInfosPanel, null);
        this.updateTitle();
    }

    public void addReportTab(Report report) {
        ++this.reportCounter;
        JPanel reportPanel = report.containsSubReport() ? new ReportsPanel(this.gui, report) : new ReportPanel(this.gui, report);
        this.tabbedPane.addTab(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.reportTab.title")) + "(" + this.reportCounter + ")", null, reportPanel, null);
        this.tabbedPane.setSelectedComponent(reportPanel);
    }

    public void addTab(String title, JPanel panel) {
        this.tabbedPane.addTab(title, null, panel, null);
        this.tabbedPane.setSelectedComponent(panel);
    }

    public void closeCurrentTab() {
        this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
    }

    private void performCloseGroupNet() {
        if (PuckGUI.instance().windowGUIs().size() > 1) {
            boolean doClose;
            if (this.gui.isChanged()) {
                String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
                String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");
                int response = JOptionPane.showConfirmDialog(this.thisFrame, message, title, 0);
                doClose = response == 0;
            } else {
                doClose = true;
            }
            if (doClose) {
                PuckGUI.instance().close(this.gui);
                this.thisFrame.dispose();
            }
        }
    }

    private void performCloseWindow() {
        boolean doClose;
        if (this.gui.isChanged()) {
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.closeConfirm.existingChange.text");
            int response = JOptionPane.showConfirmDialog(this.thisFrame, message, title, 0);
            doClose = response == 0;
        } else {
            doClose = true;
        }
        if (doClose) {
            if (PuckGUI.instance().windowGUIs().size() == 1) {
                PuckGUI.instance().exit();
            } else {
                PuckGUI.instance().close(this.gui);
                this.thisFrame.dispose();
            }
        }
    }

    private void performQuit() {
        boolean doQuit;
        if (PuckGUI.instance().existsUnsavedChanges()) {
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.quitConfirm.existingChange.text");
            int response = JOptionPane.showConfirmDialog(this.thisFrame, message, title, 0);
            doQuit = response == 0;
        } else {
            doQuit = true;
        }
        if (doQuit) {
            PuckGUI.instance().exit();
        }
    }

    public void updateLocale(Locale locale) {
        this.thisFrame.setLocale(locale);
    }

    public void updateTitle() {
        String changeToken;
        if (this.gui.isChanged()) {
            changeToken = "*";
            this.thisFrame.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
        } else {
            changeToken = "";
            this.thisFrame.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        this.thisFrame.setTitle(String.valueOf(changeToken) + this.gui.getTitle() + " - Puck");
    }

    public static File selectDatFile(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(true);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Matrix Dat Files (*.dat)", "dat");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.addChoosableFileFilter(new GenericFileFilter("Dat (*.dat)", "dat"));
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }

    public static File selectFolder(JFrame parentPanel, File folder) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            chooser.setCurrentDirectory(folder);
        } else if (PuckGUI.instance().recentFolders().isEmpty()) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
        }
        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(true);
        if (chooser.showOpenDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            logger.debug("No Selection ");
            result = null;
        }
        return result;
    }
}

