/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.AttributesPanel;

public class CorpusPanel
extends JPanel {
    private static final long serialVersionUID = 1990081342527870857L;
    private static final Logger logger = LoggerFactory.getLogger(CorpusPanel.class);
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    JLabel lblFileNameValue;
    JLabel lblFileDateValue;
    JLabel lblFileSizeValue;
    JLabel lblIndividualCount;
    JLabel lblFamilyCount;
    private AttributesPanel attributesPanel;
    private JLabel lblRelationCount;
    private JLabel lblRelationModelCount;

    public CorpusPanel(NetGUI guiManager) {
        this.netGUI = guiManager;
        this.setVisible(true);
        this.setLayout(new BorderLayout(0, 0));
        JPanel generalPanel = new JPanel();
        this.add((Component)generalPanel, "North");
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel corpusStaticDataPanel = new JPanel();
        corpusStaticDataPanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "General", 4, 2, null, new Color(51, 51, 51)));
        corpusStaticDataPanel.setAlignmentX(0.0f);
        generalPanel.add(corpusStaticDataPanel);
        corpusStaticDataPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblFileName = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileName.text"));
        lblFileName.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblFileName, "2, 2");
        this.lblFileNameValue = new JLabel("-");
        this.lblFileNameValue.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblFileNameValue, "4, 2");
        JLabel lblFileDate = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileDate.text"));
        lblFileDate.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblFileDate, "2, 4");
        this.lblFileDateValue = new JLabel("-");
        this.lblFileDateValue.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblFileDateValue, "4, 4");
        JLabel lblFileSize = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFileSize.text"));
        lblFileSize.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblFileSize, "2, 6");
        this.lblFileSizeValue = new JLabel("-");
        this.lblFileSizeValue.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblFileSizeValue, "4, 6");
        JLabel lblIndividuals = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblIndividuals.text"));
        lblIndividuals.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblIndividuals, "2, 8");
        this.lblIndividualCount = new JLabel("-");
        this.lblIndividualCount.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblIndividualCount, "4, 8");
        JLabel lblFamilies = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblFamilies.text"));
        lblFamilies.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblFamilies, "2, 10");
        this.lblFamilyCount = new JLabel("-");
        this.lblFamilyCount.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblFamilyCount, "4, 10");
        JLabel lblRelationModels = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblRelationModels.text"));
        lblRelationModels.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblRelationModels, "2, 12");
        this.lblRelationModelCount = new JLabel("-");
        this.lblRelationModelCount.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblRelationModelCount, "4, 12");
        JLabel lblRelations = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("CorpusPanel.lblRelations.text"));
        lblRelations.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)lblRelations, "2, 14");
        this.lblRelationCount = new JLabel("-");
        this.lblRelationCount.setFont(new Font("Dialog", 0, 12));
        corpusStaticDataPanel.add((Component)this.lblRelationCount, "4, 14");
        Component verticalStrut_10 = Box.createVerticalStrut(10);
        generalPanel.add(verticalStrut_10);
        JSeparator separator_5 = new JSeparator();
        generalPanel.add(separator_5);
        Component verticalStrut_9 = Box.createVerticalStrut(10);
        generalPanel.add(verticalStrut_9);
        this.attributesPanel = new AttributesPanel(this.netGUI, null);
        this.add((Component)this.attributesPanel, "Center");
    }

    public void update() {
        this.lblFileNameValue.setText(this.netGUI.getFile().getName());
        this.lblFileNameValue.setToolTipText(this.netGUI.getFile().getAbsolutePath());
        long time = this.netGUI.getFile().lastModified();
        String timeText = time == 0L ? "-" : new SimpleDateFormat("dd/MM/yyyy HH':'mm").format(new Date(time));
        this.lblFileDateValue.setText(timeText);
        this.lblFileSizeValue.setText(String.valueOf(this.netGUI.getFile().length()) + " octets");
        this.lblIndividualCount.setText(String.valueOf(this.netGUI.getNet().individuals().size()));
        this.lblFamilyCount.setText(String.valueOf(this.netGUI.getNet().families().size()));
        this.lblRelationModelCount.setText(String.valueOf(this.netGUI.getNet().relationModels().size()));
        this.lblRelationCount.setText(String.valueOf(this.netGUI.getNet().relations().size()));
        this.attributesPanel.setSource(this.netGUI.getNet().attributes());
    }
}

