/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

public class ClusterValueExtractionInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(ClusterValueExtractionInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static String lastParameter;
    private static int lastMinimalValue;
    private JComboBox comboBoxParameter;
    private JSpinner spinnerMinimalNumberOfElements;

    static {
        lastMinimalValue = 0;
    }

    public ClusterValueExtractionInputWindow(final NetGUI netGUI) {
        List<String> availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        if (lastParameter == null) {
            availableLabels.add(0, "");
        } else {
            availableLabels.add(0, lastParameter);
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClusterValueExtractionInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Extract Large Clusters");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 200);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel label = new JLabel("Label:");
        panel.add((Component)label, "2, 4, right, default");
        this.comboBoxParameter = new JComboBox<Object>(availableLabels.toArray());
        this.comboBoxParameter.setSelectedIndex(0);
        this.comboBoxParameter.setMaximumRowCount(12);
        this.comboBoxParameter.setEditable(true);
        panel.add((Component)this.comboBoxParameter, "4, 4, fill, default");
        JLabel lblMinimalNumberOf = new JLabel("<html><div style=\"text-align:right\">Minimal value:\r\n </div></html>");
        panel.add((Component)lblMinimalNumberOf, "2, 6, center, default");
        this.spinnerMinimalNumberOfElements = new JSpinner();
        this.spinnerMinimalNumberOfElements.setModel(new SpinnerNumberModel(new Integer(1), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNumberOfElements, "4, 6");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClusterValueExtractionInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String parameter = (String)ClusterValueExtractionInputWindow.this.comboBoxParameter.getSelectedItem();
                    int minimalValue = (Integer)ClusterValueExtractionInputWindow.this.spinnerMinimalNumberOfElements.getValue();
                    lastParameter = parameter;
                    lastMinimalValue = minimalValue;
                    if (parameter == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(ClusterValueExtractionInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Net target = NetUtils.extractByClusterValue(netGUI.getNet(), parameter, minimalValue);
                        NetGUI newNetGui = PuckGUI.instance().createNetGUI(netGUI.getFile(), target);
                        newNetGui.setChanged(true, "-" + parameter + "_valueAbove_" + minimalValue);
                        ClusterValueExtractionInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(ClusterValueExtractionInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        this.spinnerMinimalNumberOfElements.setValue(lastMinimalValue);
    }
}

