/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attributes;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.models.AttributesModel;

public class AttributesPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(AttributesPanel.class);
    private static final long serialVersionUID = -7349931177487894947L;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private JTable table;
    private JLabel lblTitle;
    private JButton btnAdd;
    private WindowGUI guim;

    public AttributesPanel(WindowGUI guiManager, Attributes source) {
        this.guim = guiManager;
        this.setLayout(new BoxLayout(this, 0));
        JPanel panel_1 = new JPanel();
        this.add(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        Component verticalStrut_1 = Box.createVerticalStrut(5);
        panel_1.add(verticalStrut_1);
        JPanel panel = new JPanel();
        panel_1.add(panel);
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.lblTitle = new JLabel("Additional Data");
        panel.add(this.lblTitle);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        panel.add(horizontalStrut);
        this.btnAdd = new JButton(" + ");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (((AttributesModel)AttributesPanel.this.table.getModel()).getSource() != null) {
                    if (AttributesPanel.this.table.getModel().getRowCount() == ((AttributesModel)AttributesPanel.this.table.getModel()).getSource().size()) {
                        ((AttributesModel)AttributesPanel.this.table.getModel()).setNewItem();
                    }
                    AttributesPanel.this.table.scrollRectToVisible(AttributesPanel.this.table.getCellRect(AttributesPanel.this.table.getModel().getRowCount() - 1, 0, true));
                    AttributesPanel.this.table.setRowSelectionInterval(AttributesPanel.this.table.getModel().getRowCount() - 1, AttributesPanel.this.table.getModel().getRowCount() - 1);
                    AttributesPanel.this.table.setColumnSelectionInterval(0, 0);
                    AttributesPanel.this.table.editCellAt(AttributesPanel.this.table.getModel().getRowCount() - 1, 0);
                    AttributesPanel.this.table.getEditorComponent().requestFocus();
                }
            }
        });
        this.btnAdd.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add(this.btnAdd);
        Component verticalStrut = Box.createVerticalStrut(5);
        panel_1.add(verticalStrut);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAlignmentX(0.0f);
        panel_1.add(scrollPane);
        this.table = new JTable();
        this.table.setSelectionMode(2);
        this.table.setCellSelectionEnabled(true);
        scrollPane.setViewportView(this.table);
        this.table.setModel(new AttributesModel(this.guim, null));
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mntmDelete = new JMenuItem("Delete");
        mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                logger.debug("Delete " + ArrayUtils.toString((Object)AttributesPanel.this.table.getSelectedRows()));
                int[] selectedRowIds = AttributesPanel.this.table.getSelectedRows();
                ArrayUtils.reverse((int[])selectedRowIds);
                int[] nArray = selectedRowIds;
                int n = selectedRowIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int rowIndex = nArray[n2];
                    String label = (String)AttributesPanel.this.table.getModel().getValueAt(rowIndex, 0);
                    ((AttributesModel)AttributesPanel.this.table.getModel()).getSource().remove(label);
                    ++n2;
                }
                AttributesPanel.this.setSource(((AttributesModel)AttributesPanel.this.table.getModel()).getSource());
            }
        });
        popupMenu.add(mntmDelete);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                AttributesPanel.this.lblTitle.setText(String.valueOf(bundle.getString("MainWindow.lblAdditionalData.text")) + " (" + AttributesPanel.this.table.getModel().getRowCount() + ")");
            }
        });
        AttributesPanel.addPopup(this.table, popupMenu);
    }

    public void setSource(Attributes source) {
        if (source == null) {
            this.lblTitle.setText(bundle.getString("MainWindow.lblAdditionalData.text"));
            ((AttributesModel)this.table.getModel()).setSource(null);
            this.btnAdd.setEnabled(false);
        } else {
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            ((AttributesModel)this.table.getModel()).setSource(source);
            this.lblTitle.setText(String.valueOf(bundle.getString("MainWindow.lblAdditionalData.text")) + " (" + source.size() + ")");
            this.btnAdd.setEnabled(true);
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }
}

