/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.clusternetworks.ClusterNetworkUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;

public class AllianceNetworkInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(AllianceNetworkInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static String lastLabel;
    private static int lastMinimalValue;
    private static boolean lastWeightedArcs;
    private static int lastMinimalArcWeight;
    private JComboBox cmbBxLabel;
    private JComboBox comboBoxType;
    private JSpinner spinnerMinimalNumberOfLinks;
    private JCheckBox chckbxWeightedArcs;
    private JSpinner spinnerMinimalArcWeight;

    static {
        lastMinimalValue = 0;
        lastWeightedArcs = true;
        lastMinimalArcWeight = 0;
    }

    public AllianceNetworkInputWindow(final NetGUI netGUI) {
        List<String> availableLabels = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
        if (lastLabel == null) {
            availableLabels.add(0, "");
        } else {
            availableLabels.add(0, lastLabel);
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AllianceNetworkInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("Alliance Network Inputs");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 290);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel label = new JLabel("Label:");
        panel.add((Component)label, "2, 4, right, default");
        this.cmbBxLabel = new JComboBox<Object>(availableLabels.toArray());
        this.cmbBxLabel.setSelectedIndex(0);
        this.cmbBxLabel.setMaximumRowCount(12);
        this.cmbBxLabel.setEditable(true);
        panel.add((Component)this.cmbBxLabel, "4, 4, fill, default");
        JLabel lblMinimalNumberOf = new JLabel("<html><div style=\"text-align:right\">Minimal number:<br/>of links</div></html>");
        panel.add((Component)lblMinimalNumberOf, "2, 6, center, default");
        this.spinnerMinimalNumberOfLinks = new JSpinner();
        this.spinnerMinimalNumberOfLinks.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNumberOfLinks, "4, 6");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AllianceNetworkInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String label = (String)AllianceNetworkInputWindow.this.cmbBxLabel.getSelectedItem();
                    String type = (String)AllianceNetworkInputWindow.this.comboBoxType.getSelectedItem();
                    int minimalNumberOfLinks = (Integer)AllianceNetworkInputWindow.this.spinnerMinimalNumberOfLinks.getValue();
                    ClusterNetworkUtils.LineType lineType = AllianceNetworkInputWindow.this.chckbxWeightedArcs.isSelected() ? ClusterNetworkUtils.LineType.WEIGHTED_ARC : ClusterNetworkUtils.LineType.SIMPLE_ARC;
                    int minimalArcWeight = (Integer)AllianceNetworkInputWindow.this.spinnerMinimalArcWeight.getValue();
                    lastLabel = label;
                    lastMinimalValue = minimalNumberOfLinks;
                    lastWeightedArcs = AllianceNetworkInputWindow.this.chckbxWeightedArcs.isSelected();
                    lastMinimalArcWeight = minimalArcWeight;
                    if (label == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Graph<Cluster<Individual>> graph = null;
                        if (type.equals("Wife-Husband")) {
                            graph = ClusterNetworkUtils.createAllianceNetwork(netGUI.getSegmentation(), label, lineType);
                        } else if (type.equals("Sister-Brother")) {
                            graph = ClusterNetworkUtils.createSiblingNetwork(netGUI.getSegmentation(), label, lineType);
                        }
                        graph = GraphUtils.reduce(graph, minimalNumberOfLinks, minimalArcWeight);
                        graph.attributes().put("Label", label);
                        graph.attributes().put("Minimal number of links", String.valueOf(minimalNumberOfLinks));
                        graph.attributes().put("Arc Type", type);
                        graph.attributes().put("Weighted Arcs", String.valueOf(AllianceNetworkInputWindow.this.chckbxWeightedArcs.isSelected()));
                        graph.attributes().put("Minimal Arc Weight (marriages)", String.valueOf(minimalArcWeight));
                        PuckGUI.instance().createGroupNetGUI(graph);
                        AllianceNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        JButton btnLaunchold = new JButton("Statistics");
        btnLaunchold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String parameter = (String)AllianceNetworkInputWindow.this.cmbBxLabel.getSelectedItem();
                    String type = (String)AllianceNetworkInputWindow.this.comboBoxType.getSelectedItem();
                    int minimalNumberOfLinks = (Integer)AllianceNetworkInputWindow.this.spinnerMinimalNumberOfLinks.getValue();
                    ClusterNetworkUtils.LineType lineType = AllianceNetworkInputWindow.this.chckbxWeightedArcs.isSelected() ? ClusterNetworkUtils.LineType.WEIGHTED_ARC : ClusterNetworkUtils.LineType.SIMPLE_ARC;
                    int minimalArcWeight = (Integer)AllianceNetworkInputWindow.this.spinnerMinimalArcWeight.getValue();
                    lastLabel = parameter;
                    lastMinimalValue = minimalNumberOfLinks;
                    lastWeightedArcs = AllianceNetworkInputWindow.this.chckbxWeightedArcs.isSelected();
                    lastMinimalArcWeight = minimalArcWeight;
                    if (parameter == null) {
                        String title = "Bad input";
                        String message = "Please, enter none empty input.";
                        JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                    } else {
                        Report report = ClusterNetworkReporter.reportAllianceNetwork(netGUI.getSegmentation(), netGUI.getFile(), parameter, lineType, minimalNumberOfLinks, type, minimalArcWeight);
                        netGUI.addReportTab(report);
                        AllianceNetworkInputWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(AllianceNetworkInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunchold);
        buttonPanel.add(btnLaunch);
        this.spinnerMinimalNumberOfLinks.setValue(lastMinimalValue);
        JLabel lblLink = new JLabel("Arc Type:");
        panel.add((Component)lblLink, "2, 8, right, default");
        this.comboBoxType = new JComboBox<Object>(new Object[]{"Wife-Husband", "Sister-Brother"});
        this.comboBoxType.setSelectedIndex(0);
        this.comboBoxType.setMaximumRowCount(12);
        this.comboBoxType.setEditable(true);
        panel.add((Component)this.comboBoxType, "4, 8, fill, default");
        this.chckbxWeightedArcs = new JCheckBox("Weighted Arcs");
        this.chckbxWeightedArcs.setSelected(true);
        panel.add((Component)this.chckbxWeightedArcs, "4, 10");
        this.chckbxWeightedArcs.setSelected(lastWeightedArcs);
        JLabel lblMinimalArcWeight = new JLabel("<html><div style=\"text-align:right\">Minimal arc:<br/>weight (marr.)</div></html>");
        panel.add((Component)lblMinimalArcWeight, "2, 12, right, default");
        this.spinnerMinimalArcWeight = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalArcWeight, "4, 12");
        this.spinnerMinimalArcWeight.setValue(lastMinimalArcWeight);
    }
}

