/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;

public class IndividualsModel
extends AbstractListModel {
    private static final long serialVersionUID = -4415669569733860497L;
    private Individuals source;
    private List<Individual> delegate;
    private int lastIndividualSearchIndex;
    private String lastIndividualSearchPattern;

    public IndividualsModel(Individuals source) {
        this.source = source;
        this.delegate = source == null ? new ArrayList<Individual>(0) : this.source.toSortedList();
        this.lastIndividualSearchIndex = -1;
        this.lastIndividualSearchPattern = null;
    }

    @Override
    public Object getElementAt(int index) {
        Individual result = this.delegate.get(index);
        return result;
    }

    @Override
    public int getSize() {
        int result = this.delegate.size();
        return result;
    }

    public Individuals getSource() {
        return this.source;
    }

    public int indexOf(Individual individual) {
        int result;
        if (this.source == null) {
            result = -1;
        } else {
            boolean ended = false;
            result = -1;
            int index = 0;
            while (!ended) {
                if (index < this.delegate.size()) {
                    if (this.delegate.get(index) == individual) {
                        ended = true;
                        result = index;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = -1;
            }
        }
        return result;
    }

    public Individual nextSearchedIndividual(String pattern) {
        Individual result;
        if (StringUtils.isBlank((CharSequence)pattern)) {
            result = null;
        } else if (NumberUtils.isDigits((String)pattern)) {
            int individualId = Integer.parseInt(pattern);
            result = (Individual)this.source.getById(individualId);
            this.resetIndividualSearch();
        } else {
            List<Individual> foundIndividuals = this.source.searchByName(pattern);
            if (foundIndividuals.isEmpty()) {
                this.resetIndividualSearch();
                result = null;
            } else if (this.lastIndividualSearchPattern == null || !this.lastIndividualSearchPattern.equals(pattern)) {
                this.lastIndividualSearchIndex = 0;
                this.lastIndividualSearchPattern = pattern;
                result = foundIndividuals.get(0);
            } else {
                ++this.lastIndividualSearchIndex;
                if (this.lastIndividualSearchIndex >= foundIndividuals.size()) {
                    this.lastIndividualSearchIndex = 0;
                }
                result = foundIndividuals.get(this.lastIndividualSearchIndex);
            }
        }
        return result;
    }

    public int nextSearchedIndividualIndex(String pattern) {
        int result = this.indexOf(this.nextSearchedIndividual(pattern));
        return result;
    }

    public void resetIndividualSearch() {
        this.lastIndividualSearchIndex = -1;
        this.lastIndividualSearchPattern = null;
    }

    public void setSource(Individuals source) {
        this.resetIndividualSearch();
        this.fireIntervalRemoved(this, 0, this.delegate.size());
        this.source = source;
        this.delegate = this.source.toSortedList();
        this.fireIntervalAdded(this, 0, this.delegate.size());
    }

    public List<Individual> toSortedList() {
        List<Individual> result = this.delegate;
        return result;
    }
}

